import os
import json
from collections import defaultdict
from tqdm import tqdm

ann_path_list = [
    '/mnt/petrelfs/share_data/wangweiyun/share_data_sft/datasets/EduChat-Math/data/train_data.jsonl',
    # '/mnt/petrelfs/share_data/wangweiyun/share_data_sft/datasets/EduChat-Math/data/test_data.jsonl',
]
img_dir = '/mnt/petrelfs/share_data/wangweiyun/share_data_sft/datasets/EduChat-Math/Images'
keywords = ['略', '见详解', '本地图片', '![](']
valid_options = ['A', 'B', 'C', 'D']

IMG_PLACEHOLDER = '<ImageHere>'
IMG_PLACEHOLDER_NEW = '<image>'

def check_keywords(string):
    for keyword in keywords:
        if keyword in string:
            return True
    return False

def parse_options(question, options):
    for valid_option in valid_options:
        assert options.count(f'{valid_option}.') == 1
    assert options.count('E.') == 0

    curr_options = options
    options_list = []
    for opt_idx in range(1, len(valid_options)):
        opt, curr_options = curr_options.split(f'{valid_options[opt_idx]}.')
        options_list.append(opt.strip().strip(f'{valid_options[opt_idx-1]}.').strip())
    options_list.append(curr_options.strip().strip(f'{valid_options[-1]}.').strip())

    for opt_idx, opt in enumerate(options_list):
        question = question + f"\n{chr(ord('A') + opt_idx)}. {opt}"

    return question.strip()

def main():
    for ann_path in ann_path_list:
        with open(ann_path) as file:
            lines = file.readlines()

        is_train = ann_path.endswith('train_data.jsonl')

        info = defaultdict(int)
        data_list = []
        for line in tqdm(lines):
            item = json.loads(line)
            item_id = item['id']
            image = item['image']
            options = item['options']
            question = item['question']
            analysis = item['analysis']
            solution = item['solution']
            answer = item['answer']

            if isinstance(options, list):
                assert len(options) == 0
            else:
                assert isinstance(options, str)

            if (
                False
                or answer.strip('解').strip('答案:').strip() == '$\\times$'
                or answer.strip('解').strip('答案:').strip() == '$\\\\times$'
            ):
                info['update_times_to_chinese'] += 1
                answer = '错误'

            if (
                False
                or check_keywords(options)
                or check_keywords(question)
                or check_keywords(analysis)
                or check_keywords(solution)
                or check_keywords(answer)
            ):
                info['sample_with_noise'] += 1
                continue

            assert solution == 'null'

            if IMG_PLACEHOLDER in solution or IMG_PLACEHOLDER in analysis or IMG_PLACEHOLDER in answer:
                info['rationale_with_img'] += 1
                continue

            abs_image = []
            for img in image:
                abs_image.append(os.path.join(img_dir, 'Train_Images' if is_train else 'Test_Images', img))

            if options:
                try:
                    question = parse_options(question, options)
                except:
                    info['invalid_options'] += 1
                    continue

            question = question.replace(IMG_PLACEHOLDER, IMG_PLACEHOLDER_NEW)
            if question.count(IMG_PLACEHOLDER_NEW) != len(abs_image):
                info['inconsist_images'] += 1
                continue

            data_list.append({
                'id': item_id,
                'image': abs_image,
                'question': question,
                'answer': answer,
                'analysis': analysis,
            })

        for k, v in info.items():
            print(k, v)

        print(f'{len(lines)=}, {len(data_list)=}')
        save_path = ann_path.replace('.jsonl', '_dpo.jsonl')
        with open(save_path, 'w') as file:
            for data in data_list:
                file.write(json.dumps(data) + '\n')

        print()

if __name__ == '__main__':
    main()
