"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Utilities_1 = require("./Utilities");
class FrameHeader {
    /**
     * Initializes a new instance of the `FrameHeader` class.
     * @param code the kind of frame this is.
     * @param channelId the channel that this frame refers to or carries a payload for.
     */
    constructor(code, channelId) {
        if (channelId) {
            Utilities_1.requireInteger("channelId", channelId, 4, "signed");
        }
        this.code = code;
        this.channelId = channelId;
    }
    /**
    * Gets the channel that this frame refers to or carries a payload for.
    */
    get requiredChannelId() {
        if (this.channelId) {
            return this.channelId;
        }
        throw new Error("Expected ChannelId not present in frame header.");
    }
}
exports.FrameHeader = FrameHeader;
//# sourceMappingURL=FrameHeader.js.map