// Generated by Peggy 3.0.2.
//
// https://peggyjs.org/

"use strict";

function peg$subclass(child, parent) {
  function C() { this.constructor = child; }
  C.prototype = parent.prototype;
  child.prototype = new C();
}

function peg$SyntaxError(message, expected, found, location) {
  var self = Error.call(this, message);
  // istanbul ignore next Check is a necessary evil to support older environments
  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(self, peg$SyntaxError.prototype);
  }
  self.expected = expected;
  self.found = found;
  self.location = location;
  self.name = "SyntaxError";
  return self;
}

peg$subclass(peg$SyntaxError, Error);

function peg$padEnd(str, targetLength, padString) {
  padString = padString || " ";
  if (str.length > targetLength) { return str; }
  targetLength -= str.length;
  padString += padString.repeat(targetLength);
  return str + padString.slice(0, targetLength);
}

peg$SyntaxError.prototype.format = function(sources) {
  var str = "Error: " + this.message;
  if (this.location) {
    var src = null;
    var k;
    for (k = 0; k < sources.length; k++) {
      if (sources[k].source === this.location.source) {
        src = sources[k].text.split(/\r\n|\n|\r/g);
        break;
      }
    }
    var s = this.location.start;
    var offset_s = (this.location.source && (typeof this.location.source.offset === "function"))
      ? this.location.source.offset(s)
      : s;
    var loc = this.location.source + ":" + offset_s.line + ":" + offset_s.column;
    if (src) {
      var e = this.location.end;
      var filler = peg$padEnd("", offset_s.line.toString().length, ' ');
      var line = src[s.line - 1];
      var last = s.line === e.line ? e.column : line.length + 1;
      var hatLen = (last - s.column) || 1;
      str += "\n --> " + loc + "\n"
          + filler + " |\n"
          + offset_s.line + " | " + line + "\n"
          + filler + " | " + peg$padEnd("", s.column - 1, ' ')
          + peg$padEnd("", hatLen, "^");
    } else {
      str += "\n at " + loc;
    }
  }
  return str;
};

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
    literal: function(expectation) {
      return "\"" + literalEscape(expectation.text) + "\"";
    },

    class: function(expectation) {
      var escapedParts = expectation.parts.map(function(part) {
        return Array.isArray(part)
          ? classEscape(part[0]) + "-" + classEscape(part[1])
          : classEscape(part);
      });

      return "[" + (expectation.inverted ? "^" : "") + escapedParts.join("") + "]";
    },

    any: function() {
      return "any character";
    },

    end: function() {
      return "end of input";
    },

    other: function(expectation) {
      return expectation.description;
    }
  };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/"/g,  "\\\"")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/\]/g, "\\]")
      .replace(/\^/g, "\\^")
      .replace(/-/g,  "\\-")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = expected.map(describeExpectation);
    var i, j;

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$DefaultTracer() {
  this.indentLevel = 0;
}

peg$DefaultTracer.prototype.trace = function(event) {
  var that = this;

  function log(event) {
    function repeat(string, n) {
       var result = "", i;

       for (i = 0; i < n; i++) {
         result += string;
       }

       return result;
    }

    function pad(string, length) {
      return string + repeat(" ", length - string.length);
    }

    if (typeof console === "object") {
      console.log(
        event.location.start.line + ":" + event.location.start.column + "-"
          + event.location.end.line + ":" + event.location.end.column + " "
          + pad(event.type, 10) + " "
          + repeat("  ", that.indentLevel) + event.rule
      );
    }
  }

  switch (event.type) {
    case "rule.enter":
      log(event);
      this.indentLevel++;
      break;

    case "rule.match":
      this.indentLevel--;
      log(event);
      break;

    case "rule.fail":
      this.indentLevel--;
      log(event);
      break;

    default:
      throw new Error("Invalid event type: " + event.type + ".");
  }
};

function peg$parse(input, options) {
  options = options !== undefined ? options : {};

  var peg$FAILED = {};
  var peg$source = options.grammarSource;

  var peg$startRuleFunctions = { Root: peg$parseRoot, Preamble: peg$parsePreamble };
  var peg$startRuleFunction = peg$parseRoot;

  var peg$c0 = "begin{document}";
  var peg$c1 = "%";
  var peg$c2 = ".";
  var peg$c3 = "label";
  var peg$c4 = "ref";
  var peg$c5 = "eqref";
  var peg$c6 = "autoref";
  var peg$c7 = "}";
  var peg$c8 = "{";
  var peg$c9 = "url";
  var peg$c10 = "href";
  var peg$c11 = "verb*";
  var peg$c12 = "verb";
  var peg$c13 = "verbatim";
  var peg$c14 = "verbatim*";
  var peg$c15 = "minted";
  var peg$c16 = "lstlisting";
  var peg$c17 = "comment";
  var peg$c18 = "@";
  var peg$c19 = "*";
  var peg$c20 = "\\*";
  var peg$c21 = "end";
  var peg$c22 = "[";
  var peg$c23 = "]";
  var peg$c24 = "(";
  var peg$c25 = ")";
  var peg$c26 = "def";
  var peg$c27 = "left";
  var peg$c28 = "right";
  var peg$c29 = "\\{";
  var peg$c30 = "\\}";
  var peg$c31 = "bigg";
  var peg$c32 = "Bigg";
  var peg$c33 = "big";
  var peg$c34 = "Big";
  var peg$c35 = ",";
  var peg$c36 = "text";
  var peg$c37 = "begin";
  var peg$c38 = "equation*";
  var peg$c39 = "equation";
  var peg$c40 = "align*";
  var peg$c41 = "align";
  var peg$c42 = "alignat*";
  var peg$c43 = "alignat";
  var peg$c44 = "gather*";
  var peg$c45 = "gather";
  var peg$c46 = "multline*";
  var peg$c47 = "multline";
  var peg$c48 = "flalign*";
  var peg$c49 = "flalign";
  var peg$c50 = "math";
  var peg$c51 = "displaymath";
  var peg$c52 = "alignedat";
  var peg$c53 = "aligned";
  var peg$c54 = "cases*";
  var peg$c55 = "cases";
  var peg$c56 = "gathered";
  var peg$c57 = "split";
  var peg$c58 = "matrix";
  var peg$c59 = "bmatrix";
  var peg$c60 = "pmatrix";
  var peg$c61 = "vmatrix";
  var peg$c62 = "Bmatrix";
  var peg$c63 = "Vmatrix";
  var peg$c64 = "\\";
  var peg$c65 = "$";
  var peg$c66 = "&";
  var peg$c67 = "#";
  var peg$c68 = "^";
  var peg$c69 = "_";
  var peg$c70 = "\0";
  var peg$c71 = "~";
  var peg$c72 = "document";
  var peg$c73 = "linebreak";
  var peg$c74 = "newline";
  var peg$c75 = "\n";
  var peg$c76 = "\r\n";
  var peg$c77 = "\r";
  var peg$c78 = "\u2028";
  var peg$c79 = "\u2029";
  var peg$c80 = "par";

  var peg$r0 = /^[ ]/;
  var peg$r1 = /^[^\\%{}$&~\r\n\u2028\u2029#\^_\0 \t[\]]/;
  var peg$r2 = /^[\\%{}$&~\r\n\u2028\u2029#\^_\0 \t[\]]/;
  var peg$r3 = /^[^a-zA-Z]/;
  var peg$r4 = /^[ $%#&{}_\-,\/@]/;
  var peg$r5 = /^[()[\]|\/.]/;
  var peg$r6 = /^[{}]/;
  var peg$r7 = /^[rlm]/;
  var peg$r8 = /^[a-zA-Z]/;
  var peg$r9 = /^[0-9]/;
  var peg$r10 = /^[.,;:\-*\/()!?=+<>[\]]/;
  var peg$r11 = /^[ \t]/;
  var peg$r12 = /^[^ \r\n\t%\u2028\u2029]/;

  var peg$e0 = peg$literalExpectation("begin{document}", false);
  var peg$e1 = peg$anyExpectation();
  var peg$e2 = peg$classExpectation([" "], false, false);
  var peg$e3 = peg$classExpectation(["\\", "%", "{", "}", "$", "&", "~", "\r", "\n", "\u2028", "\u2029", "#", "^", "_", "\0", " ", "\t", "[", "]"], true, false);
  var peg$e4 = peg$classExpectation(["\\", "%", "{", "}", "$", "&", "~", "\r", "\n", "\u2028", "\u2029", "#", "^", "_", "\0", " ", "\t", "[", "]"], false, false);
  var peg$e5 = peg$literalExpectation("%", false);
  var peg$e6 = peg$literalExpectation(".", false);
  var peg$e7 = peg$otherExpectation("special command");
  var peg$e8 = peg$literalExpectation("label", false);
  var peg$e9 = peg$literalExpectation("ref", false);
  var peg$e10 = peg$literalExpectation("eqref", false);
  var peg$e11 = peg$literalExpectation("autoref", false);
  var peg$e12 = peg$literalExpectation("}", false);
  var peg$e13 = peg$literalExpectation("{", false);
  var peg$e14 = peg$literalExpectation("url", false);
  var peg$e15 = peg$literalExpectation("href", false);
  var peg$e16 = peg$literalExpectation("verb*", false);
  var peg$e17 = peg$literalExpectation("verb", false);
  var peg$e18 = peg$classExpectation([["a", "z"], ["A", "Z"]], true, false);
  var peg$e19 = peg$literalExpectation("verbatim", false);
  var peg$e20 = peg$literalExpectation("verbatim*", false);
  var peg$e21 = peg$literalExpectation("minted", false);
  var peg$e22 = peg$literalExpectation("lstlisting", false);
  var peg$e23 = peg$literalExpectation("comment", false);
  var peg$e24 = peg$literalExpectation("@", false);
  var peg$e25 = peg$literalExpectation("*", false);
  var peg$e26 = peg$literalExpectation("\\*", false);
  var peg$e27 = peg$classExpectation([" ", "$", "%", "#", "&", "{", "}", "_", "-", ",", "/", "@"], false, false);
  var peg$e28 = peg$literalExpectation("end", false);
  var peg$e29 = peg$literalExpectation("[", false);
  var peg$e30 = peg$literalExpectation("]", false);
  var peg$e31 = peg$literalExpectation("(", false);
  var peg$e32 = peg$literalExpectation(")", false);
  var peg$e33 = peg$literalExpectation("def", false);
  var peg$e34 = peg$literalExpectation("left", false);
  var peg$e35 = peg$literalExpectation("right", false);
  var peg$e36 = peg$classExpectation(["(", ")", "[", "]", "|", "/", "."], false, false);
  var peg$e37 = peg$classExpectation(["{", "}"], false, false);
  var peg$e38 = peg$literalExpectation("\\{", false);
  var peg$e39 = peg$literalExpectation("\\}", false);
  var peg$e40 = peg$literalExpectation("bigg", false);
  var peg$e41 = peg$literalExpectation("Bigg", false);
  var peg$e42 = peg$literalExpectation("big", false);
  var peg$e43 = peg$literalExpectation("Big", false);
  var peg$e44 = peg$classExpectation(["r", "l", "m"], false, false);
  var peg$e45 = peg$literalExpectation(",", false);
  var peg$e46 = peg$literalExpectation("text", false);
  var peg$e47 = peg$literalExpectation("begin", false);
  var peg$e48 = peg$literalExpectation("equation*", false);
  var peg$e49 = peg$literalExpectation("equation", false);
  var peg$e50 = peg$literalExpectation("align*", false);
  var peg$e51 = peg$literalExpectation("align", false);
  var peg$e52 = peg$literalExpectation("alignat*", false);
  var peg$e53 = peg$literalExpectation("alignat", false);
  var peg$e54 = peg$literalExpectation("gather*", false);
  var peg$e55 = peg$literalExpectation("gather", false);
  var peg$e56 = peg$literalExpectation("multline*", false);
  var peg$e57 = peg$literalExpectation("multline", false);
  var peg$e58 = peg$literalExpectation("flalign*", false);
  var peg$e59 = peg$literalExpectation("flalign", false);
  var peg$e60 = peg$literalExpectation("math", false);
  var peg$e61 = peg$literalExpectation("displaymath", false);
  var peg$e62 = peg$literalExpectation("alignedat", false);
  var peg$e63 = peg$literalExpectation("aligned", false);
  var peg$e64 = peg$literalExpectation("cases*", false);
  var peg$e65 = peg$literalExpectation("cases", false);
  var peg$e66 = peg$literalExpectation("gathered", false);
  var peg$e67 = peg$literalExpectation("split", false);
  var peg$e68 = peg$literalExpectation("matrix", false);
  var peg$e69 = peg$literalExpectation("bmatrix", false);
  var peg$e70 = peg$literalExpectation("pmatrix", false);
  var peg$e71 = peg$literalExpectation("vmatrix", false);
  var peg$e72 = peg$literalExpectation("Bmatrix", false);
  var peg$e73 = peg$literalExpectation("Vmatrix", false);
  var peg$e74 = peg$literalExpectation("\\", false);
  var peg$e75 = peg$literalExpectation("$", false);
  var peg$e76 = peg$literalExpectation("&", false);
  var peg$e77 = peg$literalExpectation("#", false);
  var peg$e78 = peg$literalExpectation("^", false);
  var peg$e79 = peg$literalExpectation("_", false);
  var peg$e80 = peg$literalExpectation("\0", false);
  var peg$e81 = peg$classExpectation([["a", "z"], ["A", "Z"]], false, false);
  var peg$e82 = peg$classExpectation([["0", "9"]], false, false);
  var peg$e83 = peg$classExpectation([".", ",", ";", ":", "-", "*", "/", "(", ")", "!", "?", "=", "+", "<", ">", "[", "]"], false, false);
  var peg$e84 = peg$literalExpectation("~", false);
  var peg$e85 = peg$literalExpectation("document", false);
  var peg$e86 = peg$literalExpectation("linebreak", false);
  var peg$e87 = peg$literalExpectation("newline", false);
  var peg$e88 = peg$literalExpectation("\n", false);
  var peg$e89 = peg$literalExpectation("\r\n", false);
  var peg$e90 = peg$literalExpectation("\r", false);
  var peg$e91 = peg$literalExpectation("\u2028", false);
  var peg$e92 = peg$literalExpectation("\u2029", false);
  var peg$e93 = peg$classExpectation([" ", "\t"], false, false);
  var peg$e94 = peg$otherExpectation("spaces");
  var peg$e95 = peg$classExpectation([" ", "\r", "\n", "\t", "%", "\u2028", "\u2029"], true, false);
  var peg$e96 = peg$literalExpectation("par", false);

  var peg$f0 = function(x) { 
    const comment = commentMap ? Array.from(commentMap.values()) : undefined;
    return { kind: "ast.root", content: x, comment };
  };
  var peg$f1 = function(e) { return e; };
  var peg$f2 = function(x, rest) {
    const comment = commentMap ? Array.from(commentMap.values()) : undefined;
    return { kind: "ast.preamble", content: x, rest, comment };
  };
  var peg$f3 = function(x) { 
    return x;
  };
  var peg$f4 = function(c) {
    timeKeeper && timeKeeper.check();
    return { kind: "text.string", content: c, location: location() };
  };
  var peg$f5 = function(c) {
    timeKeeper && timeKeeper.check();
    return { kind: "text.string", content: c, location: location() };
  };
  var peg$f6 = function(c) {
    return { kind: "space" };
  };
  var peg$f7 = function(x) { 
    return x;
  };
  var peg$f8 = function(c) {
    if (options.enableMathCharacterLocation) {
      return { kind: "math.character", content: c, location: location() };
    } else {
      return { kind: "math.character", content: c };
    }
  };
  var peg$f9 = function(name, label) {
    return { kind: "command.label", name, label: label.join(''), location: location() };
  };
  var peg$f10 = function(x) {
    return { kind: "command.url", name: "url", url: x, location: location() };
  };
  var peg$f11 = function(arg, x, grp) {
    return { kind: "command.href", name: "href", url: x, content: grp.content, arg: arg || undefined, location: location() };
  };
  var peg$f12 = function(name, e, end) {return end === e;};
  var peg$f13 = function(name, e, x, end) {return end === e;};
  var peg$f14 = function(name, e, x) {
    return { kind: "verb", name, escape: e, content: x, location: location() };
  };
  var peg$f15 = function(x) {
    return x;
  };
  var peg$f16 = function(x) {
    return { kind: "env.verbatim", name: "verbatim", content: x, location: location() };
  };
  var peg$f17 = function(x) {
    return { kind: "env.verbatim", name: "verbatim*", content: x, location: location() };
  };
  var peg$f18 = function(x) {
    return x;
  };
  var peg$f19 = function(args, x) {
    return { kind: "env.minted", name: "minted", args: args, content: x, location: location() };
  };
  var peg$f20 = function(x) {
    return x;
  };
  var peg$f21 = function(arg, x) {
    return { kind: "env.lstlisting", name: "lstlisting", arg: arg, content: x, location: location() };
  };
  var peg$f22 = function(x) {
    return { kind: "env.comment", content: x, location: location() };
  };
  var peg$f23 = function(t) {return t;};
  var peg$f24 = function(eq) {
    return { kind: "inlineMath", content: eq, location: location() };
  };
  var peg$f25 = function(t) {return t;};
  var peg$f26 = function(eq) {
    return { kind: "inlineMath", content: eq, location: location() };
  };
  var peg$f27 = function(x) {return x;};
  var peg$f28 = function(x) {
    return { kind: "inlineMath", content: x, location: location() };
  };
  var peg$f29 = function(x) {return x;};
  var peg$f30 = function(x) {
    return { kind: "displayMath", content: x, location: location() };
  };
  var peg$f31 = function(x) {return x;};
  var peg$f32 = function(x) {
    return { kind: "displayMath", content: x, location: location() };
  };
  var peg$f33 = function(n, args) {
    return { kind: "command", name: n, args: args, location: location() };
  };
  var peg$f34 = function(x) {
    return x;
  };
  var peg$f35 = function(n) {
    return { kind: "command", name: n, args: [], location: location() };
  };
  var peg$f36 = function(n) { return n + '*'; };
  var peg$f37 = function(c) {
    return { kind: "command", name: c, args: [], location: location() };
  };
  var peg$f38 = function(n, args) {
    return { kind: "command", name: n, args: args, location: location() };
  };
  var peg$f39 = function(token, numArgs, grArg) {
    return { kind: "command.def", token, args: numArgs.concat([grArg]), location: location() };
  };
  var peg$f40 = function(x) {
    return x;
  };
  var peg$f41 = function(c) {return c;};
  var peg$f42 = function(x) {
    return { kind: "arg.group", content: x, location: location() };
  };
  var peg$f43 = function(x) {
    return x;
  };
  var peg$f44 = function(c) {return c;};
  var peg$f45 = function(x) {
    return { kind: "arg.group", content: x, location: location() };
  };
  var peg$f46 = function(x) {
    return x;
  };
  var peg$f47 = function(l, c) {return c;};
  var peg$f48 = function(l, x, r) {
    return { kind: "math.matching_delimiters", left: l, right: r, content: x, location: location() };
  };
  var peg$f49 = function(x) {
    return x;
  };
  var peg$f50 = function(l, c) {return c;};
  var peg$f51 = function(l, x, r) {
    return { kind: "math.math_delimiters", lcommand: l, rcommand: r, left: "(", right: ")", content: x, location: location() };
  };
  var peg$f52 = function(l, c) {return c;};
  var peg$f53 = function(l, x, r) {
    return { kind: "math.math_delimiters", lcommand: l, rcommand: r, left: "[", right: "]", content: x, location: location() };
  };
  var peg$f54 = function(l, c) {return c;};
  var peg$f55 = function(l, x, r) {
    return { kind: "math.math_delimiters", lcommand: l, rcommand: r, left: "\\{", right: "\\}", content: x, location: location() };
  };
  var peg$f56 = function(x) {
    return x;
  };
  var peg$f57 = function(x) {return x;};
  var peg$f58 = function(body) {
    return { kind: "arg.optional", content: body, location: location() };
  };
  var peg$f59 = function() { return { kind:"parbreak", location: location() }; };
  var peg$f60 = function(c) { return { kind: "text.string", content: c, location: location() }; };
  var peg$f61 = function() {
    return { kind: "text.string", content: ",", location: location() };
  };
  var peg$f62 = function(x) {
    return x;
  };
  var peg$f63 = function(name, args, x) {return x;};
  var peg$f64 = function(name, args, body, n) { return name === n; };
  var peg$f65 = function(name, args, body, n) {
    return { kind: "env", name, args, content: body, location: location() };
  };
  var peg$f66 = function(x) {
    return x;
  };
  var peg$f67 = function(name, x) {return x;};
  var peg$f68 = function(name, body, n) { return name === n; };
  var peg$f69 = function(name, body, n) {
    return { kind: "env.math.align", name, args: [], content: body, location: location() };
  };
  var peg$f70 = function(name, x) {return x;};
  var peg$f71 = function(name, body, n) { return name === n; };
  var peg$f72 = function(name, body, n) {
    return { kind: "env.math.aligned", name, args: [], content: body, location: location() };
  };
  var peg$f73 = function(x) {
    return x;
  };
  var peg$f74 = function(arg) {
    return { kind: "command.text", arg: arg, location: location() };
  };
  var peg$f75 = function(x) { return { kind: "comment", content: x, location: location() }; };
  var peg$f76 = function(x) { return { kind: "comment", content: x, location: location() }; };
  var peg$f77 = function() {
    return { kind: "alignmentTab", location: location() };
  };
  var peg$f78 = function(x) {
    return { kind: "superscript", arg: x, location: location() };
  };
  var peg$f79 = function() {
    return { kind: "superscript", arg: undefined, location: location() };
  };
  var peg$f80 = function(x) {
    return { kind: "subscript", arg: x, location: location() };
  };
  var peg$f81 = function() {
    return { kind: "subscript", arg: undefined, location: location() };
  };
  var peg$f82 = function() {
    return { kind: "ignore", location: location() };
  };
  var peg$f83 = function() {
    return { kind: "activeCharacter", location: location() };
  };
  var peg$f84 = function(n) {
    return { kind: "commandParameter", nargs: n, location: location() };
  };
  var peg$f85 = function(c) {
    return c;
  };
  var peg$f86 = function(x) {
    return x;
  };
  var peg$f87 = function(n, arg) {
    return { kind: "linebreak", name: n, arg: arg || undefined, location: location() };
  };
  var peg$f88 = function(n, arg) {
    return { kind: "linebreak", name: n, arg: arg || undefined, location: location() };
  };
  var peg$f89 = function(n) {
    return { kind: "linebreak", name: n, arg: undefined, location: location() }
  };
  var peg$f90 = function() {
    return { kind: "softbreak" };
  };
  var peg$f91 = function() {
    return { kind: "space" };
  };
  var peg$f92 = function(c) { 
    if (options.enableComment) {
      const loc = location();
      const locJson = JSON.stringify(loc);
      if (!commentMap.has(locJson)) {
        commentMap.set(locJson, { kind: "comment", content: c, location: loc } );
      }
    }
  };
  var peg$f93 = function() {
    return undefined;
  };
  var peg$f94 = function() {
    return { kind: "parbreak", location: location() };
  };
  var peg$f95 = function() {
    return { kind: "parbreak", location: location() };
  };
  var peg$currPos = 0;
  var peg$savedPos = 0;
  var peg$posDetailsCache = [{ line: 1, column: 1 }];
  var peg$maxFailPos = 0;
  var peg$maxFailExpected = [];
  var peg$silentFails = 0;

  var peg$tracer = "tracer" in options ? options.tracer : new peg$DefaultTracer();

  var peg$result;

  if ("startRule" in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function offset() {
    return peg$savedPos;
  }

  function range() {
    return {
      source: peg$source,
      start: peg$savedPos,
      end: peg$currPos
    };
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos];
    var p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;

      return details;
    }
  }

  function peg$computeLocation(startPos, endPos, offset) {
    var startPosDetails = peg$computePosDetails(startPos);
    var endPosDetails = peg$computePosDetails(endPos);

    var res = {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column
      }
    };
    if (offset && peg$source && (typeof peg$source.offset === "function")) {
      res.start = peg$source.offset(res.start);
      res.end = peg$source.offset(res.end);
    }
    return res;
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parseRoot() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Root",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseElement();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseElement();
      }
      peg$savedPos = s0;
      s0 = peg$f0(s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Root",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Root",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsePreamble() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Preamble",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      s5 = peg$currPos;
      s6 = peg$parseskip_space();
      if (s6 !== peg$FAILED) {
        s7 = peg$parseescape();
        if (s7 !== peg$FAILED) {
          if (input.substr(peg$currPos, 15) === peg$c0) {
            s8 = peg$c0;
            peg$currPos += 15;
          } else {
            s8 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e0); }
          }
          if (s8 !== peg$FAILED) {
            s6 = [s6, s7, s8];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parseElement();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s3;
          s3 = peg$f1(s5);
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = peg$currPos;
        s6 = peg$parseskip_space();
        if (s6 !== peg$FAILED) {
          s7 = peg$parseescape();
          if (s7 !== peg$FAILED) {
            if (input.substr(peg$currPos, 15) === peg$c0) {
              s8 = peg$c0;
              peg$currPos += 15;
            } else {
              s8 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e0); }
            }
            if (s8 !== peg$FAILED) {
              s6 = [s6, s7, s8];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parseElement();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s3;
            s3 = peg$f1(s5);
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      s3 = peg$parseskip_space();
      if (s3 !== peg$FAILED) {
        s4 = peg$currPos;
        s5 = peg$currPos;
        s6 = peg$parseescape();
        if (s6 !== peg$FAILED) {
          if (input.substr(peg$currPos, 15) === peg$c0) {
            s7 = peg$c0;
            peg$currPos += 15;
          } else {
            s7 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e0); }
          }
          if (s7 !== peg$FAILED) {
            s8 = [];
            if (input.length > peg$currPos) {
              s9 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s9 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e1); }
            }
            while (s9 !== peg$FAILED) {
              s8.push(s9);
              if (input.length > peg$currPos) {
                s9 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s9 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e1); }
              }
            }
            s6 = [s6, s7, s8];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s4 = input.substring(s4, peg$currPos);
        peg$savedPos = s0;
        s0 = peg$f2(s2, s4);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Preamble",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Preamble",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseElement() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Element",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseElement_p();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseskip_comment();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseskip_comment();
      }
      peg$savedPos = s0;
      s0 = peg$f3(s1);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Element",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Element",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseElement_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Element_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$parseTypicalWord();
    if (s0 === peg$FAILED) {
      s0 = peg$parseTypicalSpace();
      if (s0 === peg$FAILED) {
        s0 = peg$parseSpecialCommand();
        if (s0 === peg$FAILED) {
          s0 = peg$parsebreak();
          if (s0 === peg$FAILED) {
            s0 = peg$parseLinebreak();
            if (s0 === peg$FAILED) {
              s0 = peg$parseDefCommand();
              if (s0 === peg$FAILED) {
                s0 = peg$parseCommand();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseGroupIsolated();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseInlineMathShift();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parseAlignmentTab();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parseCommandParameterWithNumber();
                        if (s0 === peg$FAILED) {
                          s0 = peg$parseSuperscript();
                          if (s0 === peg$FAILED) {
                            s0 = peg$parseSubscript();
                            if (s0 === peg$FAILED) {
                              s0 = peg$parseActiveCharacter();
                              if (s0 === peg$FAILED) {
                                s0 = peg$parseignore();
                                if (s0 === peg$FAILED) {
                                  s0 = peg$parseSoftbreak();
                                  if (s0 === peg$FAILED) {
                                    s0 = peg$currPos;
                                    s1 = peg$currPos;
                                    s2 = [];
                                    s3 = peg$currPos;
                                    s4 = peg$currPos;
                                    peg$silentFails++;
                                    s5 = peg$parsenoncharToken();
                                    peg$silentFails--;
                                    if (s5 === peg$FAILED) {
                                      s4 = undefined;
                                    } else {
                                      peg$currPos = s4;
                                      s4 = peg$FAILED;
                                    }
                                    if (s4 !== peg$FAILED) {
                                      if (input.length > peg$currPos) {
                                        s5 = input.charAt(peg$currPos);
                                        peg$currPos++;
                                      } else {
                                        s5 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$e1); }
                                      }
                                      if (s5 !== peg$FAILED) {
                                        s4 = [s4, s5];
                                        s3 = s4;
                                      } else {
                                        peg$currPos = s3;
                                        s3 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s3;
                                      s3 = peg$FAILED;
                                    }
                                    if (s3 !== peg$FAILED) {
                                      while (s3 !== peg$FAILED) {
                                        s2.push(s3);
                                        s3 = peg$currPos;
                                        s4 = peg$currPos;
                                        peg$silentFails++;
                                        s5 = peg$parsenoncharToken();
                                        peg$silentFails--;
                                        if (s5 === peg$FAILED) {
                                          s4 = undefined;
                                        } else {
                                          peg$currPos = s4;
                                          s4 = peg$FAILED;
                                        }
                                        if (s4 !== peg$FAILED) {
                                          if (input.length > peg$currPos) {
                                            s5 = input.charAt(peg$currPos);
                                            peg$currPos++;
                                          } else {
                                            s5 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$e1); }
                                          }
                                          if (s5 !== peg$FAILED) {
                                            s4 = [s4, s5];
                                            s3 = s4;
                                          } else {
                                            peg$currPos = s3;
                                            s3 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s3;
                                          s3 = peg$FAILED;
                                        }
                                      }
                                    } else {
                                      s2 = peg$FAILED;
                                    }
                                    if (s2 !== peg$FAILED) {
                                      s1 = input.substring(s1, peg$currPos);
                                    } else {
                                      s1 = s2;
                                    }
                                    if (s1 !== peg$FAILED) {
                                      peg$savedPos = s0;
                                      s1 = peg$f4(s1);
                                    }
                                    s0 = s1;
                                    if (s0 === peg$FAILED) {
                                      s0 = peg$parseSpace();
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Element_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Element_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseTypicalWord() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "TypicalWord",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    s3 = peg$parsecharTokenOptm();
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsecharTokenOptm();
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parsespecialTokenOptm();
      peg$silentFails--;
      if (s3 !== peg$FAILED) {
        peg$currPos = s2;
        s2 = undefined;
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f5(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "TypicalWord",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "TypicalWord",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseTypicalSpace() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "TypicalSpace",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    if (peg$r0.test(input.charAt(peg$currPos))) {
      s3 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e2); }
    }
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        if (peg$r0.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e2); }
        }
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parsecharTokenOptm();
      peg$silentFails--;
      if (s3 !== peg$FAILED) {
        peg$currPos = s2;
        s2 = undefined;
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f6(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "TypicalSpace",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "TypicalSpace",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsecharTokenOptm() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "charTokenOptm",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (peg$r1.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e3); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "charTokenOptm",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "charTokenOptm",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsespecialTokenOptm() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "specialTokenOptm",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (peg$r2.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e4); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "specialTokenOptm",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "specialTokenOptm",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathElement() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathElement",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseMathElement_p();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseskip_comment();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseskip_comment();
      }
      peg$savedPos = s0;
      s0 = peg$f7(s1);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathElement",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathElement",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathElement_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathElement_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$parseMathAlignedEnvironment();
    if (s0 === peg$FAILED) {
      s0 = peg$parseLinebreak();
      if (s0 === peg$FAILED) {
        s0 = peg$parseAmsmathTextCommand();
        if (s0 === peg$FAILED) {
          s0 = peg$parseSpecialCommand();
          if (s0 === peg$FAILED) {
            s0 = peg$parseMatchingDelimiters();
            if (s0 === peg$FAILED) {
              s0 = peg$parseMathematicalDelimiters();
              if (s0 === peg$FAILED) {
                s0 = peg$parseMathCommand();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseMathGroup();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseAlignmentTab();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parseCommandParameterWithNumber();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parseSuperscriptWithArg();
                        if (s0 === peg$FAILED) {
                          s0 = peg$parseSubscriptWithArg();
                          if (s0 === peg$FAILED) {
                            s0 = peg$parseActiveCharacter();
                            if (s0 === peg$FAILED) {
                              s0 = peg$parseignore();
                              if (s0 === peg$FAILED) {
                                s0 = peg$currPos;
                                s1 = peg$currPos;
                                s2 = peg$currPos;
                                s3 = peg$currPos;
                                peg$silentFails++;
                                s4 = peg$parsenonMathcharToken();
                                peg$silentFails--;
                                if (s4 === peg$FAILED) {
                                  s3 = undefined;
                                } else {
                                  peg$currPos = s3;
                                  s3 = peg$FAILED;
                                }
                                if (s3 !== peg$FAILED) {
                                  if (input.length > peg$currPos) {
                                    s4 = input.charAt(peg$currPos);
                                    peg$currPos++;
                                  } else {
                                    s4 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$e1); }
                                  }
                                  if (s4 !== peg$FAILED) {
                                    s3 = [s3, s4];
                                    s2 = s3;
                                  } else {
                                    peg$currPos = s2;
                                    s2 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s2;
                                  s2 = peg$FAILED;
                                }
                                if (s2 !== peg$FAILED) {
                                  s1 = input.substring(s1, peg$currPos);
                                } else {
                                  s1 = s2;
                                }
                                if (s1 !== peg$FAILED) {
                                  peg$savedPos = s0;
                                  s1 = peg$f8(s1);
                                }
                                s0 = s1;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathElement_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathElement_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsenonMathcharToken() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "nonMathcharToken",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$parsemathShift();
    if (s0 === peg$FAILED) {
      s0 = peg$parseescape();
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "nonMathcharToken",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "nonMathcharToken",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsenoncharToken() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "noncharToken",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$parseescape();
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 37) {
        s0 = peg$c1;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e5); }
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parsebeginGroup();
        if (s0 === peg$FAILED) {
          s0 = peg$parseendGroup();
          if (s0 === peg$FAILED) {
            s0 = peg$parsemathShift();
            if (s0 === peg$FAILED) {
              s0 = peg$parseAlignmentTab();
              if (s0 === peg$FAILED) {
                s0 = peg$parseActiveCharacter();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsenl();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parsecommandParameter();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parseSuperscript();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parseSubscript();
                        if (s0 === peg$FAILED) {
                          s0 = peg$parseignore();
                          if (s0 === peg$FAILED) {
                            s0 = peg$parsesp();
                            if (s0 === peg$FAILED) {
                              s0 = peg$parseEOF();
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "noncharToken",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "noncharToken",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsenumber() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "number",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    s3 = peg$parsenum();
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsenum();
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 46) {
        s3 = peg$c2;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e6); }
      }
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parsenum();
        if (s5 !== peg$FAILED) {
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parsenum();
          }
        } else {
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s2 = [s2, s3, s4];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 46) {
        s2 = peg$c2;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e6); }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parsenum();
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parsenum();
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        s0 = input.substring(s0, peg$currPos);
      } else {
        s0 = s1;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$currPos;
        s2 = [];
        s3 = peg$parsenum();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parsenum();
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s3 = peg$c2;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e6); }
          }
          if (s3 !== peg$FAILED) {
            s2 = [s2, s3];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
          s0 = input.substring(s0, peg$currPos);
        } else {
          s0 = s1;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = [];
          s2 = peg$parsenum();
          if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
              s1.push(s2);
              s2 = peg$parsenum();
            }
          } else {
            s1 = peg$FAILED;
          }
          if (s1 !== peg$FAILED) {
            s0 = input.substring(s0, peg$currPos);
          } else {
            s0 = s1;
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "number",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "number",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseSpecialCommand() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "SpecialCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    peg$silentFails++;
    s0 = peg$parseUrlCommand();
    if (s0 === peg$FAILED) {
      s0 = peg$parseHrefCommand();
      if (s0 === peg$FAILED) {
        s0 = peg$parseVerb();
        if (s0 === peg$FAILED) {
          s0 = peg$parseVerbatim();
          if (s0 === peg$FAILED) {
            s0 = peg$parseMinted();
            if (s0 === peg$FAILED) {
              s0 = peg$parseLstlisting();
              if (s0 === peg$FAILED) {
                s0 = peg$parsecommentenv();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseDisplayMath();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseInlineMathParen();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parseMathEnvironment();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parseEnvironment();
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e7); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "SpecialCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "SpecialCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseLabelCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "LabelCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 5) === peg$c3) {
        s2 = peg$c3;
        peg$currPos += 5;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e8); }
      }
      if (s2 === peg$FAILED) {
        if (input.substr(peg$currPos, 3) === peg$c4) {
          s2 = peg$c4;
          peg$currPos += 3;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e9); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c5) {
            s2 = peg$c5;
            peg$currPos += 5;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e10); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 7) === peg$c6) {
              s2 = peg$c6;
              peg$currPos += 7;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e11); }
            }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsebeginGroup();
          if (s4 !== peg$FAILED) {
            s5 = peg$parselabelString();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseendGroup();
              if (s6 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f9(s2, s5);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "LabelCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "LabelCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parselabelString() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "labelString",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = [];
    s1 = peg$parseskip_comment();
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      s2 = peg$parsepairedCurlySkippingComment();
      if (s2 !== peg$FAILED) {
        s1 = input.substring(s1, peg$currPos);
      } else {
        s1 = s2;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = peg$currPos;
        s3 = peg$currPos;
        peg$silentFails++;
        if (input.charCodeAt(peg$currPos) === 125) {
          s4 = peg$c7;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e12); }
        }
        peg$silentFails--;
        if (s4 === peg$FAILED) {
          s3 = undefined;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          if (input.length > peg$currPos) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s1 = input.substring(s1, peg$currPos);
        } else {
          s1 = s2;
        }
      }
    }
    if (s1 !== peg$FAILED) {
      while (s1 !== peg$FAILED) {
        s0.push(s1);
        s1 = peg$parseskip_comment();
        if (s1 === peg$FAILED) {
          s1 = peg$currPos;
          s2 = peg$parsepairedCurlySkippingComment();
          if (s2 !== peg$FAILED) {
            s1 = input.substring(s1, peg$currPos);
          } else {
            s1 = s2;
          }
          if (s1 === peg$FAILED) {
            s1 = peg$currPos;
            s2 = peg$currPos;
            s3 = peg$currPos;
            peg$silentFails++;
            if (input.charCodeAt(peg$currPos) === 125) {
              s4 = peg$c7;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e12); }
            }
            peg$silentFails--;
            if (s4 === peg$FAILED) {
              s3 = undefined;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 !== peg$FAILED) {
              if (input.length > peg$currPos) {
                s4 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e1); }
              }
              if (s4 !== peg$FAILED) {
                s3 = [s3, s4];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 !== peg$FAILED) {
              s1 = input.substring(s1, peg$currPos);
            } else {
              s1 = s2;
            }
          }
        }
      }
    } else {
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "labelString",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "labelString",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsepairedCurlySkippingComment() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "pairedCurlySkippingComment",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 123) {
      s1 = peg$c8;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e13); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseskip_comment();
      if (s3 === peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$parsepairedCurlySkippingComment();
        if (s4 !== peg$FAILED) {
          s3 = input.substring(s3, peg$currPos);
        } else {
          s3 = s4;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$currPos;
          s5 = peg$currPos;
          peg$silentFails++;
          if (input.charCodeAt(peg$currPos) === 125) {
            s6 = peg$c7;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e12); }
          }
          peg$silentFails--;
          if (s6 === peg$FAILED) {
            s5 = undefined;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            if (input.length > peg$currPos) {
              s6 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e1); }
            }
            if (s6 !== peg$FAILED) {
              s5 = [s5, s6];
              s4 = s5;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s3 = input.substring(s3, peg$currPos);
          } else {
            s3 = s4;
          }
        }
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseskip_comment();
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsepairedCurlySkippingComment();
          if (s4 !== peg$FAILED) {
            s3 = input.substring(s3, peg$currPos);
          } else {
            s3 = s4;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            s4 = peg$currPos;
            s5 = peg$currPos;
            peg$silentFails++;
            if (input.charCodeAt(peg$currPos) === 125) {
              s6 = peg$c7;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e12); }
            }
            peg$silentFails--;
            if (s6 === peg$FAILED) {
              s5 = undefined;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 !== peg$FAILED) {
              if (input.length > peg$currPos) {
                s6 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e1); }
              }
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              s3 = input.substring(s3, peg$currPos);
            } else {
              s3 = s4;
            }
          }
        }
      }
      if (input.charCodeAt(peg$currPos) === 125) {
        s3 = peg$c7;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e12); }
      }
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "pairedCurlySkippingComment",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "pairedCurlySkippingComment",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseUrlCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "UrlCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 3) === peg$c9) {
        s2 = peg$c9;
        peg$currPos += 3;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e14); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsebeginGroup();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parseurlString();
            s5 = input.substring(s5, peg$currPos);
            s6 = peg$parseendGroup();
            if (s6 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f10(s5);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "UrlCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "UrlCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseHrefCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "HrefCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 4) === peg$c10) {
        s2 = peg$c10;
        peg$currPos += 4;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e15); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseArgumentList();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        s4 = peg$parseskip_space();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsebeginGroup();
          if (s5 !== peg$FAILED) {
            s6 = peg$currPos;
            s7 = peg$parseurlString();
            s6 = input.substring(s6, peg$currPos);
            s7 = peg$parseendGroup();
            if (s7 !== peg$FAILED) {
              s8 = peg$parseGroup();
              if (s8 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f11(s3, s6, s8);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "HrefCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "HrefCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseurlString() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "urlString",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = [];
    s1 = peg$parsepairedCurly();
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      s2 = peg$currPos;
      peg$silentFails++;
      if (input.charCodeAt(peg$currPos) === 125) {
        s3 = peg$c7;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e12); }
      }
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.length > peg$currPos) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e1); }
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parsepairedCurly();
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = peg$currPos;
        peg$silentFails++;
        if (input.charCodeAt(peg$currPos) === 125) {
          s3 = peg$c7;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e12); }
        }
        peg$silentFails--;
        if (s3 === peg$FAILED) {
          s2 = undefined;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          if (input.length > peg$currPos) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s3 !== peg$FAILED) {
            s2 = [s2, s3];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "urlString",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "urlString",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsepairedCurly() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "pairedCurly",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 123) {
      s1 = peg$c8;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e13); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsepairedCurly();
      if (s3 === peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        if (input.charCodeAt(peg$currPos) === 125) {
          s5 = peg$c7;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e12); }
        }
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          if (input.length > peg$currPos) {
            s5 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsepairedCurly();
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$currPos;
          peg$silentFails++;
          if (input.charCodeAt(peg$currPos) === 125) {
            s5 = peg$c7;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e12); }
          }
          peg$silentFails--;
          if (s5 === peg$FAILED) {
            s4 = undefined;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            if (input.length > peg$currPos) {
              s5 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e1); }
            }
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
      }
      if (input.charCodeAt(peg$currPos) === 125) {
        s3 = peg$c7;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e12); }
      }
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "pairedCurly",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "pairedCurly",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseVerb() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Verb",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 5) === peg$c11) {
        s2 = peg$c11;
        peg$currPos += 5;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e16); }
      }
      if (s2 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c12) {
          s2 = peg$c12;
          peg$currPos += 4;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e17); }
        }
      }
      if (s2 !== peg$FAILED) {
        if (peg$r3.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e18); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = [];
          s6 = peg$currPos;
          s7 = peg$currPos;
          peg$silentFails++;
          s8 = peg$currPos;
          if (input.length > peg$currPos) {
            s9 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s9 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s9 !== peg$FAILED) {
            peg$savedPos = peg$currPos;
            s10 = peg$f12(s2, s3, s9);
            if (s10) {
              s10 = undefined;
            } else {
              s10 = peg$FAILED;
            }
            if (s10 !== peg$FAILED) {
              s9 = [s9, s10];
              s8 = s9;
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
          } else {
            peg$currPos = s8;
            s8 = peg$FAILED;
          }
          peg$silentFails--;
          if (s8 === peg$FAILED) {
            s7 = undefined;
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 !== peg$FAILED) {
            if (input.length > peg$currPos) {
              s8 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s8 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e1); }
            }
            if (s8 !== peg$FAILED) {
              s7 = [s7, s8];
              s6 = s7;
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            s6 = peg$currPos;
            s7 = peg$currPos;
            peg$silentFails++;
            s8 = peg$currPos;
            if (input.length > peg$currPos) {
              s9 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s9 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e1); }
            }
            if (s9 !== peg$FAILED) {
              peg$savedPos = peg$currPos;
              s10 = peg$f12(s2, s3, s9);
              if (s10) {
                s10 = undefined;
              } else {
                s10 = peg$FAILED;
              }
              if (s10 !== peg$FAILED) {
                s9 = [s9, s10];
                s8 = s9;
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
            peg$silentFails--;
            if (s8 === peg$FAILED) {
              s7 = undefined;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
            if (s7 !== peg$FAILED) {
              if (input.length > peg$currPos) {
                s8 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s8 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e1); }
              }
              if (s8 !== peg$FAILED) {
                s7 = [s7, s8];
                s6 = s7;
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          }
          s4 = input.substring(s4, peg$currPos);
          s5 = peg$currPos;
          if (input.length > peg$currPos) {
            s6 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s6 !== peg$FAILED) {
            peg$savedPos = peg$currPos;
            s7 = peg$f13(s2, s3, s4, s6);
            if (s7) {
              s7 = undefined;
            } else {
              s7 = peg$FAILED;
            }
            if (s7 !== peg$FAILED) {
              s6 = [s6, s7];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f14(s2, s3, s4);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Verb",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Verb",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseVerbatim() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Verbatim",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseVerbatim_p();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f15(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Verbatim",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Verbatim",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseVerbatim_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Verbatim_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginEnv();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebeginGroup();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 8) === peg$c13) {
          s3 = peg$c13;
          peg$currPos += 8;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e19); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseendGroup();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = [];
            s7 = peg$currPos;
            s8 = peg$currPos;
            peg$silentFails++;
            s9 = peg$currPos;
            s10 = peg$parseendEnv();
            if (s10 !== peg$FAILED) {
              s11 = peg$parsebeginGroup();
              if (s11 !== peg$FAILED) {
                if (input.substr(peg$currPos, 8) === peg$c13) {
                  s12 = peg$c13;
                  peg$currPos += 8;
                } else {
                  s12 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e19); }
                }
                if (s12 !== peg$FAILED) {
                  s13 = peg$parseendGroup();
                  if (s13 !== peg$FAILED) {
                    s10 = [s10, s11, s12, s13];
                    s9 = s10;
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
            } else {
              peg$currPos = s9;
              s9 = peg$FAILED;
            }
            peg$silentFails--;
            if (s9 === peg$FAILED) {
              s8 = undefined;
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
            if (s8 !== peg$FAILED) {
              if (input.length > peg$currPos) {
                s9 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s9 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e1); }
              }
              if (s9 !== peg$FAILED) {
                s8 = [s8, s9];
                s7 = s8;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$currPos;
              s8 = peg$currPos;
              peg$silentFails++;
              s9 = peg$currPos;
              s10 = peg$parseendEnv();
              if (s10 !== peg$FAILED) {
                s11 = peg$parsebeginGroup();
                if (s11 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 8) === peg$c13) {
                    s12 = peg$c13;
                    peg$currPos += 8;
                  } else {
                    s12 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e19); }
                  }
                  if (s12 !== peg$FAILED) {
                    s13 = peg$parseendGroup();
                    if (s13 !== peg$FAILED) {
                      s10 = [s10, s11, s12, s13];
                      s9 = s10;
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
              peg$silentFails--;
              if (s9 === peg$FAILED) {
                s8 = undefined;
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
              if (s8 !== peg$FAILED) {
                if (input.length > peg$currPos) {
                  s9 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s9 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e1); }
                }
                if (s9 !== peg$FAILED) {
                  s8 = [s8, s9];
                  s7 = s8;
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
            }
            s5 = input.substring(s5, peg$currPos);
            s6 = peg$parseendEnv();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsebeginGroup();
              if (s7 !== peg$FAILED) {
                if (input.substr(peg$currPos, 8) === peg$c13) {
                  s8 = peg$c13;
                  peg$currPos += 8;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e19); }
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseendGroup();
                  if (s9 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f16(s5);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsebeginEnv();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsebeginGroup();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 9) === peg$c14) {
            s3 = peg$c14;
            peg$currPos += 9;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e20); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseendGroup();
            if (s4 !== peg$FAILED) {
              s5 = peg$currPos;
              s6 = [];
              s7 = peg$currPos;
              s8 = peg$currPos;
              peg$silentFails++;
              s9 = peg$currPos;
              s10 = peg$parseendEnv();
              if (s10 !== peg$FAILED) {
                s11 = peg$parsebeginGroup();
                if (s11 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 9) === peg$c14) {
                    s12 = peg$c14;
                    peg$currPos += 9;
                  } else {
                    s12 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e20); }
                  }
                  if (s12 !== peg$FAILED) {
                    s13 = peg$parseendGroup();
                    if (s13 !== peg$FAILED) {
                      s10 = [s10, s11, s12, s13];
                      s9 = s10;
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
              peg$silentFails--;
              if (s9 === peg$FAILED) {
                s8 = undefined;
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
              if (s8 !== peg$FAILED) {
                if (input.length > peg$currPos) {
                  s9 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s9 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e1); }
                }
                if (s9 !== peg$FAILED) {
                  s8 = [s8, s9];
                  s7 = s8;
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$currPos;
                s8 = peg$currPos;
                peg$silentFails++;
                s9 = peg$currPos;
                s10 = peg$parseendEnv();
                if (s10 !== peg$FAILED) {
                  s11 = peg$parsebeginGroup();
                  if (s11 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 9) === peg$c14) {
                      s12 = peg$c14;
                      peg$currPos += 9;
                    } else {
                      s12 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e20); }
                    }
                    if (s12 !== peg$FAILED) {
                      s13 = peg$parseendGroup();
                      if (s13 !== peg$FAILED) {
                        s10 = [s10, s11, s12, s13];
                        s9 = s10;
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
                peg$silentFails--;
                if (s9 === peg$FAILED) {
                  s8 = undefined;
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
                if (s8 !== peg$FAILED) {
                  if (input.length > peg$currPos) {
                    s9 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e1); }
                  }
                  if (s9 !== peg$FAILED) {
                    s8 = [s8, s9];
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              }
              s5 = input.substring(s5, peg$currPos);
              s6 = peg$parseendEnv();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsebeginGroup();
                if (s7 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 9) === peg$c14) {
                    s8 = peg$c14;
                    peg$currPos += 9;
                  } else {
                    s8 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e20); }
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseendGroup();
                    if (s9 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s0 = peg$f17(s5);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Verbatim_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Verbatim_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMinted() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Minted",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseMinted_p();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f18(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Minted",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Minted",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMinted_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Minted_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginEnv();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebeginGroup();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c15) {
          s3 = peg$c15;
          peg$currPos += 6;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e21); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseendGroup();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parseArgumentList();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseGroup();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = peg$parseGroup();
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = [];
              s8 = peg$currPos;
              s9 = peg$currPos;
              peg$silentFails++;
              s10 = peg$currPos;
              s11 = peg$parseendEnv();
              if (s11 !== peg$FAILED) {
                s12 = peg$parsebeginGroup();
                if (s12 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 6) === peg$c15) {
                    s13 = peg$c15;
                    peg$currPos += 6;
                  } else {
                    s13 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e21); }
                  }
                  if (s13 !== peg$FAILED) {
                    s14 = peg$parseendGroup();
                    if (s14 !== peg$FAILED) {
                      s11 = [s11, s12, s13, s14];
                      s10 = s11;
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
              } else {
                peg$currPos = s10;
                s10 = peg$FAILED;
              }
              peg$silentFails--;
              if (s10 === peg$FAILED) {
                s9 = undefined;
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
              if (s9 !== peg$FAILED) {
                if (input.length > peg$currPos) {
                  s10 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s10 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e1); }
                }
                if (s10 !== peg$FAILED) {
                  s9 = [s9, s10];
                  s8 = s9;
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
              while (s8 !== peg$FAILED) {
                s7.push(s8);
                s8 = peg$currPos;
                s9 = peg$currPos;
                peg$silentFails++;
                s10 = peg$currPos;
                s11 = peg$parseendEnv();
                if (s11 !== peg$FAILED) {
                  s12 = peg$parsebeginGroup();
                  if (s12 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 6) === peg$c15) {
                      s13 = peg$c15;
                      peg$currPos += 6;
                    } else {
                      s13 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e21); }
                    }
                    if (s13 !== peg$FAILED) {
                      s14 = peg$parseendGroup();
                      if (s14 !== peg$FAILED) {
                        s11 = [s11, s12, s13, s14];
                        s10 = s11;
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
                peg$silentFails--;
                if (s10 === peg$FAILED) {
                  s9 = undefined;
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
                if (s9 !== peg$FAILED) {
                  if (input.length > peg$currPos) {
                    s10 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s10 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e1); }
                  }
                  if (s10 !== peg$FAILED) {
                    s9 = [s9, s10];
                    s8 = s9;
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
              }
              s6 = input.substring(s6, peg$currPos);
              s7 = peg$parseendEnv();
              if (s7 !== peg$FAILED) {
                s8 = peg$parsebeginGroup();
                if (s8 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 6) === peg$c15) {
                    s9 = peg$c15;
                    peg$currPos += 6;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e21); }
                  }
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseendGroup();
                    if (s10 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s0 = peg$f19(s5, s6);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Minted_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Minted_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseLstlisting() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Lstlisting",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseLstlisting_p();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f20(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Lstlisting",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Lstlisting",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseLstlisting_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Lstlisting_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginEnv();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebeginGroup();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 10) === peg$c16) {
          s3 = peg$c16;
          peg$currPos += 10;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e22); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseendGroup();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseArgumentList();
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            s6 = peg$currPos;
            s7 = [];
            s8 = peg$currPos;
            s9 = peg$currPos;
            peg$silentFails++;
            s10 = peg$currPos;
            s11 = peg$parseendEnv();
            if (s11 !== peg$FAILED) {
              s12 = peg$parsebeginGroup();
              if (s12 !== peg$FAILED) {
                if (input.substr(peg$currPos, 10) === peg$c16) {
                  s13 = peg$c16;
                  peg$currPos += 10;
                } else {
                  s13 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e22); }
                }
                if (s13 !== peg$FAILED) {
                  s14 = peg$parseendGroup();
                  if (s14 !== peg$FAILED) {
                    s11 = [s11, s12, s13, s14];
                    s10 = s11;
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
              } else {
                peg$currPos = s10;
                s10 = peg$FAILED;
              }
            } else {
              peg$currPos = s10;
              s10 = peg$FAILED;
            }
            peg$silentFails--;
            if (s10 === peg$FAILED) {
              s9 = undefined;
            } else {
              peg$currPos = s9;
              s9 = peg$FAILED;
            }
            if (s9 !== peg$FAILED) {
              if (input.length > peg$currPos) {
                s10 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s10 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e1); }
              }
              if (s10 !== peg$FAILED) {
                s9 = [s9, s10];
                s8 = s9;
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
            while (s8 !== peg$FAILED) {
              s7.push(s8);
              s8 = peg$currPos;
              s9 = peg$currPos;
              peg$silentFails++;
              s10 = peg$currPos;
              s11 = peg$parseendEnv();
              if (s11 !== peg$FAILED) {
                s12 = peg$parsebeginGroup();
                if (s12 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 10) === peg$c16) {
                    s13 = peg$c16;
                    peg$currPos += 10;
                  } else {
                    s13 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e22); }
                  }
                  if (s13 !== peg$FAILED) {
                    s14 = peg$parseendGroup();
                    if (s14 !== peg$FAILED) {
                      s11 = [s11, s12, s13, s14];
                      s10 = s11;
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
              } else {
                peg$currPos = s10;
                s10 = peg$FAILED;
              }
              peg$silentFails--;
              if (s10 === peg$FAILED) {
                s9 = undefined;
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
              if (s9 !== peg$FAILED) {
                if (input.length > peg$currPos) {
                  s10 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s10 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e1); }
                }
                if (s10 !== peg$FAILED) {
                  s9 = [s9, s10];
                  s8 = s9;
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
            }
            s6 = input.substring(s6, peg$currPos);
            s7 = peg$parseendEnv();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsebeginGroup();
              if (s8 !== peg$FAILED) {
                if (input.substr(peg$currPos, 10) === peg$c16) {
                  s9 = peg$c16;
                  peg$currPos += 10;
                } else {
                  s9 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e22); }
                }
                if (s9 !== peg$FAILED) {
                  s10 = peg$parseendGroup();
                  if (s10 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f21(s5, s6);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Lstlisting_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Lstlisting_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsecommentenv() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "commentenv",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebeginEnv();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsebeginGroup();
        if (s3 !== peg$FAILED) {
          if (input.substr(peg$currPos, 7) === peg$c17) {
            s4 = peg$c17;
            peg$currPos += 7;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e23); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseendGroup();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = [];
              s8 = peg$currPos;
              s9 = peg$currPos;
              peg$silentFails++;
              s10 = peg$currPos;
              s11 = peg$parseendEnv();
              if (s11 !== peg$FAILED) {
                s12 = peg$parsebeginGroup();
                if (s12 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 7) === peg$c17) {
                    s13 = peg$c17;
                    peg$currPos += 7;
                  } else {
                    s13 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e23); }
                  }
                  if (s13 !== peg$FAILED) {
                    s14 = peg$parseendGroup();
                    if (s14 !== peg$FAILED) {
                      s11 = [s11, s12, s13, s14];
                      s10 = s11;
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
              } else {
                peg$currPos = s10;
                s10 = peg$FAILED;
              }
              peg$silentFails--;
              if (s10 === peg$FAILED) {
                s9 = undefined;
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
              if (s9 !== peg$FAILED) {
                if (input.length > peg$currPos) {
                  s10 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s10 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e1); }
                }
                if (s10 !== peg$FAILED) {
                  s9 = [s9, s10];
                  s8 = s9;
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
              while (s8 !== peg$FAILED) {
                s7.push(s8);
                s8 = peg$currPos;
                s9 = peg$currPos;
                peg$silentFails++;
                s10 = peg$currPos;
                s11 = peg$parseendEnv();
                if (s11 !== peg$FAILED) {
                  s12 = peg$parsebeginGroup();
                  if (s12 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 7) === peg$c17) {
                      s13 = peg$c17;
                      peg$currPos += 7;
                    } else {
                      s13 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e23); }
                    }
                    if (s13 !== peg$FAILED) {
                      s14 = peg$parseendGroup();
                      if (s14 !== peg$FAILED) {
                        s11 = [s11, s12, s13, s14];
                        s10 = s11;
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
                peg$silentFails--;
                if (s10 === peg$FAILED) {
                  s9 = undefined;
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
                if (s9 !== peg$FAILED) {
                  if (input.length > peg$currPos) {
                    s10 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s10 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e1); }
                  }
                  if (s10 !== peg$FAILED) {
                    s9 = [s9, s10];
                    s8 = s9;
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
              }
              s6 = input.substring(s6, peg$currPos);
              s7 = peg$parseendEnv();
              if (s7 !== peg$FAILED) {
                s8 = peg$parsebeginGroup();
                if (s8 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 7) === peg$c17) {
                    s9 = peg$c17;
                    peg$currPos += 7;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e23); }
                  }
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseendGroup();
                    if (s10 !== peg$FAILED) {
                      s11 = peg$parseskip_space();
                      if (s11 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s0 = peg$f22(s6);
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "commentenv",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "commentenv",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseInlineMathShift() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "InlineMathShift",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsemathShift();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        s5 = peg$currPos;
        peg$silentFails++;
        s6 = peg$parsemathShift();
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseMathElement();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseskip_space();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s4;
              s4 = peg$f23(s6);
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$currPos;
            s5 = peg$currPos;
            peg$silentFails++;
            s6 = peg$parsemathShift();
            peg$silentFails--;
            if (s6 === peg$FAILED) {
              s5 = undefined;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parseMathElement();
              if (s6 !== peg$FAILED) {
                s7 = peg$parseskip_space();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s4;
                  s4 = peg$f23(s6);
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsemathShift();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f24(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsemathShift();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsewhitespace();
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$currPos;
          s5 = peg$currPos;
          peg$silentFails++;
          s6 = peg$parsemathShift();
          peg$silentFails--;
          if (s6 === peg$FAILED) {
            s5 = undefined;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseMathElement();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseskip_space();
              if (s7 !== peg$FAILED) {
                peg$savedPos = s4;
                s4 = peg$f25(s6);
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$currPos;
            s5 = peg$currPos;
            peg$silentFails++;
            s6 = peg$parsemathShift();
            peg$silentFails--;
            if (s6 === peg$FAILED) {
              s5 = undefined;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parseMathElement();
              if (s6 !== peg$FAILED) {
                s7 = peg$parseskip_space();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s4;
                  s4 = peg$f25(s6);
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          s4 = peg$parsemathShift();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f26(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "InlineMathShift",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "InlineMathShift",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseInlineMathParen() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "InlineMathParen",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginInlineMath();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        s5 = peg$currPos;
        peg$silentFails++;
        s6 = peg$parseendInlineMath();
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseMathElement();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseskip_space();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s4;
              s4 = peg$f27(s6);
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$currPos;
          s5 = peg$currPos;
          peg$silentFails++;
          s6 = peg$parseendInlineMath();
          peg$silentFails--;
          if (s6 === peg$FAILED) {
            s5 = undefined;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseMathElement();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseskip_space();
              if (s7 !== peg$FAILED) {
                peg$savedPos = s4;
                s4 = peg$f27(s6);
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        }
        s4 = peg$parseendInlineMath();
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f28(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "InlineMathParen",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "InlineMathParen",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseDisplayMath() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "DisplayMath",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$parsedisplayMathSquareBracket();
    if (s0 === peg$FAILED) {
      s0 = peg$parsedisplayMathShiftShift();
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "DisplayMath",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "DisplayMath",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsedisplayMathSquareBracket() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "displayMathSquareBracket",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginDisplayMath();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        s5 = peg$currPos;
        peg$silentFails++;
        s6 = peg$parseendDisplayMath();
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseMathElement();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseskip_space();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s4;
              s4 = peg$f29(s6);
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$currPos;
          s5 = peg$currPos;
          peg$silentFails++;
          s6 = peg$parseendDisplayMath();
          peg$silentFails--;
          if (s6 === peg$FAILED) {
            s5 = undefined;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseMathElement();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseskip_space();
              if (s7 !== peg$FAILED) {
                peg$savedPos = s4;
                s4 = peg$f29(s6);
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        }
        s4 = peg$parseendDisplayMath();
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f30(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "displayMathSquareBracket",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "displayMathSquareBracket",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsedisplayMathShiftShift() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "displayMathShiftShift",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsemathShift();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsemathShift();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          s4 = [];
          s5 = peg$currPos;
          s6 = peg$currPos;
          peg$silentFails++;
          s7 = peg$currPos;
          s8 = peg$parsemathShift();
          if (s8 !== peg$FAILED) {
            s9 = peg$parsemathShift();
            if (s9 !== peg$FAILED) {
              s8 = [s8, s9];
              s7 = s8;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          peg$silentFails--;
          if (s7 === peg$FAILED) {
            s6 = undefined;
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parseMathElement();
            if (s7 !== peg$FAILED) {
              s8 = peg$parseskip_space();
              if (s8 !== peg$FAILED) {
                peg$savedPos = s5;
                s5 = peg$f31(s7);
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$currPos;
            s6 = peg$currPos;
            peg$silentFails++;
            s7 = peg$currPos;
            s8 = peg$parsemathShift();
            if (s8 !== peg$FAILED) {
              s9 = peg$parsemathShift();
              if (s9 !== peg$FAILED) {
                s8 = [s8, s9];
                s7 = s8;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
            peg$silentFails--;
            if (s7 === peg$FAILED) {
              s6 = undefined;
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseMathElement();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseskip_space();
                if (s8 !== peg$FAILED) {
                  peg$savedPos = s5;
                  s5 = peg$f31(s7);
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          }
          s5 = peg$parsemathShift();
          if (s5 !== peg$FAILED) {
            s6 = peg$parsemathShift();
            if (s6 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f32(s4);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "displayMathShiftShift",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "displayMathShiftShift",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Command",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$parsePrimitiveCharacterCommand();
    if (s0 === peg$FAILED) {
      s0 = peg$parseLabelCommand();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseescape();
        if (s1 !== peg$FAILED) {
          s2 = peg$parsecommandName();
          if (s2 !== peg$FAILED) {
            s3 = [];
            s4 = peg$parseArgumentList();
            if (s4 === peg$FAILED) {
              s4 = peg$parseGroup();
            }
            if (s4 !== peg$FAILED) {
              while (s4 !== peg$FAILED) {
                s3.push(s4);
                s4 = peg$parseArgumentList();
                if (s4 === peg$FAILED) {
                  s4 = peg$parseGroup();
                }
              }
            } else {
              s3 = peg$FAILED;
            }
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f33(s2, s3);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseCommand_p();
          if (s1 !== peg$FAILED) {
            s2 = peg$parseskip_space();
            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f34(s1);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Command",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Command",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseCommand_p() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Command_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsecommandName();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f35(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Command_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Command_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsecommandName() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "commandName",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    s3 = peg$parsechar();
    if (s3 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 64) {
        s3 = peg$c18;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e24); }
      }
    }
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsechar();
        if (s3 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 64) {
            s3 = peg$c18;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e24); }
          }
        }
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 42) {
          s3 = peg$c19;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e25); }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f36(s1);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsechar();
      if (s2 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 64) {
          s2 = peg$c18;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e24); }
        }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parsechar();
          if (s2 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 64) {
              s2 = peg$c18;
              peg$currPos++;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e24); }
            }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        s0 = input.substring(s0, peg$currPos);
      } else {
        s0 = s1;
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c20) {
          s0 = peg$c20;
          peg$currPos += 2;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e26); }
        }
        if (s0 === peg$FAILED) {
          if (input.length > peg$currPos) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "commandName",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "commandName",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsePrimitiveCharacterCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "PrimitiveCharacterCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (peg$r4.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e27); }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f37(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "PrimitiveCharacterCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "PrimitiveCharacterCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$parseLabelCommand();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseescape();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = peg$parsenonMathCommandName();
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecommandName();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s2 = input.substring(s2, peg$currPos);
        } else {
          s2 = s3;
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseArgumentList();
          if (s4 === peg$FAILED) {
            s4 = peg$parseMathGroup();
          }
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseArgumentList();
            if (s4 === peg$FAILED) {
              s4 = peg$parseMathGroup();
            }
          }
          peg$savedPos = s0;
          s0 = peg$f38(s2, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsenonMathCommandName() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "nonMathCommandName",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3) === peg$c21) {
      s1 = peg$c21;
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e28); }
    }
    if (s1 !== peg$FAILED) {
      if (peg$r3.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e18); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 91) {
        s0 = peg$c22;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e29); }
      }
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 93) {
          s0 = peg$c23;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e30); }
        }
        if (s0 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s0 = peg$c24;
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e31); }
          }
          if (s0 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 41) {
              s0 = peg$c25;
              peg$currPos++;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e32); }
            }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "nonMathCommandName",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "nonMathCommandName",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseDefCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "DefCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 3) === peg$c26) {
        s2 = peg$c26;
        peg$currPos += 3;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e33); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$currPos;
          s6 = peg$parseescape();
          if (s6 !== peg$FAILED) {
            s7 = [];
            s8 = peg$parsechar();
            if (s8 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 64) {
                s8 = peg$c18;
                peg$currPos++;
              } else {
                s8 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e24); }
              }
            }
            if (s8 !== peg$FAILED) {
              while (s8 !== peg$FAILED) {
                s7.push(s8);
                s8 = peg$parsechar();
                if (s8 === peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 64) {
                    s8 = peg$c18;
                    peg$currPos++;
                  } else {
                    s8 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e24); }
                  }
                }
              }
            } else {
              s7 = peg$FAILED;
            }
            if (s7 !== peg$FAILED) {
              s6 = [s6, s7];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            s4 = input.substring(s4, peg$currPos);
          } else {
            s4 = s5;
          }
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$parseArgumentList();
            if (s6 === peg$FAILED) {
              s6 = peg$parseCommandParameterWithNumber();
            }
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parseArgumentList();
              if (s6 === peg$FAILED) {
                s6 = peg$parseCommandParameterWithNumber();
              }
            }
            s6 = peg$parseGroup();
            if (s6 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f39(s4, s5, s6);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "DefCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "DefCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseGroup() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Group",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseGroupIsolated();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f40(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Group",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Group",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseGroupIsolated() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "GroupIsolated",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginGroup();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseskip_comment();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseskip_comment();
      }
      s3 = [];
      s4 = peg$currPos;
      s5 = peg$currPos;
      peg$silentFails++;
      s6 = peg$parseendGroup();
      peg$silentFails--;
      if (s6 === peg$FAILED) {
        s5 = undefined;
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parseElement();
        if (s6 !== peg$FAILED) {
          peg$savedPos = s4;
          s4 = peg$f41(s6);
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        s5 = peg$currPos;
        peg$silentFails++;
        s6 = peg$parseendGroup();
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseElement();
          if (s6 !== peg$FAILED) {
            peg$savedPos = s4;
            s4 = peg$f41(s6);
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      }
      s4 = peg$parseendGroup();
      if (s4 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f42(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "GroupIsolated",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "GroupIsolated",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathGroup() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathGroup",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseMathGroup_p();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f43(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathGroup",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathGroup",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathGroup_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathGroup_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginGroup();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        s5 = peg$currPos;
        peg$silentFails++;
        s6 = peg$parseendGroup();
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseMathElement();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseskip_space();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s4;
              s4 = peg$f44(s6);
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$currPos;
          s5 = peg$currPos;
          peg$silentFails++;
          s6 = peg$parseendGroup();
          peg$silentFails--;
          if (s6 === peg$FAILED) {
            s5 = undefined;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseMathElement();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseskip_space();
              if (s7 !== peg$FAILED) {
                peg$savedPos = s4;
                s4 = peg$f44(s6);
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        }
        s4 = peg$parseendGroup();
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f45(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathGroup_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathGroup_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMatchingDelimiters() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MatchingDelimiters",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseMatchingDelimiters_p();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f46(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MatchingDelimiters",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MatchingDelimiters",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMatchingDelimiters_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MatchingDelimiters_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 4) === peg$c27) {
        s2 = peg$c27;
        peg$currPos += 4;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e34); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$parsemathDelimiter();
          if (s5 !== peg$FAILED) {
            s4 = input.substring(s4, peg$currPos);
          } else {
            s4 = s5;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseskip_space();
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$currPos;
              s8 = peg$currPos;
              peg$silentFails++;
              s9 = peg$currPos;
              s10 = peg$parseescape();
              if (s10 !== peg$FAILED) {
                if (input.substr(peg$currPos, 5) === peg$c28) {
                  s11 = peg$c28;
                  peg$currPos += 5;
                } else {
                  s11 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e35); }
                }
                if (s11 !== peg$FAILED) {
                  s12 = peg$parsemathDelimiter();
                  if (s12 !== peg$FAILED) {
                    s10 = [s10, s11, s12];
                    s9 = s10;
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
              } else {
                peg$currPos = s9;
                s9 = peg$FAILED;
              }
              peg$silentFails--;
              if (s9 === peg$FAILED) {
                s8 = undefined;
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
              if (s8 !== peg$FAILED) {
                s9 = peg$parseMathElement();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parseskip_space();
                  if (s10 !== peg$FAILED) {
                    peg$savedPos = s7;
                    s7 = peg$f47(s4, s9);
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$currPos;
                s8 = peg$currPos;
                peg$silentFails++;
                s9 = peg$currPos;
                s10 = peg$parseescape();
                if (s10 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 5) === peg$c28) {
                    s11 = peg$c28;
                    peg$currPos += 5;
                  } else {
                    s11 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e35); }
                  }
                  if (s11 !== peg$FAILED) {
                    s12 = peg$parsemathDelimiter();
                    if (s12 !== peg$FAILED) {
                      s10 = [s10, s11, s12];
                      s9 = s10;
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
                peg$silentFails--;
                if (s9 === peg$FAILED) {
                  s8 = undefined;
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseMathElement();
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseskip_space();
                    if (s10 !== peg$FAILED) {
                      peg$savedPos = s7;
                      s7 = peg$f47(s4, s9);
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              }
              s7 = peg$parseescape();
              if (s7 !== peg$FAILED) {
                if (input.substr(peg$currPos, 5) === peg$c28) {
                  s8 = peg$c28;
                  peg$currPos += 5;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e35); }
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseskip_space();
                  if (s9 !== peg$FAILED) {
                    s10 = peg$currPos;
                    s11 = peg$parsemathDelimiter();
                    if (s11 !== peg$FAILED) {
                      s10 = input.substring(s10, peg$currPos);
                    } else {
                      s10 = s11;
                    }
                    if (s10 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s0 = peg$f48(s4, s6, s10);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MatchingDelimiters_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MatchingDelimiters_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsemathDelimiter() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "mathDelimiter",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (peg$r5.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e36); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseescape();
      if (s1 !== peg$FAILED) {
        if (peg$r6.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e37); }
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseescape();
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parsechar();
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parsechar();
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 !== peg$FAILED) {
            s1 = [s1, s2];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "mathDelimiter",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "mathDelimiter",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathematicalDelimiters() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathematicalDelimiters",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseMathematicalDelimiters_p();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f49(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathematicalDelimiters",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathematicalDelimiters",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathematicalDelimiters_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathematicalDelimiters_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parsesizeCommand();
    if (s2 === peg$FAILED) {
      s2 = null;
    }
    s1 = input.substring(s1, peg$currPos);
    s2 = peg$parseskip_space();
    if (s2 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 40) {
        s3 = peg$c24;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e31); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parseskip_space();
        if (s4 !== peg$FAILED) {
          s5 = [];
          s6 = peg$currPos;
          s7 = peg$currPos;
          peg$silentFails++;
          s8 = peg$currPos;
          s9 = peg$parsesizeCommand();
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          if (input.charCodeAt(peg$currPos) === 41) {
            s10 = peg$c25;
            peg$currPos++;
          } else {
            s10 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e32); }
          }
          if (s10 !== peg$FAILED) {
            s9 = [s9, s10];
            s8 = s9;
          } else {
            peg$currPos = s8;
            s8 = peg$FAILED;
          }
          peg$silentFails--;
          if (s8 === peg$FAILED) {
            s7 = undefined;
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 !== peg$FAILED) {
            s8 = peg$parseMathElement();
            if (s8 !== peg$FAILED) {
              s9 = peg$parseskip_space();
              if (s9 !== peg$FAILED) {
                peg$savedPos = s6;
                s6 = peg$f50(s1, s8);
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            s6 = peg$currPos;
            s7 = peg$currPos;
            peg$silentFails++;
            s8 = peg$currPos;
            s9 = peg$parsesizeCommand();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            if (input.charCodeAt(peg$currPos) === 41) {
              s10 = peg$c25;
              peg$currPos++;
            } else {
              s10 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e32); }
            }
            if (s10 !== peg$FAILED) {
              s9 = [s9, s10];
              s8 = s9;
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
            peg$silentFails--;
            if (s8 === peg$FAILED) {
              s7 = undefined;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parseMathElement();
              if (s8 !== peg$FAILED) {
                s9 = peg$parseskip_space();
                if (s9 !== peg$FAILED) {
                  peg$savedPos = s6;
                  s6 = peg$f50(s1, s8);
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          }
          s6 = peg$currPos;
          s7 = peg$parsesizeCommand();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s6 = input.substring(s6, peg$currPos);
          s7 = peg$parseskip_space();
          if (s7 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 41) {
              s8 = peg$c25;
              peg$currPos++;
            } else {
              s8 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e32); }
            }
            if (s8 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f51(s1, s5, s6);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parsesizeCommand();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      s1 = input.substring(s1, peg$currPos);
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 91) {
          s3 = peg$c22;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e29); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseskip_space();
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$currPos;
            s7 = peg$currPos;
            peg$silentFails++;
            s8 = peg$currPos;
            s9 = peg$parsesizeCommand();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            if (input.charCodeAt(peg$currPos) === 93) {
              s10 = peg$c23;
              peg$currPos++;
            } else {
              s10 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e30); }
            }
            if (s10 !== peg$FAILED) {
              s9 = [s9, s10];
              s8 = s9;
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
            peg$silentFails--;
            if (s8 === peg$FAILED) {
              s7 = undefined;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parseMathElement();
              if (s8 !== peg$FAILED) {
                s9 = peg$parseskip_space();
                if (s9 !== peg$FAILED) {
                  peg$savedPos = s6;
                  s6 = peg$f52(s1, s8);
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$currPos;
              s7 = peg$currPos;
              peg$silentFails++;
              s8 = peg$currPos;
              s9 = peg$parsesizeCommand();
              if (s9 === peg$FAILED) {
                s9 = null;
              }
              if (input.charCodeAt(peg$currPos) === 93) {
                s10 = peg$c23;
                peg$currPos++;
              } else {
                s10 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e30); }
              }
              if (s10 !== peg$FAILED) {
                s9 = [s9, s10];
                s8 = s9;
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
              peg$silentFails--;
              if (s8 === peg$FAILED) {
                s7 = undefined;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parseMathElement();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseskip_space();
                  if (s9 !== peg$FAILED) {
                    peg$savedPos = s6;
                    s6 = peg$f52(s1, s8);
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            }
            s6 = peg$currPos;
            s7 = peg$parsesizeCommand();
            if (s7 === peg$FAILED) {
              s7 = null;
            }
            s6 = input.substring(s6, peg$currPos);
            s7 = peg$parseskip_space();
            if (s7 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 93) {
                s8 = peg$c23;
                peg$currPos++;
              } else {
                s8 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e30); }
              }
              if (s8 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f53(s1, s5, s6);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$currPos;
        s2 = peg$parsesizeCommand();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        s1 = input.substring(s1, peg$currPos);
        s2 = peg$parseskip_space();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c29) {
            s3 = peg$c29;
            peg$currPos += 2;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e38); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseskip_space();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$currPos;
              s7 = peg$currPos;
              peg$silentFails++;
              s8 = peg$currPos;
              s9 = peg$parsesizeCommand();
              if (s9 === peg$FAILED) {
                s9 = null;
              }
              if (input.substr(peg$currPos, 2) === peg$c30) {
                s10 = peg$c30;
                peg$currPos += 2;
              } else {
                s10 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e39); }
              }
              if (s10 !== peg$FAILED) {
                s9 = [s9, s10];
                s8 = s9;
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
              peg$silentFails--;
              if (s8 === peg$FAILED) {
                s7 = undefined;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parseMathElement();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseskip_space();
                  if (s9 !== peg$FAILED) {
                    peg$savedPos = s6;
                    s6 = peg$f54(s1, s8);
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$currPos;
                s7 = peg$currPos;
                peg$silentFails++;
                s8 = peg$currPos;
                s9 = peg$parsesizeCommand();
                if (s9 === peg$FAILED) {
                  s9 = null;
                }
                if (input.substr(peg$currPos, 2) === peg$c30) {
                  s10 = peg$c30;
                  peg$currPos += 2;
                } else {
                  s10 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e39); }
                }
                if (s10 !== peg$FAILED) {
                  s9 = [s9, s10];
                  s8 = s9;
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
                peg$silentFails--;
                if (s8 === peg$FAILED) {
                  s7 = undefined;
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseMathElement();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseskip_space();
                    if (s9 !== peg$FAILED) {
                      peg$savedPos = s6;
                      s6 = peg$f54(s1, s8);
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              }
              s6 = peg$currPos;
              s7 = peg$parsesizeCommand();
              if (s7 === peg$FAILED) {
                s7 = null;
              }
              s6 = input.substring(s6, peg$currPos);
              s7 = peg$parseskip_space();
              if (s7 !== peg$FAILED) {
                if (input.substr(peg$currPos, 2) === peg$c30) {
                  s8 = peg$c30;
                  peg$currPos += 2;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e39); }
                }
                if (s8 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f55(s1, s5, s6);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathematicalDelimiters_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathematicalDelimiters_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsesizeCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "sizeCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 4) === peg$c31) {
        s2 = peg$c31;
        peg$currPos += 4;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e40); }
      }
      if (s2 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c32) {
          s2 = peg$c32;
          peg$currPos += 4;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e41); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c33) {
            s2 = peg$c33;
            peg$currPos += 3;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e42); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 3) === peg$c34) {
              s2 = peg$c34;
              peg$currPos += 3;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e43); }
            }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        if (peg$r7.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e44); }
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "sizeCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "sizeCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseArgumentList() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "ArgumentList",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseArgumentList_p();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f56(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "ArgumentList",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "ArgumentList",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseArgumentList_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "ArgumentList_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 91) {
      s1 = peg$c22;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e29); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        s5 = peg$currPos;
        peg$silentFails++;
        if (input.charCodeAt(peg$currPos) === 93) {
          s6 = peg$c23;
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e30); }
        }
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseargsDelimiter();
          if (s6 === peg$FAILED) {
            s6 = peg$parseargsToken();
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parseskip_space();
            if (s7 !== peg$FAILED) {
              peg$savedPos = s4;
              s4 = peg$f57(s6);
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$currPos;
          s5 = peg$currPos;
          peg$silentFails++;
          if (input.charCodeAt(peg$currPos) === 93) {
            s6 = peg$c23;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e30); }
          }
          peg$silentFails--;
          if (s6 === peg$FAILED) {
            s5 = undefined;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseargsDelimiter();
            if (s6 === peg$FAILED) {
              s6 = peg$parseargsToken();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseskip_space();
              if (s7 !== peg$FAILED) {
                peg$savedPos = s4;
                s4 = peg$f57(s6);
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        }
        if (input.charCodeAt(peg$currPos) === 93) {
          s4 = peg$c23;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e30); }
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f58(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "ArgumentList_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "ArgumentList_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseargsToken() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "argsToken",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$parseSpecialCommand();
    if (s0 === peg$FAILED) {
      s0 = peg$parseCommand();
      if (s0 === peg$FAILED) {
        s0 = peg$parseGroup();
        if (s0 === peg$FAILED) {
          s0 = peg$parseInlineMathShift();
          if (s0 === peg$FAILED) {
            s0 = peg$parseAlignmentTab();
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = [];
              s2 = peg$parsesp();
              while (s2 !== peg$FAILED) {
                s1.push(s2);
                s2 = peg$parsesp();
              }
              s2 = peg$parsenl();
              if (s2 !== peg$FAILED) {
                s3 = [];
                s4 = peg$parsesp();
                while (s4 !== peg$FAILED) {
                  s3.push(s4);
                  s4 = peg$parsesp();
                }
                s4 = [];
                s5 = peg$parsenl();
                if (s5 !== peg$FAILED) {
                  while (s5 !== peg$FAILED) {
                    s4.push(s5);
                    s5 = peg$parsenl();
                  }
                } else {
                  s4 = peg$FAILED;
                }
                if (s4 !== peg$FAILED) {
                  s5 = [];
                  s6 = peg$parsesp();
                  while (s6 !== peg$FAILED) {
                    s5.push(s6);
                    s6 = peg$parsesp();
                  }
                  peg$savedPos = s0;
                  s0 = peg$f59();
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
              if (s0 === peg$FAILED) {
                s0 = peg$parseCommandParameterWithNumber();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseSuperscript();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseSubscript();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parseActiveCharacter();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parseignore();
                        if (s0 === peg$FAILED) {
                          s0 = peg$currPos;
                          s1 = peg$currPos;
                          s2 = [];
                          s3 = peg$currPos;
                          s4 = peg$currPos;
                          peg$silentFails++;
                          s5 = peg$parsenoncharToken();
                          if (s5 === peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 44) {
                              s5 = peg$c35;
                              peg$currPos++;
                            } else {
                              s5 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$e45); }
                            }
                            if (s5 === peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 93) {
                                s5 = peg$c23;
                                peg$currPos++;
                              } else {
                                s5 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$e30); }
                              }
                            }
                          }
                          peg$silentFails--;
                          if (s5 === peg$FAILED) {
                            s4 = undefined;
                          } else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                          }
                          if (s4 !== peg$FAILED) {
                            if (input.length > peg$currPos) {
                              s5 = input.charAt(peg$currPos);
                              peg$currPos++;
                            } else {
                              s5 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$e1); }
                            }
                            if (s5 !== peg$FAILED) {
                              s4 = [s4, s5];
                              s3 = s4;
                            } else {
                              peg$currPos = s3;
                              s3 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                          if (s3 !== peg$FAILED) {
                            while (s3 !== peg$FAILED) {
                              s2.push(s3);
                              s3 = peg$currPos;
                              s4 = peg$currPos;
                              peg$silentFails++;
                              s5 = peg$parsenoncharToken();
                              if (s5 === peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 44) {
                                  s5 = peg$c35;
                                  peg$currPos++;
                                } else {
                                  s5 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$e45); }
                                }
                                if (s5 === peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 93) {
                                    s5 = peg$c23;
                                    peg$currPos++;
                                  } else {
                                    s5 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$e30); }
                                  }
                                }
                              }
                              peg$silentFails--;
                              if (s5 === peg$FAILED) {
                                s4 = undefined;
                              } else {
                                peg$currPos = s4;
                                s4 = peg$FAILED;
                              }
                              if (s4 !== peg$FAILED) {
                                if (input.length > peg$currPos) {
                                  s5 = input.charAt(peg$currPos);
                                  peg$currPos++;
                                } else {
                                  s5 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$e1); }
                                }
                                if (s5 !== peg$FAILED) {
                                  s4 = [s4, s5];
                                  s3 = s4;
                                } else {
                                  peg$currPos = s3;
                                  s3 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                              }
                            }
                          } else {
                            s2 = peg$FAILED;
                          }
                          if (s2 !== peg$FAILED) {
                            s1 = input.substring(s1, peg$currPos);
                          } else {
                            s1 = s2;
                          }
                          if (s1 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$f60(s1);
                          }
                          s0 = s1;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "argsToken",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "argsToken",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseargsDelimiter() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "argsDelimiter",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 44) {
      s1 = peg$c35;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e45); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f61();
    }
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "argsDelimiter",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "argsDelimiter",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseEnvironment() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Environment",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseEnvironment_p();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f62(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Environment",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Environment",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseEnvironment_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Environment_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginEnv();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsegroupedEnvname();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseArgumentList();
        if (s4 === peg$FAILED) {
          s4 = peg$parseGroup();
        }
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseArgumentList();
          if (s4 === peg$FAILED) {
            s4 = peg$parseGroup();
          }
        }
        s4 = peg$parseskip_space();
        if (s4 !== peg$FAILED) {
          s5 = [];
          s6 = peg$currPos;
          s7 = peg$currPos;
          peg$silentFails++;
          s8 = peg$currPos;
          s9 = peg$parseskip_space();
          if (s9 !== peg$FAILED) {
            s10 = peg$parseendEnv();
            if (s10 !== peg$FAILED) {
              s11 = peg$parseskip_space();
              if (s11 !== peg$FAILED) {
                s12 = peg$parsebeginGroup();
                if (s12 !== peg$FAILED) {
                  s9 = [s9, s10, s11, s12];
                  s8 = s9;
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
          } else {
            peg$currPos = s8;
            s8 = peg$FAILED;
          }
          peg$silentFails--;
          if (s8 === peg$FAILED) {
            s7 = undefined;
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 !== peg$FAILED) {
            s8 = peg$parseElement();
            if (s8 !== peg$FAILED) {
              peg$savedPos = s6;
              s6 = peg$f63(s2, s3, s8);
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            s6 = peg$currPos;
            s7 = peg$currPos;
            peg$silentFails++;
            s8 = peg$currPos;
            s9 = peg$parseskip_space();
            if (s9 !== peg$FAILED) {
              s10 = peg$parseendEnv();
              if (s10 !== peg$FAILED) {
                s11 = peg$parseskip_space();
                if (s11 !== peg$FAILED) {
                  s12 = peg$parsebeginGroup();
                  if (s12 !== peg$FAILED) {
                    s9 = [s9, s10, s11, s12];
                    s8 = s9;
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
              } else {
                peg$currPos = s8;
                s8 = peg$FAILED;
              }
            } else {
              peg$currPos = s8;
              s8 = peg$FAILED;
            }
            peg$silentFails--;
            if (s8 === peg$FAILED) {
              s7 = undefined;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parseElement();
              if (s8 !== peg$FAILED) {
                peg$savedPos = s6;
                s6 = peg$f63(s2, s3, s8);
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          }
          s6 = peg$parseskip_space();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseendEnv();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsegroupedEnvname();
              if (s8 !== peg$FAILED) {
                peg$savedPos = peg$currPos;
                s9 = peg$f64(s2, s3, s5, s8);
                if (s9) {
                  s9 = undefined;
                } else {
                  s9 = peg$FAILED;
                }
                if (s9 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f65(s2, s3, s5, s8);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Environment_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Environment_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathEnvironment() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathEnvironment",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseMathEnvironment_p();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f66(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathEnvironment",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathEnvironment",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathEnvironment_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathEnvironment_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginEnv();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsebeginGroup();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsemathEnvName();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseendGroup();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseskip_space();
              if (s6 !== peg$FAILED) {
                s7 = [];
                s8 = peg$currPos;
                s9 = peg$currPos;
                peg$silentFails++;
                s10 = peg$currPos;
                s11 = peg$parseskip_space();
                if (s11 !== peg$FAILED) {
                  s12 = peg$parseendEnv();
                  if (s12 !== peg$FAILED) {
                    s13 = peg$parseskip_space();
                    if (s13 !== peg$FAILED) {
                      s14 = peg$parsebeginGroup();
                      if (s14 !== peg$FAILED) {
                        s11 = [s11, s12, s13, s14];
                        s10 = s11;
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
                peg$silentFails--;
                if (s10 === peg$FAILED) {
                  s9 = undefined;
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
                if (s9 !== peg$FAILED) {
                  s10 = peg$parseMathElement();
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parseskip_space();
                    if (s11 !== peg$FAILED) {
                      peg$savedPos = s8;
                      s8 = peg$f67(s4, s10);
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
                while (s8 !== peg$FAILED) {
                  s7.push(s8);
                  s8 = peg$currPos;
                  s9 = peg$currPos;
                  peg$silentFails++;
                  s10 = peg$currPos;
                  s11 = peg$parseskip_space();
                  if (s11 !== peg$FAILED) {
                    s12 = peg$parseendEnv();
                    if (s12 !== peg$FAILED) {
                      s13 = peg$parseskip_space();
                      if (s13 !== peg$FAILED) {
                        s14 = peg$parsebeginGroup();
                        if (s14 !== peg$FAILED) {
                          s11 = [s11, s12, s13, s14];
                          s10 = s11;
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                  peg$silentFails--;
                  if (s10 === peg$FAILED) {
                    s9 = undefined;
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseMathElement();
                    if (s10 !== peg$FAILED) {
                      s11 = peg$parseskip_space();
                      if (s11 !== peg$FAILED) {
                        peg$savedPos = s8;
                        s8 = peg$f67(s4, s10);
                      } else {
                        peg$currPos = s8;
                        s8 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                }
                s8 = peg$parseskip_space();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseendEnv();
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseskip_space();
                    if (s10 !== peg$FAILED) {
                      s11 = peg$parsebeginGroup();
                      if (s11 !== peg$FAILED) {
                        s12 = peg$parsemathEnvName();
                        if (s12 !== peg$FAILED) {
                          s13 = peg$parseendGroup();
                          if (s13 !== peg$FAILED) {
                            peg$savedPos = peg$currPos;
                            s14 = peg$f68(s4, s7, s12);
                            if (s14) {
                              s14 = undefined;
                            } else {
                              s14 = peg$FAILED;
                            }
                            if (s14 !== peg$FAILED) {
                              peg$savedPos = s0;
                              s0 = peg$f69(s4, s7, s12);
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathEnvironment_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathEnvironment_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseMathAlignedEnvironment() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "MathAlignedEnvironment",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsebeginEnv();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsebeginGroup();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsemahtAlignedEnvName();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseendGroup();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseskip_space();
              if (s6 !== peg$FAILED) {
                s7 = [];
                s8 = peg$currPos;
                s9 = peg$currPos;
                peg$silentFails++;
                s10 = peg$currPos;
                s11 = peg$parseskip_space();
                if (s11 !== peg$FAILED) {
                  s12 = peg$parseendEnv();
                  if (s12 !== peg$FAILED) {
                    s13 = peg$parseskip_space();
                    if (s13 !== peg$FAILED) {
                      s14 = peg$parsebeginGroup();
                      if (s14 !== peg$FAILED) {
                        s11 = [s11, s12, s13, s14];
                        s10 = s11;
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s10;
                  s10 = peg$FAILED;
                }
                peg$silentFails--;
                if (s10 === peg$FAILED) {
                  s9 = undefined;
                } else {
                  peg$currPos = s9;
                  s9 = peg$FAILED;
                }
                if (s9 !== peg$FAILED) {
                  s10 = peg$parseMathElement();
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parseskip_space();
                    if (s11 !== peg$FAILED) {
                      peg$savedPos = s8;
                      s8 = peg$f70(s4, s10);
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s8;
                  s8 = peg$FAILED;
                }
                while (s8 !== peg$FAILED) {
                  s7.push(s8);
                  s8 = peg$currPos;
                  s9 = peg$currPos;
                  peg$silentFails++;
                  s10 = peg$currPos;
                  s11 = peg$parseskip_space();
                  if (s11 !== peg$FAILED) {
                    s12 = peg$parseendEnv();
                    if (s12 !== peg$FAILED) {
                      s13 = peg$parseskip_space();
                      if (s13 !== peg$FAILED) {
                        s14 = peg$parsebeginGroup();
                        if (s14 !== peg$FAILED) {
                          s11 = [s11, s12, s13, s14];
                          s10 = s11;
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s10;
                    s10 = peg$FAILED;
                  }
                  peg$silentFails--;
                  if (s10 === peg$FAILED) {
                    s9 = undefined;
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseMathElement();
                    if (s10 !== peg$FAILED) {
                      s11 = peg$parseskip_space();
                      if (s11 !== peg$FAILED) {
                        peg$savedPos = s8;
                        s8 = peg$f70(s4, s10);
                      } else {
                        peg$currPos = s8;
                        s8 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                }
                s8 = peg$parseendEnv();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseskip_space();
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parsebeginGroup();
                    if (s10 !== peg$FAILED) {
                      s11 = peg$parsemahtAlignedEnvName();
                      if (s11 !== peg$FAILED) {
                        s12 = peg$parseendGroup();
                        if (s12 !== peg$FAILED) {
                          peg$savedPos = peg$currPos;
                          s13 = peg$f71(s4, s7, s11);
                          if (s13) {
                            s13 = undefined;
                          } else {
                            s13 = peg$FAILED;
                          }
                          if (s13 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s0 = peg$f72(s4, s7, s11);
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "MathAlignedEnvironment",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "MathAlignedEnvironment",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsegroupedEnvname() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "groupedEnvname",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebeginGroup();
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$currPos;
        s5 = [];
        s6 = peg$parsechar();
        if (s6 !== peg$FAILED) {
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            s6 = peg$parsechar();
          }
        } else {
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 42) {
            s6 = peg$c19;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e25); }
          }
          if (s6 === peg$FAILED) {
            s6 = null;
          }
          s5 = [s5, s6];
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s3 = input.substring(s3, peg$currPos);
        } else {
          s3 = s4;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseendGroup();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f73(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "groupedEnvname",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "groupedEnvname",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseAmsmathTextCommand() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "AmsmathTextCommand",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 4) === peg$c36) {
        s2 = peg$c36;
        peg$currPos += 4;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e46); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseGroup();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f74(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "AmsmathTextCommand",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "AmsmathTextCommand",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsefull_comment() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "full_comment",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsenl();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsecomment();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f75(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecomment();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f76(s1);
      }
      s0 = s1;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "full_comment",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "full_comment",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsebeginDisplayMath() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "beginDisplayMath",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 91) {
        s2 = peg$c22;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e29); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "beginDisplayMath",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "beginDisplayMath",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseendDisplayMath() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "endDisplayMath",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 93) {
        s2 = peg$c23;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e30); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "endDisplayMath",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "endDisplayMath",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsebeginInlineMath() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "beginInlineMath",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 40) {
        s2 = peg$c24;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e31); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "beginInlineMath",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "beginInlineMath",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseendInlineMath() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "endInlineMath",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 41) {
        s2 = peg$c25;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e32); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "endInlineMath",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "endInlineMath",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsebeginEnv() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "beginEnv",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 5) === peg$c37) {
        s2 = peg$c37;
        peg$currPos += 5;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e47); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "beginEnv",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "beginEnv",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseendEnv() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "endEnv",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 3) === peg$c21) {
        s2 = peg$c21;
        peg$currPos += 3;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e28); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "endEnv",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "endEnv",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsemathEnvName() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "mathEnvName",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (input.substr(peg$currPos, 9) === peg$c38) {
      s0 = peg$c38;
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e48); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 8) === peg$c39) {
        s0 = peg$c39;
        peg$currPos += 8;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e49); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c40) {
          s0 = peg$c40;
          peg$currPos += 6;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e50); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c41) {
            s0 = peg$c41;
            peg$currPos += 5;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e51); }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 8) === peg$c42) {
              s0 = peg$c42;
              peg$currPos += 8;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e52); }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 7) === peg$c43) {
                s0 = peg$c43;
                peg$currPos += 7;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e53); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 7) === peg$c44) {
                  s0 = peg$c44;
                  peg$currPos += 7;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e54); }
                }
                if (s0 === peg$FAILED) {
                  if (input.substr(peg$currPos, 6) === peg$c45) {
                    s0 = peg$c45;
                    peg$currPos += 6;
                  } else {
                    s0 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e55); }
                  }
                  if (s0 === peg$FAILED) {
                    if (input.substr(peg$currPos, 9) === peg$c46) {
                      s0 = peg$c46;
                      peg$currPos += 9;
                    } else {
                      s0 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e56); }
                    }
                    if (s0 === peg$FAILED) {
                      if (input.substr(peg$currPos, 8) === peg$c47) {
                        s0 = peg$c47;
                        peg$currPos += 8;
                      } else {
                        s0 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$e57); }
                      }
                      if (s0 === peg$FAILED) {
                        if (input.substr(peg$currPos, 8) === peg$c48) {
                          s0 = peg$c48;
                          peg$currPos += 8;
                        } else {
                          s0 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$e58); }
                        }
                        if (s0 === peg$FAILED) {
                          if (input.substr(peg$currPos, 7) === peg$c49) {
                            s0 = peg$c49;
                            peg$currPos += 7;
                          } else {
                            s0 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$e59); }
                          }
                          if (s0 === peg$FAILED) {
                            if (input.substr(peg$currPos, 4) === peg$c50) {
                              s0 = peg$c50;
                              peg$currPos += 4;
                            } else {
                              s0 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$e60); }
                            }
                            if (s0 === peg$FAILED) {
                              if (input.substr(peg$currPos, 11) === peg$c51) {
                                s0 = peg$c51;
                                peg$currPos += 11;
                              } else {
                                s0 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$e61); }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "mathEnvName",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "mathEnvName",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsemahtAlignedEnvName() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "mahtAlignedEnvName",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (input.substr(peg$currPos, 9) === peg$c52) {
      s0 = peg$c52;
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e62); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 7) === peg$c53) {
        s0 = peg$c53;
        peg$currPos += 7;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e63); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c54) {
          s0 = peg$c54;
          peg$currPos += 6;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e64); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c55) {
            s0 = peg$c55;
            peg$currPos += 5;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e65); }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 8) === peg$c56) {
              s0 = peg$c56;
              peg$currPos += 8;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e66); }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 5) === peg$c57) {
                s0 = peg$c57;
                peg$currPos += 5;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e67); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 6) === peg$c58) {
                  s0 = peg$c58;
                  peg$currPos += 6;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e68); }
                }
                if (s0 === peg$FAILED) {
                  if (input.substr(peg$currPos, 7) === peg$c59) {
                    s0 = peg$c59;
                    peg$currPos += 7;
                  } else {
                    s0 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e69); }
                  }
                  if (s0 === peg$FAILED) {
                    if (input.substr(peg$currPos, 7) === peg$c60) {
                      s0 = peg$c60;
                      peg$currPos += 7;
                    } else {
                      s0 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e70); }
                    }
                    if (s0 === peg$FAILED) {
                      if (input.substr(peg$currPos, 7) === peg$c61) {
                        s0 = peg$c61;
                        peg$currPos += 7;
                      } else {
                        s0 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$e71); }
                      }
                      if (s0 === peg$FAILED) {
                        if (input.substr(peg$currPos, 7) === peg$c62) {
                          s0 = peg$c62;
                          peg$currPos += 7;
                        } else {
                          s0 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$e72); }
                        }
                        if (s0 === peg$FAILED) {
                          if (input.substr(peg$currPos, 7) === peg$c63) {
                            s0 = peg$c63;
                            peg$currPos += 7;
                          } else {
                            s0 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$e73); }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "mahtAlignedEnvName",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "mahtAlignedEnvName",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseescape() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "escape",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (input.charCodeAt(peg$currPos) === 92) {
      s0 = peg$c64;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e74); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "escape",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "escape",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsebeginGroup() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "beginGroup",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (input.charCodeAt(peg$currPos) === 123) {
      s0 = peg$c8;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e13); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "beginGroup",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "beginGroup",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseendGroup() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "endGroup",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (input.charCodeAt(peg$currPos) === 125) {
      s0 = peg$c7;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e12); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "endGroup",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "endGroup",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsemathShift() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "mathShift",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (input.charCodeAt(peg$currPos) === 36) {
      s0 = peg$c65;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e75); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "mathShift",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "mathShift",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseAlignmentTab() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "AlignmentTab",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 38) {
      s1 = peg$c66;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e76); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f77();
    }
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "AlignmentTab",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "AlignmentTab",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsecommandParameter() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "commandParameter",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (input.charCodeAt(peg$currPos) === 35) {
      s0 = peg$c67;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e77); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "commandParameter",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "commandParameter",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseSuperscriptWithArg() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "SuperscriptWithArg",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseSuperscript();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseMathElement();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f78(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "SuperscriptWithArg",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "SuperscriptWithArg",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseSuperscript() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Superscript",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 94) {
      s1 = peg$c68;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e78); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f79();
    }
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Superscript",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Superscript",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseSubscriptWithArg() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "SubscriptWithArg",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseSubscript();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseMathElement();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f80(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "SubscriptWithArg",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "SubscriptWithArg",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseSubscript() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Subscript",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 95) {
      s1 = peg$c69;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e79); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f81();
    }
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Subscript",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Subscript",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseignore() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "ignore",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 0) {
      s1 = peg$c70;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e80); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f82();
    }
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "ignore",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "ignore",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsechar() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "char",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (peg$r8.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e81); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "char",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "char",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsenum() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "num",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (peg$r9.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e82); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "num",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "num",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsepunctuation() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "punctuation",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (peg$r10.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e83); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "punctuation",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "punctuation",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseActiveCharacter() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "ActiveCharacter",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 126) {
      s1 = peg$c71;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e84); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f83();
    }
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "ActiveCharacter",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "ActiveCharacter",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseCommandParameterWithNumber() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "CommandParameterWithNumber",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsecommandParameter();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = peg$parsenum();
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$parsenum();
      }
      s2 = input.substring(s2, peg$currPos);
      peg$savedPos = s0;
      s0 = peg$f84(s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "CommandParameterWithNumber",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "CommandParameterWithNumber",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseendDoc() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "endDoc",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseendEnv();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseskip_space();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsebeginGroup();
        if (s3 !== peg$FAILED) {
          if (input.substr(peg$currPos, 8) === peg$c72) {
            s4 = peg$c72;
            peg$currPos += 8;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e85); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseendGroup();
            if (s5 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4, s5];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "endDoc",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "endDoc",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsecomment() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "comment",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 37) {
      s1 = peg$c1;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e5); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = peg$currPos;
      s5 = peg$currPos;
      peg$silentFails++;
      s6 = peg$parsenl();
      peg$silentFails--;
      if (s6 === peg$FAILED) {
        s5 = undefined;
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      if (s5 !== peg$FAILED) {
        if (input.length > peg$currPos) {
          s6 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e1); }
        }
        if (s6 !== peg$FAILED) {
          s5 = [s5, s6];
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        s5 = peg$currPos;
        peg$silentFails++;
        s6 = peg$parsenl();
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          if (input.length > peg$currPos) {
            s6 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s6 !== peg$FAILED) {
            s5 = [s5, s6];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      }
      s2 = input.substring(s2, peg$currPos);
      s3 = peg$parsenl();
      if (s3 === peg$FAILED) {
        s3 = peg$parseEOF();
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f85(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "comment",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "comment",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseLinebreak() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Linebreak",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseskip_space();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseLinebreak_p();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseskip_space();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f86(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Linebreak",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Linebreak",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseLinebreak_p() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Linebreak_p",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parseescape();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 9) === peg$c73) {
        s2 = peg$c73;
        peg$currPos += 9;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e86); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseArgumentList();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = peg$parsechar();
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f87(s2, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseescape();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$parseescape();
        if (s3 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 42) {
            s4 = peg$c19;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e25); }
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = peg$parseescape();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseArgumentList();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f88(s2, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseescape();
        if (s1 !== peg$FAILED) {
          if (input.substr(peg$currPos, 7) === peg$c74) {
            s2 = peg$c74;
            peg$currPos += 7;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e87); }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$currPos;
            peg$silentFails++;
            s4 = peg$parsechar();
            peg$silentFails--;
            if (s4 === peg$FAILED) {
              s3 = undefined;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f89(s2);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Linebreak_p",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Linebreak_p",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseSoftbreak() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Softbreak",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$currPos;
    s3 = peg$currPos;
    peg$silentFails++;
    s4 = peg$parsebreak();
    peg$silentFails--;
    if (s4 === peg$FAILED) {
      s3 = undefined;
    } else {
      peg$currPos = s3;
      s3 = peg$FAILED;
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parsesp();
      if (s4 === peg$FAILED) {
        s4 = peg$parseskip_comment();
      }
      if (s4 !== peg$FAILED) {
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$currPos;
      s3 = peg$currPos;
      peg$silentFails++;
      s4 = peg$parsebreak();
      peg$silentFails--;
      if (s4 === peg$FAILED) {
        s3 = undefined;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parsesp();
        if (s4 === peg$FAILED) {
          s4 = peg$parseskip_comment();
        }
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    }
    s2 = peg$currPos;
    peg$silentFails++;
    s3 = peg$parsebreak();
    peg$silentFails--;
    if (s3 === peg$FAILED) {
      s2 = undefined;
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parsenl();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$currPos;
        s6 = peg$currPos;
        peg$silentFails++;
        s7 = peg$parsebreak();
        peg$silentFails--;
        if (s7 === peg$FAILED) {
          s6 = undefined;
        } else {
          peg$currPos = s6;
          s6 = peg$FAILED;
        }
        if (s6 !== peg$FAILED) {
          s7 = peg$parsesp();
          if (s7 === peg$FAILED) {
            s7 = peg$parseskip_comment();
          }
          if (s7 !== peg$FAILED) {
            s6 = [s6, s7];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$currPos;
          s6 = peg$currPos;
          peg$silentFails++;
          s7 = peg$parsebreak();
          peg$silentFails--;
          if (s7 === peg$FAILED) {
            s6 = undefined;
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parsesp();
            if (s7 === peg$FAILED) {
              s7 = peg$parseskip_comment();
            }
            if (s7 !== peg$FAILED) {
              s6 = [s6, s7];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        }
        peg$savedPos = s0;
        s0 = peg$f90();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Softbreak",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Softbreak",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseSpace() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "Space",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$currPos;
    s3 = peg$currPos;
    peg$silentFails++;
    s4 = peg$parsebreak();
    peg$silentFails--;
    if (s4 === peg$FAILED) {
      s3 = undefined;
    } else {
      peg$currPos = s3;
      s3 = peg$FAILED;
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parsenl();
      if (s4 === peg$FAILED) {
        s4 = peg$parsesp();
      }
      if (s4 !== peg$FAILED) {
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$currPos;
        s3 = peg$currPos;
        peg$silentFails++;
        s4 = peg$parsebreak();
        peg$silentFails--;
        if (s4 === peg$FAILED) {
          s3 = undefined;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsenl();
          if (s4 === peg$FAILED) {
            s4 = peg$parsesp();
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f91();
    }
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "Space",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "Space",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsewhitespace() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "whitespace",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsenl();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsesp();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsesp();
      }
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsesp();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parsesp();
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsenl();
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parsesp();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parsesp();
          }
          s4 = peg$currPos;
          peg$silentFails++;
          s5 = peg$parsenl();
          peg$silentFails--;
          if (s5 === peg$FAILED) {
            s4 = undefined;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s1 = [s1, s2, s3, s4];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = [];
        s1 = peg$parsesp();
        if (s1 !== peg$FAILED) {
          while (s1 !== peg$FAILED) {
            s0.push(s1);
            s1 = peg$parsesp();
          }
        } else {
          s0 = peg$FAILED;
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "whitespace",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "whitespace",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsenl() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "nl",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (input.charCodeAt(peg$currPos) === 10) {
      s0 = peg$c75;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e88); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c76) {
        s0 = peg$c76;
        peg$currPos += 2;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e89); }
      }
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 13) {
          s0 = peg$c77;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e90); }
        }
        if (s0 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 8232) {
            s0 = peg$c78;
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e91); }
          }
          if (s0 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 8233) {
              s0 = peg$c79;
              peg$currPos++;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e92); }
            }
          }
        }
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "nl",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "nl",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsesp() {
    var startPos = peg$currPos;
    var s0;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "sp",
      location: peg$computeLocation(startPos, startPos, true)
    });

    if (peg$r11.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e93); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "sp",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "sp",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseskip_space() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "skip_space",
      location: peg$computeLocation(startPos, startPos, true)
    });

    peg$silentFails++;
    s0 = peg$currPos;
    peg$silentFails++;
    if (peg$r12.test(input.charAt(peg$currPos))) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e95); }
    }
    peg$silentFails--;
    if (s1 !== peg$FAILED) {
      peg$currPos = s0;
      s0 = undefined;
    } else {
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = [];
      if (peg$r0.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e2); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$r0.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e2); }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        peg$silentFails++;
        s3 = peg$parsecharTokenOptm();
        peg$silentFails--;
        if (s3 !== peg$FAILED) {
          peg$currPos = s2;
          s2 = undefined;
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = [];
        s1 = peg$currPos;
        s2 = peg$currPos;
        peg$silentFails++;
        s3 = peg$parsebreak();
        peg$silentFails--;
        if (s3 === peg$FAILED) {
          s2 = undefined;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsenl();
          if (s3 === peg$FAILED) {
            s3 = peg$parsesp();
            if (s3 === peg$FAILED) {
              s3 = peg$parseskip_comment();
            }
          }
          if (s3 !== peg$FAILED) {
            s2 = [s2, s3];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          s1 = peg$currPos;
          s2 = peg$currPos;
          peg$silentFails++;
          s3 = peg$parsebreak();
          peg$silentFails--;
          if (s3 === peg$FAILED) {
            s2 = undefined;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parsenl();
            if (s3 === peg$FAILED) {
              s3 = peg$parsesp();
              if (s3 === peg$FAILED) {
                s3 = peg$parseskip_comment();
              }
            }
            if (s3 !== peg$FAILED) {
              s2 = [s2, s3];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e94); }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "skip_space",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "skip_space",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseskip_comment() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "skip_comment",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = peg$parsecomment();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f92(s1);
    }
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "skip_comment",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "skip_comment",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseskip_all_space() {
    var startPos = peg$currPos;
    var s0, s1, s2;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "skip_all_space",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsenl();
    if (s2 === peg$FAILED) {
      s2 = peg$parsesp();
      if (s2 === peg$FAILED) {
        s2 = peg$parseskip_comment();
      }
    }
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsenl();
      if (s2 === peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 === peg$FAILED) {
          s2 = peg$parseskip_comment();
        }
      }
    }
    peg$savedPos = s0;
    s1 = peg$f93();
    s0 = s1;

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "skip_all_space",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "skip_all_space",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parsebreak() {
    var startPos = peg$currPos;
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "break",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$currPos;
    s3 = peg$parseskip_all_space();
    s4 = peg$parseescape();
    if (s4 !== peg$FAILED) {
      if (input.substr(peg$currPos, 3) === peg$c80) {
        s5 = peg$c80;
        peg$currPos += 3;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e96); }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$currPos;
        peg$silentFails++;
        s7 = peg$parsechar();
        peg$silentFails--;
        if (s7 === peg$FAILED) {
          s6 = undefined;
        } else {
          peg$currPos = s6;
          s6 = peg$FAILED;
        }
        if (s6 !== peg$FAILED) {
          s7 = peg$parseskip_all_space();
          s3 = [s3, s4, s5, s6, s7];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$currPos;
        s3 = peg$parseskip_all_space();
        s4 = peg$parseescape();
        if (s4 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c80) {
            s5 = peg$c80;
            peg$currPos += 3;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e96); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$currPos;
            peg$silentFails++;
            s7 = peg$parsechar();
            peg$silentFails--;
            if (s7 === peg$FAILED) {
              s6 = undefined;
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseskip_all_space();
              s3 = [s3, s4, s5, s6, s7];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f94();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsesp();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsesp();
      }
      s2 = peg$currPos;
      s3 = peg$parsenl();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parseskip_comment();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseskip_comment();
        }
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = [];
        s3 = peg$parseskip_comment();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseskip_comment();
          }
        } else {
          s2 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        s5 = [];
        s6 = peg$parsesp();
        while (s6 !== peg$FAILED) {
          s5.push(s6);
          s6 = peg$parsesp();
        }
        s6 = peg$parsenl();
        if (s6 !== peg$FAILED) {
          s5 = [s5, s6];
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$currPos;
            s5 = [];
            s6 = peg$parsesp();
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parsesp();
            }
            s6 = peg$parsenl();
            if (s6 !== peg$FAILED) {
              s5 = [s5, s6];
              s4 = s5;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s4 = [];
          s5 = peg$parsesp();
          if (s5 === peg$FAILED) {
            s5 = peg$parsenl();
            if (s5 === peg$FAILED) {
              s5 = peg$parseskip_comment();
            }
          }
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parsesp();
            if (s5 === peg$FAILED) {
              s5 = peg$parsenl();
              if (s5 === peg$FAILED) {
                s5 = peg$parseskip_comment();
              }
            }
          }
          peg$savedPos = s0;
          s0 = peg$f95();
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "break",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "break",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }

  function peg$parseEOF() {
    var startPos = peg$currPos;
    var s0, s1;

    peg$tracer.trace({
      type: "rule.enter",
      rule: "EOF",
      location: peg$computeLocation(startPos, startPos, true)
    });

    s0 = peg$currPos;
    peg$silentFails++;
    if (input.length > peg$currPos) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e1); }
    }
    peg$silentFails--;
    if (s1 === peg$FAILED) {
      s0 = undefined;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    if (s0 !== peg$FAILED) {
      peg$tracer.trace({
        type: "rule.match",
        rule: "EOF",
        result: s0,
        location: peg$computeLocation(startPos, peg$currPos, true)
      });
    } else {
      peg$tracer.trace({
        type: "rule.fail",
        rule: "EOF",
        location: peg$computeLocation(startPos, startPos, true)
      });
    }

    return s0;
  }


  const timeKeeper = options.timeout;
  const commentMap = options.enableComment ? new Map() : undefined;

  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

module.exports = {
  SyntaxError: peg$SyntaxError,
  DefaultTracer: peg$DefaultTracer,
  parse: peg$parse
};
