"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parse = exports.SyntaxError = exports.isSyntaxError = void 0;
const _bibtexParser = require("./bibtex_parser_simple");
const _bibtexParserWithTrace = require("./bibtex_parser_trace");
const timeout_1 = require("../pegjs/timeout");
__exportStar(require("./bibtex_parser_types"), exports);
var pegjs_types_1 = require("../pegjs/pegjs_types");
Object.defineProperty(exports, "isSyntaxError", { enumerable: true, get: function () { return pegjs_types_1.isSyntaxError; } });
Object.defineProperty(exports, "SyntaxError", { enumerable: true, get: function () { return pegjs_types_1.SyntaxError; } });
function parse(s, _option) {
    const option = _option ? Object.assign({}, _option) : undefined;
    if (option && option.timeout) {
        if (typeof option.timeout !== 'object') {
            option.timeout = new timeout_1.TimeKeeper(option.timeout);
        }
    }
    if (option && option.tracer) {
        return _bibtexParserWithTrace.parse(s, option);
    }
    else {
        return _bibtexParser.parse(s, option);
    }
}
exports.parse = parse;
//# sourceMappingURL=bibtex_parser.js.map