import sys
from pathlib import Path
sys.path.append(str(Path(__file__).parent.parent))

import imageio
import numpy as np
import glob
import os
import torch

from core.tokenizer.cogvideo import CogvideoTokenizer
from core.tokenizer.wan import WanTokenizer

max_frames = 81


model_path = 'pretrained/Wan2.1-I2V-14B-480P-Diffusers/vae'
tokenizer = WanTokenizer(model_path=model_path)

save_dir = 'results/tokenizer_composite_test'
input_rgb_latent = "test_latent.pt"
os.makedirs(save_dir, exist_ok=True)

latent = torch.load(input_latent)
latent = latent.to(tokenizer.device)
latent = latent.to(tokenizer.dtype)

latent = latent[None]
rgb = tokenizer.decode(latent)
imageio.mimwrite(f'{save_dir}/rgb.mp4', (rgb*255).clip(0, 255).astype(np.uint8))
