#!/bin/bash
#SBATCH --job-name=sft
#SBATCH --nodes=2
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=64
#SBATCH --ntasks=2
#SBATCH --gpus-per-task=8
#SBATCH --partition=3dobject_aigc_scale
#SBATCH --quotatype=reserved
#SBATCH --output=./logs/%j_%x_out.log
#SBATCH --err=./logs/%j_%x_err.log

# configs
LOG_PATH="log_final.txt"
GPUS_PER_NODE=8

echo "START TIME: $(date)"

# NCCL & AWS
export NCCL_PROTO=simple
export RDMAV_FORK_SAFE=1
export FI_EFA_FORK_SAFE=1
export FI_EFA_USE_DEVICE_RDMA=1
export FI_PROVIDER=efa
export FI_LOG_LEVEL=1
export NCCL_IB_DISABLE=0
export NCCL_SOCKET_IFNAME=ib0

# network
unset http_proxy
unset https_proxy

MASTER_ADDR=$(scontrol show hostnames $SLURM_JOB_NODELIST | head -n 1)
MASTER_PORT=13547 # use 5 digits ports

NNODES=$SLURM_NNODES
NUM_PROCESSES=$(expr $NNODES \* $GPUS_PER_NODE)



# Prevent tokenizer parallelism issues
export TOKENIZERS_PARALLELISM=false

# Note: it is important to escape `$SLURM_PROCID` since we want the srun on each node to evaluate this variable
export LAUNCHER="accelerate launch \
    --config_file configs_acc/8gpu.yaml \
    --main_process_ip $MASTER_ADDR \
    --main_process_port $MASTER_PORT \
    --machine_rank \$SLURM_NODEID \
    --num_processes $NUM_PROCESSES \
    --num_machines $NNODES \
    "

export PROGRAM="\
finetune_cogvideo.py \
    --model_path /mnt/petrelfs/chenzhaoxi/project/PVGen/pretrained/CogVideoX1.5-5B-I2V \
    --model_name cogvideox1.5-i2v \
    --model_type i2pm \
    --training_type sft \
    --output_dir training/output_pointmap_cogvideo15_xyzrgb_i2pm_sft \
    --report_to tensorboard \
    --data_root /mnt/petrelfs/chenzhaoxi/project/PVGen/data/cog15 \
    --caption_column prompts_debug.txt \
    --video_column videos_debug.txt \
    --train_resolution 81x768x1360 \
    --train_epochs 10 \
    --seed \$SLURM_NODEID \
    --batch_size 1 \
    --gradient_accumulation_steps 1 \
    --mixed_precision bf16 \
    --num_workers 8 \
    --pin_memory True \
    --nccl_timeout 1800 \
    --checkpointing_steps 200 \
    --checkpointing_limit 2 \
    --do_validation false  \
    --validation_dir /mnt/petrelfs/chenzhaoxi/project/PVGen/data/cog15 \
    --validation_steps 200 \
    --validation_prompts prompts_val.txt \
    --validation_images images.txt \
    --gen_fps 24 \
"


export CMD="$LAUNCHER $PROGRAM"

srun --jobid $SLURM_JOBID bash -c "$CMD" 2>&1 | tee -a $LOG_PATH

echo "END TIME: $(date)"