import csv
import argparse
from petrel_client.client import Client
from tqdm import tqdm

def parse_clip_paths(csv_file_path, output_txt_path, client):
    """Reads the CSV file and writes the 'clip_path' column values to a text file."""
    with open(csv_file_path, mode='r', encoding='utf-8', newline='') as csvfile:
        reader = csv.DictReader(csvfile)
        with open(output_txt_path, mode='w', encoding='utf-8') as txtfile:
            for row in tqdm(reader):
                clip_path = row.get('clip_path')
                import pdb; pdb.set_trace()
                if clip_path:
                    ceph_root_dir = clip_path.split('.')[0]
                    video_name = clip_path
                    ori_video_path = f'pvgen:s3://4DGen-Dataset/Human_Raw_Data/{video_name}'
                    pexelx_name = video_name.split('/')[1]
                    name = video_name.split('/')[-1].split('.')[0]
                    annot_dir = f'pexelx_st/{pexelx_name}/{name}'
                    ceph_root_dir = f'pvgen:s3://4DGen-Dataset/{annot_dir}/'
                    clip_path_list = [f'{ceph_root_dir}{p}' for p in client.list(ceph_root_dir)]
                    for cpath in clip_path_list:
                        txtfile.write(cpath + "\n")

def main():
    parser = argparse.ArgumentParser(
        description="Extract 'clip_path' values from a CSV file and save them to a text file."
    )
    parser.add_argument("--csv", help="Path to the input CSV file")
    parser.add_argument("--output", help="Path to the output text file")
    args = parser.parse_args()
    
    s3_conf_path = '~/petreloss.conf'
    client = Client(s3_conf_path)
    parse_clip_paths(args.csv, args.output, client)
    print(f"Clip paths have been extracted from '{args.csv}' and saved to '{args.output}'.")

if __name__ == "__main__":
    main()
