import os
import random
import shutil

# --- Configuration ---
sample_size = 10
# videos_txt = "/mnt/petrelfs/chenzhaoxi.p/project/pointdiff/data/mar07/videos.txt"      # file containing video paths (.mp4)
# prompts_txt = "/mnt/petrelfs/chenzhaoxi.p/project/pointdiff/data/mar07/prompts.txt"    # file containing corresponding prompts
# image_folder = "/mnt/petrelfs/chenzhaoxi.p/project/pointdiff/data/mar07/first_frames"      # folder where original first-frame images are stored
# target_folder = "/mnt/petrelfs/chenzhaoxi.p/project/pointdiff/data/evaluation/first_frames"      # folder to move the selected first-frame images

videos_txt = "/mnt/petrelfs/chenzhaoxi/project/PVGen/data/cog15/videos.txt"      # file containing video paths (.mp4)
prompts_txt = "/mnt/petrelfs/chenzhaoxi/project/PVGen/data/cog15/prompts.txt"    # file containing corresponding prompts
image_folder = "/mnt/petrelfs/chenzhaoxi/project/PVGen/data/cog15/first_frames"      # folder where original first-frame images are stored
target_folder = "/mnt/petrelfs/chenzhaoxi/project/PVGen/data/evaluation_cog15/first_frames"      # folder to move the selected first-frame images

# Ensure the target folder exists
os.makedirs(target_folder, exist_ok=True)

# --- Read the input files ---
with open(videos_txt, 'r') as f:
    videos = [line.strip() for line in f if line.strip()]

with open(prompts_txt, 'r') as f:
    prompts = [line.strip() for line in f if line.strip()]

# Ensure both files have the same number of lines
if len(videos) != len(prompts):
    raise ValueError("The number of videos and prompts do not match.")

# --- Randomly sample 100 indices ---
indices = random.sample(range(len(videos)), sample_size)

# Prepare lists to store the sampled prompts and new image paths
sampled_prompts = []
sampled_image_paths = []

# --- Process each sampled index ---
for idx in indices:
    video_path = videos[idx]
    prompt = prompts[idx]
    
    # Parse the filename from the video path, replacing .mp4 with .png
    video_filename = os.path.basename(video_path)
    image_filename = video_filename.replace('.mp4', '.png')
    
    # Build full paths for the source and target image
    source_image_path = os.path.join(image_folder, image_filename)
    target_image_path = os.path.join(target_folder, image_filename)
    
    # Move the image if it exists
    if os.path.exists(source_image_path):
        shutil.copy(source_image_path, target_image_path)
    else:
        print(f"Warning: {source_image_path} does not exist.")
    
    # Store the prompt and new image path
    sampled_prompts.append(prompt)
    sampled_image_paths.append(target_image_path)

# --- Write out the sampled prompts to prompts_val.txt ---
with open("prompts_val.txt", "w") as f:
    for prompt in sampled_prompts:
        f.write(prompt + "\n")

# --- Write out the new image paths to images_val.txt ---
with open("images_val.txt", "w") as f:
    for path in sampled_image_paths:
        f.write(path + "\n")

print("Sampling and file processing completed.")
