import numpy as np
import pickle
from core.dataclass import Pointmap

def generate_uniform_pointmap(width, height, depth_value, save_path):
    # Create a grid of (x, y) coordinates
    x = np.linspace(0, 1, width)
    y = np.linspace(0, 1, height)
    xv, yv = np.meshgrid(x, y)
    # Create a uniform depth array
    zv = np.full_like(xv, fill_value=depth_value)
    # Stack to shape (height, width, 3)
    pointmap = np.stack([xv, yv, zv], axis=-1)
    # Add batch dimension if needed (1, H, W, 3)
    pointmap = pointmap[None, ...]
    # Save using Pointmap class
    pm = Pointmap()
    pm.init_dummy(pointmap.shape[0], pointmap.shape[1], pointmap.shape[2])
    pm.pcd = pointmap.reshape(*pm.pcd.shape)
    pickle.dump(pm, open(save_path, 'wb'))
    print(f"Saved uniform pointmap to {save_path}")

if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument("--width", type=int, default=720)
    parser.add_argument("--height", type=int, default=480)
    parser.add_argument("--depth", type=float, default=1.0)
    parser.add_argument("--out", type=str, default="uniform_pointmap.pkl")
    args = parser.parse_args()
    generate_uniform_pointmap(args.width, args.height, args.depth, args.out)
