## Easy4DGen

![Alt Text](assets/results.gif)

This code provides following features:
- [x] Loading monst3r annotations
- [x] Visualizing and tokenizing pointmap
- [x] Building dataset for Wan 2.1 finetuning
- [x] Finetuning Wan 2.1 for pointmap generation with multiple ways (sft, lora, lora with learnable embedding but same RoPE)
- [x] Visualization script based on rerun
---
### 0. Install (Environment has been set up on 10.140.0.31/32/33)
```sh
conda create -n "pvgen" python=3.10 -y
conda activate pvgen
pip3 install torch torchvision --index-url https://download.pytorch.org/whl/cu121
pip install requirements.txt

# git lfs and rerun
conda install -c conda-forge git-lfs
conda install -c conda-forge rerun-sdk
```

### 1. Visualization (Please use rerun for latest visualization)

Given the folder PKL_DIR and the path to store the rerun recording RR_RECORDING_PATH, run:
```
python rerun_vis.py --rr_recording_dir <RR_RECORDING_PATH> --pkl_dir <PKL_DIR>
```

Then, visualize the recording in the browser by running:
```
rerun <RR_RECORDING_PATH> --web-viewer
```

### 2. Inference
```sh
srun -p 3dobject_aigc_scale --quotatype=reserved --gres=gpu:1 -n1 --ntasks-per-node=1 --job-name=test python infer_wan.py --prompt ./data/evaluation/prompts_short.txt --image ./data/evaluation/images_short.txt --out <OUTPUT_DIR> --sft_path ./pretrained/Wan2.1-I2V-14B-480P-Diffusers/transformer  --type i2vwbw-demb-samerope --mode xyzrgb --lora_path <TRAINED_LORA_PATH>
```

### 3. Dataset Preparation for CogVideo SFT
Run scripts to build a dataset for CogVideo finetuning. The dataset will be in the CogVideo format. We additionally save pointmap latents and video latents.
```
# get all monst3r annotations
python scripts/make_datalist.py

# run tokenization with slurm jobarray
sbatch scripts/slurm/build_dataset.sh
```
IMPORTANT!!! PJLab clusters does not allow distributed deletion! Need to change the cache removing code before running tokenization.

### 4. CogVideo SFT
For XYZ generation:
```
bash scripts/slurm/finetune_cogvideo.sh
```

XYZ+RGB generation (only left half of the image):
```
bash scripts/slurm/finetune_cogvideo_xyzrgb.sh
```

### 5. Infer Finetuned CogVideo checkpoint
Convert the checkpoint:
```
python scripts/zero_to_fp32.py CHECKPOINT_DIR NEW_CHECKPOINT_DIR --safe_serialization
```

For XYZ generation:
```
bash scripts/slurm/batch_infer_cogvideo.sh
```

XYZ+RGB generation (only left half of the image):
```
bash scripts/slurm/batch_infer_cogvideo_xyzrgb.sh
```

Replace model checkpoint path in the slurm scipt above.


### X. Other Notes
##### Monst3R annotation formats
- `4DGen-Dataset/pexelx_st/pexels/[uid]-[frameid]/clip_[clipid].mp4`
  - `dynamic_mask_0.png`  # dynamic mask
  - `enlarged_dynamic_mask_0.png`    # dynamic mask
  - `frame_0000.npy`  # depth map
  - `frame_0000.png`  # depth visualization
  - `pred_intrinsics.txt` # camera intrinsics
  - `pred_traj.txt` # camera poses

video path: `4DGen-Dataset/Human_Raw_Data/pexels/pexels/[uid]/[uid]-[frameid].mp4`
caption path: `caption/pexels/pexels/[uid]/[uid]-[frameid].txt`


##### S3 commands
To view s3 bucket
```sh
AWS_ACCESS_KEY_ID=WI3BQ2603T8FTMUBXS14 AWS_SECRET_ACCESS_KEY=veSRxTgSkODBVE7aYvm9iRiGLcvYY7oAOYg9DMyK  aws s3 ls s3://4DGen-Dataset/pexelx_st/pexels/0094271c826e2f4ed99ce2a50635aec00f84d8569be4bd5bcaf30d7ab9e95617-00000003-00000475/clip_000344-000471.mp4/ --endpoint-url=http://10.140.27.254:80

AWS_ACCESS_KEY_ID=WI3BQ2603T8FTMUBXS14 AWS_SECRET_ACCESS_KEY=veSRxTgSkODBVE7aYvm9iRiGLcvYY7oAOYg9DMyK  aws s3 cp s3://4DGen-Dataset/Human_Raw_Data/pexels/pexels/0094271c826e2f4ed99ce2a50635aec00f84d8569be4bd5bcaf30d7ab9e95617/0094271c826e2f4ed99ce2a50635aec00f84d8569be4bd5bcaf30d7ab9e95617-00000003-00000475.mp4 vid.mp4 --endpoint-url=http://10.140.27.254:80
```

Install Petrel: http://sdoc.pjlab.org.cn/doc/#/petrel-oss/sdk/SDK%E5%AE%89%E8%A3%85
```sh
python -m pip install pip==21
python -m pip install setuptools==65
cd /mnt/lustre/share
cd petrel-oss-python-sdk && cd ..
cp -r petrel-oss-python-sdk ~/
cd ~/petrel-oss-python-sdk
python setup.py sdist
pip install --user dist/*
cd ~/ && python -c 'from petrel_client.version import version; print(version)'
```

##### pip on cluster
```
pip3 install -i https://pkg.pjlab.org.cn/repository/pypi-proxy/simple/ --trusted-host pkg.pjlab.org.cn
```