import sys
from pathlib import Path
sys.path.append(str(Path(__file__).parent.parent))

import imageio
import numpy as np
import glob
import os
from core.dataset import PointmapDataset
from core.annotation import Monst3RAnno
import pickle

from core.tokenizer.cogvideo import CogvideoTokenizer
from core.tokenizer.wan import WanTokenizer

max_frames = 29

dataset = PointmapDataset(datalist = 'data/sanity_check.txt', s3_conf_path='~/petreloss.conf', debug=True, random_shuffle=False, max_frames=max_frames)
def PointmapIterator():
    for data in dataset:
        yield data.pointmap

pointmap_iterator = PointmapIterator()

# model_path = 'pretrained/Wan2.1-I2V-14B-480P-Diffusers/vae/'
# tokenizer = WanTokenizer(model_path=model_path)
model_path = 'pretrained/CogVideoX1.5-5B-I2V/vae/'
tokenizer = CogvideoTokenizer(model_path=model_path)

save_dir = 'results/tokenizer_pointmap_test'
os.makedirs(save_dir, exist_ok=True)
for pm in pointmap_iterator:
    pickle.dump(pm, open(f'{save_dir}/pm.pkl', 'wb'))
    pointmap = pm.pcd
    print('pointmap range: ', pointmap.min(), pointmap.max())
    pointmap = np.clip(pointmap, np.percentile(pointmap, 2, axis=1, keepdims=True), np.percentile(pointmap, 98,  axis=1, keepdims=True))
    print('clipped range: ', pointmap.min(), pointmap.max())
    pointmap_in, center, scale = tokenizer.normalize_instance(pointmap, range_min=0)
    pointmap_in = pointmap_in.reshape(*pm.rgb.shape)
    pointmap_vis = (pointmap_in * 255).astype(np.uint8)

    latents, aux = tokenizer.encode(pointmap_in)
    pointmap_recon = tokenizer.decode(latents, **aux)[:max_frames]
    print(pointmap_recon.shape)

    pointmap_recon_vis = (np.clip(pointmap_recon, 0, 1) * 255).astype(np.uint8)
    imageio.mimwrite(f'{save_dir}/pointmap_comp.mp4', np.concatenate([pointmap_vis, pointmap_recon_vis], -2), fps=24)

    pointmap_recon = pointmap_recon.reshape(*pm.pcd.shape)
    pointmap_recon = tokenizer.denormalize_instance(pointmap_recon, center, scale, range_min=0)
    print('reconstructed range: ', pointmap_recon.min(), pointmap_recon.max())
    pm.pcd = pointmap_recon
    pickle.dump(pm, open(f'{save_dir}/pm_recon.pkl', 'wb'))
    break
