        # # 1. Patch & position embedding
        # self.rope = WanRotaryPosEmbed(attention_head_dim, patch_size, rope_max_seq_len)
        # self.patch_embedding = nn.Conv3d(in_channels, inner_dim, kernel_size=patch_size, stride=patch_size)
        
        # batch_size, num_channels, num_frames, height, width = hidden_states.shape
        # p_t, p_h, p_w = self.config.patch_size
        # post_patch_num_frames = num_frames // p_t
        # post_patch_height = height // p_h
        # post_patch_width = width // p_w

        # rotary_emb = self.rope(hidden_states)

        # hidden_states = self.patch_embedding(hidden_states)
        # hidden_states = hidden_states.flatten(2).transpose(1, 2)

import torch
import torch.nn as nn
import imageio.v2 as imageio
import os

def save_token_grid(tokens, seq_len, inner_dim, prefix, out_dir="patchify_visuals"):
    os.makedirs(out_dir, exist_ok=True)
    # tokens: (batch, seq_len//2, inner_dim)
    # For visualization, reduce inner_dim to 1 (mean) and reshape to a grid
    grid_size = int(seq_len ** 0.5)
    if grid_size * grid_size != seq_len:
        grid_size = int((seq_len//2) ** 0.5)
    # Take mean over inner_dim for visualization
    vis = tokens[0].mean(dim=-1).detach().cpu().numpy()
    # Pad to square if needed
    pad_len = grid_size * grid_size - vis.shape[0]
    if pad_len > 0:
        vis = np.pad(vis, (0, pad_len), mode='constant')
    vis = vis.reshape(grid_size, grid_size)
    # Normalize to 0-255 for uint8 image
    vis_min, vis_max = vis.min(), vis.max()
    if vis_max > vis_min:
        vis = (vis - vis_min) / (vis_max - vis_min)
    vis_img = (vis * 255).astype('uint8')
    imageio.imwrite(os.path.join(out_dir, f"{prefix}.png"), vis_img)

def test_patchify_token_order_visual():
    batch_size = 1
    channels = 3
    frames = 16
    height = 64
    width = 64
    patch_size = (2, 4, 4)  # typical video patch size
    inner_dim = 3

    # Create two different tensors with distinct patterns
    tensor1 = torch.zeros(batch_size, channels, frames//2, height, width)
    tensor2 = torch.ones(batch_size, channels, frames//2, height, width)
    
    # Test frame dimension concatenation
    frame_concat = torch.cat([tensor1, tensor2], dim=2)
    patch_embed = nn.Identity()
    
    # Patchify
    patched = patch_embed(frame_concat)
    tokens = patched.flatten(2).transpose(1, 2)
    
    # Split sequence back
    seq_len = tokens.shape[1]
    import pdb; pdb.set_trace()
    first_half, second_half = tokens.split(seq_len//2, dim=1)
    
    # Visualize
    save_token_grid(first_half, seq_len//2, inner_dim, "frame_first_half")
    save_token_grid(second_half, seq_len//2, inner_dim, "frame_second_half")

    # Test height dimension
    tensor1 = torch.zeros(batch_size, channels, frames, height//2, width)
    tensor2 = torch.ones(batch_size, channels, frames, height//2, width)
    height_concat = torch.cat([tensor1, tensor2], dim=3)
    
    patched = patch_embed(height_concat)
    tokens = patched.flatten(2).transpose(1, 2)
    first_half, second_half = tokens.split(seq_len//2, dim=1)
    save_token_grid(first_half, seq_len//2, inner_dim, "height_first_half")
    save_token_grid(second_half, seq_len//2, inner_dim, "height_second_half")

    # Test width dimension
    tensor1 = torch.zeros(batch_size, channels, frames, height, width//2)
    tensor2 = torch.ones(batch_size, channels, frames, height, width//2)
    width_concat = torch.cat([tensor1, tensor2], dim=4)
    
    patched = patch_embed(width_concat)
    tokens = patched.flatten(2).transpose(1, 2)
    first_half, second_half = tokens.split(seq_len//2, dim=1)
    save_token_grid(first_half, seq_len//2, inner_dim, "width_first_half")
    save_token_grid(second_half, seq_len//2, inner_dim, "width_second_half")

if __name__ == "__main__":
    import numpy as np
    test_patchify_token_order_visual()