import { GenericPoolInstrumentation } from '@opentelemetry/instrumentation-generic-pool';
import { defineIntegration, spanToJSON, SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN } from '@sentry/core';
import { generateInstrumentOnce } from '../../otel/instrument.js';

const INTEGRATION_NAME = 'GenericPool';

const instrumentGenericPool = generateInstrumentOnce(INTEGRATION_NAME, () => new GenericPoolInstrumentation({}));

const _genericPoolIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentGenericPool();
    },

    setup(client) {
      client.on('spanStart', span => {
        const spanJSON = spanToJSON(span);

        const spanDescription = spanJSON.description;

        // typo in emitted span for version <= 0.38.0 of @opentelemetry/instrumentation-generic-pool
        const isGenericPoolSpan =
          spanDescription === 'generic-pool.aquire' || spanDescription === 'generic-pool.acquire';

        if (isGenericPoolSpan) {
          span.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN, 'auto.db.otel.generic_pool');
        }
      });
    },
  };
}) ;

/**
 * GenericPool integration
 *
 * Capture tracing data for GenericPool.
 */
const genericPoolIntegration = defineIntegration(_genericPoolIntegration);

export { genericPoolIntegration, instrumentGenericPool };
