export { registerSpanErrorInstrumentation } from './tracing/errors.js';
export { getCapturedScopesOnSpan, setCapturedScopesOnSpan } from './tracing/utils.js';
export { addTracingExtensions } from './tracing/hubextensions.js';
export { TRACING_DEFAULTS, startIdleSpan } from './tracing/idleSpan.js';
export { SentrySpan } from './tracing/sentrySpan.js';
export { SentryNonRecordingSpan } from './tracing/sentryNonRecordingSpan.js';
export { SPAN_STATUS_ERROR, SPAN_STATUS_OK, SPAN_STATUS_UNSET, getSpanStatusFromHttpCode, setHttpStatus } from './tracing/spanstatus.js';
export { continueTrace, startInactiveSpan, startNewTrace, startSpan, startSpanManual, suppressTracing, withActiveSpan } from './tracing/trace.js';
export { getDynamicSamplingContextFromClient, getDynamicSamplingContextFromSpan, spanToBaggageHeader } from './tracing/dynamicSamplingContext.js';
export { setMeasurement, timedEventsToMeasurements } from './tracing/measurement.js';
export { sampleSpan } from './tracing/sampling.js';
export { logSpanEnd, logSpanStart } from './tracing/logSpans.js';
export { SEMANTIC_ATTRIBUTE_CACHE_HIT, SEMANTIC_ATTRIBUTE_CACHE_ITEM_SIZE, SEMANTIC_ATTRIBUTE_CACHE_KEY, SEMANTIC_ATTRIBUTE_EXCLUSIVE_TIME, SEMANTIC_ATTRIBUTE_HTTP_REQUEST_METHOD, SEMANTIC_ATTRIBUTE_PROFILE_ID, SEMANTIC_ATTRIBUTE_SENTRY_IDLE_SPAN_FINISH_REASON, SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_UNIT, SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_VALUE, SEMANTIC_ATTRIBUTE_SENTRY_OP, SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN, SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE, SEMANTIC_ATTRIBUTE_SENTRY_SOURCE, SEMANTIC_ATTRIBUTE_URL_FULL } from './semanticAttributes.js';
export { createEventEnvelope, createSessionEnvelope, createSpanEnvelope } from './envelope.js';
export { addEventProcessor, captureCheckIn, captureEvent, captureException, captureMessage, captureSession, close, endSession, flush, isEnabled, isInitialized, lastEventId, setContext, setExtra, setExtras, setTag, setTags, setUser, startSession, withMonitor } from './exports.js';
export { getClient, getCurrentScope, getGlobalScope, getIsolationScope, withIsolationScope, withScope } from './currentScopes.js';
export { getDefaultCurrentScope, getDefaultIsolationScope } from './defaultScopes.js';
export { setAsyncContextStrategy } from './asyncContext/index.js';
export { getMainCarrier } from './carrier.js';
export { closeSession, makeSession, updateSession } from './session.js';
export { SessionFlusher } from './sessionflusher.js';
export { Scope } from './scope.js';
export { notifyEventProcessors } from './eventProcessors.js';
export { getEnvelopeEndpointWithUrlEncodedAuth, getReportDialogEndpoint } from './api.js';
export { BaseClient } from './baseclient.js';
export { ServerRuntimeClient } from './server-runtime-client.js';
export { initAndBind, setCurrentClient } from './sdk.js';
export { createTransport } from './transports/base.js';
export { makeOfflineTransport } from './transports/offline.js';
export { makeMultiplexedTransport } from './transports/multiplexed.js';
export { addIntegration, defineIntegration, getIntegrationsToSetup } from './integration.js';
export { applyScopeDataToEvent, mergeScopeData } from './utils/applyScopeDataToEvent.js';
export { prepareEvent } from './utils/prepareEvent.js';
export { createCheckInEnvelope } from './checkin.js';
export { hasTracingEnabled } from './utils/hasTracingEnabled.js';
export { isSentryRequestUrl } from './utils/isSentryRequestUrl.js';
export { handleCallbackErrors } from './utils/handleCallbackErrors.js';
export { parameterize } from './utils/parameterize.js';
export { addChildSpanToSpan, getActiveSpan, getRootSpan, getSpanDescendants, getStatusMessage, spanIsSampled, spanTimeInputToSeconds, spanToJSON, spanToTraceContext, spanToTraceHeader } from './utils/spanUtils.js';
export { parseSampleRate } from './utils/parseSampleRate.js';
export { applySdkMetadata } from './utils/sdkMetadata.js';
export { getTraceData } from './utils/traceData.js';
export { getTraceMetaTags } from './utils/meta.js';
export { DEFAULT_ENVIRONMENT } from './constants.js';
export { addBreadcrumb } from './breadcrumbs.js';
export { functionToStringIntegration } from './integrations/functiontostring.js';
export { inboundFiltersIntegration } from './integrations/inboundfilters.js';
export { linkedErrorsIntegration } from './integrations/linkederrors.js';
export { moduleMetadataIntegration } from './integrations/metadata.js';
export { requestDataIntegration } from './integrations/requestdata.js';
export { captureConsoleIntegration } from './integrations/captureconsole.js';
export { debugIntegration } from './integrations/debug.js';
export { dedupeIntegration } from './integrations/dedupe.js';
export { extraErrorDataIntegration } from './integrations/extraerrordata.js';
export { rewriteFramesIntegration } from './integrations/rewriteframes.js';
export { sessionTimingIntegration } from './integrations/sessiontiming.js';
export { zodErrorsIntegration } from './integrations/zoderrors.js';
export { thirdPartyErrorFilterIntegration } from './integrations/third-party-errors-filter.js';
export { metrics } from './metrics/exports.js';
export { profiler } from './profiling.js';
export { metricsDefault } from './metrics/exports-default.js';
export { BrowserMetricsAggregator } from './metrics/browser-aggregator.js';
export { getMetricSummaryJsonForSpan } from './metrics/metric-summary.js';
export { addTracingHeadersToFetchRequest, instrumentFetchRequest } from './fetch.js';
export { trpcMiddleware } from './trpc.js';
export { captureFeedback } from './feedback.js';
export { getCurrentHub, getCurrentHubShim } from './getCurrentHubShim.js';
export { SDK_VERSION } from '@sentry/utils';
