Object.defineProperty(exports, '__esModule', { value: true });

const instrumentationLruMemoizer = require('@opentelemetry/instrumentation-lru-memoizer');
const core = require('@sentry/core');
const instrument = require('../../otel/instrument.js');

const INTEGRATION_NAME = 'LruMemoizer';

const instrumentLruMemoizer = instrument.generateInstrumentOnce(INTEGRATION_NAME, () => new instrumentationLruMemoizer.LruMemoizerInstrumentation());

const _lruMemoizerIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentLruMemoizer();
    },
  };
}) ;

/**
 * LruMemoizer integration
 *
 * Propagate traces through LruMemoizer.
 */
const lruMemoizerIntegration = core.defineIntegration(_lruMemoizerIntegration);

exports.instrumentLruMemoizer = instrumentLruMemoizer;
exports.lruMemoizerIntegration = lruMemoizerIntegration;
