/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.Biomes;
import net.optifine.config.BiomeId;
import net.optifine.override.ChunkCacheOF;

public class BiomeUtils {
    private static Registry<Biome> biomeRegistry = BiomeUtils.getBiomeRegistry(Minecraft.getInstance().world);
    public static Biome PLAINS = BiomeUtils.getBiomeSafe(biomeRegistry, Biomes.PLAINS, () -> BiomeMaker.makePlainsBiome(false));
    public static Biome SWAMP = BiomeUtils.getBiomeSafe(biomeRegistry, Biomes.SWAMP, () -> BiomeMaker.makeGenericSwampBiome(-0.2f, 0.1f, false));
    public static Biome SWAMP_HILLS = BiomeUtils.getBiomeSafe(biomeRegistry, Biomes.SWAMP_HILLS, () -> BiomeMaker.makeGenericSwampBiome(-0.1f, 0.3f, true));

    public static void onWorldChanged(World worldIn) {
        biomeRegistry = BiomeUtils.getBiomeRegistry(worldIn);
        PLAINS = BiomeUtils.getBiomeSafe(biomeRegistry, Biomes.PLAINS, () -> BiomeMaker.makePlainsBiome(false));
        SWAMP = BiomeUtils.getBiomeSafe(biomeRegistry, Biomes.SWAMP, () -> BiomeMaker.makeGenericSwampBiome(-0.2f, 0.1f, false));
        SWAMP_HILLS = BiomeUtils.getBiomeSafe(biomeRegistry, Biomes.SWAMP_HILLS, () -> BiomeMaker.makeGenericSwampBiome(-0.1f, 0.3f, true));
    }

    private static Biome getBiomeSafe(Registry<Biome> registry, RegistryKey<Biome> biomeKey, Supplier<Biome> biomeDefault) {
        Biome biome = registry.getValueForKey(biomeKey);
        if (biome == null) {
            biome = biomeDefault.get();
        }
        return biome;
    }

    public static Registry<Biome> getBiomeRegistry(World worldIn) {
        return worldIn != null ? worldIn.func_241828_r().getRegistry(Registry.BIOME_KEY) : WorldGenRegistries.BIOME;
    }

    public static Registry<Biome> getBiomeRegistry() {
        return biomeRegistry;
    }

    public static ResourceLocation getLocation(Biome biome) {
        return BiomeUtils.getBiomeRegistry().getKey(biome);
    }

    public static int getId(Biome biome) {
        return BiomeUtils.getBiomeRegistry().getId(biome);
    }

    public static int getId(ResourceLocation loc) {
        Biome biome = BiomeUtils.getBiome(loc);
        return BiomeUtils.getBiomeRegistry().getId(biome);
    }

    public static BiomeId getBiomeId(ResourceLocation loc) {
        return BiomeId.make(loc);
    }

    public static Biome getBiome(ResourceLocation loc) {
        return BiomeUtils.getBiomeRegistry().getOrDefault(loc);
    }

    public static Set<ResourceLocation> getLocations() {
        return BiomeUtils.getBiomeRegistry().keySet();
    }

    public static List<Biome> getBiomes() {
        return Lists.newArrayList(biomeRegistry);
    }

    public static List<BiomeId> getBiomeIds() {
        return BiomeUtils.getBiomeIds(BiomeUtils.getLocations());
    }

    public static List<BiomeId> getBiomeIds(Collection<ResourceLocation> locations) {
        ArrayList<BiomeId> list = new ArrayList<BiomeId>();
        for (ResourceLocation resourcelocation : locations) {
            BiomeId biomeid = BiomeId.make(resourcelocation);
            if (biomeid == null) continue;
            list.add(biomeid);
        }
        return list;
    }

    public static Biome getBiome(IBlockDisplayReader lightReader, BlockPos blockPos) {
        Biome biome = PLAINS;
        if (lightReader instanceof ChunkCacheOF) {
            biome = ((ChunkCacheOF)lightReader).getBiome(blockPos);
        } else if (lightReader instanceof IWorldReader) {
            biome = ((IWorldReader)lightReader).getBiome(blockPos);
        }
        return biome;
    }
}

