/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static IBakedModel makeModelCube(String spriteName, int tintIndex) {
        TextureAtlasSprite textureatlassprite = Config.getTextureMap().getUploadedSprite(spriteName);
        return BlockModelUtils.makeModelCube(textureatlassprite, tintIndex);
    }

    public static IBakedModel makeModelCube(TextureAtlasSprite sprite, int tintIndex) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        Direction[] adirection = Direction.VALUES;
        HashMap<Direction, List<BakedQuad>> map = new HashMap<Direction, List<BakedQuad>>();
        for (int i = 0; i < adirection.length; ++i) {
            Direction direction = adirection[i];
            ArrayList<BakedQuad> list1 = new ArrayList<BakedQuad>();
            list1.add(BlockModelUtils.makeBakedQuad(direction, sprite, tintIndex));
            map.put(direction, list1);
        }
        ItemOverrideList itemoverridelist = ItemOverrideList.EMPTY;
        SimpleBakedModel ibakedmodel = new SimpleBakedModel(list, map, true, true, true, sprite, ItemCameraTransforms.DEFAULT, itemoverridelist);
        return ibakedmodel;
    }

    public static IBakedModel joinModelsCube(IBakedModel modelBase, IBakedModel modelAdd) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        list.addAll(modelBase.getQuads(null, null, RANDOM));
        list.addAll(modelAdd.getQuads(null, null, RANDOM));
        Direction[] adirection = Direction.VALUES;
        HashMap<Direction, List<BakedQuad>> map = new HashMap<Direction, List<BakedQuad>>();
        for (int i = 0; i < adirection.length; ++i) {
            Direction direction = adirection[i];
            ArrayList<BakedQuad> list1 = new ArrayList<BakedQuad>();
            list1.addAll(modelBase.getQuads(null, direction, RANDOM));
            list1.addAll(modelAdd.getQuads(null, direction, RANDOM));
            map.put(direction, list1);
        }
        boolean flag = modelBase.isAmbientOcclusion();
        boolean flag1 = modelBase.isBuiltInRenderer();
        TextureAtlasSprite textureatlassprite = modelBase.getParticleTexture();
        ItemCameraTransforms itemcameratransforms = modelBase.getItemCameraTransforms();
        ItemOverrideList itemoverridelist = modelBase.getOverrides();
        SimpleBakedModel ibakedmodel = new SimpleBakedModel(list, map, flag, flag1, true, textureatlassprite, itemcameratransforms, itemoverridelist);
        return ibakedmodel;
    }

    public static BakedQuad makeBakedQuad(Direction facing, TextureAtlasSprite sprite, int tintIndex) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f1 = new Vector3f(16.0f, 16.0f, 16.0f);
        BlockFaceUV blockfaceuv = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        BlockPartFace blockpartface = new BlockPartFace(facing, tintIndex, "#" + facing.getString(), blockfaceuv);
        ModelRotation modelrotation = ModelRotation.X0_Y0;
        BlockPartRotation blockpartrotation = null;
        boolean flag = true;
        ResourceLocation resourcelocation = sprite.getName();
        FaceBakery facebakery = new FaceBakery();
        return facebakery.bakeQuad(vector3f, vector3f1, blockpartface, sprite, facing, modelrotation, blockpartrotation, flag, resourcelocation);
    }

    public static IBakedModel makeModel(String modelName, String spriteOldName, String spriteNewName) {
        AtlasTexture atlastexture = Config.getTextureMap();
        TextureAtlasSprite textureatlassprite = atlastexture.getUploadedSprite(spriteOldName);
        TextureAtlasSprite textureatlassprite1 = atlastexture.getUploadedSprite(spriteNewName);
        return BlockModelUtils.makeModel(modelName, textureatlassprite, textureatlassprite1);
    }

    public static IBakedModel makeModel(String modelName, TextureAtlasSprite spriteOld, TextureAtlasSprite spriteNew) {
        if (spriteOld != null && spriteNew != null) {
            ModelManager modelmanager = Config.getModelManager();
            if (modelmanager == null) {
                return null;
            }
            ModelResourceLocation modelresourcelocation = new ModelResourceLocation(modelName, "");
            IBakedModel ibakedmodel = modelmanager.getModel(modelresourcelocation);
            if (ibakedmodel != null && ibakedmodel != modelmanager.getMissingModel()) {
                IBakedModel ibakedmodel1 = ModelUtils.duplicateModel(ibakedmodel);
                Direction[] adirection = Direction.VALUES;
                for (int i = 0; i < adirection.length; ++i) {
                    Direction direction = adirection[i];
                    List<BakedQuad> list = ibakedmodel1.getQuads(null, direction, RANDOM);
                    BlockModelUtils.replaceTexture(list, spriteOld, spriteNew);
                }
                List<BakedQuad> list1 = ibakedmodel1.getQuads(null, null, RANDOM);
                BlockModelUtils.replaceTexture(list1, spriteOld, spriteNew);
                return ibakedmodel1;
            }
            return null;
        }
        return null;
    }

    private static void replaceTexture(List<BakedQuad> quads, TextureAtlasSprite spriteOld, TextureAtlasSprite spriteNew) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (BakedQuad bakedquad : quads) {
            if (bakedquad.getSprite() == spriteOld) {
                bakedquad = new BakedQuadRetextured(bakedquad, spriteNew);
            }
            list.add(bakedquad);
        }
        quads.clear();
        quads.addAll(list);
    }

    public static void snapVertexPosition(Vector3f pos) {
        pos.set(BlockModelUtils.snapVertexCoord(pos.getX()), BlockModelUtils.snapVertexCoord(pos.getY()), BlockModelUtils.snapVertexCoord(pos.getZ()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        return x > 0.999999f && x < 1.000001f ? 1.0f : x;
    }

    public static AxisAlignedBB getOffsetBoundingBox(AxisAlignedBB aabb, AbstractBlock.OffsetType offsetType, BlockPos pos) {
        int i = pos.getX();
        int j = pos.getZ();
        long k = (long)(i * 3129871) ^ (long)j * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double d0 = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double d1 = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double d2 = 0.0;
        if (offsetType == AbstractBlock.OffsetType.XYZ) {
            d2 = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.offset(d0, d2, d1);
    }
}

