/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionSavedDataManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, WorldSavedData> savedDatum = Maps.newHashMap();
    private final DataFixer dataFixer;
    private final File folder;

    public DimensionSavedDataManager(File dataFolder, DataFixer dataFixerIn) {
        this.dataFixer = dataFixerIn;
        this.folder = dataFolder;
    }

    private File getDataFile(String name) {
        return new File(this.folder, name + ".dat");
    }

    public <T extends WorldSavedData> T getOrCreate(Supplier<T> defaultSupplier, String name) {
        T t = this.get(defaultSupplier, name);
        if (t != null) {
            return t;
        }
        WorldSavedData t1 = (WorldSavedData)defaultSupplier.get();
        this.set(t1);
        return (T)t1;
    }

    @Nullable
    public <T extends WorldSavedData> T get(Supplier<T> defaultSupplier, String name) {
        WorldSavedData worldsaveddata = this.savedDatum.get(name);
        if (worldsaveddata == null && !this.savedDatum.containsKey(name)) {
            worldsaveddata = this.loadSavedData(defaultSupplier, name);
            this.savedDatum.put(name, worldsaveddata);
        }
        return (T)worldsaveddata;
    }

    @Nullable
    private <T extends WorldSavedData> T loadSavedData(Supplier<T> defaultSupplier, String name) {
        try {
            File file1 = this.getDataFile(name);
            if (file1.exists()) {
                WorldSavedData t = (WorldSavedData)defaultSupplier.get();
                CompoundNBT compoundnbt = this.load(name, SharedConstants.getVersion().getWorldVersion());
                t.read(compoundnbt.getCompound("data"));
                return (T)t;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error loading saved data: {}", (Object)name, (Object)exception);
        }
        return (T)((WorldSavedData)null);
    }

    public void set(WorldSavedData data) {
        this.savedDatum.put(data.getName(), data);
    }

    public CompoundNBT load(String name, int worldVersion) throws IOException {
        CompoundNBT compoundnbt1;
        File file1 = this.getDataFile(name);
        try (FileInputStream fileinputstream = new FileInputStream(file1);
             PushbackInputStream pushbackinputstream = new PushbackInputStream(fileinputstream, 2);){
            CompoundNBT compoundnbt;
            if (this.isCompressed(pushbackinputstream)) {
                compoundnbt = CompressedStreamTools.readCompressed(pushbackinputstream);
            } else {
                try (DataInputStream datainputstream = new DataInputStream(pushbackinputstream);){
                    compoundnbt = CompressedStreamTools.read(datainputstream);
                }
            }
            int i = compoundnbt.contains("DataVersion", 99) ? compoundnbt.getInt("DataVersion") : 1343;
            compoundnbt1 = NBTUtil.update(this.dataFixer, DefaultTypeReferences.SAVED_DATA, compoundnbt, i, worldVersion);
        }
        return compoundnbt1;
    }

    private boolean isCompressed(PushbackInputStream inputStream) throws IOException {
        int j;
        byte[] abyte = new byte[2];
        boolean flag = false;
        int i = inputStream.read(abyte, 0, 2);
        if (i == 2 && (j = (abyte[1] & 0xFF) << 8 | abyte[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i != 0) {
            inputStream.unread(abyte, 0, i);
        }
        return flag;
    }

    public void save() {
        for (WorldSavedData worldsaveddata : this.savedDatum.values()) {
            if (worldsaveddata == null) continue;
            worldsaveddata.save(this.getDataFile(worldsaveddata.getName()));
        }
    }
}

