/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome.provider;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.SimplexNoiseGenerator;

public class EndBiomeProvider
extends BiomeProvider {
    public static final Codec<EndBiomeProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group(RegistryLookupCodec.getLookUpCodec(Registry.BIOME_KEY).forGetter(provider -> provider.lookupRegistry), ((MapCodec)Codec.LONG.fieldOf("seed")).stable().forGetter(provider -> provider.seed)).apply((Applicative<EndBiomeProvider, ?>)builder, builder.stable(EndBiomeProvider::new)));
    private final SimplexNoiseGenerator generator;
    private final Registry<Biome> lookupRegistry;
    private final long seed;
    private final Biome theEndBiome;
    private final Biome endHighlandsBiome;
    private final Biome endMidlandsBiome;
    private final Biome smallEndIslandsBiome;
    private final Biome endBarrensBiome;

    public EndBiomeProvider(Registry<Biome> lookupRegistry, long seed) {
        this(lookupRegistry, seed, lookupRegistry.getOrThrow(Biomes.THE_END), lookupRegistry.getOrThrow(Biomes.END_HIGHLANDS), lookupRegistry.getOrThrow(Biomes.END_MIDLANDS), lookupRegistry.getOrThrow(Biomes.SMALL_END_ISLANDS), lookupRegistry.getOrThrow(Biomes.END_BARRENS));
    }

    private EndBiomeProvider(Registry<Biome> lookupRegistry, long seed, Biome theEndBiome, Biome endHighlandsBiome, Biome endMidlandsBiome, Biome smallEndIslandsBiome, Biome endBarrensBiome) {
        super(ImmutableList.of(theEndBiome, endHighlandsBiome, endMidlandsBiome, smallEndIslandsBiome, endBarrensBiome));
        this.lookupRegistry = lookupRegistry;
        this.seed = seed;
        this.theEndBiome = theEndBiome;
        this.endHighlandsBiome = endHighlandsBiome;
        this.endMidlandsBiome = endMidlandsBiome;
        this.smallEndIslandsBiome = smallEndIslandsBiome;
        this.endBarrensBiome = endBarrensBiome;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
        sharedseedrandom.skip(17292);
        this.generator = new SimplexNoiseGenerator(sharedseedrandom);
    }

    @Override
    protected Codec<? extends BiomeProvider> getBiomeProviderCodec() {
        return CODEC;
    }

    @Override
    public BiomeProvider getBiomeProvider(long seed) {
        return new EndBiomeProvider(this.lookupRegistry, seed, this.theEndBiome, this.endHighlandsBiome, this.endMidlandsBiome, this.smallEndIslandsBiome, this.endBarrensBiome);
    }

    @Override
    public Biome getNoiseBiome(int x, int y, int z) {
        int i = x >> 2;
        int j = z >> 2;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return this.theEndBiome;
        }
        float f = EndBiomeProvider.getRandomNoise(this.generator, i * 2 + 1, j * 2 + 1);
        if (f > 40.0f) {
            return this.endHighlandsBiome;
        }
        if (f >= 0.0f) {
            return this.endMidlandsBiome;
        }
        return f < -20.0f ? this.smallEndIslandsBiome : this.endBarrensBiome;
    }

    public boolean areProvidersEqual(long seed) {
        return this.seed == seed;
    }

    public static float getRandomNoise(SimplexNoiseGenerator noiseGenerator, int x, int z) {
        int i = x / 2;
        int j = z / 2;
        int k = x % 2;
        int l = z % 2;
        float f = 100.0f - MathHelper.sqrt(x * x + z * z) * 8.0f;
        f = MathHelper.clamp(f, -100.0f, 80.0f);
        for (int i1 = -12; i1 <= 12; ++i1) {
            for (int j1 = -12; j1 <= 12; ++j1) {
                long k1 = i + i1;
                long l1 = j + j1;
                if (k1 * k1 + l1 * l1 <= 4096L || !(noiseGenerator.getValue(k1, l1) < (double)-0.9f)) continue;
                float f1 = (MathHelper.abs(k1) * 3439.0f + MathHelper.abs(l1) * 147.0f) % 13.0f + 9.0f;
                float f2 = k - i1 * 2;
                float f3 = l - j1 * 2;
                float f4 = 100.0f - MathHelper.sqrt(f2 * f2 + f3 * f3) * f1;
                f4 = MathHelper.clamp(f4, -100.0f, 80.0f);
                f = Math.max(f, f4);
            }
        }
        return f;
    }
}

