/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.EntityExplosionContext;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Explosion {
    private static final ExplosionContext DEFAULT_CONTEXT = new ExplosionContext();
    private final boolean causesFire;
    private final Mode mode;
    private final Random random = new Random(0L);
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity exploder;
    private final float size;
    private final DamageSource damageSource;
    private final ExplosionContext context;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> playerKnockbackMap = Maps.newHashMap();

    public Explosion(World worldIn, @Nullable Entity entityIn, double x, double y, double z, float size, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, false, Mode.DESTROY, affectedPositions);
    }

    public Explosion(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Mode modeIn, List<BlockPos> affectedBlockPositionsIn) {
        this(worldIn, exploderIn, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
        this.affectedBlockPositions.addAll(affectedBlockPositionsIn);
    }

    public Explosion(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Mode modeIn) {
        this(worldIn, exploderIn, null, null, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
    }

    public Explosion(World world, @Nullable Entity exploder, @Nullable DamageSource source, @Nullable ExplosionContext context, double x, double y, double z, float size, boolean causesFire, Mode mode) {
        this.world = world;
        this.exploder = exploder;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.causesFire = causesFire;
        this.mode = mode;
        this.damageSource = source == null ? DamageSource.causeExplosionDamage(this) : source;
        this.context = context == null ? this.getEntityExplosionContext(exploder) : context;
    }

    private ExplosionContext getEntityExplosionContext(@Nullable Entity entity) {
        return entity == null ? DEFAULT_CONTEXT : new EntityExplosionContext(entity);
    }

    public static float getBlockDensity(Vector3d explosionVector, Entity entity) {
        AxisAlignedBB axisalignedbb = entity.getBoundingBox();
        double d0 = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = MathHelper.lerp((double)f, axisalignedbb.minX, axisalignedbb.maxX);
                        Vector3d vector3d = new Vector3d(d5 + d3, d6 = MathHelper.lerp((double)f1, axisalignedbb.minY, axisalignedbb.maxY), (d7 = MathHelper.lerp((double)f2, axisalignedbb.minZ, axisalignedbb.maxZ)) + d4);
                        if (entity.world.rayTraceBlocks(new RayTraceContext(vector3d, explosionVector, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).getType() == RayTraceResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void doExplosionA() {
        HashSet<BlockPos> set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.rand.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        FluidState fluidstate;
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.world.getBlockState(blockpos);
                        Optional<Float> optional = this.context.getExplosionResistance(this, this.world, blockpos, blockstate, fluidstate = this.world.getFluidState(blockpos));
                        if (optional.isPresent()) {
                            f -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.context.canExplosionDestroyBlock(this, this.world, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f2 = this.size * 2.0f;
        int k1 = MathHelper.floor(this.x - (double)f2 - 1.0);
        int l1 = MathHelper.floor(this.x + (double)f2 + 1.0);
        int i2 = MathHelper.floor(this.y - (double)f2 - 1.0);
        int i1 = MathHelper.floor(this.y + (double)f2 + 1.0);
        int j2 = MathHelper.floor(this.z - (double)f2 - 1.0);
        int j1 = MathHelper.floor(this.z + (double)f2 + 1.0);
        List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this.exploder, new AxisAlignedBB(k1, i2, j2, l1, i1, j1));
        Vector3d vector3d = new Vector3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            PlayerEntity playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = list.get(k2);
            if (entity.isImmuneToExplosions() || !((d12 = (double)(MathHelper.sqrt(entity.getDistanceSq(vector3d)) / f2)) <= 1.0) || (d13 = (double)MathHelper.sqrt((d5 = entity.getPosX() - this.x) * d5 + (d7 = (entity instanceof TNTEntity ? entity.getPosY() : entity.getPosYEye()) - this.y) * d7 + (d9 = entity.getPosZ() - this.z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Explosion.getBlockDensity(vector3d, entity);
            double d10 = (1.0 - d12) * d14;
            entity.attackEntityFrom(this.getDamageSource(), (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.getBlastDamageReduction((LivingEntity)entity, d10);
            }
            entity.setMotion(entity.getMotion().add(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity).isSpectator() || playerentity.isCreative() && playerentity.abilities.isFlying) continue;
            this.playerKnockbackMap.put(playerentity, new Vector3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void doExplosionB(boolean spawnParticles) {
        boolean flag;
        if (this.world.isRemote) {
            this.world.playSound(this.x, this.y, this.z, SoundEvents.ENTITY_GENERIC_EXPLODE, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.mode != Mode.NONE;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && flag) {
                this.world.addParticle(ParticleTypes.EXPLOSION_EMITTER, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.addParticle(ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.affectedBlockPositions, this.world.rand);
            for (BlockPos blockpos : this.affectedBlockPositions) {
                BlockState blockstate = this.world.getBlockState(blockpos);
                Block block = blockstate.getBlock();
                if (blockstate.isAir()) continue;
                BlockPos blockpos1 = blockpos.toImmutable();
                this.world.getProfiler().startSection("explosion_blocks");
                if (block.canDropFromExplosion(this) && this.world instanceof ServerWorld) {
                    TileEntity tileentity = block.isTileEntityProvider() ? this.world.getTileEntity(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.world).withRandom(this.world.rand).withParameter(LootParameters.field_237457_g_, Vector3d.copyCentered(blockpos)).withParameter(LootParameters.TOOL, ItemStack.EMPTY).withNullableParameter(LootParameters.BLOCK_ENTITY, tileentity).withNullableParameter(LootParameters.THIS_ENTITY, this.exploder);
                    if (this.mode == Mode.DESTROY) {
                        lootcontext$builder.withParameter(LootParameters.EXPLOSION_RADIUS, Float.valueOf(this.size));
                    }
                    blockstate.getDrops(lootcontext$builder).forEach(stack -> Explosion.handleExplosionDrops(objectarraylist, stack, blockpos1));
                }
                this.world.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 3);
                block.onExplosionDestroy(this.world, blockpos, this);
                this.world.getProfiler().endSection();
            }
            for (Pair pair : objectarraylist) {
                Block.spawnAsEntity(this.world, (BlockPos)pair.getSecond(), (ItemStack)pair.getFirst());
            }
        }
        if (this.causesFire) {
            for (BlockPos blockpos2 : this.affectedBlockPositions) {
                if (this.random.nextInt(3) != 0 || !this.world.getBlockState(blockpos2).isAir() || !this.world.getBlockState(blockpos2.down()).isOpaqueCube(this.world, blockpos2.down())) continue;
                this.world.setBlockState(blockpos2, AbstractFireBlock.getFireForPlacement(this.world, blockpos2));
            }
        }
    }

    private static void handleExplosionDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos) {
        int i = dropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair<ItemStack, BlockPos> pair = dropPositionArray.get(j);
            ItemStack itemstack = pair.getFirst();
            if (!ItemEntity.canMergeStacks(itemstack, stack)) continue;
            ItemStack itemstack1 = ItemEntity.mergeStacks(itemstack, stack, 16);
            dropPositionArray.set(j, Pair.of(itemstack1, pair.getSecond()));
            if (!stack.isEmpty()) continue;
            return;
        }
        dropPositionArray.add(Pair.of(stack, pos));
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public Map<PlayerEntity, Vector3d> getPlayerKnockbackMap() {
        return this.playerKnockbackMap;
    }

    @Nullable
    public LivingEntity getExplosivePlacedBy() {
        Entity entity;
        if (this.exploder == null) {
            return null;
        }
        if (this.exploder instanceof TNTEntity) {
            return ((TNTEntity)this.exploder).getTntPlacedBy();
        }
        if (this.exploder instanceof LivingEntity) {
            return (LivingEntity)this.exploder;
        }
        if (this.exploder instanceof ProjectileEntity && (entity = ((ProjectileEntity)this.exploder).func_234616_v_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void clearAffectedBlockPositions() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> getAffectedBlockPositions() {
        return this.affectedBlockPositions;
    }

    public static enum Mode {
        NONE,
        BREAK,
        DESTROY;

    }
}

