/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.palette;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IResizeCallback;

public class ArrayPalette<T>
implements IPalette<T> {
    private final ObjectIntIdentityMap<T> registry;
    private final T[] states;
    private final IResizeCallback<T> resizeHandler;
    private final Function<CompoundNBT, T> deserializer;
    private final int bits;
    private int arraySize;

    public ArrayPalette(ObjectIntIdentityMap<T> registryIn, int bitsIn, IResizeCallback<T> resizeHandlerIn, Function<CompoundNBT, T> deserializerIn) {
        this.registry = registryIn;
        this.states = new Object[1 << bitsIn];
        this.bits = bitsIn;
        this.resizeHandler = resizeHandlerIn;
        this.deserializer = deserializerIn;
    }

    @Override
    public int idFor(T state) {
        int j;
        for (int i = 0; i < this.arraySize; ++i) {
            if (this.states[i] != state) continue;
            return i;
        }
        if ((j = this.arraySize++) < this.states.length) {
            this.states[j] = state;
            return j;
        }
        return this.resizeHandler.onResize(this.bits + 1, state);
    }

    @Override
    public boolean func_230341_a_(Predicate<T> p_230341_1_) {
        for (int i = 0; i < this.arraySize; ++i) {
            if (!p_230341_1_.test(this.states[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public T get(int indexKey) {
        return indexKey >= 0 && indexKey < this.arraySize ? (T)this.states[indexKey] : null;
    }

    @Override
    public void read(PacketBuffer buf) {
        this.arraySize = buf.readVarInt();
        for (int i = 0; i < this.arraySize; ++i) {
            this.states[i] = this.registry.getByValue(buf.readVarInt());
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeVarInt(this.arraySize);
        for (int i = 0; i < this.arraySize; ++i) {
            buf.writeVarInt(this.registry.getId(this.states[i]));
        }
    }

    @Override
    public int getSerializedSize() {
        int i = PacketBuffer.getVarIntSize(this.getPaletteSize());
        for (int j = 0; j < this.getPaletteSize(); ++j) {
            i += PacketBuffer.getVarIntSize(this.registry.getId(this.states[j]));
        }
        return i;
    }

    public int getPaletteSize() {
        return this.arraySize;
    }

    @Override
    public void read(ListNBT nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            this.states[i] = this.deserializer.apply(nbt.getCompound(i));
        }
        this.arraySize = nbt.size();
    }
}

