/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.TypeReferences;

public class SpawnerEntityTypes
extends DataFix {
    public SpawnerEntityTypes(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private Dynamic<?> fix(Dynamic<?> p_209659_1_) {
        Optional<Stream<Dynamic<?>>> optional1;
        if (!"MobSpawner".equals(p_209659_1_.get("id").asString(""))) {
            return p_209659_1_;
        }
        Optional<String> optional = p_209659_1_.get("EntityId").asString().result();
        if (optional.isPresent()) {
            Dynamic dynamic = DataFixUtils.orElse(p_209659_1_.get("SpawnData").result(), p_209659_1_.emptyMap());
            dynamic = dynamic.set("id", dynamic.createString(optional.get().isEmpty() ? "Pig" : optional.get()));
            p_209659_1_ = p_209659_1_.set("SpawnData", dynamic);
            p_209659_1_ = p_209659_1_.remove("EntityId");
        }
        if ((optional1 = p_209659_1_.get("SpawnPotentials").asStreamOpt().result()).isPresent()) {
            p_209659_1_ = p_209659_1_.set("SpawnPotentials", p_209659_1_.createList(optional1.get().map(p_209657_0_ -> {
                Optional<String> optional2 = p_209657_0_.get("Type").asString().result();
                if (optional2.isPresent()) {
                    Dynamic dynamic1 = DataFixUtils.orElse(p_209657_0_.get("Properties").result(), p_209657_0_.emptyMap()).set("id", p_209657_0_.createString(optional2.get()));
                    return p_209657_0_.set("Entity", dynamic1).remove("Type").remove("Properties");
                }
                return p_209657_0_;
            })));
        }
        return p_209659_1_;
    }

    @Override
    public TypeRewriteRule makeRule() {
        Type<?> type = this.getOutputSchema().getType(TypeReferences.UNTAGGED_SPAWNER);
        return this.fixTypeEverywhereTyped("MobSpawnerEntityIdentifiersFix", this.getInputSchema().getType(TypeReferences.UNTAGGED_SPAWNER), type, (Typed<?> p_206369_2_) -> {
            Dynamic dynamic = p_206369_2_.get(DSL.remainderFinder());
            DataResult dataresult = type.readTyped(this.fix(dynamic = dynamic.set("id", dynamic.createString("MobSpawner"))));
            return !dataresult.result().isPresent() ? p_206369_2_ : dataresult.result().get().getFirst();
        });
    }
}

