/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;

public enum Direction implements IStringSerializable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vector3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vector3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vector3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vector3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vector3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vector3i(1, 0, 0));

    private final int index;
    private final int opposite;
    private final int horizontalIndex;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vector3i directionVec;
    public static final Direction[] VALUES;
    private static final Map<String, Direction> NAME_LOOKUP;
    public static final Direction[] BY_INDEX;
    private static final Direction[] BY_HORIZONTAL_INDEX;
    private static final Long2ObjectMap<Direction> BY_LONG;

    private Direction(int indexIn, int oppositeIn, int horizontalIndexIn, String nameIn, AxisDirection axisDirectionIn, Axis axisIn, Vector3i directionVecIn) {
        this.index = indexIn;
        this.horizontalIndex = horizontalIndexIn;
        this.opposite = oppositeIn;
        this.name = nameIn;
        this.axis = axisIn;
        this.axisDirection = axisDirectionIn;
        this.directionVec = directionVecIn;
    }

    public static Direction[] getFacingDirections(Entity entityIn) {
        Direction direction2;
        float f = entityIn.getPitch(1.0f) * ((float)Math.PI / 180);
        float f1 = -entityIn.getYaw(1.0f) * ((float)Math.PI / 180);
        float f2 = MathHelper.sin(f);
        float f3 = MathHelper.cos(f);
        float f4 = MathHelper.sin(f1);
        float f5 = MathHelper.cos(f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.compose(direction1, direction, direction2);
            }
            return f10 > f7 ? Direction.compose(direction, direction2, direction1) : Direction.compose(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return Direction.compose(direction1, direction2, direction);
        }
        return f9 > f7 ? Direction.compose(direction2, direction, direction1) : Direction.compose(direction2, direction1, direction);
    }

    private static Direction[] compose(Direction first, Direction second, Direction third) {
        return new Direction[]{first, second, third, third.getOpposite(), second.getOpposite(), first.getOpposite()};
    }

    public static Direction rotateFace(Matrix4f matrixIn, Direction directionIn) {
        Vector3i vector3i = directionIn.getDirectionVec();
        Vector4f vector4f = new Vector4f(vector3i.getX(), vector3i.getY(), vector3i.getZ(), 0.0f);
        vector4f.transform(matrixIn);
        return Direction.getFacingFromVector(vector4f.getX(), vector4f.getY(), vector4f.getZ());
    }

    public Quaternion getRotation() {
        Quaternion quaternion = Vector3f.XP.rotationDegrees(90.0f);
        switch (this) {
            case DOWN: {
                return Vector3f.XP.rotationDegrees(180.0f);
            }
            case UP: {
                return Quaternion.ONE.copy();
            }
            case NORTH: {
                quaternion.multiply(Vector3f.ZP.rotationDegrees(180.0f));
                return quaternion;
            }
            case SOUTH: {
                return quaternion;
            }
            case WEST: {
                quaternion.multiply(Vector3f.ZP.rotationDegrees(90.0f));
                return quaternion;
            }
        }
        quaternion.multiply(Vector3f.ZP.rotationDegrees(-90.0f));
        return quaternion;
    }

    public int getIndex() {
        return this.index;
    }

    public int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public Direction getOpposite() {
        return VALUES[this.opposite];
    }

    public Direction rotateY() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
    }

    public Direction rotateYCCW() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
            case EAST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + this);
    }

    public int getXOffset() {
        return this.directionVec.getX();
    }

    public int getYOffset() {
        return this.directionVec.getY();
    }

    public int getZOffset() {
        return this.directionVec.getZ();
    }

    public Vector3f toVector3f() {
        return new Vector3f(this.getXOffset(), this.getYOffset(), this.getZOffset());
    }

    public String getName2() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    @Nullable
    public static Direction byName(@Nullable String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase(Locale.ROOT));
    }

    public static Direction byIndex(int index) {
        return BY_INDEX[MathHelper.abs(index % BY_INDEX.length)];
    }

    public static Direction byHorizontalIndex(int horizontalIndexIn) {
        return BY_HORIZONTAL_INDEX[MathHelper.abs(horizontalIndexIn % BY_HORIZONTAL_INDEX.length)];
    }

    @Nullable
    public static Direction byLong(int x, int y, int z) {
        return (Direction)BY_LONG.get(BlockPos.pack(x, y, z));
    }

    public static Direction fromAngle(double angle) {
        return Direction.byHorizontalIndex(MathHelper.floor(angle / 90.0 + 0.5) & 3);
    }

    public static Direction getFacingFromAxisDirection(Axis axisIn, AxisDirection axisDirectionIn) {
        switch (axisIn) {
            case X: {
                return axisDirectionIn == AxisDirection.POSITIVE ? EAST : WEST;
            }
            case Y: {
                return axisDirectionIn == AxisDirection.POSITIVE ? UP : DOWN;
            }
        }
        return axisDirectionIn == AxisDirection.POSITIVE ? SOUTH : NORTH;
    }

    public float getHorizontalAngle() {
        return (this.horizontalIndex & 3) * 90;
    }

    public static Direction getRandomDirection(Random rand) {
        return Util.getRandomObject(VALUES, rand);
    }

    public static Direction getFacingFromVector(double x, double y, double z) {
        return Direction.getFacingFromVector((float)x, (float)y, (float)z);
    }

    public static Direction getFacingFromVector(float x, float y, float z) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : VALUES) {
            float f1 = x * (float)direction1.directionVec.getX() + y * (float)direction1.directionVec.getY() + z * (float)direction1.directionVec.getZ();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getString() {
        return this.name;
    }

    public static Direction getFacingFromAxis(AxisDirection axisDirectionIn, Axis axisIn) {
        for (Direction direction : VALUES) {
            if (direction.getAxisDirection() != axisDirectionIn || direction.getAxis() != axisIn) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)axisDirectionIn) + " " + axisIn);
    }

    public Vector3i getDirectionVec() {
        return this.directionVec;
    }

    public boolean hasOrientation(float degrees) {
        float f = degrees * ((float)Math.PI / 180);
        float f1 = -MathHelper.sin(f);
        float f2 = MathHelper.cos(f);
        return (float)this.directionVec.getX() * f1 + (float)this.directionVec.getZ() * f2 > 0.0f;
    }

    static {
        VALUES = Direction.values();
        NAME_LOOKUP = Arrays.stream(VALUES).collect(Collectors.toMap(Direction::getName2, p_lambda$static$0_0_ -> p_lambda$static$0_0_));
        BY_INDEX = (Direction[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(p_lambda$static$1_0_ -> p_lambda$static$1_0_.index)).toArray(Direction[]::new);
        BY_HORIZONTAL_INDEX = (Direction[])Arrays.stream(VALUES).filter(p_lambda$static$3_0_ -> p_lambda$static$3_0_.getAxis().isHorizontal()).sorted(Comparator.comparingInt(p_lambda$static$4_0_ -> p_lambda$static$4_0_.horizontalIndex)).toArray(Direction[]::new);
        BY_LONG = Arrays.stream(VALUES).collect(Collectors.toMap(p_lambda$static$6_0_ -> new BlockPos(p_lambda$static$6_0_.getDirectionVec()).toLong(), p_lambda$static$7_0_ -> p_lambda$static$7_0_, (p_lambda$static$8_0_, p_lambda$static$8_1_) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] facingValues;
        private final Axis[] axisValues;

        private Plane(Direction[] facingValuesIn, Axis[] axisValuesIn) {
            this.facingValues = facingValuesIn;
            this.axisValues = axisValuesIn;
        }

        public Direction random(Random rand) {
            return Util.getRandomObject(this.facingValues, rand);
        }

        public Axis func_244803_b(Random p_244803_1_) {
            return Util.getRandomObject(this.axisValues, p_244803_1_);
        }

        @Override
        public boolean test(@Nullable Direction p_test_1_) {
            return p_test_1_ != null && p_test_1_.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray(this.facingValues);
        }

        public Stream<Direction> getDirectionValues() {
            return Arrays.stream(this.facingValues);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int offset;
        private final String description;

        private AxisDirection(int offset, String description) {
            this.offset = offset;
            this.description = description;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.description;
        }

        public AxisDirection inverted() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Axis implements IStringSerializable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int getCoordinate(int x, int y, int z) {
                return x;
            }

            @Override
            public double getCoordinate(double x, double y, double z) {
                return x;
            }
        }
        ,
        Y("y"){

            @Override
            public int getCoordinate(int x, int y, int z) {
                return y;
            }

            @Override
            public double getCoordinate(double x, double y, double z) {
                return y;
            }
        }
        ,
        Z("z"){

            @Override
            public int getCoordinate(int x, int y, int z) {
                return z;
            }

            @Override
            public double getCoordinate(double x, double y, double z) {
                return z;
            }
        };

        private static final Axis[] VALUES;
        public static final Codec<Axis> CODEC;
        private static final Map<String, Axis> NAME_LOOKUP;
        private final String name;

        private Axis(String nameIn) {
            this.name = nameIn;
        }

        @Nullable
        public static Axis byName(String name) {
            return NAME_LOOKUP.get(name.toLowerCase(Locale.ROOT));
        }

        public String getName2() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.name;
        }

        public static Axis getRandomAxis(Random rand) {
            return Util.getRandomObject(VALUES, rand);
        }

        @Override
        public boolean test(@Nullable Direction p_test_1_) {
            return p_test_1_ != null && p_test_1_.getAxis() == this;
        }

        public Plane getPlane() {
            switch (this) {
                case X: 
                case Z: {
                    return Plane.HORIZONTAL;
                }
                case Y: {
                    return Plane.VERTICAL;
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        @Override
        public String getString() {
            return this.name;
        }

        public abstract int getCoordinate(int var1, int var2, int var3);

        public abstract double getCoordinate(double var1, double var3, double var5);

        static {
            VALUES = Axis.values();
            CODEC = IStringSerializable.createEnumCodec(Axis::values, Axis::byName);
            NAME_LOOKUP = Arrays.stream(VALUES).collect(Collectors.toMap(Axis::getName2, p_lambda$static$0_0_ -> p_lambda$static$0_0_));
        }
    }
}

