/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import org.apache.commons.lang3.Validate;

public class BitArray {
    private static final int[] field_232981_a_ = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final long[] longArray;
    private final int bitsPerEntry;
    private final long maxEntryValue;
    private final int arraySize;
    private final int field_232982_f_;
    private final int field_232983_g_;
    private final int field_232984_h_;
    private final int field_232985_i_;

    public BitArray(int bitsPerEntryIn, int arraySizeIn) {
        this(bitsPerEntryIn, arraySizeIn, null);
    }

    public BitArray(int bitsPerEntryIn, int arraySizeIn, @Nullable long[] data) {
        Validate.inclusiveBetween(1L, 32L, bitsPerEntryIn);
        this.arraySize = arraySizeIn;
        this.bitsPerEntry = bitsPerEntryIn;
        this.maxEntryValue = (1L << bitsPerEntryIn) - 1L;
        this.field_232982_f_ = (char)(64 / bitsPerEntryIn);
        int i = 3 * (this.field_232982_f_ - 1);
        this.field_232983_g_ = field_232981_a_[i + 0];
        this.field_232984_h_ = field_232981_a_[i + 1];
        this.field_232985_i_ = field_232981_a_[i + 2];
        int j = (arraySizeIn + this.field_232982_f_ - 1) / this.field_232982_f_;
        if (data != null) {
            if (data.length != j) {
                throw Util.pauseDevMode(new RuntimeException("Invalid length given for storage, got: " + data.length + " but expected: " + j));
            }
            this.longArray = data;
        } else {
            this.longArray = new long[j];
        }
    }

    private int func_232986_b_(int p_232986_1_) {
        long i = Integer.toUnsignedLong(this.field_232983_g_);
        long j = Integer.toUnsignedLong(this.field_232984_h_);
        return (int)((long)p_232986_1_ * i + j >> 32 >> this.field_232985_i_);
    }

    public int swapAt(int index, int value) {
        Validate.inclusiveBetween(0L, this.arraySize - 1, index);
        Validate.inclusiveBetween(0L, this.maxEntryValue, value);
        int i = this.func_232986_b_(index);
        long j = this.longArray[i];
        int k = (index - i * this.field_232982_f_) * this.bitsPerEntry;
        int l = (int)(j >> k & this.maxEntryValue);
        this.longArray[i] = j & (this.maxEntryValue << k ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxEntryValue) << k;
        return l;
    }

    public void setAt(int index, int value) {
        Validate.inclusiveBetween(0L, this.arraySize - 1, index);
        Validate.inclusiveBetween(0L, this.maxEntryValue, value);
        int i = this.func_232986_b_(index);
        long j = this.longArray[i];
        int k = (index - i * this.field_232982_f_) * this.bitsPerEntry;
        this.longArray[i] = j & (this.maxEntryValue << k ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxEntryValue) << k;
    }

    public int getAt(int index) {
        Validate.inclusiveBetween(0L, this.arraySize - 1, index);
        int i = this.func_232986_b_(index);
        long j = this.longArray[i];
        int k = (index - i * this.field_232982_f_) * this.bitsPerEntry;
        return (int)(j >> k & this.maxEntryValue);
    }

    public long[] getBackingLongArray() {
        return this.longArray;
    }

    public int size() {
        return this.arraySize;
    }

    public void getAll(IntConsumer consumer) {
        int i = 0;
        for (long j : this.longArray) {
            for (int k = 0; k < this.field_232982_f_; ++k) {
                consumer.accept((int)(j & this.maxEntryValue));
                j >>= this.bitsPerEntry;
                if (++i < this.arraySize) continue;
                return;
            }
        }
    }
}

