/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class ConduitTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final Block[] field_205042_e = new Block[]{Blocks.PRISMARINE, Blocks.PRISMARINE_BRICKS, Blocks.SEA_LANTERN, Blocks.DARK_PRISMARINE};
    public int ticksExisted;
    private float activeRotation;
    private boolean active;
    private boolean eyeOpen;
    private final List<BlockPos> prismarinePositions = Lists.newArrayList();
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID targetUuid;
    private long nextSoundTime;

    public ConduitTileEntity() {
        this(TileEntityType.CONDUIT);
    }

    public ConduitTileEntity(TileEntityType<?> p_i48929_1_) {
        super(p_i48929_1_);
    }

    @Override
    public void read(BlockState state, CompoundNBT nbt) {
        super.read(state, nbt);
        this.targetUuid = nbt.hasUniqueId("Target") ? nbt.getUniqueId("Target") : null;
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        super.write(compound);
        if (this.target != null) {
            compound.putUniqueId("Target", this.target.getUniqueID());
        }
        return compound;
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket getUpdatePacket() {
        return new SUpdateTileEntityPacket(this.pos, 5, this.getUpdateTag());
    }

    @Override
    public CompoundNBT getUpdateTag() {
        return this.write(new CompoundNBT());
    }

    @Override
    public void tick() {
        ++this.ticksExisted;
        long i = this.world.getGameTime();
        if (i % 40L == 0L) {
            this.setActive(this.shouldBeActive());
            if (!this.world.isRemote && this.isActive()) {
                this.addEffectsToPlayers();
                this.attackMobs();
            }
        }
        if (i % 80L == 0L && this.isActive()) {
            this.playSound(SoundEvents.BLOCK_CONDUIT_AMBIENT);
        }
        if (i > this.nextSoundTime && this.isActive()) {
            this.nextSoundTime = i + 60L + (long)this.world.getRandom().nextInt(40);
            this.playSound(SoundEvents.BLOCK_CONDUIT_AMBIENT_SHORT);
        }
        if (this.world.isRemote) {
            this.updateClientTarget();
            this.spawnParticles();
            if (this.isActive()) {
                this.activeRotation += 1.0f;
            }
        }
    }

    private boolean shouldBeActive() {
        this.prismarinePositions.clear();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos blockpos = this.pos.add(i, j, k);
                    if (this.world.hasWater(blockpos)) continue;
                    return false;
                }
            }
        }
        for (int j1 = -2; j1 <= 2; ++j1) {
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    int i2 = Math.abs(j1);
                    int l = Math.abs(k1);
                    int i1 = Math.abs(l1);
                    if (i2 <= 1 && l <= 1 && i1 <= 1 || (j1 != 0 || l != 2 && i1 != 2) && (k1 != 0 || i2 != 2 && i1 != 2) && (l1 != 0 || i2 != 2 && l != 2)) continue;
                    BlockPos blockpos1 = this.pos.add(j1, k1, l1);
                    BlockState blockstate = this.world.getBlockState(blockpos1);
                    for (Block block : field_205042_e) {
                        if (!blockstate.isIn(block)) continue;
                        this.prismarinePositions.add(blockpos1);
                    }
                }
            }
        }
        this.setEyeOpen(this.prismarinePositions.size() >= 42);
        return this.prismarinePositions.size() >= 16;
    }

    private void addEffectsToPlayers() {
        int i1;
        int l;
        int i = this.prismarinePositions.size();
        int j = i / 7 * 16;
        int k = this.pos.getX();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(k, l = this.pos.getY(), i1 = this.pos.getZ(), k + 1, l + 1, i1 + 1).grow(j).expand(0.0, this.world.getHeight(), 0.0);
        List<PlayerEntity> list = this.world.getEntitiesWithinAABB(PlayerEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (PlayerEntity playerentity : list) {
                if (!this.pos.withinDistance(playerentity.getPosition(), (double)j) || !playerentity.isWet()) continue;
                playerentity.addPotionEffect(new EffectInstance(Effects.CONDUIT_POWER, 260, 0, true, true));
            }
        }
    }

    private void attackMobs() {
        LivingEntity livingentity = this.target;
        int i = this.prismarinePositions.size();
        if (i < 42) {
            this.target = null;
        } else if (this.target == null && this.targetUuid != null) {
            this.target = this.findExistingTarget();
            this.targetUuid = null;
        } else if (this.target == null) {
            List<LivingEntity> list = this.world.getEntitiesWithinAABB(LivingEntity.class, this.getAreaOfEffect(), p_205033_0_ -> p_205033_0_ instanceof IMob && p_205033_0_.isWet());
            if (!list.isEmpty()) {
                this.target = list.get(this.world.rand.nextInt(list.size()));
            }
        } else if (!this.target.isAlive() || !this.pos.withinDistance(this.target.getPosition(), 8.0)) {
            this.target = null;
        }
        if (this.target != null) {
            this.world.playSound(null, this.target.getPosX(), this.target.getPosY(), this.target.getPosZ(), SoundEvents.BLOCK_CONDUIT_ATTACK_TARGET, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.target.attackEntityFrom(DamageSource.MAGIC, 4.0f);
        }
        if (livingentity != this.target) {
            BlockState blockstate = this.getBlockState();
            this.world.notifyBlockUpdate(this.pos, blockstate, blockstate, 2);
        }
    }

    private void updateClientTarget() {
        if (this.targetUuid == null) {
            this.target = null;
        } else if (this.target == null || !this.target.getUniqueID().equals(this.targetUuid)) {
            this.target = this.findExistingTarget();
            if (this.target == null) {
                this.targetUuid = null;
            }
        }
    }

    private AxisAlignedBB getAreaOfEffect() {
        int i = this.pos.getX();
        int j = this.pos.getY();
        int k = this.pos.getZ();
        return new AxisAlignedBB(i, j, k, i + 1, j + 1, k + 1).grow(8.0);
    }

    @Nullable
    private LivingEntity findExistingTarget() {
        List<LivingEntity> list = this.world.getEntitiesWithinAABB(LivingEntity.class, this.getAreaOfEffect(), p_205032_1_ -> p_205032_1_.getUniqueID().equals(this.targetUuid));
        return list.size() == 1 ? list.get(0) : null;
    }

    private void spawnParticles() {
        Random random = this.world.rand;
        double d0 = MathHelper.sin((float)(this.ticksExisted + 35) * 0.1f) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vector3d vector3d = new Vector3d((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 1.5 + d0, (double)this.pos.getZ() + 0.5);
        for (BlockPos blockpos : this.prismarinePositions) {
            if (random.nextInt(50) != 0) continue;
            float f = -0.5f + random.nextFloat();
            float f1 = -2.0f + random.nextFloat();
            float f2 = -0.5f + random.nextFloat();
            BlockPos blockpos1 = blockpos.subtract(this.pos);
            Vector3d vector3d1 = new Vector3d(f, f1, f2).add(blockpos1.getX(), blockpos1.getY(), blockpos1.getZ());
            this.world.addParticle(ParticleTypes.NAUTILUS, vector3d.x, vector3d.y, vector3d.z, vector3d1.x, vector3d1.y, vector3d1.z);
        }
        if (this.target != null) {
            Vector3d vector3d2 = new Vector3d(this.target.getPosX(), this.target.getPosYEye(), this.target.getPosZ());
            float f3 = (-0.5f + random.nextFloat()) * (3.0f + this.target.getWidth());
            float f4 = -1.0f + random.nextFloat() * this.target.getHeight();
            float f5 = (-0.5f + random.nextFloat()) * (3.0f + this.target.getWidth());
            Vector3d vector3d3 = new Vector3d(f3, f4, f5);
            this.world.addParticle(ParticleTypes.NAUTILUS, vector3d2.x, vector3d2.y, vector3d2.z, vector3d3.x, vector3d3.y, vector3d3.z);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEyeOpen() {
        return this.eyeOpen;
    }

    private void setActive(boolean p_205739_1_) {
        if (p_205739_1_ != this.active) {
            this.playSound(p_205739_1_ ? SoundEvents.BLOCK_CONDUIT_ACTIVATE : SoundEvents.BLOCK_CONDUIT_DEACTIVATE);
        }
        this.active = p_205739_1_;
    }

    private void setEyeOpen(boolean p_207736_1_) {
        this.eyeOpen = p_207736_1_;
    }

    public float getActiveRotation(float p_205036_1_) {
        return (this.activeRotation + p_205036_1_) * -0.0375f;
    }

    public void playSound(SoundEvent p_205738_1_) {
        this.world.playSound(null, this.pos, p_205738_1_, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

