/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class CommandBlockLogic
implements ICommandSource {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final ITextComponent field_226655_c_ = new StringTextComponent("@");
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable
    private ITextComponent lastOutput;
    private String commandStored = "";
    private ITextComponent customName = field_226655_c_;

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int successCountIn) {
        this.successCount = successCountIn;
    }

    public ITextComponent getLastOutput() {
        return this.lastOutput == null ? StringTextComponent.EMPTY : this.lastOutput;
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.putString("Command", this.commandStored);
        compound.putInt("SuccessCount", this.successCount);
        compound.putString("CustomName", ITextComponent.Serializer.toJson(this.customName));
        compound.putBoolean("TrackOutput", this.trackOutput);
        if (this.lastOutput != null && this.trackOutput) {
            compound.putString("LastOutput", ITextComponent.Serializer.toJson(this.lastOutput));
        }
        compound.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution > 0L) {
            compound.putLong("LastExecution", this.lastExecution);
        }
        return compound;
    }

    public void read(CompoundNBT nbt) {
        this.commandStored = nbt.getString("Command");
        this.successCount = nbt.getInt("SuccessCount");
        if (nbt.contains("CustomName", 8)) {
            this.setName(ITextComponent.Serializer.getComponentFromJson(nbt.getString("CustomName")));
        }
        if (nbt.contains("TrackOutput", 1)) {
            this.trackOutput = nbt.getBoolean("TrackOutput");
        }
        if (nbt.contains("LastOutput", 8) && this.trackOutput) {
            try {
                this.lastOutput = ITextComponent.Serializer.getComponentFromJson(nbt.getString("LastOutput"));
            }
            catch (Throwable throwable) {
                this.lastOutput = new StringTextComponent(throwable.getMessage());
            }
        } else {
            this.lastOutput = null;
        }
        if (nbt.contains("UpdateLastExecution")) {
            this.updateLastExecution = nbt.getBoolean("UpdateLastExecution");
        }
        this.lastExecution = this.updateLastExecution && nbt.contains("LastExecution") ? nbt.getLong("LastExecution") : -1L;
    }

    public void setCommand(String command) {
        this.commandStored = command;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.commandStored;
    }

    public boolean trigger(World worldIn) {
        if (!worldIn.isRemote && worldIn.getGameTime() != this.lastExecution) {
            if ("Searge".equalsIgnoreCase(this.commandStored)) {
                this.lastOutput = new StringTextComponent("#itzlipofutzli");
                this.successCount = 1;
                return true;
            }
            this.successCount = 0;
            MinecraftServer minecraftserver = this.getWorld().getServer();
            if (minecraftserver.isCommandBlockEnabled() && !StringUtils.isNullOrEmpty(this.commandStored)) {
                try {
                    this.lastOutput = null;
                    CommandSource commandsource = this.getCommandSource().withResultConsumer((p_209527_1_, p_209527_2_, p_209527_3_) -> {
                        if (p_209527_2_) {
                            ++this.successCount;
                        }
                    });
                    minecraftserver.getCommandManager().handleCommand(commandsource, this.commandStored);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Executing command block");
                    CrashReportCategory crashreportcategory = crashreport.makeCategory("Command to be executed");
                    crashreportcategory.addDetail("Command", this::getCommand);
                    crashreportcategory.addDetail("Name", () -> this.getName().getString());
                    throw new ReportedException(crashreport);
                }
            }
            this.lastExecution = this.updateLastExecution ? worldIn.getGameTime() : -1L;
            return true;
        }
        return false;
    }

    public ITextComponent getName() {
        return this.customName;
    }

    public void setName(@Nullable ITextComponent nameIn) {
        this.customName = nameIn != null ? nameIn : field_226655_c_;
    }

    @Override
    public void sendMessage(ITextComponent component, UUID senderUUID) {
        if (this.trackOutput) {
            this.lastOutput = new StringTextComponent("[" + TIMESTAMP_FORMAT.format(new Date()) + "] ").append(component);
            this.updateCommand();
        }
    }

    public abstract ServerWorld getWorld();

    public abstract void updateCommand();

    public void setLastOutput(@Nullable ITextComponent lastOutputMessage) {
        this.lastOutput = lastOutputMessage;
    }

    public void setTrackOutput(boolean shouldTrackOutput) {
        this.trackOutput = shouldTrackOutput;
    }

    public boolean shouldTrackOutput() {
        return this.trackOutput;
    }

    public ActionResultType tryOpenEditCommandBlock(PlayerEntity playerIn) {
        if (!playerIn.canUseCommandBlock()) {
            return ActionResultType.PASS;
        }
        if (playerIn.getEntityWorld().isRemote) {
            playerIn.openMinecartCommandBlock(this);
        }
        return ActionResultType.func_233537_a_(playerIn.world.isRemote);
    }

    public abstract Vector3d getPositionVector();

    public abstract CommandSource getCommandSource();

    @Override
    public boolean shouldReceiveFeedback() {
        return this.getWorld().getGameRules().getBoolean(GameRules.SEND_COMMAND_FEEDBACK) && this.trackOutput;
    }

    @Override
    public boolean shouldReceiveErrors() {
        return this.trackOutput;
    }

    @Override
    public boolean allowLogging() {
        return this.getWorld().getGameRules().getBoolean(GameRules.COMMAND_BLOCK_OUTPUT);
    }
}

