/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClimberPathNavigator
extends GroundPathNavigator {
    private BlockPos targetPosition;

    public ClimberPathNavigator(MobEntity entityLivingIn, World worldIn) {
        super(entityLivingIn, worldIn);
    }

    @Override
    public Path getPathToPos(BlockPos pos, int p_179680_2_) {
        this.targetPosition = pos;
        return super.getPathToPos(pos, p_179680_2_);
    }

    @Override
    public Path getPathToEntity(Entity entityIn, int p_75494_2_) {
        this.targetPosition = entityIn.getPosition();
        return super.getPathToEntity(entityIn, p_75494_2_);
    }

    @Override
    public boolean tryMoveToEntityLiving(Entity entityIn, double speedIn) {
        Path path = this.getPathToEntity(entityIn, 0);
        if (path != null) {
            return this.setPath(path, speedIn);
        }
        this.targetPosition = entityIn.getPosition();
        this.speed = speedIn;
        return true;
    }

    @Override
    public void tick() {
        if (!this.noPath()) {
            super.tick();
        } else if (this.targetPosition != null) {
            if (!(this.targetPosition.withinDistance(this.entity.getPositionVec(), (double)this.entity.getWidth()) || this.entity.getPosY() > (double)this.targetPosition.getY() && new BlockPos((double)this.targetPosition.getX(), this.entity.getPosY(), (double)this.targetPosition.getZ()).withinDistance(this.entity.getPositionVec(), (double)this.entity.getWidth()))) {
                this.entity.getMoveHelper().setMoveTo(this.targetPosition.getX(), this.targetPosition.getY(), this.targetPosition.getZ(), this.speed);
            } else {
                this.targetPosition = null;
            }
        }
    }
}

