/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

public class SStopSoundPacket
implements IPacket<IClientPlayNetHandler> {
    private ResourceLocation name;
    private SoundCategory category;

    public SStopSoundPacket() {
    }

    public SStopSoundPacket(@Nullable ResourceLocation p_i47929_1_, @Nullable SoundCategory p_i47929_2_) {
        this.name = p_i47929_1_;
        this.category = p_i47929_2_;
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        byte i = buf.readByte();
        if ((i & 1) > 0) {
            this.category = buf.readEnumValue(SoundCategory.class);
        }
        if ((i & 2) > 0) {
            this.name = buf.readResourceLocation();
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        if (this.category != null) {
            if (this.name != null) {
                buf.writeByte(3);
                buf.writeEnumValue(this.category);
                buf.writeResourceLocation(this.name);
            } else {
                buf.writeByte(1);
                buf.writeEnumValue(this.category);
            }
        } else if (this.name != null) {
            buf.writeByte(2);
            buf.writeResourceLocation(this.name);
        } else {
            buf.writeByte(0);
        }
    }

    @Nullable
    public ResourceLocation getName() {
        return this.name;
    }

    @Nullable
    public SoundCategory getCategory() {
        return this.category;
    }

    @Override
    public void processPacket(IClientPlayNetHandler handler) {
        handler.handleStopSound(this);
    }
}

