/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;

public class SPlayerListItemPacket
implements IPacket<IClientPlayNetHandler> {
    private Action action;
    private final List<AddPlayerData> players = Lists.newArrayList();

    public SPlayerListItemPacket() {
    }

    public SPlayerListItemPacket(Action actionIn, ServerPlayerEntity ... playersIn) {
        this.action = actionIn;
        for (ServerPlayerEntity serverplayerentity : playersIn) {
            this.players.add(new AddPlayerData(serverplayerentity.getGameProfile(), serverplayerentity.ping, serverplayerentity.interactionManager.getGameType(), serverplayerentity.getTabListDisplayName()));
        }
    }

    public SPlayerListItemPacket(Action actionIn, Iterable<ServerPlayerEntity> playersIn) {
        this.action = actionIn;
        for (ServerPlayerEntity serverplayerentity : playersIn) {
            this.players.add(new AddPlayerData(serverplayerentity.getGameProfile(), serverplayerentity.ping, serverplayerentity.interactionManager.getGameType(), serverplayerentity.getTabListDisplayName()));
        }
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.action = buf.readEnumValue(Action.class);
        int i = buf.readVarInt();
        for (int j = 0; j < i; ++j) {
            GameProfile gameprofile = null;
            int k = 0;
            GameType gametype = null;
            ITextComponent itextcomponent = null;
            switch (this.action) {
                case ADD_PLAYER: {
                    gameprofile = new GameProfile(buf.readUniqueId(), buf.readString(16));
                    int l = buf.readVarInt();
                    for (int i1 = 0; i1 < l; ++i1) {
                        String s = buf.readString(Short.MAX_VALUE);
                        String s1 = buf.readString(Short.MAX_VALUE);
                        if (buf.readBoolean()) {
                            gameprofile.getProperties().put(s, new Property(s, s1, buf.readString(Short.MAX_VALUE)));
                            continue;
                        }
                        gameprofile.getProperties().put(s, new Property(s, s1));
                    }
                    gametype = GameType.getByID(buf.readVarInt());
                    k = buf.readVarInt();
                    if (!buf.readBoolean()) break;
                    itextcomponent = buf.readTextComponent();
                    break;
                }
                case UPDATE_GAME_MODE: {
                    gameprofile = new GameProfile(buf.readUniqueId(), null);
                    gametype = GameType.getByID(buf.readVarInt());
                    break;
                }
                case UPDATE_LATENCY: {
                    gameprofile = new GameProfile(buf.readUniqueId(), null);
                    k = buf.readVarInt();
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    gameprofile = new GameProfile(buf.readUniqueId(), null);
                    if (!buf.readBoolean()) break;
                    itextcomponent = buf.readTextComponent();
                    break;
                }
                case REMOVE_PLAYER: {
                    gameprofile = new GameProfile(buf.readUniqueId(), null);
                }
            }
            this.players.add(new AddPlayerData(gameprofile, k, gametype, itextcomponent));
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeEnumValue(this.action);
        buf.writeVarInt(this.players.size());
        for (AddPlayerData splayerlistitempacket$addplayerdata : this.players) {
            switch (this.action) {
                case ADD_PLAYER: {
                    buf.writeUniqueId(splayerlistitempacket$addplayerdata.getProfile().getId());
                    buf.writeString(splayerlistitempacket$addplayerdata.getProfile().getName());
                    buf.writeVarInt(splayerlistitempacket$addplayerdata.getProfile().getProperties().size());
                    for (Property property : splayerlistitempacket$addplayerdata.getProfile().getProperties().values()) {
                        buf.writeString(property.getName());
                        buf.writeString(property.getValue());
                        if (property.hasSignature()) {
                            buf.writeBoolean(true);
                            buf.writeString(property.getSignature());
                            continue;
                        }
                        buf.writeBoolean(false);
                    }
                    buf.writeVarInt(splayerlistitempacket$addplayerdata.getGameMode().getID());
                    buf.writeVarInt(splayerlistitempacket$addplayerdata.getPing());
                    if (splayerlistitempacket$addplayerdata.getDisplayName() == null) {
                        buf.writeBoolean(false);
                        break;
                    }
                    buf.writeBoolean(true);
                    buf.writeTextComponent(splayerlistitempacket$addplayerdata.getDisplayName());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    buf.writeUniqueId(splayerlistitempacket$addplayerdata.getProfile().getId());
                    buf.writeVarInt(splayerlistitempacket$addplayerdata.getGameMode().getID());
                    break;
                }
                case UPDATE_LATENCY: {
                    buf.writeUniqueId(splayerlistitempacket$addplayerdata.getProfile().getId());
                    buf.writeVarInt(splayerlistitempacket$addplayerdata.getPing());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    buf.writeUniqueId(splayerlistitempacket$addplayerdata.getProfile().getId());
                    if (splayerlistitempacket$addplayerdata.getDisplayName() == null) {
                        buf.writeBoolean(false);
                        break;
                    }
                    buf.writeBoolean(true);
                    buf.writeTextComponent(splayerlistitempacket$addplayerdata.getDisplayName());
                    break;
                }
                case REMOVE_PLAYER: {
                    buf.writeUniqueId(splayerlistitempacket$addplayerdata.getProfile().getId());
                }
            }
        }
    }

    @Override
    public void processPacket(IClientPlayNetHandler handler) {
        handler.handlePlayerListItem(this);
    }

    public List<AddPlayerData> getEntries() {
        return this.players;
    }

    public Action getAction() {
        return this.action;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("action", (Object)this.action).add("entries", this.players).toString();
    }

    public class AddPlayerData {
        private final int ping;
        private final GameType gamemode;
        private final GameProfile profile;
        private final ITextComponent displayName;

        public AddPlayerData(GameProfile profileIn, @Nullable int latencyIn, @Nullable GameType gameModeIn, ITextComponent displayNameIn) {
            this.profile = profileIn;
            this.ping = latencyIn;
            this.gamemode = gameModeIn;
            this.displayName = displayNameIn;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public int getPing() {
            return this.ping;
        }

        public GameType getGameMode() {
            return this.gamemode;
        }

        @Nullable
        public ITextComponent getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("latency", this.ping).add("gameMode", (Object)this.gamemode).add("profile", this.profile).add("displayName", this.displayName == null ? null : ITextComponent.Serializer.toJson(this.displayName)).toString();
        }
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }
}

