/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class SEntityVelocityPacket
implements IPacket<IClientPlayNetHandler> {
    private int entityID;
    private int motionX;
    private int motionY;
    private int motionZ;

    public SEntityVelocityPacket() {
    }

    public SEntityVelocityPacket(Entity entityIn) {
        this(entityIn.getEntityId(), entityIn.getMotion());
    }

    public SEntityVelocityPacket(int p_i50764_1_, Vector3d p_i50764_2_) {
        this.entityID = p_i50764_1_;
        double d0 = 3.9;
        double d1 = MathHelper.clamp(p_i50764_2_.x, -3.9, 3.9);
        double d2 = MathHelper.clamp(p_i50764_2_.y, -3.9, 3.9);
        double d3 = MathHelper.clamp(p_i50764_2_.z, -3.9, 3.9);
        this.motionX = (int)(d1 * 8000.0);
        this.motionY = (int)(d2 * 8000.0);
        this.motionZ = (int)(d3 * 8000.0);
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.entityID = buf.readVarInt();
        this.motionX = buf.readShort();
        this.motionY = buf.readShort();
        this.motionZ = buf.readShort();
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeVarInt(this.entityID);
        buf.writeShort(this.motionX);
        buf.writeShort(this.motionY);
        buf.writeShort(this.motionZ);
    }

    @Override
    public void processPacket(IClientPlayNetHandler handler) {
        handler.handleEntityVelocity(this);
    }

    public int getEntityID() {
        return this.entityID;
    }

    public int getMotionX() {
        return this.motionX;
    }

    public int getMotionY() {
        return this.motionY;
    }

    public int getMotionZ() {
        return this.motionZ;
    }
}

