/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ListNBT
extends CollectionNBT<INBT> {
    public static final INBTType<ListNBT> TYPE = new INBTType<ListNBT>(){

        @Override
        public ListNBT readNBT(DataInput input, int depth, NBTSizeTracker accounter) throws IOException {
            accounter.read(296L);
            if (depth > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte b0 = input.readByte();
            int i = input.readInt();
            if (b0 == 0 && i > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            accounter.read(32L * (long)i);
            INBTType<?> inbttype = NBTTypes.getGetTypeByID(b0);
            ArrayList<?> list = Lists.newArrayListWithCapacity(i);
            for (int j = 0; j < i; ++j) {
                list.add(inbttype.readNBT(input, depth + 1, accounter));
            }
            return new ListNBT(list, b0);
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getTagName() {
            return "TAG_List";
        }
    };
    private static final ByteSet typeSet = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private final List<INBT> tagList;
    private byte tagType;

    private ListNBT(List<INBT> tagList, byte tagType) {
        this.tagList = tagList;
        this.tagType = tagType;
    }

    public ListNBT() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        this.tagType = this.tagList.isEmpty() ? (byte)0 : this.tagList.get(0).getId();
        output.writeByte(this.tagType);
        output.writeInt(this.tagList.size());
        for (INBT inbt : this.tagList) {
            inbt.write(output);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    public INBTType<ListNBT> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[");
        for (int i = 0; i < this.tagList.size(); ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.tagList.get(i));
        }
        return stringbuilder.append(']').toString();
    }

    private void checkEmpty() {
        if (this.tagList.isEmpty()) {
            this.tagType = 0;
        }
    }

    @Override
    public INBT remove(int p_remove_1_) {
        INBT inbt = this.tagList.remove(p_remove_1_);
        this.checkEmpty();
        return inbt;
    }

    @Override
    public boolean isEmpty() {
        return this.tagList.isEmpty();
    }

    public CompoundNBT getCompound(int i) {
        INBT inbt;
        if (i >= 0 && i < this.tagList.size() && (inbt = this.tagList.get(i)).getId() == 10) {
            return (CompoundNBT)inbt;
        }
        return new CompoundNBT();
    }

    public ListNBT getList(int iIn) {
        INBT inbt;
        if (iIn >= 0 && iIn < this.tagList.size() && (inbt = this.tagList.get(iIn)).getId() == 9) {
            return (ListNBT)inbt;
        }
        return new ListNBT();
    }

    public short getShort(int iIn) {
        INBT inbt;
        if (iIn >= 0 && iIn < this.tagList.size() && (inbt = this.tagList.get(iIn)).getId() == 2) {
            return ((ShortNBT)inbt).getShort();
        }
        return 0;
    }

    public int getInt(int iIn) {
        INBT inbt;
        if (iIn >= 0 && iIn < this.tagList.size() && (inbt = this.tagList.get(iIn)).getId() == 3) {
            return ((IntNBT)inbt).getInt();
        }
        return 0;
    }

    public int[] getIntArray(int i) {
        INBT inbt;
        if (i >= 0 && i < this.tagList.size() && (inbt = this.tagList.get(i)).getId() == 11) {
            return ((IntArrayNBT)inbt).getIntArray();
        }
        return new int[0];
    }

    public double getDouble(int i) {
        INBT inbt;
        if (i >= 0 && i < this.tagList.size() && (inbt = this.tagList.get(i)).getId() == 6) {
            return ((DoubleNBT)inbt).getDouble();
        }
        return 0.0;
    }

    public float getFloat(int i) {
        INBT inbt;
        if (i >= 0 && i < this.tagList.size() && (inbt = this.tagList.get(i)).getId() == 5) {
            return ((FloatNBT)inbt).getFloat();
        }
        return 0.0f;
    }

    public String getString(int i) {
        if (i >= 0 && i < this.tagList.size()) {
            INBT inbt = this.tagList.get(i);
            return inbt.getId() == 8 ? inbt.getString() : inbt.toString();
        }
        return "";
    }

    @Override
    public int size() {
        return this.tagList.size();
    }

    @Override
    public INBT get(int p_get_1_) {
        return this.tagList.get(p_get_1_);
    }

    @Override
    public INBT set(int p_set_1_, INBT p_set_2_) {
        INBT inbt = this.get(p_set_1_);
        if (!this.setNBTByIndex(p_set_1_, p_set_2_)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", p_set_2_.getId(), this.tagType));
        }
        return inbt;
    }

    @Override
    public void add(int p_add_1_, INBT p_add_2_) {
        if (!this.addNBTByIndex(p_add_1_, p_add_2_)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", p_add_2_.getId(), this.tagType));
        }
    }

    @Override
    public boolean setNBTByIndex(int index, INBT nbt) {
        if (this.canInsert(nbt)) {
            this.tagList.set(index, nbt);
            return true;
        }
        return false;
    }

    @Override
    public boolean addNBTByIndex(int index, INBT nbt) {
        if (this.canInsert(nbt)) {
            this.tagList.add(index, nbt);
            return true;
        }
        return false;
    }

    private boolean canInsert(INBT nbt) {
        if (nbt.getId() == 0) {
            return false;
        }
        if (this.tagType == 0) {
            this.tagType = nbt.getId();
            return true;
        }
        return this.tagType == nbt.getId();
    }

    @Override
    public ListNBT copy() {
        List<INBT> iterable = NBTTypes.getGetTypeByID(this.tagType).isPrimitive() ? this.tagList : Iterables.transform(this.tagList, INBT::copy);
        ArrayList<INBT> list = Lists.newArrayList(iterable);
        return new ListNBT(list, this.tagType);
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        return p_equals_1_ instanceof ListNBT && Objects.equals(this.tagList, ((ListNBT)p_equals_1_).tagList);
    }

    @Override
    public int hashCode() {
        return this.tagList.hashCode();
    }

    @Override
    public ITextComponent toFormattedComponent(String indentation, int indentDepth) {
        if (this.isEmpty()) {
            return new StringTextComponent("[]");
        }
        if (typeSet.contains(this.tagType) && this.size() <= 8) {
            String s1 = ", ";
            StringTextComponent iformattabletextcomponent2 = new StringTextComponent("[");
            for (int j = 0; j < this.tagList.size(); ++j) {
                if (j != 0) {
                    iformattabletextcomponent2.appendString(", ");
                }
                iformattabletextcomponent2.append(this.tagList.get(j).toFormattedComponent());
            }
            iformattabletextcomponent2.appendString("]");
            return iformattabletextcomponent2;
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("[");
        if (!indentation.isEmpty()) {
            iformattabletextcomponent.appendString("\n");
        }
        String s = String.valueOf(',');
        for (int i = 0; i < this.tagList.size(); ++i) {
            StringTextComponent iformattabletextcomponent1 = new StringTextComponent(Strings.repeat(indentation, indentDepth + 1));
            iformattabletextcomponent1.append(this.tagList.get(i).toFormattedComponent(indentation, indentDepth + 1));
            if (i != this.tagList.size() - 1) {
                iformattabletextcomponent1.appendString(s).appendString(indentation.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.append(iformattabletextcomponent1);
        }
        if (!indentation.isEmpty()) {
            iformattabletextcomponent.appendString("\n").appendString(Strings.repeat(indentation, indentDepth));
        }
        iformattabletextcomponent.appendString("]");
        return iformattabletextcomponent;
    }

    @Override
    public byte getTagType() {
        return this.tagType;
    }

    @Override
    public void clear() {
        this.tagList.clear();
        this.tagType = 0;
    }
}

