/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ShulkerBoxColoringRecipe
extends SpecialRecipe {
    public ShulkerBoxColoringRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public boolean matches(CraftingInventory inv, World worldIn) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < inv.getSizeInventory(); ++k) {
            ItemStack itemstack = inv.getStackInSlot(k);
            if (itemstack.isEmpty()) continue;
            if (Block.getBlockFromItem(itemstack.getItem()) instanceof ShulkerBoxBlock) {
                ++i;
            } else {
                if (!(itemstack.getItem() instanceof DyeItem)) {
                    return false;
                }
                ++j;
            }
            if (j <= 1 && i <= 1) continue;
            return false;
        }
        return i == 1 && j == 1;
    }

    @Override
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack itemstack = ItemStack.EMPTY;
        DyeItem dyeitem = (DyeItem)Items.WHITE_DYE;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack itemstack1 = inv.getStackInSlot(i);
            if (itemstack1.isEmpty()) continue;
            Item item = itemstack1.getItem();
            if (Block.getBlockFromItem(item) instanceof ShulkerBoxBlock) {
                itemstack = itemstack1;
                continue;
            }
            if (!(item instanceof DyeItem)) continue;
            dyeitem = (DyeItem)item;
        }
        ItemStack itemstack2 = ShulkerBoxBlock.getColoredItemStack(dyeitem.getDyeColor());
        if (itemstack.hasTag()) {
            itemstack2.setTag(itemstack.getTag().copy());
        }
        return itemstack2;
    }

    @Override
    public boolean canFit(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public IRecipeSerializer<?> getSerializer() {
        return IRecipeSerializer.CRAFTING_SPECIAL_SHULKERBOXCOLORING;
    }
}

