/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FireChargeItem
extends Item {
    public FireChargeItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        World world = context.getWorld();
        BlockPos blockpos = context.getPos();
        BlockState blockstate = world.getBlockState(blockpos);
        boolean flag = false;
        if (CampfireBlock.canBeLit(blockstate)) {
            this.playUseSound(world, blockpos);
            world.setBlockState(blockpos, (BlockState)blockstate.with(CampfireBlock.LIT, true));
            flag = true;
        } else if (AbstractFireBlock.canLightBlock(world, blockpos = blockpos.offset(context.getFace()), context.getPlacementHorizontalFacing())) {
            this.playUseSound(world, blockpos);
            world.setBlockState(blockpos, AbstractFireBlock.getFireForPlacement(world, blockpos));
            flag = true;
        }
        if (flag) {
            context.getItem().shrink(1);
            return ActionResultType.func_233537_a_(world.isRemote);
        }
        return ActionResultType.FAIL;
    }

    private void playUseSound(World worldIn, BlockPos pos) {
        worldIn.playSound(null, pos, SoundEvents.ITEM_FIRECHARGE_USE, SoundCategory.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
    }
}

