/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.EyeOfEnderEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class EnderEyeItem
extends Item {
    public EnderEyeItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.getWorld();
        BlockState blockstate = world.getBlockState(blockpos = context.getPos());
        if (blockstate.isIn(Blocks.END_PORTAL_FRAME) && !blockstate.get(EndPortalFrameBlock.EYE).booleanValue()) {
            if (world.isRemote) {
                return ActionResultType.SUCCESS;
            }
            BlockState blockstate1 = (BlockState)blockstate.with(EndPortalFrameBlock.EYE, true);
            Block.nudgeEntitiesWithNewState(blockstate, blockstate1, world, blockpos);
            world.setBlockState(blockpos, blockstate1, 2);
            world.updateComparatorOutputLevel(blockpos, Blocks.END_PORTAL_FRAME);
            context.getItem().shrink(1);
            world.playEvent(1503, blockpos, 0);
            BlockPattern.PatternHelper blockpattern$patternhelper = EndPortalFrameBlock.getOrCreatePortalShape().match(world, blockpos);
            if (blockpattern$patternhelper != null) {
                BlockPos blockpos1 = blockpattern$patternhelper.getFrontTopLeft().add(-3, 0, -3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        world.setBlockState(blockpos1.add(i, 0, j), Blocks.END_PORTAL.getDefaultState(), 2);
                    }
                }
                world.playBroadcastSound(1038, blockpos1.add(1, 0, 1), 0);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BlockPos blockpos;
        ItemStack itemstack = playerIn.getHeldItem(handIn);
        BlockRayTraceResult raytraceresult = EnderEyeItem.rayTrace(worldIn, playerIn, RayTraceContext.FluidMode.NONE);
        if (((RayTraceResult)raytraceresult).getType() == RayTraceResult.Type.BLOCK && worldIn.getBlockState(raytraceresult.getPos()).isIn(Blocks.END_PORTAL_FRAME)) {
            return ActionResult.resultPass(itemstack);
        }
        playerIn.setActiveHand(handIn);
        if (worldIn instanceof ServerWorld && (blockpos = ((ServerWorld)worldIn).getChunkProvider().getChunkGenerator().func_235956_a_((ServerWorld)worldIn, Structure.STRONGHOLD, playerIn.getPosition(), 100, false)) != null) {
            EyeOfEnderEntity eyeofenderentity = new EyeOfEnderEntity(worldIn, playerIn.getPosX(), playerIn.getPosYHeight(0.5), playerIn.getPosZ());
            eyeofenderentity.func_213863_b(itemstack);
            eyeofenderentity.moveTowards(blockpos);
            worldIn.addEntity(eyeofenderentity);
            if (playerIn instanceof ServerPlayerEntity) {
                CriteriaTriggers.USED_ENDER_EYE.trigger((ServerPlayerEntity)playerIn, blockpos);
            }
            worldIn.playSound(null, playerIn.getPosX(), playerIn.getPosY(), playerIn.getPosZ(), SoundEvents.ENTITY_ENDER_EYE_LAUNCH, SoundCategory.NEUTRAL, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            worldIn.playEvent(null, 1003, playerIn.getPosition(), 0);
            if (!playerIn.abilities.isCreativeMode) {
                itemstack.shrink(1);
            }
            playerIn.addStat(Stats.ITEM_USED.get(this));
            playerIn.swing(handIn, true);
            return ActionResult.resultSuccess(itemstack);
        }
        return ActionResult.resultConsume(itemstack);
    }
}

