/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class BoatItem
extends Item {
    private static final Predicate<Entity> field_219989_a = EntityPredicates.NOT_SPECTATING.and(Entity::canBeCollidedWith);
    private final BoatEntity.Type type;

    public BoatItem(BoatEntity.Type typeIn, Item.Properties properties) {
        super(properties);
        this.type = typeIn;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.getHeldItem(handIn);
        BlockRayTraceResult raytraceresult = BoatItem.rayTrace(worldIn, playerIn, RayTraceContext.FluidMode.ANY);
        if (((RayTraceResult)raytraceresult).getType() == RayTraceResult.Type.MISS) {
            return ActionResult.resultPass(itemstack);
        }
        Vector3d vector3d = playerIn.getLook(1.0f);
        double d0 = 5.0;
        List<Entity> list = worldIn.getEntitiesInAABBexcluding(playerIn, playerIn.getBoundingBox().expand(vector3d.scale(5.0)).grow(1.0), field_219989_a);
        if (!list.isEmpty()) {
            Vector3d vector3d1 = playerIn.getEyePosition(1.0f);
            for (Entity entity : list) {
                AxisAlignedBB axisalignedbb = entity.getBoundingBox().grow(entity.getCollisionBorderSize());
                if (!axisalignedbb.contains(vector3d1)) continue;
                return ActionResult.resultPass(itemstack);
            }
        }
        if (((RayTraceResult)raytraceresult).getType() == RayTraceResult.Type.BLOCK) {
            BoatEntity boatentity = new BoatEntity(worldIn, raytraceresult.getHitVec().x, raytraceresult.getHitVec().y, raytraceresult.getHitVec().z);
            boatentity.setBoatType(this.type);
            boatentity.rotationYaw = playerIn.rotationYaw;
            if (!worldIn.hasNoCollisions(boatentity, boatentity.getBoundingBox().grow(-0.1))) {
                return ActionResult.resultFail(itemstack);
            }
            if (!worldIn.isRemote) {
                worldIn.addEntity(boatentity);
                if (!playerIn.abilities.isCreativeMode) {
                    itemstack.shrink(1);
                }
            }
            playerIn.addStat(Stats.ITEM_USED.get(this));
            return ActionResult.func_233538_a_(itemstack, worldIn.isRemote());
        }
        return ActionResult.resultPass(itemstack);
    }
}

