/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty FALLING = BlockStateProperties.FALLING;
    public static final IntegerProperty LEVEL_1_8 = BlockStateProperties.LEVEL_1_8;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>> field_212756_e = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>(200){

            @Override
            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    private final Map<FluidState, VoxelShape> field_215669_f = Maps.newIdentityHashMap();

    @Override
    protected void fillStateContainer(StateContainer.Builder<Fluid, FluidState> builder) {
        builder.add(FALLING);
    }

    @Override
    public Vector3d getFlow(IBlockReader blockReader, BlockPos pos, FluidState fluidState) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockpos$mutable.setAndMove(pos, direction);
            FluidState fluidstate = blockReader.getFluidState(blockpos$mutable);
            if (!this.isSameOrEmpty(fluidstate)) continue;
            float f = fluidstate.getHeight();
            float f1 = 0.0f;
            if (f == 0.0f) {
                Vector3i blockpos;
                FluidState fluidstate1;
                if (!blockReader.getBlockState(blockpos$mutable).getMaterial().blocksMovement() && this.isSameOrEmpty(fluidstate1 = blockReader.getFluidState((BlockPos)(blockpos = blockpos$mutable.down()))) && (f = fluidstate1.getHeight()) > 0.0f) {
                    f1 = fluidState.getHeight() - (f - 0.8888889f);
                }
            } else if (f > 0.0f) {
                f1 = fluidState.getHeight() - f;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)direction.getXOffset() * f1);
            d1 += (double)((float)direction.getZOffset() * f1);
        }
        Vector3d vector3d = new Vector3d(d0, 0.0, d1);
        if (fluidState.get(FALLING).booleanValue()) {
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                blockpos$mutable.setAndMove(pos, direction1);
                if (!this.causesDownwardCurrent(blockReader, blockpos$mutable, direction1) && !this.causesDownwardCurrent(blockReader, (BlockPos)blockpos$mutable.up(), direction1)) continue;
                vector3d = vector3d.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return vector3d.normalize();
    }

    private boolean isSameOrEmpty(FluidState state) {
        return state.isEmpty() || state.getFluid().isEquivalentTo(this);
    }

    protected boolean causesDownwardCurrent(IBlockReader worldIn, BlockPos neighborPos, Direction side) {
        BlockState blockstate = worldIn.getBlockState(neighborPos);
        FluidState fluidstate = worldIn.getFluidState(neighborPos);
        if (fluidstate.getFluid().isEquivalentTo(this)) {
            return false;
        }
        if (side == Direction.UP) {
            return true;
        }
        return blockstate.getMaterial() == Material.ICE ? false : blockstate.isSolidSide(worldIn, neighborPos, side);
    }

    protected void flowAround(IWorld worldIn, BlockPos pos, FluidState stateIn) {
        if (!stateIn.isEmpty()) {
            BlockState blockstate = worldIn.getBlockState(pos);
            BlockPos blockpos = pos.down();
            BlockState blockstate1 = worldIn.getBlockState(blockpos);
            FluidState fluidstate = this.calculateCorrectFlowingState(worldIn, blockpos, blockstate1);
            if (this.canFlow(worldIn, pos, blockstate, Direction.DOWN, blockpos, blockstate1, worldIn.getFluidState(blockpos), fluidstate.getFluid())) {
                this.flowInto(worldIn, blockpos, blockstate1, Direction.DOWN, fluidstate);
                if (this.getNumHorizontallyAdjacentSources(worldIn, pos) >= 3) {
                    this.func_207937_a(worldIn, pos, stateIn, blockstate);
                }
            } else if (stateIn.isSource() || !this.func_211759_a(worldIn, fluidstate.getFluid(), pos, blockstate, blockpos, blockstate1)) {
                this.func_207937_a(worldIn, pos, stateIn, blockstate);
            }
        }
    }

    private void func_207937_a(IWorld p_207937_1_, BlockPos p_207937_2_, FluidState p_207937_3_, BlockState p_207937_4_) {
        int i = p_207937_3_.getLevel() - this.getLevelDecreasePerBlock(p_207937_1_);
        if (p_207937_3_.get(FALLING).booleanValue()) {
            i = 7;
        }
        if (i > 0) {
            Map<Direction, FluidState> map = this.func_205572_b(p_207937_1_, p_207937_2_, p_207937_4_);
            for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                BlockState blockstate;
                Direction direction = entry.getKey();
                FluidState fluidstate = entry.getValue();
                BlockPos blockpos = p_207937_2_.offset(direction);
                if (!this.canFlow(p_207937_1_, p_207937_2_, p_207937_4_, direction, blockpos, blockstate = p_207937_1_.getBlockState(blockpos), p_207937_1_.getFluidState(blockpos), fluidstate.getFluid())) continue;
                this.flowInto(p_207937_1_, blockpos, blockstate, direction, fluidstate);
            }
        }
    }

    protected FluidState calculateCorrectFlowingState(IWorldReader worldIn, BlockPos pos, BlockState blockStateIn) {
        BlockPos blockpos1;
        BlockState blockstate2;
        FluidState fluidstate2;
        int i = 0;
        int j = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.offset(direction);
            BlockState blockstate = worldIn.getBlockState(blockpos);
            FluidState fluidstate = blockstate.getFluidState();
            if (!fluidstate.getFluid().isEquivalentTo(this) || !this.doesSideHaveHoles(direction, worldIn, pos, blockStateIn, blockpos, blockstate)) continue;
            if (fluidstate.isSource()) {
                ++j;
            }
            i = Math.max(i, fluidstate.getLevel());
        }
        if (this.canSourcesMultiply() && j >= 2) {
            BlockState blockstate1 = worldIn.getBlockState(pos.down());
            FluidState fluidstate1 = blockstate1.getFluidState();
            if (blockstate1.getMaterial().isSolid() || this.isSameAs(fluidstate1)) {
                return this.getStillFluidState(false);
            }
        }
        if (!(fluidstate2 = (blockstate2 = worldIn.getBlockState(blockpos1 = pos.up())).getFluidState()).isEmpty() && fluidstate2.getFluid().isEquivalentTo(this) && this.doesSideHaveHoles(Direction.UP, worldIn, pos, blockStateIn, blockpos1, blockstate2)) {
            return this.getFlowingFluidState(8, true);
        }
        int k = i - this.getLevelDecreasePerBlock(worldIn);
        return k <= 0 ? Fluids.EMPTY.getDefaultState() : this.getFlowingFluidState(k, false);
    }

    private boolean doesSideHaveHoles(Direction p_212751_1_, IBlockReader p_212751_2_, BlockPos p_212751_3_, BlockState p_212751_4_, BlockPos p_212751_5_, BlockState p_212751_6_) {
        VoxelShape voxelshape;
        VoxelShape voxelshape1;
        boolean flag;
        Block.RenderSideCacheKey block$rendersidecachekey;
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2bytelinkedopenhashmap = !p_212751_4_.getBlock().isVariableOpacity() && !p_212751_6_.getBlock().isVariableOpacity() ? field_212756_e.get() : null;
        if (object2bytelinkedopenhashmap != null) {
            block$rendersidecachekey = new Block.RenderSideCacheKey(p_212751_4_, p_212751_6_, p_212751_1_);
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst(block$rendersidecachekey);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            block$rendersidecachekey = null;
        }
        boolean bl = flag = !VoxelShapes.doAdjacentCubeSidesFillSquare(voxelshape1 = p_212751_4_.getCollisionShape(p_212751_2_, p_212751_3_), voxelshape = p_212751_6_.getCollisionShape(p_212751_2_, p_212751_5_), p_212751_1_);
        if (object2bytelinkedopenhashmap != null) {
            if (object2bytelinkedopenhashmap.size() == 200) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst(block$rendersidecachekey, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    public abstract Fluid getFlowingFluid();

    public FluidState getFlowingFluidState(int level, boolean falling) {
        return (FluidState)((FluidState)this.getFlowingFluid().getDefaultState().with(LEVEL_1_8, level)).with(FALLING, falling);
    }

    public abstract Fluid getStillFluid();

    public FluidState getStillFluidState(boolean falling) {
        return (FluidState)this.getStillFluid().getDefaultState().with(FALLING, falling);
    }

    protected abstract boolean canSourcesMultiply();

    protected void flowInto(IWorld worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
        if (blockStateIn.getBlock() instanceof ILiquidContainer) {
            ((ILiquidContainer)((Object)blockStateIn.getBlock())).receiveFluid(worldIn, pos, blockStateIn, fluidStateIn);
        } else {
            if (!blockStateIn.isAir()) {
                this.beforeReplacingBlock(worldIn, pos, blockStateIn);
            }
            worldIn.setBlockState(pos, fluidStateIn.getBlockState(), 3);
        }
    }

    protected abstract void beforeReplacingBlock(IWorld var1, BlockPos var2, BlockState var3);

    private static short func_212752_a(BlockPos p_212752_0_, BlockPos p_212752_1_) {
        int i = p_212752_1_.getX() - p_212752_0_.getX();
        int j = p_212752_1_.getZ() - p_212752_0_.getZ();
        return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
    }

    protected int func_205571_a(IWorldReader p_205571_1_, BlockPos p_205571_2_, int p_205571_3_, Direction p_205571_4_, BlockState p_205571_5_, BlockPos p_205571_6_, Short2ObjectMap<Pair<BlockState, FluidState>> p_205571_7_, Short2BooleanMap p_205571_8_) {
        int i = 1000;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            if (direction == p_205571_4_) continue;
            BlockPos blockpos = p_205571_2_.offset(direction);
            short short1 = FlowingFluid.func_212752_a(p_205571_6_, blockpos);
            Pair pair = p_205571_7_.computeIfAbsent(short1, p_212748_2_ -> {
                BlockState blockstate1 = p_205571_1_.getBlockState(blockpos);
                return Pair.of(blockstate1, blockstate1.getFluidState());
            });
            BlockState blockstate = (BlockState)pair.getFirst();
            FluidState fluidstate = (FluidState)pair.getSecond();
            if (!this.func_211760_a(p_205571_1_, this.getFlowingFluid(), p_205571_2_, p_205571_5_, direction, blockpos, blockstate, fluidstate)) continue;
            boolean flag = p_205571_8_.computeIfAbsent(short1, p_212749_4_ -> {
                BlockPos blockpos1 = blockpos.down();
                BlockState blockstate1 = p_205571_1_.getBlockState(blockpos1);
                return this.func_211759_a(p_205571_1_, this.getFlowingFluid(), blockpos, blockstate, blockpos1, blockstate1);
            });
            if (flag) {
                return p_205571_3_;
            }
            if (p_205571_3_ >= this.getSlopeFindDistance(p_205571_1_) || (j = this.func_205571_a(p_205571_1_, blockpos, p_205571_3_ + 1, direction.getOpposite(), blockstate, p_205571_6_, p_205571_7_, p_205571_8_)) >= i) continue;
            i = j;
        }
        return i;
    }

    private boolean func_211759_a(IBlockReader p_211759_1_, Fluid p_211759_2_, BlockPos p_211759_3_, BlockState p_211759_4_, BlockPos p_211759_5_, BlockState p_211759_6_) {
        if (!this.doesSideHaveHoles(Direction.DOWN, p_211759_1_, p_211759_3_, p_211759_4_, p_211759_5_, p_211759_6_)) {
            return false;
        }
        return p_211759_6_.getFluidState().getFluid().isEquivalentTo(this) ? true : this.isBlocked(p_211759_1_, p_211759_5_, p_211759_6_, p_211759_2_);
    }

    private boolean func_211760_a(IBlockReader p_211760_1_, Fluid p_211760_2_, BlockPos p_211760_3_, BlockState p_211760_4_, Direction p_211760_5_, BlockPos p_211760_6_, BlockState p_211760_7_, FluidState p_211760_8_) {
        return !this.isSameAs(p_211760_8_) && this.doesSideHaveHoles(p_211760_5_, p_211760_1_, p_211760_3_, p_211760_4_, p_211760_6_, p_211760_7_) && this.isBlocked(p_211760_1_, p_211760_6_, p_211760_7_, p_211760_2_);
    }

    private boolean isSameAs(FluidState stateIn) {
        return stateIn.getFluid().isEquivalentTo(this) && stateIn.isSource();
    }

    protected abstract int getSlopeFindDistance(IWorldReader var1);

    private int getNumHorizontallyAdjacentSources(IWorldReader worldIn, BlockPos pos) {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.offset(direction);
            FluidState fluidstate = worldIn.getFluidState(blockpos);
            if (!this.isSameAs(fluidstate)) continue;
            ++i;
        }
        return i;
    }

    protected Map<Direction, FluidState> func_205572_b(IWorldReader p_205572_1_, BlockPos p_205572_2_, BlockState p_205572_3_) {
        int i = 1000;
        EnumMap<Direction, FluidState> map = Maps.newEnumMap(Direction.class);
        Short2ObjectOpenHashMap<Pair<BlockState, FluidState>> short2objectmap = new Short2ObjectOpenHashMap<Pair<BlockState, FluidState>>();
        Short2BooleanOpenHashMap short2booleanmap = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_205572_2_.offset(direction);
            short short1 = FlowingFluid.func_212752_a(p_205572_2_, blockpos);
            Pair pair = short2objectmap.computeIfAbsent(short1, p_212755_2_ -> {
                BlockState blockstate1 = p_205572_1_.getBlockState(blockpos);
                return Pair.of(blockstate1, blockstate1.getFluidState());
            });
            BlockState blockstate = (BlockState)pair.getFirst();
            FluidState fluidstate = (FluidState)pair.getSecond();
            FluidState fluidstate1 = this.calculateCorrectFlowingState(p_205572_1_, blockpos, blockstate);
            if (!this.func_211760_a(p_205572_1_, fluidstate1.getFluid(), p_205572_2_, p_205572_3_, direction, blockpos, blockstate, fluidstate)) continue;
            BlockPos blockpos1 = blockpos.down();
            boolean flag = short2booleanmap.computeIfAbsent(short1, p_212753_5_ -> {
                BlockState blockstate1 = p_205572_1_.getBlockState(blockpos1);
                return this.func_211759_a(p_205572_1_, this.getFlowingFluid(), blockpos, blockstate, blockpos1, blockstate1);
            });
            int j = flag ? 0 : this.func_205571_a(p_205572_1_, blockpos, 1, direction.getOpposite(), blockstate, p_205572_2_, short2objectmap, short2booleanmap);
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(direction, fluidstate1);
            i = j;
        }
        return map;
    }

    private boolean isBlocked(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        Block block = state.getBlock();
        if (block instanceof ILiquidContainer) {
            return ((ILiquidContainer)((Object)block)).canContainFluid(worldIn, pos, state, fluidIn);
        }
        if (!(block instanceof DoorBlock) && !block.isIn(BlockTags.SIGNS) && block != Blocks.LADDER && block != Blocks.SUGAR_CANE && block != Blocks.BUBBLE_COLUMN) {
            Material material = state.getMaterial();
            if (material != Material.PORTAL && material != Material.STRUCTURE_VOID && material != Material.OCEAN_PLANT && material != Material.SEA_GRASS) {
                return !material.blocksMovement();
            }
            return false;
        }
        return false;
    }

    protected boolean canFlow(IBlockReader worldIn, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluidIn) {
        return toFluidState.canDisplace(worldIn, toPos, fluidIn, direction) && this.doesSideHaveHoles(direction, worldIn, fromPos, fromBlockState, toPos, toBlockState) && this.isBlocked(worldIn, toPos, toBlockState, fluidIn);
    }

    protected abstract int getLevelDecreasePerBlock(IWorldReader var1);

    protected int func_215667_a(World world, BlockPos pos, FluidState p_215667_3_, FluidState p_215667_4_) {
        return this.getTickRate(world);
    }

    @Override
    public void tick(World worldIn, BlockPos pos, FluidState state) {
        if (!state.isSource()) {
            FluidState fluidstate = this.calculateCorrectFlowingState(worldIn, pos, worldIn.getBlockState(pos));
            int i = this.func_215667_a(worldIn, pos, state, fluidstate);
            if (fluidstate.isEmpty()) {
                state = fluidstate;
                worldIn.setBlockState(pos, Blocks.AIR.getDefaultState(), 3);
            } else if (!fluidstate.equals(state)) {
                state = fluidstate;
                BlockState blockstate = fluidstate.getBlockState();
                worldIn.setBlockState(pos, blockstate, 2);
                worldIn.getPendingFluidTicks().scheduleTick(pos, fluidstate.getFluid(), i);
                worldIn.notifyNeighborsOfStateChange(pos, blockstate.getBlock());
            }
        }
        this.flowAround(worldIn, pos, state);
    }

    protected static int getLevelFromState(FluidState state) {
        return state.isSource() ? 0 : 8 - Math.min(state.getLevel(), 8) + (state.get(FALLING) != false ? 8 : 0);
    }

    private static boolean isFullHeight(FluidState p_215666_0_, IBlockReader p_215666_1_, BlockPos p_215666_2_) {
        return p_215666_0_.getFluid().isEquivalentTo(p_215666_1_.getFluidState(p_215666_2_.up()).getFluid());
    }

    @Override
    public float getActualHeight(FluidState p_215662_1_, IBlockReader p_215662_2_, BlockPos p_215662_3_) {
        return FlowingFluid.isFullHeight(p_215662_1_, p_215662_2_, p_215662_3_) ? 1.0f : p_215662_1_.getHeight();
    }

    @Override
    public float getHeight(FluidState p_223407_1_) {
        return (float)p_223407_1_.getLevel() / 9.0f;
    }

    @Override
    public VoxelShape func_215664_b(FluidState p_215664_1_, IBlockReader p_215664_2_, BlockPos p_215664_3_) {
        return p_215664_1_.getLevel() == 9 && FlowingFluid.isFullHeight(p_215664_1_, p_215664_2_, p_215664_3_) ? VoxelShapes.fullCube() : this.field_215669_f.computeIfAbsent(p_215664_1_, p_215668_2_ -> VoxelShapes.create(0.0, 0.0, 0.0, 1.0, p_215668_2_.getActualHeight(p_215664_2_, p_215664_3_), 1.0));
    }
}

