/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Lists;
import com.minerl.multiagent.RandomHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageAtNightGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;

public class FoxEntity
extends AnimalEntity {
    private static final DataParameter<Integer> FOX_TYPE = EntityDataManager.createKey(FoxEntity.class, DataSerializers.VARINT);
    private static final DataParameter<Byte> FOX_FLAGS = EntityDataManager.createKey(FoxEntity.class, DataSerializers.BYTE);
    private static final DataParameter<Optional<UUID>> TRUSTED_UUID_SECONDARY = EntityDataManager.createKey(FoxEntity.class, DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final DataParameter<Optional<UUID>> TRUSTED_UUID_MAIN = EntityDataManager.createKey(FoxEntity.class, DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final Predicate<ItemEntity> TRUSTED_TARGET_SELECTOR = p_213489_0_ -> !p_213489_0_.cannotPickup() && p_213489_0_.isAlive();
    private static final Predicate<Entity> STALKABLE_PREY = p_213470_0_ -> {
        if (!(p_213470_0_ instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)p_213470_0_;
        return livingentity.getLastAttackedEntity() != null && livingentity.getLastAttackedEntityTime() < livingentity.ticksExisted + 600;
    };
    private static final Predicate<Entity> IS_PREY = p_213498_0_ -> p_213498_0_ instanceof ChickenEntity || p_213498_0_ instanceof RabbitEntity;
    private static final Predicate<Entity> SHOULD_AVOID = p_213463_0_ -> !p_213463_0_.isDiscrete() && EntityPredicates.CAN_AI_TARGET.test((Entity)p_213463_0_);
    private Goal attackAnimals;
    private Goal attackTurtles;
    private Goal attackFish;
    private float interestedAngle;
    private float interestedAngleO;
    private float crouchAmount;
    private float crouchAmountO;
    private int eatTicks;

    public FoxEntity(EntityType<? extends FoxEntity> type, World worldIn) {
        super((EntityType<? extends AnimalEntity>)type, worldIn);
        this.lookController = new LookHelperController();
        this.moveController = new MoveHelperController();
        this.setPathPriority(PathNodeType.DANGER_OTHER, 0.0f);
        this.setPathPriority(PathNodeType.DAMAGE_OTHER, 0.0f);
        this.setCanPickUpLoot(true);
    }

    @Override
    protected void registerData() {
        super.registerData();
        this.dataManager.register(TRUSTED_UUID_SECONDARY, Optional.empty());
        this.dataManager.register(TRUSTED_UUID_MAIN, Optional.empty());
        this.dataManager.register(FOX_TYPE, 0);
        this.dataManager.register(FOX_FLAGS, (byte)0);
    }

    @Override
    protected void registerGoals() {
        this.attackAnimals = new NearestAttackableTargetGoal<AnimalEntity>(this, AnimalEntity.class, 10, false, false, p_213487_0_ -> p_213487_0_ instanceof ChickenEntity || p_213487_0_ instanceof RabbitEntity);
        this.attackTurtles = new NearestAttackableTargetGoal<TurtleEntity>(this, TurtleEntity.class, 10, false, false, TurtleEntity.TARGET_DRY_BABY);
        this.attackFish = new NearestAttackableTargetGoal<AbstractFishEntity>(this, AbstractFishEntity.class, 20, false, false, p_213456_0_ -> p_213456_0_ instanceof AbstractGroupFishEntity);
        this.goalSelector.addGoal(0, new SwimGoal());
        this.goalSelector.addGoal(1, new JumpGoal());
        this.goalSelector.addGoal(2, new PanicGoal(2.2));
        this.goalSelector.addGoal(3, new MateGoal(1.0));
        this.goalSelector.addGoal(4, new AvoidEntityGoal<PlayerEntity>(this, PlayerEntity.class, 16.0f, 1.6, 1.4, p_213497_1_ -> SHOULD_AVOID.test((Entity)p_213497_1_) && !this.isTrustedUUID(p_213497_1_.getUniqueID()) && !this.isFoxAggroed()));
        this.goalSelector.addGoal(4, new AvoidEntityGoal<WolfEntity>(this, WolfEntity.class, 8.0f, 1.6, 1.4, p_213469_1_ -> !((WolfEntity)p_213469_1_).isTamed() && !this.isFoxAggroed()));
        this.goalSelector.addGoal(4, new AvoidEntityGoal<PolarBearEntity>(this, PolarBearEntity.class, 8.0f, 1.6, 1.4, p_213493_1_ -> !this.isFoxAggroed()));
        this.goalSelector.addGoal(5, new FollowTargetGoal());
        this.goalSelector.addGoal(6, new PounceGoal());
        this.goalSelector.addGoal(6, new FindShelterGoal(1.25));
        this.goalSelector.addGoal(7, new BiteGoal((double)1.2f, true));
        this.goalSelector.addGoal(7, new SleepGoal());
        this.goalSelector.addGoal(8, new FollowGoal(this, 1.25));
        this.goalSelector.addGoal(9, new StrollGoal(32, 200));
        this.goalSelector.addGoal(10, new EatBerriesGoal((double)1.2f, 12, 2));
        this.goalSelector.addGoal(10, new LeapAtTargetGoal(this, 0.4f));
        this.goalSelector.addGoal(11, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.goalSelector.addGoal(11, new FindItemsGoal());
        this.goalSelector.addGoal(12, new WatchGoal(this, PlayerEntity.class, 24.0f));
        this.goalSelector.addGoal(13, new SitAndLookGoal());
        this.targetSelector.addGoal(3, new RevengeGoal(LivingEntity.class, false, false, p_234193_1_ -> STALKABLE_PREY.test((Entity)p_234193_1_) && !this.isTrustedUUID(p_234193_1_.getUniqueID())));
    }

    @Override
    public SoundEvent getEatSound(ItemStack itemStackIn) {
        return SoundEvents.ENTITY_FOX_EAT;
    }

    @Override
    public void livingTick() {
        if (!this.world.isRemote && this.isAlive() && this.isServerWorld()) {
            LivingEntity livingentity;
            ++this.eatTicks;
            ItemStack itemstack = this.getItemStackFromSlot(EquipmentSlotType.MAINHAND);
            if (this.canEatItem(itemstack)) {
                if (this.eatTicks > 600) {
                    ItemStack itemstack1 = itemstack.onItemUseFinish(this.world, this);
                    if (!itemstack1.isEmpty()) {
                        this.setItemStackToSlot(EquipmentSlotType.MAINHAND, itemstack1);
                    }
                    this.eatTicks = 0;
                } else if (this.eatTicks > 560 && this.rand.nextFloat() < 0.1f) {
                    this.playSound(this.getEatSound(itemstack), 1.0f, 1.0f);
                    this.world.setEntityState(this, (byte)45);
                }
            }
            if ((livingentity = this.getAttackTarget()) == null || !livingentity.isAlive()) {
                this.setCrouching(false);
                this.func_213502_u(false);
            }
        }
        if (this.isSleeping() || this.isMovementBlocked()) {
            this.isJumping = false;
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
        }
        super.livingTick();
        if (this.isFoxAggroed() && this.rand.nextFloat() < 0.05f) {
            this.playSound(SoundEvents.ENTITY_FOX_AGGRO, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.getShouldBeDead();
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.getItem().isFood() && this.getAttackTarget() == null && this.onGround && !this.isSleeping();
    }

    @Override
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance difficulty) {
        if (this.rand.nextFloat() < 0.2f) {
            float f = this.rand.nextFloat();
            ItemStack itemstack = f < 0.05f ? new ItemStack(Items.EMERALD) : (f < 0.2f ? new ItemStack(Items.EGG) : (f < 0.4f ? (this.rand.nextBoolean() ? new ItemStack(Items.RABBIT_FOOT) : new ItemStack(Items.RABBIT_HIDE)) : (f < 0.6f ? new ItemStack(Items.WHEAT) : (f < 0.8f ? new ItemStack(Items.LEATHER) : new ItemStack(Items.FEATHER)))));
            this.setItemStackToSlot(EquipmentSlotType.MAINHAND, itemstack);
        }
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.getItemStackFromSlot(EquipmentSlotType.MAINHAND);
            if (!itemstack.isEmpty()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d vector3d = new Vector3d(((double)this.rand.nextFloat() - 0.5) * 0.1, RandomHelper.randomDouble() * 0.1 + 0.1, 0.0).rotatePitch(-this.rotationPitch * ((float)Math.PI / 180)).rotateYaw(-this.rotationYaw * ((float)Math.PI / 180));
                    this.world.addParticle(new ItemParticleData(ParticleTypes.ITEM, itemstack), this.getPosX() + this.getLookVec().x / 2.0, this.getPosY(), this.getPosZ() + this.getLookVec().z / 2.0, vector3d.x, vector3d.y + 0.05, vector3d.z);
                }
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234192_eI_() {
        return MobEntity.func_233666_p_().createMutableAttribute(Attributes.MOVEMENT_SPEED, 0.3f).createMutableAttribute(Attributes.MAX_HEALTH, 10.0).createMutableAttribute(Attributes.FOLLOW_RANGE, 32.0).createMutableAttribute(Attributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    public FoxEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        FoxEntity foxentity = EntityType.FOX.create(p_241840_1_);
        foxentity.setVariantType(this.rand.nextBoolean() ? this.getVariantType() : ((FoxEntity)p_241840_2_).getVariantType());
        return foxentity;
    }

    @Override
    @Nullable
    public ILivingEntityData onInitialSpawn(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Optional<RegistryKey<Biome>> optional = worldIn.func_242406_i(this.getPosition());
        Type foxentity$type = Type.func_242325_a(optional);
        boolean flag = false;
        if (spawnDataIn instanceof FoxData) {
            foxentity$type = ((FoxData)spawnDataIn).field_220366_a;
            if (((FoxData)spawnDataIn).getIndexInGroup() >= 2) {
                flag = true;
            }
        } else {
            spawnDataIn = new FoxData(foxentity$type);
        }
        this.setVariantType(foxentity$type);
        if (flag) {
            this.setGrowingAge(-24000);
        }
        if (worldIn instanceof ServerWorld) {
            this.setAttackGoals();
        }
        this.setEquipmentBasedOnDifficulty(difficultyIn);
        return super.onInitialSpawn(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void setAttackGoals() {
        if (this.getVariantType() == Type.RED) {
            this.targetSelector.addGoal(4, this.attackAnimals);
            this.targetSelector.addGoal(4, this.attackTurtles);
            this.targetSelector.addGoal(6, this.attackFish);
        } else {
            this.targetSelector.addGoal(4, this.attackFish);
            this.targetSelector.addGoal(6, this.attackAnimals);
            this.targetSelector.addGoal(6, this.attackTurtles);
        }
    }

    @Override
    protected void consumeItemFromStack(PlayerEntity player, ItemStack stack) {
        if (this.isBreedingItem(stack)) {
            this.playSound(this.getEatSound(stack), 1.0f, 1.0f);
        }
        super.consumeItemFromStack(player, stack);
    }

    @Override
    protected float getStandingEyeHeight(Pose poseIn, EntitySize sizeIn) {
        return this.isChild() ? sizeIn.height * 0.85f : 0.4f;
    }

    public Type getVariantType() {
        return Type.getTypeByIndex(this.dataManager.get(FOX_TYPE));
    }

    private void setVariantType(Type typeIn) {
        this.dataManager.set(FOX_TYPE, typeIn.getIndex());
    }

    private List<UUID> getTrustedUUIDs() {
        ArrayList<UUID> list = Lists.newArrayList();
        list.add(this.dataManager.get(TRUSTED_UUID_SECONDARY).orElse(null));
        list.add(this.dataManager.get(TRUSTED_UUID_MAIN).orElse(null));
        return list;
    }

    private void addTrustedUUID(@Nullable UUID uuidIn) {
        if (this.dataManager.get(TRUSTED_UUID_SECONDARY).isPresent()) {
            this.dataManager.set(TRUSTED_UUID_MAIN, Optional.ofNullable(uuidIn));
        } else {
            this.dataManager.set(TRUSTED_UUID_SECONDARY, Optional.ofNullable(uuidIn));
        }
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        List<UUID> list = this.getTrustedUUIDs();
        ListNBT listnbt = new ListNBT();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listnbt.add(NBTUtil.func_240626_a_(uuid));
        }
        compound.put("Trusted", listnbt);
        compound.putBoolean("Sleeping", this.isSleeping());
        compound.putString("Type", this.getVariantType().getName());
        compound.putBoolean("Sitting", this.isSitting());
        compound.putBoolean("Crouching", this.isCrouching());
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        ListNBT listnbt = compound.getList("Trusted", 11);
        for (int i = 0; i < listnbt.size(); ++i) {
            this.addTrustedUUID(NBTUtil.readUniqueId(listnbt.get(i)));
        }
        this.setSleeping(compound.getBoolean("Sleeping"));
        this.setVariantType(Type.getTypeByName(compound.getString("Type")));
        this.setSitting(compound.getBoolean("Sitting"));
        this.setCrouching(compound.getBoolean("Crouching"));
        if (this.world instanceof ServerWorld) {
            this.setAttackGoals();
        }
    }

    public boolean isSitting() {
        return this.getFoxFlag(1);
    }

    public void setSitting(boolean p_213466_1_) {
        this.setFoxFlag(1, p_213466_1_);
    }

    public boolean isStuck() {
        return this.getFoxFlag(64);
    }

    private void setStuck(boolean p_213492_1_) {
        this.setFoxFlag(64, p_213492_1_);
    }

    private boolean isFoxAggroed() {
        return this.getFoxFlag(128);
    }

    private void setFoxAggroed(boolean p_213482_1_) {
        this.setFoxFlag(128, p_213482_1_);
    }

    @Override
    public boolean isSleeping() {
        return this.getFoxFlag(32);
    }

    private void setSleeping(boolean p_213485_1_) {
        this.setFoxFlag(32, p_213485_1_);
    }

    private void setFoxFlag(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.dataManager.set(FOX_FLAGS, (byte)(this.dataManager.get(FOX_FLAGS) | p_213505_1_));
        } else {
            this.dataManager.set(FOX_FLAGS, (byte)(this.dataManager.get(FOX_FLAGS) & ~p_213505_1_));
        }
    }

    private boolean getFoxFlag(int p_213507_1_) {
        return (this.dataManager.get(FOX_FLAGS) & p_213507_1_) != 0;
    }

    @Override
    public boolean canPickUpItem(ItemStack itemstackIn) {
        EquipmentSlotType equipmentslottype = MobEntity.getSlotForItemStack(itemstackIn);
        if (!this.getItemStackFromSlot(equipmentslottype).isEmpty()) {
            return false;
        }
        return equipmentslottype == EquipmentSlotType.MAINHAND && super.canPickUpItem(itemstackIn);
    }

    @Override
    public boolean canEquipItem(ItemStack stack) {
        Item item = stack.getItem();
        ItemStack itemstack = this.getItemStackFromSlot(EquipmentSlotType.MAINHAND);
        return itemstack.isEmpty() || this.eatTicks > 0 && item.isFood() && !itemstack.getItem().isFood();
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.isEmpty() && !this.world.isRemote) {
            ItemEntity itementity = new ItemEntity(this.world, this.getPosX() + this.getLookVec().x, this.getPosY() + 1.0, this.getPosZ() + this.getLookVec().z, stackIn);
            itementity.setPickupDelay(40);
            itementity.setThrowerId(this.getUniqueID());
            this.playSound(SoundEvents.ENTITY_FOX_SPIT, 1.0f, 1.0f);
            this.world.addEntity(itementity);
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.world, this.getPosX(), this.getPosY(), this.getPosZ(), stackIn);
        this.world.addEntity(itementity);
    }

    @Override
    protected void updateEquipmentIfNeeded(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.getItem();
        if (this.canEquipItem(itemstack)) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.spawnItem(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemStackFromSlot(EquipmentSlotType.MAINHAND));
            this.triggerItemPickupTrigger(itemEntity);
            this.setItemStackToSlot(EquipmentSlotType.MAINHAND, itemstack.split(1));
            this.inventoryHandsDropChances[EquipmentSlotType.MAINHAND.getIndex()] = 2.0f;
            this.onItemPickup(itemEntity, itemstack.getCount());
            itemEntity.remove();
            this.eatTicks = 0;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isServerWorld()) {
            boolean flag = this.isInWater();
            if (flag || this.getAttackTarget() != null || this.world.isThundering()) {
                this.func_213454_em();
            }
            if (flag || this.isSleeping()) {
                this.setSitting(false);
            }
            if (this.isStuck() && this.world.rand.nextFloat() < 0.2f) {
                BlockPos blockpos = this.getPosition();
                BlockState blockstate = this.world.getBlockState(blockpos);
                this.world.playEvent(2001, blockpos, Block.getStateId(blockstate));
            }
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.func_213467_eg() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        this.crouchAmountO = this.crouchAmount;
        if (this.isCrouching()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
    }

    @Override
    public boolean isBreedingItem(ItemStack stack) {
        return stack.getItem() == Items.SWEET_BERRIES;
    }

    @Override
    protected void onChildSpawnFromEgg(PlayerEntity playerIn, MobEntity child) {
        ((FoxEntity)child).addTrustedUUID(playerIn.getUniqueID());
    }

    public boolean func_213480_dY() {
        return this.getFoxFlag(16);
    }

    public void func_213461_s(boolean p_213461_1_) {
        this.setFoxFlag(16, p_213461_1_);
    }

    public boolean func_213490_ee() {
        return this.crouchAmount == 3.0f;
    }

    public void setCrouching(boolean p_213451_1_) {
        this.setFoxFlag(4, p_213451_1_);
    }

    @Override
    public boolean isCrouching() {
        return this.getFoxFlag(4);
    }

    public void func_213502_u(boolean p_213502_1_) {
        this.setFoxFlag(8, p_213502_1_);
    }

    public boolean func_213467_eg() {
        return this.getFoxFlag(8);
    }

    public float func_213475_v(float p_213475_1_) {
        return MathHelper.lerp(p_213475_1_, this.interestedAngleO, this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public float func_213503_w(float p_213503_1_) {
        return MathHelper.lerp(p_213503_1_, this.crouchAmountO, this.crouchAmount);
    }

    @Override
    public void setAttackTarget(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.isFoxAggroed() && entitylivingbaseIn == null) {
            this.setFoxAggroed(false);
        }
        super.setAttackTarget(entitylivingbaseIn);
    }

    @Override
    protected int calculateFallDamage(float distance, float damageMultiplier) {
        return MathHelper.ceil((distance - 5.0f) * damageMultiplier);
    }

    private void func_213454_em() {
        this.setSleeping(false);
    }

    private void func_213499_en() {
        this.func_213502_u(false);
        this.setCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setFoxAggroed(false);
        this.setStuck(false);
    }

    private boolean func_213478_eo() {
        return !this.isSleeping() && !this.isSitting() && !this.isStuck();
    }

    @Override
    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent == SoundEvents.ENTITY_FOX_SCREECH) {
            this.playSound(soundevent, 2.0f, this.getSoundPitch());
        } else {
            super.playAmbientSound();
        }
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        List<Entity> list;
        if (this.isSleeping()) {
            return SoundEvents.ENTITY_FOX_SLEEP;
        }
        if (!this.world.isDaytime() && this.rand.nextFloat() < 0.1f && (list = this.world.getEntitiesWithinAABB(PlayerEntity.class, this.getBoundingBox().grow(16.0, 16.0, 16.0), EntityPredicates.NOT_SPECTATING)).isEmpty()) {
            return SoundEvents.ENTITY_FOX_SCREECH;
        }
        return SoundEvents.ENTITY_FOX_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_FOX_HURT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_FOX_DEATH;
    }

    private boolean isTrustedUUID(UUID p_213468_1_) {
        return this.getTrustedUUIDs().contains(p_213468_1_);
    }

    @Override
    protected void spawnDrops(DamageSource damageSourceIn) {
        ItemStack itemstack = this.getItemStackFromSlot(EquipmentSlotType.MAINHAND);
        if (!itemstack.isEmpty()) {
            this.entityDropItem(itemstack);
            this.setItemStackToSlot(EquipmentSlotType.MAINHAND, ItemStack.EMPTY);
        }
        super.spawnDrops(damageSourceIn);
    }

    public static boolean func_213481_a(FoxEntity p_213481_0_, LivingEntity p_213481_1_) {
        double d0 = p_213481_1_.getPosZ() - p_213481_0_.getPosZ();
        double d1 = p_213481_1_.getPosX() - p_213481_0_.getPosX();
        double d2 = d0 / d1;
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_213481_0_.world.getBlockState(new BlockPos(p_213481_0_.getPosX() + d4, p_213481_0_.getPosY() + (double)k, p_213481_0_.getPosZ() + d3)).getMaterial().isReplaceable()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.55f * this.getEyeHeight(), this.getWidth() * 0.4f);
    }

    class WatchGoal
    extends LookAtGoal {
        public WatchGoal(MobEntity p_i50733_2_, Class<? extends LivingEntity> p_i50733_3_, float p_i50733_4_) {
            super(p_i50733_2_, p_i50733_3_, p_i50733_4_);
        }

        @Override
        public boolean shouldExecute() {
            return super.shouldExecute() && !FoxEntity.this.isStuck() && !FoxEntity.this.func_213467_eg();
        }

        @Override
        public boolean shouldContinueExecuting() {
            return super.shouldContinueExecuting() && !FoxEntity.this.isStuck() && !FoxEntity.this.func_213467_eg();
        }
    }

    public static enum Type {
        RED(0, "red", Biomes.TAIGA, Biomes.TAIGA_HILLS, Biomes.TAIGA_MOUNTAINS, Biomes.GIANT_TREE_TAIGA, Biomes.GIANT_SPRUCE_TAIGA, Biomes.GIANT_TREE_TAIGA_HILLS, Biomes.GIANT_SPRUCE_TAIGA_HILLS),
        SNOW(1, "snow", Biomes.SNOWY_TAIGA, Biomes.SNOWY_TAIGA_HILLS, Biomes.SNOWY_TAIGA_MOUNTAINS);

        private static final Type[] field_221088_c;
        private static final Map<String, Type> TYPES_BY_NAME;
        private final int index;
        private final String name;
        private final List<RegistryKey<Biome>> spawnBiomes;

        private Type(int p_i241911_3_, String p_i241911_4_, RegistryKey<Biome> ... p_i241911_5_) {
            this.index = p_i241911_3_;
            this.name = p_i241911_4_;
            this.spawnBiomes = Arrays.asList(p_i241911_5_);
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public static Type getTypeByName(String nameIn) {
            return TYPES_BY_NAME.getOrDefault(nameIn, RED);
        }

        public static Type getTypeByIndex(int indexIn) {
            if (indexIn < 0 || indexIn > field_221088_c.length) {
                indexIn = 0;
            }
            return field_221088_c[indexIn];
        }

        public static Type func_242325_a(Optional<RegistryKey<Biome>> p_242325_0_) {
            return p_242325_0_.isPresent() && Type.SNOW.spawnBiomes.contains(p_242325_0_.get()) ? SNOW : RED;
        }

        static {
            field_221088_c = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::getIndex)).toArray(Type[]::new);
            TYPES_BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, p_221081_0_ -> p_221081_0_));
        }
    }

    class SwimGoal
    extends net.minecraft.entity.ai.goal.SwimGoal {
        public SwimGoal() {
            super(FoxEntity.this);
        }

        @Override
        public void startExecuting() {
            super.startExecuting();
            FoxEntity.this.func_213499_en();
        }

        @Override
        public boolean shouldExecute() {
            return FoxEntity.this.isInWater() && FoxEntity.this.func_233571_b_(FluidTags.WATER) > 0.25 || FoxEntity.this.isInLava();
        }
    }

    class StrollGoal
    extends MoveThroughVillageAtNightGoal {
        public StrollGoal(int p_i50726_2_, int p_i50726_3_) {
            super(FoxEntity.this, p_i50726_3_);
        }

        @Override
        public void startExecuting() {
            FoxEntity.this.func_213499_en();
            super.startExecuting();
        }

        @Override
        public boolean shouldExecute() {
            return super.shouldExecute() && this.func_220759_g();
        }

        @Override
        public boolean shouldContinueExecuting() {
            return super.shouldContinueExecuting() && this.func_220759_g();
        }

        private boolean func_220759_g() {
            return !FoxEntity.this.isSleeping() && !FoxEntity.this.isSitting() && !FoxEntity.this.isFoxAggroed() && FoxEntity.this.getAttackTarget() == null;
        }
    }

    class SleepGoal
    extends BaseGoal {
        private int field_220825_c;

        public SleepGoal() {
            this.field_220825_c = FoxEntity.this.rand.nextInt(140);
            this.setMutexFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean shouldExecute() {
            if (FoxEntity.this.moveStrafing == 0.0f && FoxEntity.this.moveVertical == 0.0f && FoxEntity.this.moveForward == 0.0f) {
                return this.func_220823_j() || FoxEntity.this.isSleeping();
            }
            return false;
        }

        @Override
        public boolean shouldContinueExecuting() {
            return this.func_220823_j();
        }

        private boolean func_220823_j() {
            if (this.field_220825_c > 0) {
                --this.field_220825_c;
                return false;
            }
            return FoxEntity.this.world.isDaytime() && this.func_220813_g() && !this.func_220814_h();
        }

        @Override
        public void resetTask() {
            this.field_220825_c = FoxEntity.this.rand.nextInt(140);
            FoxEntity.this.func_213499_en();
        }

        @Override
        public void startExecuting() {
            FoxEntity.this.setSitting(false);
            FoxEntity.this.setCrouching(false);
            FoxEntity.this.func_213502_u(false);
            FoxEntity.this.setJumping(false);
            FoxEntity.this.setSleeping(true);
            FoxEntity.this.getNavigator().clearPath();
            FoxEntity.this.getMoveHelper().setMoveTo(FoxEntity.this.getPosX(), FoxEntity.this.getPosY(), FoxEntity.this.getPosZ(), 0.0);
        }
    }

    class SitAndLookGoal
    extends BaseGoal {
        private double field_220819_c;
        private double field_220820_d;
        private int field_220821_e;
        private int field_220822_f;

        public SitAndLookGoal() {
            this.setMutexFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean shouldExecute() {
            return FoxEntity.this.getRevengeTarget() == null && FoxEntity.this.getRNG().nextFloat() < 0.02f && !FoxEntity.this.isSleeping() && FoxEntity.this.getAttackTarget() == null && FoxEntity.this.getNavigator().noPath() && !this.func_220814_h() && !FoxEntity.this.func_213480_dY() && !FoxEntity.this.isCrouching();
        }

        @Override
        public boolean shouldContinueExecuting() {
            return this.field_220822_f > 0;
        }

        @Override
        public void startExecuting() {
            this.func_220817_j();
            this.field_220822_f = 2 + FoxEntity.this.getRNG().nextInt(3);
            FoxEntity.this.setSitting(true);
            FoxEntity.this.getNavigator().clearPath();
        }

        @Override
        public void resetTask() {
            FoxEntity.this.setSitting(false);
        }

        @Override
        public void tick() {
            --this.field_220821_e;
            if (this.field_220821_e <= 0) {
                --this.field_220822_f;
                this.func_220817_j();
            }
            FoxEntity.this.getLookController().setLookPosition(FoxEntity.this.getPosX() + this.field_220819_c, FoxEntity.this.getPosYEye(), FoxEntity.this.getPosZ() + this.field_220820_d, FoxEntity.this.getHorizontalFaceSpeed(), FoxEntity.this.getVerticalFaceSpeed());
        }

        private void func_220817_j() {
            double d0 = Math.PI * 2 * FoxEntity.this.getRNG().nextDouble();
            this.field_220819_c = Math.cos(d0);
            this.field_220820_d = Math.sin(d0);
            this.field_220821_e = 80 + FoxEntity.this.getRNG().nextInt(20);
        }
    }

    class RevengeGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity field_220786_j;
        private LivingEntity field_220787_k;
        private int field_220788_l;

        public RevengeGoal(Class<LivingEntity> p_i50743_2_, boolean p_i50743_3_, @Nullable boolean p_i50743_4_, Predicate<LivingEntity> p_i50743_5_) {
            super(FoxEntity.this, p_i50743_2_, 10, p_i50743_3_, p_i50743_4_, p_i50743_5_);
        }

        @Override
        public boolean shouldExecute() {
            if (this.targetChance > 0 && this.goalOwner.getRNG().nextInt(this.targetChance) != 0) {
                return false;
            }
            for (UUID uuid : FoxEntity.this.getTrustedUUIDs()) {
                LivingEntity livingentity;
                Entity entity;
                if (uuid == null || !(FoxEntity.this.world instanceof ServerWorld) || !((entity = ((ServerWorld)FoxEntity.this.world).getEntityByUuid(uuid)) instanceof LivingEntity)) continue;
                this.field_220787_k = livingentity = (LivingEntity)entity;
                this.field_220786_j = livingentity.getRevengeTarget();
                int i = livingentity.getRevengeTimer();
                return i != this.field_220788_l && this.isSuitableTarget(this.field_220786_j, this.targetEntitySelector);
            }
            return false;
        }

        @Override
        public void startExecuting() {
            this.setNearestTarget(this.field_220786_j);
            this.nearestTarget = this.field_220786_j;
            if (this.field_220787_k != null) {
                this.field_220788_l = this.field_220787_k.getRevengeTimer();
            }
            FoxEntity.this.playSound(SoundEvents.ENTITY_FOX_AGGRO, 1.0f, 1.0f);
            FoxEntity.this.setFoxAggroed(true);
            FoxEntity.this.func_213454_em();
            super.startExecuting();
        }
    }

    public class PounceGoal
    extends net.minecraft.entity.ai.goal.JumpGoal {
        @Override
        public boolean shouldExecute() {
            if (!FoxEntity.this.func_213490_ee()) {
                return false;
            }
            LivingEntity livingentity = FoxEntity.this.getAttackTarget();
            if (livingentity != null && livingentity.isAlive()) {
                if (livingentity.getAdjustedHorizontalFacing() != livingentity.getHorizontalFacing()) {
                    return false;
                }
                boolean flag = FoxEntity.func_213481_a(FoxEntity.this, livingentity);
                if (!flag) {
                    FoxEntity.this.getNavigator().getPathToEntity(livingentity, 0);
                    FoxEntity.this.setCrouching(false);
                    FoxEntity.this.func_213502_u(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean shouldContinueExecuting() {
            LivingEntity livingentity = FoxEntity.this.getAttackTarget();
            if (livingentity != null && livingentity.isAlive()) {
                double d0 = FoxEntity.this.getMotion().y;
                return !(d0 * d0 < (double)0.05f && Math.abs(FoxEntity.this.rotationPitch) < 15.0f && FoxEntity.this.onGround || FoxEntity.this.isStuck());
            }
            return false;
        }

        @Override
        public boolean isPreemptible() {
            return false;
        }

        @Override
        public void startExecuting() {
            FoxEntity.this.setJumping(true);
            FoxEntity.this.func_213461_s(true);
            FoxEntity.this.func_213502_u(false);
            LivingEntity livingentity = FoxEntity.this.getAttackTarget();
            FoxEntity.this.getLookController().setLookPositionWithEntity(livingentity, 60.0f, 30.0f);
            Vector3d vector3d = new Vector3d(livingentity.getPosX() - FoxEntity.this.getPosX(), livingentity.getPosY() - FoxEntity.this.getPosY(), livingentity.getPosZ() - FoxEntity.this.getPosZ()).normalize();
            FoxEntity.this.setMotion(FoxEntity.this.getMotion().add(vector3d.x * 0.8, 0.9, vector3d.z * 0.8));
            FoxEntity.this.getNavigator().clearPath();
        }

        @Override
        public void resetTask() {
            FoxEntity.this.setCrouching(false);
            FoxEntity.this.crouchAmount = 0.0f;
            FoxEntity.this.crouchAmountO = 0.0f;
            FoxEntity.this.func_213502_u(false);
            FoxEntity.this.func_213461_s(false);
        }

        @Override
        public void tick() {
            LivingEntity livingentity = FoxEntity.this.getAttackTarget();
            if (livingentity != null) {
                FoxEntity.this.getLookController().setLookPositionWithEntity(livingentity, 60.0f, 30.0f);
            }
            if (!FoxEntity.this.isStuck()) {
                Vector3d vector3d = FoxEntity.this.getMotion();
                if (vector3d.y * vector3d.y < (double)0.03f && FoxEntity.this.rotationPitch != 0.0f) {
                    FoxEntity.this.rotationPitch = MathHelper.rotLerp(FoxEntity.this.rotationPitch, 0.0f, 0.2f);
                } else {
                    double d0 = Math.sqrt(Entity.horizontalMag(vector3d));
                    double d1 = Math.signum(-vector3d.y) * Math.acos(d0 / vector3d.length()) * 57.2957763671875;
                    FoxEntity.this.rotationPitch = (float)d1;
                }
            }
            if (livingentity != null && FoxEntity.this.getDistance(livingentity) <= 2.0f) {
                FoxEntity.this.attackEntityAsMob(livingentity);
            } else if (FoxEntity.this.rotationPitch > 0.0f && FoxEntity.this.onGround && (float)FoxEntity.this.getMotion().y != 0.0f && FoxEntity.this.world.getBlockState(FoxEntity.this.getPosition()).isIn(Blocks.SNOW)) {
                FoxEntity.this.rotationPitch = 60.0f;
                FoxEntity.this.setAttackTarget(null);
                FoxEntity.this.setStuck(true);
            }
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal(double p_i50729_2_) {
            super(FoxEntity.this, p_i50729_2_);
        }

        @Override
        public boolean shouldExecute() {
            return !FoxEntity.this.isFoxAggroed() && super.shouldExecute();
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController() {
            super(FoxEntity.this);
        }

        @Override
        public void tick() {
            if (FoxEntity.this.func_213478_eo()) {
                super.tick();
            }
        }
    }

    class MateGoal
    extends BreedGoal {
        public MateGoal(double p_i50738_2_) {
            super(FoxEntity.this, p_i50738_2_);
        }

        @Override
        public void startExecuting() {
            ((FoxEntity)this.animal).func_213499_en();
            ((FoxEntity)this.targetMate).func_213499_en();
            super.startExecuting();
        }

        @Override
        protected void spawnBaby() {
            ServerWorld serverworld = (ServerWorld)this.world;
            FoxEntity foxentity = (FoxEntity)this.animal.func_241840_a(serverworld, this.targetMate);
            if (foxentity != null) {
                ServerPlayerEntity serverplayerentity = this.animal.getLoveCause();
                ServerPlayerEntity serverplayerentity1 = this.targetMate.getLoveCause();
                ServerPlayerEntity serverplayerentity2 = serverplayerentity;
                if (serverplayerentity != null) {
                    foxentity.addTrustedUUID(serverplayerentity.getUniqueID());
                } else {
                    serverplayerentity2 = serverplayerentity1;
                }
                if (serverplayerentity1 != null && serverplayerentity != serverplayerentity1) {
                    foxentity.addTrustedUUID(serverplayerentity1.getUniqueID());
                }
                if (serverplayerentity2 != null) {
                    serverplayerentity2.addStat(Stats.ANIMALS_BRED);
                    CriteriaTriggers.BRED_ANIMALS.trigger(serverplayerentity2, this.animal, this.targetMate, foxentity);
                }
                this.animal.setGrowingAge(6000);
                this.targetMate.setGrowingAge(6000);
                this.animal.resetInLove();
                this.targetMate.resetInLove();
                foxentity.setGrowingAge(-24000);
                foxentity.setLocationAndAngles(this.animal.getPosX(), this.animal.getPosY(), this.animal.getPosZ(), 0.0f, 0.0f);
                serverworld.func_242417_l(foxentity);
                this.world.setEntityState(this.animal, (byte)18);
                if (this.world.getGameRules().getBoolean(GameRules.DO_MOB_LOOT)) {
                    this.world.addEntity(new ExperienceOrbEntity(this.world, this.animal.getPosX(), this.animal.getPosY(), this.animal.getPosZ(), this.animal.getRNG().nextInt(7) + 1));
                }
            }
        }
    }

    public class LookHelperController
    extends LookController {
        public LookHelperController() {
            super(FoxEntity.this);
        }

        @Override
        public void tick() {
            if (!FoxEntity.this.isSleeping()) {
                super.tick();
            }
        }

        @Override
        protected boolean shouldResetPitch() {
            return !FoxEntity.this.func_213480_dY() && !FoxEntity.this.isCrouching() && !FoxEntity.this.func_213467_eg() & !FoxEntity.this.isStuck();
        }
    }

    class JumpGoal
    extends Goal {
        int delay;

        public JumpGoal() {
            this.setMutexFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        @Override
        public boolean shouldExecute() {
            return FoxEntity.this.isStuck();
        }

        @Override
        public boolean shouldContinueExecuting() {
            return this.shouldExecute() && this.delay > 0;
        }

        @Override
        public void startExecuting() {
            this.delay = 40;
        }

        @Override
        public void resetTask() {
            FoxEntity.this.setStuck(false);
        }

        @Override
        public void tick() {
            --this.delay;
        }
    }

    public static class FoxData
    extends AgeableEntity.AgeableData {
        public final Type field_220366_a;

        public FoxData(Type p_i50734_1_) {
            super(false);
            this.field_220366_a = p_i50734_1_;
        }
    }

    class FollowTargetGoal
    extends Goal {
        public FollowTargetGoal() {
            this.setMutexFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean shouldExecute() {
            if (FoxEntity.this.isSleeping()) {
                return false;
            }
            LivingEntity livingentity = FoxEntity.this.getAttackTarget();
            return livingentity != null && livingentity.isAlive() && IS_PREY.test(livingentity) && FoxEntity.this.getDistanceSq(livingentity) > 36.0 && !FoxEntity.this.isCrouching() && !FoxEntity.this.func_213467_eg() && !FoxEntity.this.isJumping;
        }

        @Override
        public void startExecuting() {
            FoxEntity.this.setSitting(false);
            FoxEntity.this.setStuck(false);
        }

        @Override
        public void resetTask() {
            LivingEntity livingentity = FoxEntity.this.getAttackTarget();
            if (livingentity != null && FoxEntity.func_213481_a(FoxEntity.this, livingentity)) {
                FoxEntity.this.func_213502_u(true);
                FoxEntity.this.setCrouching(true);
                FoxEntity.this.getNavigator().clearPath();
                FoxEntity.this.getLookController().setLookPositionWithEntity(livingentity, FoxEntity.this.getHorizontalFaceSpeed(), FoxEntity.this.getVerticalFaceSpeed());
            } else {
                FoxEntity.this.func_213502_u(false);
                FoxEntity.this.setCrouching(false);
            }
        }

        @Override
        public void tick() {
            LivingEntity livingentity = FoxEntity.this.getAttackTarget();
            FoxEntity.this.getLookController().setLookPositionWithEntity(livingentity, FoxEntity.this.getHorizontalFaceSpeed(), FoxEntity.this.getVerticalFaceSpeed());
            if (FoxEntity.this.getDistanceSq(livingentity) <= 36.0) {
                FoxEntity.this.func_213502_u(true);
                FoxEntity.this.setCrouching(true);
                FoxEntity.this.getNavigator().clearPath();
            } else {
                FoxEntity.this.getNavigator().tryMoveToEntityLiving(livingentity, 1.5);
            }
        }
    }

    class FollowGoal
    extends FollowParentGoal {
        private final FoxEntity owner;

        public FollowGoal(FoxEntity p_i50735_2_, double p_i50735_3_) {
            super(p_i50735_2_, p_i50735_3_);
            this.owner = p_i50735_2_;
        }

        @Override
        public boolean shouldExecute() {
            return !this.owner.isFoxAggroed() && super.shouldExecute();
        }

        @Override
        public boolean shouldContinueExecuting() {
            return !this.owner.isFoxAggroed() && super.shouldContinueExecuting();
        }

        @Override
        public void startExecuting() {
            this.owner.func_213499_en();
            super.startExecuting();
        }
    }

    class FindShelterGoal
    extends FleeSunGoal {
        private int cooldown;

        public FindShelterGoal(double p_i50724_2_) {
            super(FoxEntity.this, p_i50724_2_);
            this.cooldown = 100;
        }

        @Override
        public boolean shouldExecute() {
            if (!FoxEntity.this.isSleeping() && this.creature.getAttackTarget() == null) {
                if (FoxEntity.this.world.isThundering()) {
                    return true;
                }
                if (this.cooldown > 0) {
                    --this.cooldown;
                    return false;
                }
                this.cooldown = 100;
                BlockPos blockpos = this.creature.getPosition();
                return FoxEntity.this.world.isDaytime() && FoxEntity.this.world.canSeeSky(blockpos) && !((ServerWorld)FoxEntity.this.world).isVillage(blockpos) && this.isPossibleShelter();
            }
            return false;
        }

        @Override
        public void startExecuting() {
            FoxEntity.this.func_213499_en();
            super.startExecuting();
        }
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.setMutexFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean shouldExecute() {
            if (!FoxEntity.this.getItemStackFromSlot(EquipmentSlotType.MAINHAND).isEmpty()) {
                return false;
            }
            if (FoxEntity.this.getAttackTarget() == null && FoxEntity.this.getRevengeTarget() == null) {
                if (!FoxEntity.this.func_213478_eo()) {
                    return false;
                }
                if (FoxEntity.this.getRNG().nextInt(10) != 0) {
                    return false;
                }
                List<ItemEntity> list = FoxEntity.this.world.getEntitiesWithinAABB(ItemEntity.class, FoxEntity.this.getBoundingBox().grow(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
                return !list.isEmpty() && FoxEntity.this.getItemStackFromSlot(EquipmentSlotType.MAINHAND).isEmpty();
            }
            return false;
        }

        @Override
        public void tick() {
            List<ItemEntity> list = FoxEntity.this.world.getEntitiesWithinAABB(ItemEntity.class, FoxEntity.this.getBoundingBox().grow(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
            ItemStack itemstack = FoxEntity.this.getItemStackFromSlot(EquipmentSlotType.MAINHAND);
            if (itemstack.isEmpty() && !list.isEmpty()) {
                FoxEntity.this.getNavigator().tryMoveToEntityLiving(list.get(0), 1.2f);
            }
        }

        @Override
        public void startExecuting() {
            List<ItemEntity> list = FoxEntity.this.world.getEntitiesWithinAABB(ItemEntity.class, FoxEntity.this.getBoundingBox().grow(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
            if (!list.isEmpty()) {
                FoxEntity.this.getNavigator().tryMoveToEntityLiving(list.get(0), 1.2f);
            }
        }
    }

    public class EatBerriesGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public EatBerriesGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super(FoxEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        @Override
        public double getTargetDistanceSq() {
            return 2.0;
        }

        @Override
        public boolean shouldMove() {
            return this.timeoutCounter % 100 == 0;
        }

        @Override
        protected boolean shouldMoveTo(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.getBlockState(pos);
            return blockstate.isIn(Blocks.SWEET_BERRY_BUSH) && blockstate.get(SweetBerryBushBlock.AGE) >= 2;
        }

        @Override
        public void tick() {
            if (this.getIsAboveDestination()) {
                if (this.field_220731_g >= 40) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                }
            } else if (!this.getIsAboveDestination() && FoxEntity.this.rand.nextFloat() < 0.05f) {
                FoxEntity.this.playSound(SoundEvents.ENTITY_FOX_SNIFF, 1.0f, 1.0f);
            }
            super.tick();
        }

        protected void eatBerry() {
            BlockState blockstate;
            if (FoxEntity.this.world.getGameRules().getBoolean(GameRules.MOB_GRIEFING) && (blockstate = FoxEntity.this.world.getBlockState(this.destinationBlock)).isIn(Blocks.SWEET_BERRY_BUSH)) {
                int i = blockstate.get(SweetBerryBushBlock.AGE);
                blockstate.with(SweetBerryBushBlock.AGE, 1);
                int j = 1 + FoxEntity.this.world.rand.nextInt(2) + (i == 3 ? 1 : 0);
                ItemStack itemstack = FoxEntity.this.getItemStackFromSlot(EquipmentSlotType.MAINHAND);
                if (itemstack.isEmpty()) {
                    FoxEntity.this.setItemStackToSlot(EquipmentSlotType.MAINHAND, new ItemStack(Items.SWEET_BERRIES));
                    --j;
                }
                if (j > 0) {
                    Block.spawnAsEntity(FoxEntity.this.world, this.destinationBlock, new ItemStack(Items.SWEET_BERRIES, j));
                }
                FoxEntity.this.playSound(SoundEvents.ITEM_SWEET_BERRIES_PICK_FROM_BUSH, 1.0f, 1.0f);
                FoxEntity.this.world.setBlockState(this.destinationBlock, (BlockState)blockstate.with(SweetBerryBushBlock.AGE, 1), 2);
            }
        }

        @Override
        public boolean shouldExecute() {
            return !FoxEntity.this.isSleeping() && super.shouldExecute();
        }

        @Override
        public void startExecuting() {
            this.field_220731_g = 0;
            FoxEntity.this.setSitting(false);
            super.startExecuting();
        }
    }

    class BiteGoal
    extends MeleeAttackGoal {
        public BiteGoal(double p_i50731_2_, boolean p_i50731_4_) {
            super(FoxEntity.this, p_i50731_2_, p_i50731_4_);
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.attacker.attackEntityAsMob(enemy);
                FoxEntity.this.playSound(SoundEvents.ENTITY_FOX_BITE, 1.0f, 1.0f);
            }
        }

        @Override
        public void startExecuting() {
            FoxEntity.this.func_213502_u(false);
            super.startExecuting();
        }

        @Override
        public boolean shouldExecute() {
            return !FoxEntity.this.isSitting() && !FoxEntity.this.isSleeping() && !FoxEntity.this.isCrouching() && !FoxEntity.this.isStuck() && super.shouldExecute();
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final EntityPredicate field_220816_b;

        private BaseGoal() {
            this.field_220816_b = new EntityPredicate().setDistance(12.0).setLineOfSiteRequired().setCustomPredicate(new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockpos = new BlockPos(FoxEntity.this.getPosX(), FoxEntity.this.getBoundingBox().maxY, FoxEntity.this.getPosZ());
            return !FoxEntity.this.world.canSeeSky(blockpos) && FoxEntity.this.getBlockPathWeight(blockpos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !FoxEntity.this.world.getTargettableEntitiesWithinAABB(LivingEntity.class, this.field_220816_b, FoxEntity.this, FoxEntity.this.getBoundingBox().grow(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof FoxEntity) {
                return false;
            }
            if (!(p_test_1_ instanceof ChickenEntity || p_test_1_ instanceof RabbitEntity || p_test_1_ instanceof MonsterEntity)) {
                if (p_test_1_ instanceof TameableEntity) {
                    return !((TameableEntity)p_test_1_).isTamed();
                }
                if (!(p_test_1_ instanceof PlayerEntity) || !p_test_1_.isSpectator() && !((PlayerEntity)p_test_1_).isCreative()) {
                    if (FoxEntity.this.isTrustedUUID(p_test_1_.getUniqueID())) {
                        return false;
                    }
                    return !p_test_1_.isSleeping() && !p_test_1_.isDiscrete();
                }
                return false;
            }
            return true;
        }
    }
}

