/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AnimalEntity
extends AgeableEntity {
    private int inLove;
    private UUID playerInLove;

    protected AnimalEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super((EntityType<? extends AgeableEntity>)type, worldIn);
        this.setPathPriority(PathNodeType.DANGER_FIRE, 16.0f);
        this.setPathPriority(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    @Override
    protected void updateAITasks() {
        if (this.getGrowingAge() != 0) {
            this.inLove = 0;
        }
        super.updateAITasks();
    }

    @Override
    public void livingTick() {
        super.livingTick();
        if (this.getGrowingAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d0 = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                this.world.addParticle(ParticleTypes.HEART, this.getPosXRandom(1.0), this.getPosYRandom() + 0.5, this.getPosZRandom(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.inLove = 0;
        return super.attackEntityFrom(source, amount);
    }

    @Override
    public float getBlockPathWeight(BlockPos pos, IWorldReader worldIn) {
        return worldIn.getBlockState(pos.down()).isIn(Blocks.GRASS_BLOCK) ? 10.0f : worldIn.getBrightness(pos) - 0.5f;
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        compound.putInt("InLove", this.inLove);
        if (this.playerInLove != null) {
            compound.putUniqueId("LoveCause", this.playerInLove);
        }
    }

    @Override
    public double getYOffset() {
        return 0.14;
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        this.inLove = compound.getInt("InLove");
        this.playerInLove = compound.hasUniqueId("LoveCause") ? compound.getUniqueId("LoveCause") : null;
    }

    public static boolean canAnimalSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.getBlockState(pos.down()).isIn(Blocks.GRASS_BLOCK) && worldIn.getLightSubtracted(pos, 0) > 8;
    }

    @Override
    public int getTalkInterval() {
        return 120;
    }

    @Override
    public boolean canDespawn(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected int getExperiencePoints(PlayerEntity player) {
        return 1 + this.world.rand.nextInt(3);
    }

    public boolean isBreedingItem(ItemStack stack) {
        return stack.getItem() == Items.WHEAT;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.getHeldItem(p_230254_2_);
        if (this.isBreedingItem(itemstack)) {
            int i = this.getGrowingAge();
            if (!this.world.isRemote && i == 0 && this.canFallInLove()) {
                this.consumeItemFromStack(p_230254_1_, itemstack);
                this.setInLove(p_230254_1_);
                return ActionResultType.SUCCESS;
            }
            if (this.isChild()) {
                this.consumeItemFromStack(p_230254_1_, itemstack);
                this.ageUp((int)((float)(-i / 20) * 0.1f), true);
                return ActionResultType.func_233537_a_(this.world.isRemote);
            }
            if (this.world.isRemote) {
                return ActionResultType.CONSUME;
            }
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void consumeItemFromStack(PlayerEntity player, ItemStack stack) {
        if (!player.abilities.isCreativeMode) {
            stack.shrink(1);
        }
    }

    public boolean canFallInLove() {
        return this.inLove <= 0;
    }

    public void setInLove(@Nullable PlayerEntity player) {
        this.inLove = 600;
        if (player != null) {
            this.playerInLove = player.getUniqueID();
        }
        this.world.setEntityState(this, (byte)18);
    }

    public void setInLove(int ticks) {
        this.inLove = ticks;
    }

    public int func_234178_eO_() {
        return this.inLove;
    }

    @Nullable
    public ServerPlayerEntity getLoveCause() {
        if (this.playerInLove == null) {
            return null;
        }
        PlayerEntity playerentity = this.world.getPlayerByUuid(this.playerInLove);
        return playerentity instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerentity : null;
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetInLove() {
        this.inLove = 0;
    }

    public boolean canMateWith(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        return this.isInLove() && otherAnimal.isInLove();
    }

    public void func_234177_a_(ServerWorld p_234177_1_, AnimalEntity p_234177_2_) {
        AgeableEntity ageableentity = this.func_241840_a(p_234177_1_, p_234177_2_);
        if (ageableentity != null) {
            ServerPlayerEntity serverplayerentity = this.getLoveCause();
            if (serverplayerentity == null && p_234177_2_.getLoveCause() != null) {
                serverplayerentity = p_234177_2_.getLoveCause();
            }
            if (serverplayerentity != null) {
                serverplayerentity.addStat(Stats.ANIMALS_BRED);
                CriteriaTriggers.BRED_ANIMALS.trigger(serverplayerentity, this, p_234177_2_, ageableentity);
            }
            this.setGrowingAge(6000);
            p_234177_2_.setGrowingAge(6000);
            this.resetInLove();
            p_234177_2_.resetInLove();
            ageableentity.setChild(true);
            ageableentity.setLocationAndAngles(this.getPosX(), this.getPosY(), this.getPosZ(), 0.0f, 0.0f);
            p_234177_1_.func_242417_l(ageableentity);
            p_234177_1_.setEntityState(this, (byte)18);
            if (p_234177_1_.getGameRules().getBoolean(GameRules.DO_MOB_LOOT)) {
                p_234177_1_.addEntity(new ExperienceOrbEntity(p_234177_1_, this.getPosX(), this.getPosY(), this.getPosZ(), this.getRNG().nextInt(7) + 1));
            }
        }
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                this.world.addParticle(ParticleTypes.HEART, this.getPosXRandom(1.0), this.getPosYRandom() + 0.5, this.getPosZRandom(1.0), d0, d1, d2);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }
}

