/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ZombifiedPiglinEntity
extends ZombieEntity
implements IAngerable {
    private static final UUID field_234344_b_ = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier field_234349_c_ = new AttributeModifier(field_234344_b_, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);
    private static final RangedInteger field_234350_d_ = TickRangeConverter.convertRange(0, 1);
    private int field_234345_bu_;
    private static final RangedInteger field_234346_bv_ = TickRangeConverter.convertRange(20, 39);
    private int field_234347_bw_;
    private UUID field_234348_bx_;
    private static final RangedInteger field_241403_bz_ = TickRangeConverter.convertRange(4, 6);
    private int field_241401_bA_;

    public ZombifiedPiglinEntity(EntityType<? extends ZombifiedPiglinEntity> p_i231568_1_, World p_i231568_2_) {
        super((EntityType<? extends ZombieEntity>)p_i231568_1_, p_i231568_2_);
        this.setPathPriority(PathNodeType.LAVA, 8.0f);
    }

    @Override
    public void setAngerTarget(@Nullable UUID target) {
        this.field_234348_bx_ = target;
    }

    @Override
    public double getYOffset() {
        return this.isChild() ? -0.05 : -0.45;
    }

    @Override
    protected void applyEntityAI() {
        this.goalSelector.addGoal(2, new ZombieAttackGoal(this, 1.0, false));
        this.goalSelector.addGoal(7, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, new Class[0]).setCallsForHelp(new Class[0]));
        this.targetSelector.addGoal(2, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, this::func_233680_b_));
        this.targetSelector.addGoal(3, new ResetAngerGoal<ZombifiedPiglinEntity>(this, true));
    }

    public static AttributeModifierMap.MutableAttribute func_234352_eU_() {
        return ZombieEntity.func_234342_eQ_().createMutableAttribute(Attributes.ZOMBIE_SPAWN_REINFORCEMENTS, 0.0).createMutableAttribute(Attributes.MOVEMENT_SPEED, 0.23f).createMutableAttribute(Attributes.ATTACK_DAMAGE, 5.0);
    }

    @Override
    protected boolean shouldDrown() {
        return false;
    }

    @Override
    protected void updateAITasks() {
        ModifiableAttributeInstance modifiableattributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.func_233678_J__()) {
            if (!this.isChild() && !modifiableattributeinstance.hasModifier(field_234349_c_)) {
                modifiableattributeinstance.applyNonPersistentModifier(field_234349_c_);
            }
            this.func_241409_eY_();
        } else if (modifiableattributeinstance.hasModifier(field_234349_c_)) {
            modifiableattributeinstance.removeModifier(field_234349_c_);
        }
        this.func_241359_a_((ServerWorld)this.world, true);
        if (this.getAttackTarget() != null) {
            this.func_241410_eZ_();
        }
        if (this.func_233678_J__()) {
            this.recentlyHit = this.ticksExisted;
        }
        super.updateAITasks();
    }

    private void func_241409_eY_() {
        if (this.field_234345_bu_ > 0) {
            --this.field_234345_bu_;
            if (this.field_234345_bu_ == 0) {
                this.func_234353_eV_();
            }
        }
    }

    private void func_241410_eZ_() {
        if (this.field_241401_bA_ > 0) {
            --this.field_241401_bA_;
        } else {
            if (this.getEntitySenses().canSee(this.getAttackTarget())) {
                this.func_241411_fa_();
            }
            this.field_241401_bA_ = field_241403_bz_.getRandomWithinRange(this.rand);
        }
    }

    private void func_241411_fa_() {
        double d0 = this.getAttributeValue(Attributes.FOLLOW_RANGE);
        AxisAlignedBB axisalignedbb = AxisAlignedBB.fromVector(this.getPositionVec()).grow(d0, 10.0, d0);
        this.world.getLoadedEntitiesWithinAABB(ZombifiedPiglinEntity.class, axisalignedbb).stream().filter(p_241408_1_ -> p_241408_1_ != this).filter(p_241407_0_ -> p_241407_0_.getAttackTarget() == null).filter(p_241406_1_ -> !p_241406_1_.isOnSameTeam(this.getAttackTarget())).forEach(p_241405_1_ -> p_241405_1_.setAttackTarget(this.getAttackTarget()));
    }

    private void func_234353_eV_() {
        this.playSound(SoundEvents.ENTITY_ZOMBIFIED_PIGLIN_ANGRY, this.getSoundVolume() * 2.0f, this.getSoundPitch() * 1.8f);
    }

    @Override
    public void setAttackTarget(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.getAttackTarget() == null && entitylivingbaseIn != null) {
            this.field_234345_bu_ = field_234350_d_.getRandomWithinRange(this.rand);
            this.field_241401_bA_ = field_241403_bz_.getRandomWithinRange(this.rand);
        }
        if (entitylivingbaseIn instanceof PlayerEntity) {
            this.func_230246_e_((PlayerEntity)entitylivingbaseIn);
        }
        super.setAttackTarget(entitylivingbaseIn);
    }

    @Override
    public void func_230258_H__() {
        this.setAngerTime(field_234346_bv_.getRandomWithinRange(this.rand));
    }

    public static boolean func_234351_b_(EntityType<ZombifiedPiglinEntity> p_234351_0_, IWorld p_234351_1_, SpawnReason p_234351_2_, BlockPos p_234351_3_, Random p_234351_4_) {
        return p_234351_1_.getDifficulty() != Difficulty.PEACEFUL && p_234351_1_.getBlockState(p_234351_3_.down()).getBlock() != Blocks.NETHER_WART_BLOCK;
    }

    @Override
    public boolean isNotColliding(IWorldReader worldIn) {
        return worldIn.checkNoEntityCollision(this) && !worldIn.containsAnyLiquid(this.getBoundingBox());
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        this.writeAngerNBT(compound);
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        this.readAngerNBT((ServerWorld)this.world, compound);
    }

    @Override
    public void setAngerTime(int time) {
        this.field_234347_bw_ = time;
    }

    @Override
    public int getAngerTime() {
        return this.field_234347_bw_;
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        return this.isInvulnerableTo(source) ? false : super.attackEntityFrom(source, amount);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.func_233678_J__() ? SoundEvents.ENTITY_ZOMBIFIED_PIGLIN_ANGRY : SoundEvents.ENTITY_ZOMBIFIED_PIGLIN_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_ZOMBIFIED_PIGLIN_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_ZOMBIFIED_PIGLIN_DEATH;
    }

    @Override
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance difficulty) {
        this.setItemStackToSlot(EquipmentSlotType.MAINHAND, new ItemStack(Items.GOLDEN_SWORD));
    }

    @Override
    protected ItemStack getSkullDrop() {
        return ItemStack.EMPTY;
    }

    @Override
    protected void func_230291_eT_() {
        this.getAttribute(Attributes.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(0.0);
    }

    @Override
    public UUID getAngerTarget() {
        return this.field_234348_bx_;
    }

    @Override
    public boolean func_230292_f_(PlayerEntity p_230292_1_) {
        return this.func_233680_b_(p_230292_1_);
    }
}

