/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ShulkerAABBHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;

public class ShulkerEntity
extends GolemEntity
implements IMob {
    private static final UUID COVERED_ARMOR_BONUS_ID = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier COVERED_ARMOR_BONUS_MODIFIER = new AttributeModifier(COVERED_ARMOR_BONUS_ID, "Covered armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    protected static final DataParameter<Direction> ATTACHED_FACE = EntityDataManager.createKey(ShulkerEntity.class, DataSerializers.DIRECTION);
    protected static final DataParameter<Optional<BlockPos>> ATTACHED_BLOCK_POS = EntityDataManager.createKey(ShulkerEntity.class, DataSerializers.OPTIONAL_BLOCK_POS);
    protected static final DataParameter<Byte> PEEK_TICK = EntityDataManager.createKey(ShulkerEntity.class, DataSerializers.BYTE);
    protected static final DataParameter<Byte> COLOR = EntityDataManager.createKey(ShulkerEntity.class, DataSerializers.BYTE);
    private float prevPeekAmount;
    private float peekAmount;
    private BlockPos currentAttachmentPosition = null;
    private int clientSideTeleportInterpolation;

    public ShulkerEntity(EntityType<? extends ShulkerEntity> p_i50196_1_, World p_i50196_2_) {
        super((EntityType<? extends GolemEntity>)p_i50196_1_, p_i50196_2_);
        this.experienceValue = 5;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.goalSelector.addGoal(4, new AttackGoal());
        this.goalSelector.addGoal(7, new PeekGoal());
        this.goalSelector.addGoal(8, new LookRandomlyGoal(this));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, new Class[0]).setCallsForHelp(new Class[0]));
        this.targetSelector.addGoal(2, new AttackNearestGoal(this));
        this.targetSelector.addGoal(3, new DefenseAttackGoal(this));
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SHULKER_AMBIENT;
    }

    @Override
    public void playAmbientSound() {
        if (!this.isClosed()) {
            super.playAmbientSound();
        }
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SHULKER_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.isClosed() ? SoundEvents.ENTITY_SHULKER_HURT_CLOSED : SoundEvents.ENTITY_SHULKER_HURT;
    }

    @Override
    protected void registerData() {
        super.registerData();
        this.dataManager.register(ATTACHED_FACE, Direction.DOWN);
        this.dataManager.register(ATTACHED_BLOCK_POS, Optional.empty());
        this.dataManager.register(PEEK_TICK, (byte)0);
        this.dataManager.register(COLOR, (byte)16);
    }

    public static AttributeModifierMap.MutableAttribute func_234300_m_() {
        return MobEntity.func_233666_p_().createMutableAttribute(Attributes.MAX_HEALTH, 30.0);
    }

    @Override
    protected BodyController createBodyController() {
        return new BodyHelperController(this);
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        this.dataManager.set(ATTACHED_FACE, Direction.byIndex(compound.getByte("AttachFace")));
        this.dataManager.set(PEEK_TICK, compound.getByte("Peek"));
        this.dataManager.set(COLOR, compound.getByte("Color"));
        if (compound.contains("APX")) {
            int i = compound.getInt("APX");
            int j = compound.getInt("APY");
            int k = compound.getInt("APZ");
            this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of(new BlockPos(i, j, k)));
        } else {
            this.dataManager.set(ATTACHED_BLOCK_POS, Optional.empty());
        }
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        compound.putByte("AttachFace", (byte)this.dataManager.get(ATTACHED_FACE).getIndex());
        compound.putByte("Peek", this.dataManager.get(PEEK_TICK));
        compound.putByte("Color", this.dataManager.get(COLOR));
        BlockPos blockpos = this.getAttachmentPos();
        if (blockpos != null) {
            compound.putInt("APX", blockpos.getX());
            compound.putInt("APY", blockpos.getY());
            compound.putInt("APZ", blockpos.getZ());
        }
    }

    @Override
    public void tick() {
        super.tick();
        BlockPos blockpos = this.dataManager.get(ATTACHED_BLOCK_POS).orElse(null);
        if (blockpos == null && !this.world.isRemote) {
            blockpos = this.getPosition();
            this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of(blockpos));
        }
        if (this.isPassenger()) {
            float f;
            blockpos = null;
            this.rotationYaw = f = this.getRidingEntity().rotationYaw;
            this.renderYawOffset = f;
            this.prevRenderYawOffset = f;
            this.clientSideTeleportInterpolation = 0;
        } else if (!this.world.isRemote) {
            Direction direction4;
            BlockState blockstate = this.world.getBlockState(blockpos);
            if (!blockstate.isAir()) {
                if (blockstate.isIn(Blocks.MOVING_PISTON)) {
                    Direction direction = blockstate.get(PistonBlock.FACING);
                    if (this.world.isAirBlock(blockpos.offset(direction))) {
                        blockpos = blockpos.offset(direction);
                        this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of(blockpos));
                    } else {
                        this.tryTeleportToNewPosition();
                    }
                } else if (blockstate.isIn(Blocks.PISTON_HEAD)) {
                    Direction direction3 = blockstate.get(PistonHeadBlock.FACING);
                    if (this.world.isAirBlock(blockpos.offset(direction3))) {
                        blockpos = blockpos.offset(direction3);
                        this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of(blockpos));
                    } else {
                        this.tryTeleportToNewPosition();
                    }
                } else {
                    this.tryTeleportToNewPosition();
                }
            }
            if (!this.func_234298_a_(blockpos, direction4 = this.getAttachmentFacing())) {
                Direction direction1 = this.func_234299_g_(blockpos);
                if (direction1 != null) {
                    this.dataManager.set(ATTACHED_FACE, direction1);
                } else {
                    this.tryTeleportToNewPosition();
                }
            }
        }
        float f1 = (float)this.getPeekTick() * 0.01f;
        this.prevPeekAmount = this.peekAmount;
        if (this.peekAmount > f1) {
            this.peekAmount = MathHelper.clamp(this.peekAmount - 0.05f, f1, 1.0f);
        } else if (this.peekAmount < f1) {
            this.peekAmount = MathHelper.clamp(this.peekAmount + 0.05f, 0.0f, f1);
        }
        if (blockpos != null) {
            List<Entity> list;
            if (this.world.isRemote) {
                if (this.clientSideTeleportInterpolation > 0 && this.currentAttachmentPosition != null) {
                    --this.clientSideTeleportInterpolation;
                } else {
                    this.currentAttachmentPosition = blockpos;
                }
            }
            this.forceSetPosition((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5);
            double d2 = 0.5 - (double)MathHelper.sin((0.5f + this.peekAmount) * (float)Math.PI) * 0.5;
            double d0 = 0.5 - (double)MathHelper.sin((0.5f + this.prevPeekAmount) * (float)Math.PI) * 0.5;
            Direction direction2 = this.getAttachmentFacing().getOpposite();
            this.setBoundingBox(new AxisAlignedBB(this.getPosX() - 0.5, this.getPosY(), this.getPosZ() - 0.5, this.getPosX() + 0.5, this.getPosY() + 1.0, this.getPosZ() + 0.5).expand((double)direction2.getXOffset() * d2, (double)direction2.getYOffset() * d2, (double)direction2.getZOffset() * d2));
            double d1 = d2 - d0;
            if (d1 > 0.0 && !(list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.getBoundingBox())).isEmpty()) {
                for (Entity entity : list) {
                    if (entity instanceof ShulkerEntity || entity.noClip) continue;
                    entity.move(MoverType.SHULKER, new Vector3d(d1 * (double)direction2.getXOffset(), d1 * (double)direction2.getYOffset(), d1 * (double)direction2.getZOffset()));
                }
            }
        }
    }

    @Override
    public void move(MoverType typeIn, Vector3d pos) {
        if (typeIn == MoverType.SHULKER_BOX) {
            this.tryTeleportToNewPosition();
        } else {
            super.move(typeIn, pos);
        }
    }

    @Override
    public void setPosition(double x, double y, double z) {
        super.setPosition(x, y, z);
        if (this.dataManager != null && this.ticksExisted != 0) {
            Optional<BlockPos> optional = this.dataManager.get(ATTACHED_BLOCK_POS);
            Optional<BlockPos> optional1 = Optional.of(new BlockPos(x, y, z));
            if (!optional1.equals(optional)) {
                this.dataManager.set(ATTACHED_BLOCK_POS, optional1);
                this.dataManager.set(PEEK_TICK, (byte)0);
                this.isAirBorne = true;
            }
        }
    }

    @Nullable
    protected Direction func_234299_g_(BlockPos p_234299_1_) {
        for (Direction direction : Direction.values()) {
            if (!this.func_234298_a_(p_234299_1_, direction)) continue;
            return direction;
        }
        return null;
    }

    private boolean func_234298_a_(BlockPos p_234298_1_, Direction p_234298_2_) {
        return this.world.isDirectionSolid(p_234298_1_.offset(p_234298_2_), this, p_234298_2_.getOpposite()) && this.world.hasNoCollisions(this, ShulkerAABBHelper.getOpenedCollisionBox(p_234298_1_, p_234298_2_.getOpposite()));
    }

    protected boolean tryTeleportToNewPosition() {
        if (!this.isAIDisabled() && this.isAlive()) {
            BlockPos blockpos = this.getPosition();
            for (int i = 0; i < 5; ++i) {
                Direction direction;
                BlockPos blockpos1 = blockpos.add(8 - this.rand.nextInt(17), 8 - this.rand.nextInt(17), 8 - this.rand.nextInt(17));
                if (blockpos1.getY() <= 0 || !this.world.isAirBlock(blockpos1) || !this.world.getWorldBorder().contains(blockpos1) || !this.world.hasNoCollisions(this, new AxisAlignedBB(blockpos1)) || (direction = this.func_234299_g_(blockpos1)) == null) continue;
                this.dataManager.set(ATTACHED_FACE, direction);
                this.playSound(SoundEvents.ENTITY_SHULKER_TELEPORT, 1.0f, 1.0f);
                this.dataManager.set(ATTACHED_BLOCK_POS, Optional.of(blockpos1));
                this.dataManager.set(PEEK_TICK, (byte)0);
                this.setAttackTarget(null);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void livingTick() {
        super.livingTick();
        this.setMotion(Vector3d.ZERO);
        if (!this.isAIDisabled()) {
            this.prevRenderYawOffset = 0.0f;
            this.renderYawOffset = 0.0f;
        }
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> key) {
        BlockPos blockpos;
        if (ATTACHED_BLOCK_POS.equals(key) && this.world.isRemote && !this.isPassenger() && (blockpos = this.getAttachmentPos()) != null) {
            if (this.currentAttachmentPosition == null) {
                this.currentAttachmentPosition = blockpos;
            } else {
                this.clientSideTeleportInterpolation = 6;
            }
            this.forceSetPosition((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5);
        }
        super.notifyDataManagerChange(key);
    }

    @Override
    public void setPositionAndRotationDirect(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.newPosRotationIncrements = 0;
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        Entity entity;
        if (this.isClosed() && (entity = source.getImmediateSource()) instanceof AbstractArrowEntity) {
            return false;
        }
        if (super.attackEntityFrom(source, amount)) {
            if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5 && this.rand.nextInt(4) == 0) {
                this.tryTeleportToNewPosition();
            }
            return true;
        }
        return false;
    }

    private boolean isClosed() {
        return this.getPeekTick() == 0;
    }

    @Override
    public boolean func_241845_aY() {
        return this.isAlive();
    }

    public Direction getAttachmentFacing() {
        return this.dataManager.get(ATTACHED_FACE);
    }

    @Nullable
    public BlockPos getAttachmentPos() {
        return this.dataManager.get(ATTACHED_BLOCK_POS).orElse(null);
    }

    public void setAttachmentPos(@Nullable BlockPos pos) {
        this.dataManager.set(ATTACHED_BLOCK_POS, Optional.ofNullable(pos));
    }

    public int getPeekTick() {
        return this.dataManager.get(PEEK_TICK).byteValue();
    }

    public void updateArmorModifier(int p_184691_1_) {
        if (!this.world.isRemote) {
            this.getAttribute(Attributes.ARMOR).removeModifier(COVERED_ARMOR_BONUS_MODIFIER);
            if (p_184691_1_ == 0) {
                this.getAttribute(Attributes.ARMOR).applyPersistentModifier(COVERED_ARMOR_BONUS_MODIFIER);
                this.playSound(SoundEvents.ENTITY_SHULKER_CLOSE, 1.0f, 1.0f);
            } else {
                this.playSound(SoundEvents.ENTITY_SHULKER_OPEN, 1.0f, 1.0f);
            }
        }
        this.dataManager.set(PEEK_TICK, (byte)p_184691_1_);
    }

    public float getClientPeekAmount(float p_184688_1_) {
        return MathHelper.lerp(p_184688_1_, this.prevPeekAmount, this.peekAmount);
    }

    public int getClientTeleportInterp() {
        return this.clientSideTeleportInterpolation;
    }

    public BlockPos getOldAttachPos() {
        return this.currentAttachmentPosition;
    }

    @Override
    protected float getStandingEyeHeight(Pose poseIn, EntitySize sizeIn) {
        return 0.5f;
    }

    @Override
    public int getVerticalFaceSpeed() {
        return 180;
    }

    @Override
    public int getHorizontalFaceSpeed() {
        return 180;
    }

    @Override
    public void applyEntityCollision(Entity entityIn) {
    }

    @Override
    public float getCollisionBorderSize() {
        return 0.0f;
    }

    public boolean isAttachedToBlock() {
        return this.currentAttachmentPosition != null && this.getAttachmentPos() != null;
    }

    @Nullable
    public DyeColor getColor() {
        Byte obyte = this.dataManager.get(COLOR);
        return obyte != 16 && obyte <= 15 ? DyeColor.byId(obyte.byteValue()) : null;
    }

    class PeekGoal
    extends Goal {
        private int peekTime;

        private PeekGoal() {
        }

        @Override
        public boolean shouldExecute() {
            return ShulkerEntity.this.getAttackTarget() == null && ShulkerEntity.this.rand.nextInt(40) == 0;
        }

        @Override
        public boolean shouldContinueExecuting() {
            return ShulkerEntity.this.getAttackTarget() == null && this.peekTime > 0;
        }

        @Override
        public void startExecuting() {
            this.peekTime = 20 * (1 + ShulkerEntity.this.rand.nextInt(3));
            ShulkerEntity.this.updateArmorModifier(30);
        }

        @Override
        public void resetTask() {
            if (ShulkerEntity.this.getAttackTarget() == null) {
                ShulkerEntity.this.updateArmorModifier(0);
            }
        }

        @Override
        public void tick() {
            --this.peekTime;
        }
    }

    static class DefenseAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public DefenseAttackGoal(ShulkerEntity shulker) {
            super(shulker, LivingEntity.class, 10, true, false, p_200826_0_ -> p_200826_0_ instanceof IMob);
        }

        @Override
        public boolean shouldExecute() {
            return this.goalOwner.getTeam() == null ? false : super.shouldExecute();
        }

        @Override
        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            Direction direction = ((ShulkerEntity)this.goalOwner).getAttachmentFacing();
            if (direction.getAxis() == Direction.Axis.X) {
                return this.goalOwner.getBoundingBox().grow(4.0, targetDistance, targetDistance);
            }
            return direction.getAxis() == Direction.Axis.Z ? this.goalOwner.getBoundingBox().grow(targetDistance, targetDistance, 4.0) : this.goalOwner.getBoundingBox().grow(targetDistance, 4.0, targetDistance);
        }
    }

    class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity p_i50612_2_) {
            super(p_i50612_2_);
        }

        @Override
        public void updateRenderAngles() {
        }
    }

    class AttackNearestGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackNearestGoal(ShulkerEntity shulker) {
            super((MobEntity)shulker, PlayerEntity.class, true);
        }

        @Override
        public boolean shouldExecute() {
            return ShulkerEntity.this.world.getDifficulty() == Difficulty.PEACEFUL ? false : super.shouldExecute();
        }

        @Override
        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            Direction direction = ((ShulkerEntity)this.goalOwner).getAttachmentFacing();
            if (direction.getAxis() == Direction.Axis.X) {
                return this.goalOwner.getBoundingBox().grow(4.0, targetDistance, targetDistance);
            }
            return direction.getAxis() == Direction.Axis.Z ? this.goalOwner.getBoundingBox().grow(targetDistance, targetDistance, 4.0) : this.goalOwner.getBoundingBox().grow(targetDistance, 4.0, targetDistance);
        }
    }

    class AttackGoal
    extends Goal {
        private int attackTime;

        public AttackGoal() {
            this.setMutexFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean shouldExecute() {
            LivingEntity livingentity = ShulkerEntity.this.getAttackTarget();
            if (livingentity != null && livingentity.isAlive()) {
                return ShulkerEntity.this.world.getDifficulty() != Difficulty.PEACEFUL;
            }
            return false;
        }

        @Override
        public void startExecuting() {
            this.attackTime = 20;
            ShulkerEntity.this.updateArmorModifier(100);
        }

        @Override
        public void resetTask() {
            ShulkerEntity.this.updateArmorModifier(0);
        }

        @Override
        public void tick() {
            if (ShulkerEntity.this.world.getDifficulty() != Difficulty.PEACEFUL) {
                --this.attackTime;
                LivingEntity livingentity = ShulkerEntity.this.getAttackTarget();
                ShulkerEntity.this.getLookController().setLookPositionWithEntity(livingentity, 180.0f, 180.0f);
                double d0 = ShulkerEntity.this.getDistanceSq(livingentity);
                if (d0 < 400.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20 + ShulkerEntity.this.rand.nextInt(10) * 20 / 2;
                        ShulkerEntity.this.world.addEntity(new ShulkerBulletEntity(ShulkerEntity.this.world, ShulkerEntity.this, livingentity, ShulkerEntity.this.getAttachmentFacing().getAxis()));
                        ShulkerEntity.this.playSound(SoundEvents.ENTITY_SHULKER_SHOOT, 2.0f, (ShulkerEntity.this.rand.nextFloat() - ShulkerEntity.this.rand.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    ShulkerEntity.this.setAttackTarget(null);
                }
                super.tick();
            }
        }
    }
}

