/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.raid.Raid;

public abstract class PatrollerEntity
extends MonsterEntity {
    private BlockPos patrolTarget;
    private boolean patrolLeader;
    private boolean patrolling;

    protected PatrollerEntity(EntityType<? extends PatrollerEntity> p_i50201_1_, World worldIn) {
        super((EntityType<? extends MonsterEntity>)p_i50201_1_, worldIn);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, new PatrolGoal<PatrollerEntity>(this, 0.7, 0.595));
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        if (this.patrolTarget != null) {
            compound.put("PatrolTarget", NBTUtil.writeBlockPos(this.patrolTarget));
        }
        compound.putBoolean("PatrolLeader", this.patrolLeader);
        compound.putBoolean("Patrolling", this.patrolling);
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        if (compound.contains("PatrolTarget")) {
            this.patrolTarget = NBTUtil.readBlockPos(compound.getCompound("PatrolTarget"));
        }
        this.patrolLeader = compound.getBoolean("PatrolLeader");
        this.patrolling = compound.getBoolean("Patrolling");
    }

    @Override
    public double getYOffset() {
        return -0.45;
    }

    public boolean canBeLeader() {
        return true;
    }

    @Override
    @Nullable
    public ILivingEntityData onInitialSpawn(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason != SpawnReason.PATROL && reason != SpawnReason.EVENT && reason != SpawnReason.STRUCTURE && this.rand.nextFloat() < 0.06f && this.canBeLeader()) {
            this.patrolLeader = true;
        }
        if (this.isLeader()) {
            this.setItemStackToSlot(EquipmentSlotType.HEAD, Raid.createIllagerBanner());
            this.setDropChance(EquipmentSlotType.HEAD, 2.0f);
        }
        if (reason == SpawnReason.PATROL) {
            this.patrolling = true;
        }
        return super.onInitialSpawn(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean func_223330_b(EntityType<? extends PatrollerEntity> patrollerType, IWorld worldIn, SpawnReason reason, BlockPos p_223330_3_, Random p_223330_4_) {
        return worldIn.getLightFor(LightType.BLOCK, p_223330_3_) > 8 ? false : PatrollerEntity.canMonsterSpawn(patrollerType, worldIn, reason, p_223330_3_, p_223330_4_);
    }

    @Override
    public boolean canDespawn(double distanceToClosestPlayer) {
        return !this.patrolling || distanceToClosestPlayer > 16384.0;
    }

    public void setPatrolTarget(BlockPos p_213631_1_) {
        this.patrolTarget = p_213631_1_;
        this.patrolling = true;
    }

    public BlockPos getPatrolTarget() {
        return this.patrolTarget;
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setLeader(boolean isLeader) {
        this.patrolLeader = isLeader;
        this.patrolling = true;
    }

    public boolean isLeader() {
        return this.patrolLeader;
    }

    public boolean notInRaid() {
        return true;
    }

    public void resetPatrolTarget() {
        this.patrolTarget = this.getPosition().add(-500 + this.rand.nextInt(1000), 0, -500 + this.rand.nextInt(1000));
        this.patrolling = true;
    }

    protected boolean isPatrolling() {
        return this.patrolling;
    }

    protected void setPatrolling(boolean p_226541_1_) {
        this.patrolling = p_226541_1_;
    }

    public static class PatrolGoal<T extends PatrollerEntity>
    extends Goal {
        private final T owner;
        private final double field_220840_b;
        private final double field_220841_c;
        private long field_226542_d_;

        public PatrolGoal(T p_i50070_1_, double p_i50070_2_, double p_i50070_4_) {
            this.owner = p_i50070_1_;
            this.field_220840_b = p_i50070_2_;
            this.field_220841_c = p_i50070_4_;
            this.field_226542_d_ = -1L;
            this.setMutexFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean shouldExecute() {
            boolean flag = ((PatrollerEntity)this.owner).world.getGameTime() < this.field_226542_d_;
            return ((PatrollerEntity)this.owner).isPatrolling() && ((MobEntity)this.owner).getAttackTarget() == null && !((Entity)this.owner).isBeingRidden() && ((PatrollerEntity)this.owner).hasPatrolTarget() && !flag;
        }

        @Override
        public void startExecuting() {
        }

        @Override
        public void resetTask() {
        }

        @Override
        public void tick() {
            boolean flag = ((PatrollerEntity)this.owner).isLeader();
            PathNavigator pathnavigator = ((MobEntity)this.owner).getNavigator();
            if (pathnavigator.noPath()) {
                List<PatrollerEntity> list = this.func_226544_g_();
                if (((PatrollerEntity)this.owner).isPatrolling() && list.isEmpty()) {
                    ((PatrollerEntity)this.owner).setPatrolling(false);
                } else if (flag && ((PatrollerEntity)this.owner).getPatrolTarget().withinDistance(((Entity)this.owner).getPositionVec(), 10.0)) {
                    ((PatrollerEntity)this.owner).resetPatrolTarget();
                } else {
                    Vector3d vector3d = Vector3d.copyCenteredHorizontally(((PatrollerEntity)this.owner).getPatrolTarget());
                    Vector3d vector3d1 = ((Entity)this.owner).getPositionVec();
                    Vector3d vector3d2 = vector3d1.subtract(vector3d);
                    vector3d = vector3d2.rotateYaw(90.0f).scale(0.4).add(vector3d);
                    Vector3d vector3d3 = vector3d.subtract(vector3d1).normalize().scale(10.0).add(vector3d1);
                    BlockPos blockpos = new BlockPos(vector3d3);
                    if (!pathnavigator.tryMoveToXYZ((blockpos = ((PatrollerEntity)this.owner).world.getHeight(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, blockpos)).getX(), blockpos.getY(), blockpos.getZ(), flag ? this.field_220841_c : this.field_220840_b)) {
                        this.func_226545_h_();
                        this.field_226542_d_ = ((PatrollerEntity)this.owner).world.getGameTime() + 200L;
                    } else if (flag) {
                        for (PatrollerEntity patrollerentity : list) {
                            patrollerentity.setPatrolTarget(blockpos);
                        }
                    }
                }
            }
        }

        private List<PatrollerEntity> func_226544_g_() {
            return ((PatrollerEntity)this.owner).world.getEntitiesWithinAABB(PatrollerEntity.class, ((Entity)this.owner).getBoundingBox().grow(16.0), p_226543_1_ -> p_226543_1_.notInRaid() && !p_226543_1_.isEntityEqual((Entity)this.owner));
        }

        private boolean func_226545_h_() {
            Random random = ((LivingEntity)this.owner).getRNG();
            BlockPos blockpos = ((PatrollerEntity)this.owner).world.getHeight(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ((Entity)this.owner).getPosition().add(-8 + random.nextInt(16), 0, -8 + random.nextInt(16)));
            return ((MobEntity)this.owner).getNavigator().tryMoveToXYZ(blockpos.getX(), blockpos.getY(), blockpos.getZ(), this.field_220840_b);
        }
    }
}

