/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item.minecart;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class ChestMinecartEntity
extends ContainerMinecartEntity {
    public ChestMinecartEntity(EntityType<? extends ChestMinecartEntity> type, World world) {
        super(type, world);
    }

    public ChestMinecartEntity(World worldIn, double x, double y, double z) {
        super(EntityType.CHEST_MINECART, x, y, z, worldIn);
    }

    @Override
    public void killMinecart(DamageSource source) {
        super.killMinecart(source);
        if (this.world.getGameRules().getBoolean(GameRules.DO_ENTITY_DROPS)) {
            this.entityDropItem(Blocks.CHEST);
        }
    }

    @Override
    public int getSizeInventory() {
        return 27;
    }

    @Override
    public AbstractMinecartEntity.Type getMinecartType() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    @Override
    public BlockState getDefaultDisplayTile() {
        return (BlockState)Blocks.CHEST.getDefaultState().with(ChestBlock.FACING, Direction.NORTH);
    }

    @Override
    public int getDefaultDisplayTileOffset() {
        return 8;
    }

    @Override
    public Container createContainer(int id, PlayerInventory playerInventoryIn) {
        return ChestContainer.createGeneric9X3(id, playerInventoryIn, this);
    }
}

