/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class WitherEntity
extends MonsterEntity
implements IChargeableMob,
IRangedAttackMob {
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.createKey(WitherEntity.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.createKey(WitherEntity.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.createKey(WitherEntity.class, DataSerializers.VARINT);
    private static final List<DataParameter<Integer>> HEAD_TARGETS = ImmutableList.of(FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET);
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.createKey(WitherEntity.class, DataSerializers.VARINT);
    private final float[] xRotationHeads = new float[2];
    private final float[] yRotationHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int blockBreakCounter;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.getDisplayName(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).setDarkenSky(true);
    private static final Predicate<LivingEntity> NOT_UNDEAD = p_213797_0_ -> p_213797_0_.getCreatureAttribute() != CreatureAttribute.UNDEAD && p_213797_0_.attackable();
    private static final EntityPredicate ENEMY_CONDITION = new EntityPredicate().setDistance(20.0).setCustomPredicate(NOT_UNDEAD);

    public WitherEntity(EntityType<? extends WitherEntity> wither, World world) {
        super((EntityType<? extends MonsterEntity>)wither, world);
        this.setHealth(this.getMaxHealth());
        this.getNavigator().setCanSwim(true);
        this.experienceValue = 50;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new DoNothingGoal());
        this.goalSelector.addGoal(2, new RangedAttackGoal(this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.goalSelector.addGoal(6, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.goalSelector.addGoal(7, new LookRandomlyGoal(this));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, new Class[0]));
        this.targetSelector.addGoal(2, new NearestAttackableTargetGoal<MobEntity>(this, MobEntity.class, 0, false, false, NOT_UNDEAD));
    }

    @Override
    protected void registerData() {
        super.registerData();
        this.dataManager.register(FIRST_HEAD_TARGET, 0);
        this.dataManager.register(SECOND_HEAD_TARGET, 0);
        this.dataManager.register(THIRD_HEAD_TARGET, 0);
        this.dataManager.register(INVULNERABILITY_TIME, 0);
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        compound.putInt("Invul", this.getInvulTime());
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        this.setInvulTime(compound.getInt("Invul"));
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    @Override
    public void setCustomName(@Nullable ITextComponent name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_WITHER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_WITHER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WITHER_DEATH;
    }

    @Override
    public void livingTick() {
        Entity entity;
        Vector3d vector3d = this.getMotion().mul(1.0, 0.6, 1.0);
        if (!this.world.isRemote && this.getWatchedTargetId(0) > 0 && (entity = this.world.getEntityByID(this.getWatchedTargetId(0))) != null) {
            double d0 = vector3d.y;
            if (this.getPosY() < entity.getPosY() || !this.isCharged() && this.getPosY() < entity.getPosY() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vector3d = new Vector3d(vector3d.x, d0, vector3d.z);
            Vector3d vector3d1 = new Vector3d(entity.getPosX() - this.getPosX(), 0.0, entity.getPosZ() - this.getPosZ());
            if (WitherEntity.horizontalMag(vector3d1) > 9.0) {
                Vector3d vector3d2 = vector3d1.normalize();
                vector3d = vector3d.add(vector3d2.x * 0.3 - vector3d.x * 0.6, 0.0, vector3d2.z * 0.3 - vector3d.z * 0.6);
            }
        }
        this.setMotion(vector3d);
        if (WitherEntity.horizontalMag(vector3d) > 0.05) {
            this.rotationYaw = (float)MathHelper.atan2(vector3d.z, vector3d.x) * 57.295776f - 90.0f;
        }
        super.livingTick();
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.getWatchedTargetId(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.world.getEntityByID(k);
            }
            if (entity1 != null) {
                double d9 = this.getHeadX(j + 1);
                double d1 = this.getHeadY(j + 1);
                double d3 = this.getHeadZ(j + 1);
                double d4 = entity1.getPosX() - d9;
                double d5 = entity1.getPosYEye() - d1;
                double d6 = entity1.getPosZ() - d3;
                double d7 = MathHelper.sqrt(d4 * d4 + d6 * d6);
                float f = (float)(MathHelper.atan2(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.atan2(d5, d7) * 57.2957763671875));
                this.xRotationHeads[j] = this.rotlerp(this.xRotationHeads[j], f1, 40.0f);
                this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], f, 10.0f);
                continue;
            }
            this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], this.renderYawOffset, 10.0f);
        }
        boolean flag = this.isCharged();
        for (int l = 0; l < 3; ++l) {
            double d8 = this.getHeadX(l);
            double d10 = this.getHeadY(l);
            double d2 = this.getHeadZ(l);
            this.world.addParticle(ParticleTypes.SMOKE, d8 + this.rand.nextGaussian() * (double)0.3f, d10 + this.rand.nextGaussian() * (double)0.3f, d2 + this.rand.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
            if (!flag || this.world.rand.nextInt(4) != 0) continue;
            this.world.addParticle(ParticleTypes.ENTITY_EFFECT, d8 + this.rand.nextGaussian() * (double)0.3f, d10 + this.rand.nextGaussian() * (double)0.3f, d2 + this.rand.nextGaussian() * (double)0.3f, 0.7f, 0.7f, 0.5);
        }
        if (this.getInvulTime() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.world.addParticle(ParticleTypes.ENTITY_EFFECT, this.getPosX() + this.rand.nextGaussian(), this.getPosY() + (double)(this.rand.nextFloat() * 3.3f), this.getPosZ() + this.rand.nextGaussian(), 0.7f, 0.7f, 0.9f);
            }
        }
    }

    @Override
    protected void updateAITasks() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                Explosion.Mode explosion$mode = this.world.getGameRules().getBoolean(GameRules.MOB_GRIEFING) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                this.world.createExplosion(this, this.getPosX(), this.getPosYEye(), this.getPosZ(), 7.0f, false, explosion$mode);
                if (!this.isSilent()) {
                    this.world.playBroadcastSound(1023, this.getPosition(), 0);
                }
            }
            this.setInvulTime(j1);
            if (this.ticksExisted % 10 == 0) {
                this.heal(10.0f);
            }
        } else {
            super.updateAITasks();
            block0: for (int i = 1; i < 3; ++i) {
                int k1;
                if (this.ticksExisted < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.ticksExisted + 10 + this.rand.nextInt(10);
                if (this.world.getDifficulty() == Difficulty.NORMAL || this.world.getDifficulty() == Difficulty.HARD) {
                    int j3 = i - 1;
                    int k3 = this.idleHeadUpdates[i - 1];
                    this.idleHeadUpdates[j3] = this.idleHeadUpdates[i - 1] + 1;
                    if (k3 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.nextDouble(this.rand, this.getPosX() - 10.0, this.getPosX() + 10.0);
                        double d1 = MathHelper.nextDouble(this.rand, this.getPosY() - 5.0, this.getPosY() + 5.0);
                        double d2 = MathHelper.nextDouble(this.rand, this.getPosZ() - 10.0, this.getPosZ() + 10.0);
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((k1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.world.getEntityByID(k1);
                    if (entity != null && entity.isAlive() && !(this.getDistanceSq(entity) > 900.0) && this.canEntityBeSeen(entity)) {
                        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).abilities.disableDamage) {
                            this.updateWatchedTargetId(i, 0);
                            continue;
                        }
                        this.launchWitherSkullToEntity(i + 1, (LivingEntity)entity);
                        this.nextHeadUpdate[i - 1] = this.ticksExisted + 40 + this.rand.nextInt(20);
                        this.idleHeadUpdates[i - 1] = 0;
                        continue;
                    }
                    this.updateWatchedTargetId(i, 0);
                    continue;
                }
                List<LivingEntity> list = this.world.getTargettableEntitiesWithinAABB(LivingEntity.class, ENEMY_CONDITION, this, this.getBoundingBox().grow(20.0, 8.0, 20.0));
                for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                    LivingEntity livingentity = list.get(this.rand.nextInt(list.size()));
                    if (livingentity != this && livingentity.isAlive() && this.canEntityBeSeen(livingentity)) {
                        if (livingentity instanceof PlayerEntity) {
                            if (((PlayerEntity)livingentity).abilities.disableDamage) continue block0;
                            this.updateWatchedTargetId(i, livingentity.getEntityId());
                            continue block0;
                        }
                        this.updateWatchedTargetId(i, livingentity.getEntityId());
                        continue block0;
                    }
                    list.remove(livingentity);
                }
            }
            if (this.getAttackTarget() != null) {
                this.updateWatchedTargetId(0, this.getAttackTarget().getEntityId());
            } else {
                this.updateWatchedTargetId(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.world.getGameRules().getBoolean(GameRules.MOB_GRIEFING)) {
                    int i1 = MathHelper.floor(this.getPosY());
                    int l1 = MathHelper.floor(this.getPosX());
                    int i2 = MathHelper.floor(this.getPosZ());
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i1 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                BlockState blockstate = this.world.getBlockState(blockpos);
                                if (!WitherEntity.canDestroyBlock(blockstate)) continue;
                                flag = this.world.destroyBlock(blockpos, true, this) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.world.playEvent(null, 1022, this.getPosition(), 0);
                    }
                }
            }
            if (this.ticksExisted % 20 == 0) {
                this.heal(1.0f);
            }
            this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
        }
    }

    public static boolean canDestroyBlock(BlockState blockIn) {
        return !blockIn.isAir() && !BlockTags.WITHER_IMMUNE.contains(blockIn.getBlock());
    }

    public void ignite() {
        this.setInvulTime(220);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void setMotionMultiplier(BlockState state, Vector3d motionMultiplierIn) {
    }

    @Override
    public void addTrackingPlayer(ServerPlayerEntity player) {
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    @Override
    public void removeTrackingPlayer(ServerPlayerEntity player) {
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    private double getHeadX(int head) {
        if (head <= 0) {
            return this.getPosX();
        }
        float f = (this.renderYawOffset + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.cos(f);
        return this.getPosX() + (double)f1 * 1.3;
    }

    private double getHeadY(int head) {
        return head <= 0 ? this.getPosY() + 3.0 : this.getPosY() + 2.2;
    }

    private double getHeadZ(int head) {
        if (head <= 0) {
            return this.getPosZ();
        }
        float f = (this.renderYawOffset + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.sin(f);
        return this.getPosZ() + (double)f1 * 1.3;
    }

    private float rotlerp(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f = MathHelper.wrapDegrees(p_82204_2_ - p_82204_1_);
        if (f > p_82204_3_) {
            f = p_82204_3_;
        }
        if (f < -p_82204_3_) {
            f = -p_82204_3_;
        }
        return p_82204_1_ + f;
    }

    private void launchWitherSkullToEntity(int head, LivingEntity target) {
        this.launchWitherSkullToCoords(head, target.getPosX(), target.getPosY() + (double)target.getEyeHeight() * 0.5, target.getPosZ(), head == 0 && this.rand.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int head, double x, double y, double z, boolean invulnerable) {
        if (!this.isSilent()) {
            this.world.playEvent(null, 1024, this.getPosition(), 0);
        }
        double d0 = this.getHeadX(head);
        double d1 = this.getHeadY(head);
        double d2 = this.getHeadZ(head);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        WitherSkullEntity witherskullentity = new WitherSkullEntity(this.world, this, d3, d4, d5);
        witherskullentity.setShooter(this);
        if (invulnerable) {
            witherskullentity.setSkullInvulnerable(true);
        }
        witherskullentity.setRawPosition(d0, d1, d2);
        this.world.addEntity(witherskullentity);
    }

    @Override
    public void attackEntityWithRangedAttack(LivingEntity target, float distanceFactor) {
        this.launchWitherSkullToEntity(0, target);
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source != DamageSource.DROWN && !(source.getTrueSource() instanceof WitherEntity)) {
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.OUT_OF_WORLD) {
                return false;
            }
            if (this.isCharged() && (entity = source.getImmediateSource()) instanceof AbstractArrowEntity) {
                return false;
            }
            Entity entity1 = source.getTrueSource();
            if (entity1 != null && !(entity1 instanceof PlayerEntity) && entity1 instanceof LivingEntity && ((LivingEntity)entity1).getCreatureAttribute() == this.getCreatureAttribute()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.idleHeadUpdates.length) {
                int n = i++;
                this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 3;
            }
            return super.attackEntityFrom(source, amount);
        }
        return false;
    }

    @Override
    protected void dropSpecialItems(DamageSource source, int looting, boolean recentlyHitIn) {
        super.dropSpecialItems(source, looting, recentlyHitIn);
        ItemEntity itementity = this.entityDropItem(Items.NETHER_STAR);
        if (itementity != null) {
            itementity.setNoDespawn();
        }
    }

    @Override
    public void checkDespawn() {
        if (this.world.getDifficulty() == Difficulty.PEACEFUL && this.isDespawnPeaceful()) {
            this.remove();
        } else {
            this.idleTime = 0;
        }
    }

    @Override
    public boolean onLivingFall(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    public boolean addPotionEffect(EffectInstance effectInstanceIn) {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().createMutableAttribute(Attributes.MAX_HEALTH, 300.0).createMutableAttribute(Attributes.MOVEMENT_SPEED, 0.6f).createMutableAttribute(Attributes.FOLLOW_RANGE, 40.0).createMutableAttribute(Attributes.ARMOR, 4.0);
    }

    public float getHeadYRotation(int head) {
        return this.yRotationHeads[head];
    }

    public float getHeadXRotation(int head) {
        return this.xRotationHeads[head];
    }

    public int getInvulTime() {
        return this.dataManager.get(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.dataManager.set(INVULNERABILITY_TIME, time);
    }

    public int getWatchedTargetId(int head) {
        return this.dataManager.get(HEAD_TARGETS.get(head));
    }

    public void updateWatchedTargetId(int targetOffset, int newId) {
        this.dataManager.set(HEAD_TARGETS.get(targetOffset), newId);
    }

    @Override
    public boolean isCharged() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    public CreatureAttribute getCreatureAttribute() {
        return CreatureAttribute.UNDEAD;
    }

    @Override
    protected boolean canBeRidden(Entity entityIn) {
        return false;
    }

    @Override
    public boolean isNonBoss() {
        return false;
    }

    @Override
    public boolean isPotionApplicable(EffectInstance potioneffectIn) {
        return potioneffectIn.getPotion() == Effects.WITHER ? false : super.isPotionApplicable(potioneffectIn);
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.setMutexFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean shouldExecute() {
            return WitherEntity.this.getInvulTime() > 0;
        }
    }
}

