/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.goal;

import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.GroundPathHelper;
import net.minecraft.util.math.BlockPos;

public abstract class InteractDoorGoal
extends Goal {
    protected MobEntity entity;
    protected BlockPos doorPosition = BlockPos.ZERO;
    protected boolean doorInteract;
    private boolean hasStoppedDoorInteraction;
    private float entityPositionX;
    private float entityPositionZ;

    public InteractDoorGoal(MobEntity entityIn) {
        this.entity = entityIn;
        if (!GroundPathHelper.isGroundNavigator(entityIn)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    protected boolean canDestroy() {
        if (!this.doorInteract) {
            return false;
        }
        BlockState blockstate = this.entity.world.getBlockState(this.doorPosition);
        if (!(blockstate.getBlock() instanceof DoorBlock)) {
            this.doorInteract = false;
            return false;
        }
        return blockstate.get(DoorBlock.OPEN);
    }

    protected void toggleDoor(boolean open) {
        BlockState blockstate;
        if (this.doorInteract && (blockstate = this.entity.world.getBlockState(this.doorPosition)).getBlock() instanceof DoorBlock) {
            ((DoorBlock)blockstate.getBlock()).openDoor(this.entity.world, blockstate, this.doorPosition, open);
        }
    }

    @Override
    public boolean shouldExecute() {
        if (!GroundPathHelper.isGroundNavigator(this.entity)) {
            return false;
        }
        if (!this.entity.collidedHorizontally) {
            return false;
        }
        GroundPathNavigator groundpathnavigator = (GroundPathNavigator)this.entity.getNavigator();
        Path path = groundpathnavigator.getPath();
        if (path != null && !path.isFinished() && groundpathnavigator.getEnterDoors()) {
            for (int i = 0; i < Math.min(path.getCurrentPathIndex() + 2, path.getCurrentPathLength()); ++i) {
                PathPoint pathpoint = path.getPathPointFromIndex(i);
                this.doorPosition = new BlockPos(pathpoint.x, pathpoint.y + 1, pathpoint.z);
                if (this.entity.getDistanceSq(this.doorPosition.getX(), this.entity.getPosY(), this.doorPosition.getZ()) > 2.25) continue;
                this.doorInteract = DoorBlock.isWooden(this.entity.world, this.doorPosition);
                if (!this.doorInteract) continue;
                return true;
            }
            this.doorPosition = this.entity.getPosition().up();
            this.doorInteract = DoorBlock.isWooden(this.entity.world, this.doorPosition);
            return this.doorInteract;
        }
        return false;
    }

    @Override
    public boolean shouldContinueExecuting() {
        return !this.hasStoppedDoorInteraction;
    }

    @Override
    public void startExecuting() {
        this.hasStoppedDoorInteraction = false;
        this.entityPositionX = (float)((double)this.doorPosition.getX() + 0.5 - this.entity.getPosX());
        this.entityPositionZ = (float)((double)this.doorPosition.getZ() + 0.5 - this.entity.getPosZ());
    }

    @Override
    public void tick() {
        float f1;
        float f = (float)((double)this.doorPosition.getX() + 0.5 - this.entity.getPosX());
        float f2 = this.entityPositionX * f + this.entityPositionZ * (f1 = (float)((double)this.doorPosition.getZ() + 0.5 - this.entity.getPosZ()));
        if (f2 < 0.0f) {
            this.hasStoppedDoorInteraction = true;
        }
    }
}

