/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.CommandBlockMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.EyeOfEnderEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityType<T extends Entity> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final EntityType<AreaEffectCloudEntity> AREA_EFFECT_CLOUD = EntityType.register("area_effect_cloud", Builder.create(AreaEffectCloudEntity::new, EntityClassification.MISC).immuneToFire().size(6.0f, 0.5f).trackingRange(10).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<ArmorStandEntity> ARMOR_STAND = EntityType.register("armor_stand", Builder.create(ArmorStandEntity::new, EntityClassification.MISC).size(0.5f, 1.975f).trackingRange(10));
    public static final EntityType<ArrowEntity> ARROW = EntityType.register("arrow", Builder.create(ArrowEntity::new, EntityClassification.MISC).size(0.5f, 0.5f).trackingRange(4).func_233608_b_(20));
    public static final EntityType<BatEntity> BAT = EntityType.register("bat", Builder.create(BatEntity::new, EntityClassification.AMBIENT).size(0.5f, 0.9f).trackingRange(5));
    public static final EntityType<BeeEntity> BEE = EntityType.register("bee", Builder.create(BeeEntity::new, EntityClassification.CREATURE).size(0.7f, 0.6f).trackingRange(8));
    public static final EntityType<BlazeEntity> BLAZE = EntityType.register("blaze", Builder.create(BlazeEntity::new, EntityClassification.MONSTER).immuneToFire().size(0.6f, 1.8f).trackingRange(8));
    public static final EntityType<BoatEntity> BOAT = EntityType.register("boat", Builder.create(BoatEntity::new, EntityClassification.MISC).size(1.375f, 0.5625f).trackingRange(10));
    public static final EntityType<CatEntity> CAT = EntityType.register("cat", Builder.create(CatEntity::new, EntityClassification.CREATURE).size(0.6f, 0.7f).trackingRange(8));
    public static final EntityType<CaveSpiderEntity> CAVE_SPIDER = EntityType.register("cave_spider", Builder.create(CaveSpiderEntity::new, EntityClassification.MONSTER).size(0.7f, 0.5f).trackingRange(8));
    public static final EntityType<ChickenEntity> CHICKEN = EntityType.register("chicken", Builder.create(ChickenEntity::new, EntityClassification.CREATURE).size(0.4f, 0.7f).trackingRange(10));
    public static final EntityType<CodEntity> COD = EntityType.register("cod", Builder.create(CodEntity::new, EntityClassification.WATER_AMBIENT).size(0.5f, 0.3f).trackingRange(4));
    public static final EntityType<CowEntity> COW = EntityType.register("cow", Builder.create(CowEntity::new, EntityClassification.CREATURE).size(0.9f, 1.4f).trackingRange(10));
    public static final EntityType<CreeperEntity> CREEPER = EntityType.register("creeper", Builder.create(CreeperEntity::new, EntityClassification.MONSTER).size(0.6f, 1.7f).trackingRange(8));
    public static final EntityType<DolphinEntity> DOLPHIN = EntityType.register("dolphin", Builder.create(DolphinEntity::new, EntityClassification.WATER_CREATURE).size(0.9f, 0.6f));
    public static final EntityType<DonkeyEntity> DONKEY = EntityType.register("donkey", Builder.create(DonkeyEntity::new, EntityClassification.CREATURE).size(1.3964844f, 1.5f).trackingRange(10));
    public static final EntityType<DragonFireballEntity> DRAGON_FIREBALL = EntityType.register("dragon_fireball", Builder.create(DragonFireballEntity::new, EntityClassification.MISC).size(1.0f, 1.0f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<DrownedEntity> DROWNED = EntityType.register("drowned", Builder.create(DrownedEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<ElderGuardianEntity> ELDER_GUARDIAN = EntityType.register("elder_guardian", Builder.create(ElderGuardianEntity::new, EntityClassification.MONSTER).size(1.9975f, 1.9975f).trackingRange(10));
    public static final EntityType<EnderCrystalEntity> END_CRYSTAL = EntityType.register("end_crystal", Builder.create(EnderCrystalEntity::new, EntityClassification.MISC).size(2.0f, 2.0f).trackingRange(16).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<EnderDragonEntity> ENDER_DRAGON = EntityType.register("ender_dragon", Builder.create(EnderDragonEntity::new, EntityClassification.MONSTER).immuneToFire().size(16.0f, 8.0f).trackingRange(10));
    public static final EntityType<EndermanEntity> ENDERMAN = EntityType.register("enderman", Builder.create(EndermanEntity::new, EntityClassification.MONSTER).size(0.6f, 2.9f).trackingRange(8));
    public static final EntityType<EndermiteEntity> ENDERMITE = EntityType.register("endermite", Builder.create(EndermiteEntity::new, EntityClassification.MONSTER).size(0.4f, 0.3f).trackingRange(8));
    public static final EntityType<EvokerEntity> EVOKER = EntityType.register("evoker", Builder.create(EvokerEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<EvokerFangsEntity> EVOKER_FANGS = EntityType.register("evoker_fangs", Builder.create(EvokerFangsEntity::new, EntityClassification.MISC).size(0.5f, 0.8f).trackingRange(6).func_233608_b_(2));
    public static final EntityType<ExperienceOrbEntity> EXPERIENCE_ORB = EntityType.register("experience_orb", Builder.create(ExperienceOrbEntity::new, EntityClassification.MISC).size(0.5f, 0.5f).trackingRange(6).func_233608_b_(20));
    public static final EntityType<EyeOfEnderEntity> EYE_OF_ENDER = EntityType.register("eye_of_ender", Builder.create(EyeOfEnderEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(4).func_233608_b_(4));
    public static final EntityType<FallingBlockEntity> FALLING_BLOCK = EntityType.register("falling_block", Builder.create(FallingBlockEntity::new, EntityClassification.MISC).size(0.98f, 0.98f).trackingRange(10).func_233608_b_(20));
    public static final EntityType<FireworkRocketEntity> FIREWORK_ROCKET = EntityType.register("firework_rocket", Builder.create(FireworkRocketEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<FoxEntity> FOX = EntityType.register("fox", Builder.create(FoxEntity::new, EntityClassification.CREATURE).size(0.6f, 0.7f).trackingRange(8).func_233607_a_(Blocks.SWEET_BERRY_BUSH));
    public static final EntityType<GhastEntity> GHAST = EntityType.register("ghast", Builder.create(GhastEntity::new, EntityClassification.MONSTER).immuneToFire().size(4.0f, 4.0f).trackingRange(10));
    public static final EntityType<GiantEntity> GIANT = EntityType.register("giant", Builder.create(GiantEntity::new, EntityClassification.MONSTER).size(3.6f, 12.0f).trackingRange(10));
    public static final EntityType<GuardianEntity> GUARDIAN = EntityType.register("guardian", Builder.create(GuardianEntity::new, EntityClassification.MONSTER).size(0.85f, 0.85f).trackingRange(8));
    public static final EntityType<HoglinEntity> HOGLIN = EntityType.register("hoglin", Builder.create(HoglinEntity::new, EntityClassification.MONSTER).size(1.3964844f, 1.4f).trackingRange(8));
    public static final EntityType<HorseEntity> HORSE = EntityType.register("horse", Builder.create(HorseEntity::new, EntityClassification.CREATURE).size(1.3964844f, 1.6f).trackingRange(10));
    public static final EntityType<HuskEntity> HUSK = EntityType.register("husk", Builder.create(HuskEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<IllusionerEntity> ILLUSIONER = EntityType.register("illusioner", Builder.create(IllusionerEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<IronGolemEntity> IRON_GOLEM = EntityType.register("iron_golem", Builder.create(IronGolemEntity::new, EntityClassification.MISC).size(1.4f, 2.7f).trackingRange(10));
    public static final EntityType<ItemEntity> ITEM = EntityType.register("item", Builder.create(ItemEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(6).func_233608_b_(20));
    public static final EntityType<ItemFrameEntity> ITEM_FRAME = EntityType.register("item_frame", Builder.create(ItemFrameEntity::new, EntityClassification.MISC).size(0.5f, 0.5f).trackingRange(10).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<FireballEntity> FIREBALL = EntityType.register("fireball", Builder.create(FireballEntity::new, EntityClassification.MISC).size(1.0f, 1.0f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<LeashKnotEntity> LEASH_KNOT = EntityType.register("leash_knot", Builder.create(LeashKnotEntity::new, EntityClassification.MISC).disableSerialization().size(0.5f, 0.5f).trackingRange(10).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<LightningBoltEntity> LIGHTNING_BOLT = EntityType.register("lightning_bolt", Builder.create(LightningBoltEntity::new, EntityClassification.MISC).disableSerialization().size(0.0f, 0.0f).trackingRange(16).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<LlamaEntity> LLAMA = EntityType.register("llama", Builder.create(LlamaEntity::new, EntityClassification.CREATURE).size(0.9f, 1.87f).trackingRange(10));
    public static final EntityType<LlamaSpitEntity> LLAMA_SPIT = EntityType.register("llama_spit", Builder.create(LlamaSpitEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<MagmaCubeEntity> MAGMA_CUBE = EntityType.register("magma_cube", Builder.create(MagmaCubeEntity::new, EntityClassification.MONSTER).immuneToFire().size(2.04f, 2.04f).trackingRange(8));
    public static final EntityType<MinecartEntity> MINECART = EntityType.register("minecart", Builder.create(MinecartEntity::new, EntityClassification.MISC).size(0.98f, 0.7f).trackingRange(8));
    public static final EntityType<ChestMinecartEntity> CHEST_MINECART = EntityType.register("chest_minecart", Builder.create(ChestMinecartEntity::new, EntityClassification.MISC).size(0.98f, 0.7f).trackingRange(8));
    public static final EntityType<CommandBlockMinecartEntity> COMMAND_BLOCK_MINECART = EntityType.register("command_block_minecart", Builder.create(CommandBlockMinecartEntity::new, EntityClassification.MISC).size(0.98f, 0.7f).trackingRange(8));
    public static final EntityType<FurnaceMinecartEntity> FURNACE_MINECART = EntityType.register("furnace_minecart", Builder.create(FurnaceMinecartEntity::new, EntityClassification.MISC).size(0.98f, 0.7f).trackingRange(8));
    public static final EntityType<HopperMinecartEntity> HOPPER_MINECART = EntityType.register("hopper_minecart", Builder.create(HopperMinecartEntity::new, EntityClassification.MISC).size(0.98f, 0.7f).trackingRange(8));
    public static final EntityType<SpawnerMinecartEntity> SPAWNER_MINECART = EntityType.register("spawner_minecart", Builder.create(SpawnerMinecartEntity::new, EntityClassification.MISC).size(0.98f, 0.7f).trackingRange(8));
    public static final EntityType<TNTMinecartEntity> TNT_MINECART = EntityType.register("tnt_minecart", Builder.create(TNTMinecartEntity::new, EntityClassification.MISC).size(0.98f, 0.7f).trackingRange(8));
    public static final EntityType<MuleEntity> MULE = EntityType.register("mule", Builder.create(MuleEntity::new, EntityClassification.CREATURE).size(1.3964844f, 1.6f).trackingRange(8));
    public static final EntityType<MooshroomEntity> MOOSHROOM = EntityType.register("mooshroom", Builder.create(MooshroomEntity::new, EntityClassification.CREATURE).size(0.9f, 1.4f).trackingRange(10));
    public static final EntityType<OcelotEntity> OCELOT = EntityType.register("ocelot", Builder.create(OcelotEntity::new, EntityClassification.CREATURE).size(0.6f, 0.7f).trackingRange(10));
    public static final EntityType<PaintingEntity> PAINTING = EntityType.register("painting", Builder.create(PaintingEntity::new, EntityClassification.MISC).size(0.5f, 0.5f).trackingRange(10).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<PandaEntity> PANDA = EntityType.register("panda", Builder.create(PandaEntity::new, EntityClassification.CREATURE).size(1.3f, 1.25f).trackingRange(10));
    public static final EntityType<ParrotEntity> PARROT = EntityType.register("parrot", Builder.create(ParrotEntity::new, EntityClassification.CREATURE).size(0.5f, 0.9f).trackingRange(8));
    public static final EntityType<PhantomEntity> PHANTOM = EntityType.register("phantom", Builder.create(PhantomEntity::new, EntityClassification.MONSTER).size(0.9f, 0.5f).trackingRange(8));
    public static final EntityType<PigEntity> PIG = EntityType.register("pig", Builder.create(PigEntity::new, EntityClassification.CREATURE).size(0.9f, 0.9f).trackingRange(10));
    public static final EntityType<PiglinEntity> PIGLIN = EntityType.register("piglin", Builder.create(PiglinEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<PiglinBruteEntity> field_242287_aj = EntityType.register("piglin_brute", Builder.create(PiglinBruteEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<PillagerEntity> PILLAGER = EntityType.register("pillager", Builder.create(PillagerEntity::new, EntityClassification.MONSTER).func_225435_d().size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<PolarBearEntity> POLAR_BEAR = EntityType.register("polar_bear", Builder.create(PolarBearEntity::new, EntityClassification.CREATURE).size(1.4f, 1.4f).trackingRange(10));
    public static final EntityType<TNTEntity> TNT = EntityType.register("tnt", Builder.create(TNTEntity::new, EntityClassification.MISC).immuneToFire().size(0.98f, 0.98f).trackingRange(10).func_233608_b_(10));
    public static final EntityType<PufferfishEntity> PUFFERFISH = EntityType.register("pufferfish", Builder.create(PufferfishEntity::new, EntityClassification.WATER_AMBIENT).size(0.7f, 0.7f).trackingRange(4));
    public static final EntityType<RabbitEntity> RABBIT = EntityType.register("rabbit", Builder.create(RabbitEntity::new, EntityClassification.CREATURE).size(0.4f, 0.5f).trackingRange(8));
    public static final EntityType<RavagerEntity> RAVAGER = EntityType.register("ravager", Builder.create(RavagerEntity::new, EntityClassification.MONSTER).size(1.95f, 2.2f).trackingRange(10));
    public static final EntityType<SalmonEntity> SALMON = EntityType.register("salmon", Builder.create(SalmonEntity::new, EntityClassification.WATER_AMBIENT).size(0.7f, 0.4f).trackingRange(4));
    public static final EntityType<SheepEntity> SHEEP = EntityType.register("sheep", Builder.create(SheepEntity::new, EntityClassification.CREATURE).size(0.9f, 1.3f).trackingRange(10));
    public static final EntityType<ShulkerEntity> SHULKER = EntityType.register("shulker", Builder.create(ShulkerEntity::new, EntityClassification.MONSTER).immuneToFire().func_225435_d().size(1.0f, 1.0f).trackingRange(10));
    public static final EntityType<ShulkerBulletEntity> SHULKER_BULLET = EntityType.register("shulker_bullet", Builder.create(ShulkerBulletEntity::new, EntityClassification.MISC).size(0.3125f, 0.3125f).trackingRange(8));
    public static final EntityType<SilverfishEntity> SILVERFISH = EntityType.register("silverfish", Builder.create(SilverfishEntity::new, EntityClassification.MONSTER).size(0.4f, 0.3f).trackingRange(8));
    public static final EntityType<SkeletonEntity> SKELETON = EntityType.register("skeleton", Builder.create(SkeletonEntity::new, EntityClassification.MONSTER).size(0.6f, 1.99f).trackingRange(8));
    public static final EntityType<SkeletonHorseEntity> SKELETON_HORSE = EntityType.register("skeleton_horse", Builder.create(SkeletonHorseEntity::new, EntityClassification.CREATURE).size(1.3964844f, 1.6f).trackingRange(10));
    public static final EntityType<SlimeEntity> SLIME = EntityType.register("slime", Builder.create(SlimeEntity::new, EntityClassification.MONSTER).size(2.04f, 2.04f).trackingRange(10));
    public static final EntityType<SmallFireballEntity> SMALL_FIREBALL = EntityType.register("small_fireball", Builder.create(SmallFireballEntity::new, EntityClassification.MISC).size(0.3125f, 0.3125f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<SnowGolemEntity> SNOW_GOLEM = EntityType.register("snow_golem", Builder.create(SnowGolemEntity::new, EntityClassification.MISC).size(0.7f, 1.9f).trackingRange(8));
    public static final EntityType<SnowballEntity> SNOWBALL = EntityType.register("snowball", Builder.create(SnowballEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<SpectralArrowEntity> SPECTRAL_ARROW = EntityType.register("spectral_arrow", Builder.create(SpectralArrowEntity::new, EntityClassification.MISC).size(0.5f, 0.5f).trackingRange(4).func_233608_b_(20));
    public static final EntityType<SpiderEntity> SPIDER = EntityType.register("spider", Builder.create(SpiderEntity::new, EntityClassification.MONSTER).size(1.4f, 0.9f).trackingRange(8));
    public static final EntityType<SquidEntity> SQUID = EntityType.register("squid", Builder.create(SquidEntity::new, EntityClassification.WATER_CREATURE).size(0.8f, 0.8f).trackingRange(8));
    public static final EntityType<StrayEntity> STRAY = EntityType.register("stray", Builder.create(StrayEntity::new, EntityClassification.MONSTER).size(0.6f, 1.99f).trackingRange(8));
    public static final EntityType<StriderEntity> STRIDER = EntityType.register("strider", Builder.create(StriderEntity::new, EntityClassification.CREATURE).immuneToFire().size(0.9f, 1.7f).trackingRange(10));
    public static final EntityType<EggEntity> EGG = EntityType.register("egg", Builder.create(EggEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<EnderPearlEntity> ENDER_PEARL = EntityType.register("ender_pearl", Builder.create(EnderPearlEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<ExperienceBottleEntity> EXPERIENCE_BOTTLE = EntityType.register("experience_bottle", Builder.create(ExperienceBottleEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<PotionEntity> POTION = EntityType.register("potion", Builder.create(PotionEntity::new, EntityClassification.MISC).size(0.25f, 0.25f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<TridentEntity> TRIDENT = EntityType.register("trident", Builder.create(TridentEntity::new, EntityClassification.MISC).size(0.5f, 0.5f).trackingRange(4).func_233608_b_(20));
    public static final EntityType<TraderLlamaEntity> TRADER_LLAMA = EntityType.register("trader_llama", Builder.create(TraderLlamaEntity::new, EntityClassification.CREATURE).size(0.9f, 1.87f).trackingRange(10));
    public static final EntityType<TropicalFishEntity> TROPICAL_FISH = EntityType.register("tropical_fish", Builder.create(TropicalFishEntity::new, EntityClassification.WATER_AMBIENT).size(0.5f, 0.4f).trackingRange(4));
    public static final EntityType<TurtleEntity> TURTLE = EntityType.register("turtle", Builder.create(TurtleEntity::new, EntityClassification.CREATURE).size(1.2f, 0.4f).trackingRange(10));
    public static final EntityType<VexEntity> VEX = EntityType.register("vex", Builder.create(VexEntity::new, EntityClassification.MONSTER).immuneToFire().size(0.4f, 0.8f).trackingRange(8));
    public static final EntityType<VillagerEntity> VILLAGER = EntityType.register("villager", Builder.create(VillagerEntity::new, EntityClassification.MISC).size(0.6f, 1.95f).trackingRange(10));
    public static final EntityType<VindicatorEntity> VINDICATOR = EntityType.register("vindicator", Builder.create(VindicatorEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<WanderingTraderEntity> WANDERING_TRADER = EntityType.register("wandering_trader", Builder.create(WanderingTraderEntity::new, EntityClassification.CREATURE).size(0.6f, 1.95f).trackingRange(10));
    public static final EntityType<WitchEntity> WITCH = EntityType.register("witch", Builder.create(WitchEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<WitherEntity> WITHER = EntityType.register("wither", Builder.create(WitherEntity::new, EntityClassification.MONSTER).immuneToFire().func_233607_a_(Blocks.WITHER_ROSE).size(0.9f, 3.5f).trackingRange(10));
    public static final EntityType<WitherSkeletonEntity> WITHER_SKELETON = EntityType.register("wither_skeleton", Builder.create(WitherSkeletonEntity::new, EntityClassification.MONSTER).immuneToFire().func_233607_a_(Blocks.WITHER_ROSE).size(0.7f, 2.4f).trackingRange(8));
    public static final EntityType<WitherSkullEntity> WITHER_SKULL = EntityType.register("wither_skull", Builder.create(WitherSkullEntity::new, EntityClassification.MISC).size(0.3125f, 0.3125f).trackingRange(4).func_233608_b_(10));
    public static final EntityType<WolfEntity> WOLF = EntityType.register("wolf", Builder.create(WolfEntity::new, EntityClassification.CREATURE).size(0.6f, 0.85f).trackingRange(10));
    public static final EntityType<ZoglinEntity> ZOGLIN = EntityType.register("zoglin", Builder.create(ZoglinEntity::new, EntityClassification.MONSTER).immuneToFire().size(1.3964844f, 1.4f).trackingRange(8));
    public static final EntityType<ZombieEntity> ZOMBIE = EntityType.register("zombie", Builder.create(ZombieEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<ZombieHorseEntity> ZOMBIE_HORSE = EntityType.register("zombie_horse", Builder.create(ZombieHorseEntity::new, EntityClassification.CREATURE).size(1.3964844f, 1.6f).trackingRange(10));
    public static final EntityType<ZombieVillagerEntity> ZOMBIE_VILLAGER = EntityType.register("zombie_villager", Builder.create(ZombieVillagerEntity::new, EntityClassification.MONSTER).size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<ZombifiedPiglinEntity> ZOMBIFIED_PIGLIN = EntityType.register("zombified_piglin", Builder.create(ZombifiedPiglinEntity::new, EntityClassification.MONSTER).immuneToFire().size(0.6f, 1.95f).trackingRange(8));
    public static final EntityType<PlayerEntity> PLAYER = EntityType.register("player", Builder.create(EntityClassification.MISC).disableSerialization().disableSummoning().size(0.6f, 1.8f).trackingRange(32).func_233608_b_(2));
    public static final EntityType<FishingBobberEntity> FISHING_BOBBER = EntityType.register("fishing_bobber", Builder.create(EntityClassification.MISC).disableSerialization().disableSummoning().size(0.25f, 0.25f).trackingRange(4).func_233608_b_(5));
    private final IFactory<T> factory;
    private final EntityClassification classification;
    private final ImmutableSet<Block> field_233593_bg_;
    private final boolean serializable;
    private final boolean summonable;
    private final boolean immuneToFire;
    private final boolean field_225438_be;
    private final int defaultTrackingRange;
    private final int defaultUpdateInterval;
    @Nullable
    private String translationKey;
    @Nullable
    private ITextComponent name;
    @Nullable
    private ResourceLocation lootTable;
    private final EntitySize size;

    private static <T extends Entity> EntityType<T> register(String key, Builder<T> builder) {
        return Registry.register(Registry.ENTITY_TYPE, key, builder.build(key));
    }

    public static ResourceLocation getKey(EntityType<?> entityTypeIn) {
        return Registry.ENTITY_TYPE.getKey(entityTypeIn);
    }

    public static Optional<EntityType<?>> byKey(String key) {
        return Registry.ENTITY_TYPE.getOptional(ResourceLocation.tryCreate(key));
    }

    public EntityType(IFactory<T> p_i231489_1_, EntityClassification p_i231489_2_, boolean p_i231489_3_, boolean p_i231489_4_, boolean p_i231489_5_, boolean p_i231489_6_, ImmutableSet<Block> p_i231489_7_, EntitySize p_i231489_8_, int trackingRange, int updateInterval) {
        this.factory = p_i231489_1_;
        this.classification = p_i231489_2_;
        this.field_225438_be = p_i231489_6_;
        this.serializable = p_i231489_3_;
        this.summonable = p_i231489_4_;
        this.immuneToFire = p_i231489_5_;
        this.field_233593_bg_ = p_i231489_7_;
        this.size = p_i231489_8_;
        this.defaultTrackingRange = trackingRange;
        this.defaultUpdateInterval = updateInterval;
    }

    @Nullable
    public Entity spawn(ServerWorld worldIn, @Nullable ItemStack stack, @Nullable PlayerEntity playerIn, BlockPos pos, SpawnReason reason, boolean p_220331_6_, boolean p_220331_7_) {
        return this.spawn(worldIn, stack == null ? null : stack.getTag(), stack != null && stack.hasDisplayName() ? stack.getDisplayName() : null, playerIn, pos, reason, p_220331_6_, p_220331_7_);
    }

    @Nullable
    public T spawn(ServerWorld worldIn, @Nullable CompoundNBT compound, @Nullable ITextComponent customName, @Nullable PlayerEntity playerIn, BlockPos pos, SpawnReason reason, boolean p_220342_7_, boolean p_220342_8_) {
        T t = this.create(worldIn, compound, customName, playerIn, pos, reason, p_220342_7_, p_220342_8_);
        if (t != null) {
            worldIn.func_242417_l((Entity)t);
        }
        return t;
    }

    @Nullable
    public T create(ServerWorld worldIn, @Nullable CompoundNBT compound, @Nullable ITextComponent customName, @Nullable PlayerEntity playerIn, BlockPos pos, SpawnReason reason, boolean p_220349_7_, boolean p_220349_8_) {
        double d0;
        T t = this.create(worldIn);
        if (t == null) {
            return (T)((Entity)null);
        }
        if (p_220349_7_) {
            ((Entity)t).setPosition((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5);
            d0 = EntityType.func_208051_a(worldIn, pos, p_220349_8_, ((Entity)t).getBoundingBox());
        } else {
            d0 = 0.0;
        }
        ((Entity)t).setLocationAndAngles((double)pos.getX() + 0.5, (double)pos.getY() + d0, (double)pos.getZ() + 0.5, MathHelper.wrapDegrees(worldIn.rand.nextFloat() * 360.0f), 0.0f);
        if (t instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)t;
            mobentity.rotationYawHead = mobentity.rotationYaw;
            mobentity.renderYawOffset = mobentity.rotationYaw;
            mobentity.onInitialSpawn(worldIn, worldIn.getDifficultyForLocation(mobentity.getPosition()), reason, null, compound);
            mobentity.playAmbientSound();
        }
        if (customName != null && t instanceof LivingEntity) {
            ((Entity)t).setCustomName(customName);
        }
        EntityType.applyItemNBT(worldIn, playerIn, t, compound);
        return t;
    }

    protected static double func_208051_a(IWorldReader worldReader, BlockPos pos, boolean p_208051_2_, AxisAlignedBB p_208051_3_) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos);
        if (p_208051_2_) {
            axisalignedbb = axisalignedbb.expand(0.0, -1.0, 0.0);
        }
        Stream<VoxelShape> stream = worldReader.func_234867_d_(null, axisalignedbb, entity -> true);
        return 1.0 + VoxelShapes.getAllowedOffset(Direction.Axis.Y, p_208051_3_, stream, p_208051_2_ ? -2.0 : -1.0);
    }

    public static void applyItemNBT(World worldIn, @Nullable PlayerEntity player, @Nullable Entity spawnedEntity, @Nullable CompoundNBT itemNBT) {
        MinecraftServer minecraftserver;
        if (itemNBT != null && itemNBT.contains("EntityTag", 10) && (minecraftserver = worldIn.getServer()) != null && spawnedEntity != null && (worldIn.isRemote || !spawnedEntity.ignoreItemEntityData() || player != null && minecraftserver.getPlayerList().canSendCommands(player.getGameProfile()))) {
            CompoundNBT compoundnbt = spawnedEntity.writeWithoutTypeId(new CompoundNBT());
            UUID uuid = spawnedEntity.getUniqueID();
            compoundnbt.merge(itemNBT.getCompound("EntityTag"));
            spawnedEntity.setUniqueId(uuid);
            spawnedEntity.read(compoundnbt);
        }
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public boolean isSummonable() {
        return this.summonable;
    }

    public boolean isImmuneToFire() {
        return this.immuneToFire;
    }

    public boolean func_225437_d() {
        return this.field_225438_be;
    }

    public EntityClassification getClassification() {
        return this.classification;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.makeTranslationKey("entity", Registry.ENTITY_TYPE.getKey(this));
        }
        return this.translationKey;
    }

    public ITextComponent getName() {
        if (this.name == null) {
            this.name = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.name;
    }

    public String toString() {
        return this.getTranslationKey();
    }

    public ResourceLocation getLootTable() {
        if (this.lootTable == null) {
            ResourceLocation resourcelocation = Registry.ENTITY_TYPE.getKey(this);
            this.lootTable = new ResourceLocation(resourcelocation.getNamespace(), "entities/" + resourcelocation.getPath());
        }
        return this.lootTable;
    }

    public float getWidth() {
        return this.size.width;
    }

    public float getHeight() {
        return this.size.height;
    }

    @Nullable
    public T create(World worldIn) {
        return this.factory.create(this, worldIn);
    }

    @Nullable
    public static Entity create(int id, World worldIn) {
        return EntityType.create(worldIn, Registry.ENTITY_TYPE.getByValue(id));
    }

    public static Optional<Entity> loadEntityUnchecked(CompoundNBT compound, World worldIn) {
        return Util.acceptOrElse(EntityType.readEntityType(compound).map(entityType -> entityType.create(worldIn)), entity -> entity.read(compound), () -> LOGGER.warn("Skipping Entity with id {}", (Object)compound.getString("id")));
    }

    @Nullable
    private static Entity create(World worldIn, @Nullable EntityType<?> type) {
        return type == null ? null : (Entity)type.create(worldIn);
    }

    public AxisAlignedBB getBoundingBoxWithSizeApplied(double p_220328_1_, double p_220328_3_, double p_220328_5_) {
        float f = this.getWidth() / 2.0f;
        return new AxisAlignedBB(p_220328_1_ - (double)f, p_220328_3_, p_220328_5_ - (double)f, p_220328_1_ + (double)f, p_220328_3_ + (double)this.getHeight(), p_220328_5_ + (double)f);
    }

    public boolean func_233597_a_(BlockState p_233597_1_) {
        if (this.field_233593_bg_.contains(p_233597_1_.getBlock())) {
            return false;
        }
        if (this.immuneToFire || !p_233597_1_.isIn(BlockTags.FIRE) && !p_233597_1_.isIn(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLit(p_233597_1_) && !p_233597_1_.isIn(Blocks.LAVA)) {
            return p_233597_1_.isIn(Blocks.WITHER_ROSE) || p_233597_1_.isIn(Blocks.SWEET_BERRY_BUSH) || p_233597_1_.isIn(Blocks.CACTUS);
        }
        return true;
    }

    public EntitySize getSize() {
        return this.size;
    }

    public static Optional<EntityType<?>> readEntityType(CompoundNBT compound) {
        return Registry.ENTITY_TYPE.getOptional(new ResourceLocation(compound.getString("id")));
    }

    @Nullable
    public static Entity loadEntityAndExecute(CompoundNBT compound, World worldIn, Function<Entity, Entity> p_220335_2_) {
        return EntityType.loadEntity(compound, worldIn).map(p_220335_2_).map(p_220346_3_ -> {
            if (compound.contains("Passengers", 9)) {
                ListNBT listnbt = compound.getList("Passengers", 10);
                for (int i = 0; i < listnbt.size(); ++i) {
                    Entity entity = EntityType.loadEntityAndExecute(listnbt.getCompound(i), worldIn, p_220335_2_);
                    if (entity == null) continue;
                    entity.startRiding((Entity)p_220346_3_, true);
                }
            }
            return p_220346_3_;
        }).orElse(null);
    }

    private static Optional<Entity> loadEntity(CompoundNBT compound, World worldIn) {
        try {
            return EntityType.loadEntityUnchecked(compound, worldIn);
        }
        catch (RuntimeException runtimeexception) {
            LOGGER.warn("Exception loading entity: ", (Throwable)runtimeexception);
            return Optional.empty();
        }
    }

    public int func_233602_m_() {
        return this.defaultTrackingRange;
    }

    public int getUpdateFrequency() {
        return this.defaultUpdateInterval;
    }

    public boolean shouldSendVelocityUpdates() {
        return this != PLAYER && this != LLAMA_SPIT && this != WITHER && this != BAT && this != ITEM_FRAME && this != LEASH_KNOT && this != PAINTING && this != END_CRYSTAL && this != EVOKER_FANGS;
    }

    public boolean isContained(ITag<EntityType<?>> tagIn) {
        return tagIn.contains(this);
    }

    public static interface IFactory<T extends Entity> {
        public T create(EntityType<T> var1, World var2);
    }

    public static class Builder<T extends Entity> {
        private final IFactory<T> factory;
        private final EntityClassification classification;
        private ImmutableSet<Block> field_233603_c_ = ImmutableSet.of();
        private boolean serializable = true;
        private boolean summonable = true;
        private boolean immuneToFire;
        private boolean field_225436_f;
        private int field_233604_h_ = 5;
        private int field_233605_i_ = 3;
        private EntitySize size = EntitySize.flexible(0.6f, 1.8f);

        private Builder(IFactory<T> factoryIn, EntityClassification classificationIn) {
            this.factory = factoryIn;
            this.classification = classificationIn;
            this.field_225436_f = classificationIn == EntityClassification.CREATURE || classificationIn == EntityClassification.MISC;
        }

        public static <T extends Entity> Builder<T> create(IFactory<T> factoryIn, EntityClassification classificationIn) {
            return new Builder<T>(factoryIn, classificationIn);
        }

        public static <T extends Entity> Builder<T> create(EntityClassification classificationIn) {
            return new Builder<Entity>((type, world) -> null, classificationIn);
        }

        public Builder<T> size(float width, float height) {
            this.size = EntitySize.flexible(width, height);
            return this;
        }

        public Builder<T> disableSummoning() {
            this.summonable = false;
            return this;
        }

        public Builder<T> disableSerialization() {
            this.serializable = false;
            return this;
        }

        public Builder<T> immuneToFire() {
            this.immuneToFire = true;
            return this;
        }

        public Builder<T> func_233607_a_(Block ... p_233607_1_) {
            this.field_233603_c_ = ImmutableSet.copyOf(p_233607_1_);
            return this;
        }

        public Builder<T> func_225435_d() {
            this.field_225436_f = true;
            return this;
        }

        public Builder<T> trackingRange(int p_233606_1_) {
            this.field_233604_h_ = p_233606_1_;
            return this;
        }

        public Builder<T> func_233608_b_(int p_233608_1_) {
            this.field_233605_i_ = p_233608_1_;
            return this;
        }

        public EntityType<T> build(String id) {
            if (this.serializable) {
                Util.attemptDataFix(TypeReferences.ENTITY_TYPE, id);
            }
            return new EntityType<T>(this.factory, this.classification, this.serializable, this.summonable, this.immuneToFire, this.field_225436_f, this.field_233603_c_, this.size, this.field_233604_h_, this.field_233605_i_);
        }
    }
}

