/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.HoneyBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.PortalSize;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.PushReaction;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Entity
implements INameable,
ICommandSource {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger NEXT_ENTITY_ID = new AtomicInteger();
    private static final List<ItemStack> EMPTY_EQUIPMENT = Collections.emptyList();
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static double renderDistanceWeight = 1.0;
    private final EntityType<?> type;
    private int entityId = NEXT_ENTITY_ID.incrementAndGet();
    public boolean preventEntitySpawning;
    private final List<Entity> passengers = Lists.newArrayList();
    protected int rideCooldown;
    @Nullable
    private Entity ridingEntity;
    public boolean forceSpawn;
    public World world;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    private Vector3d positionVec;
    private BlockPos position;
    private Vector3d motion = Vector3d.ZERO;
    public float rotationYaw;
    public float rotationPitch;
    public float prevRotationYaw;
    public float prevRotationPitch;
    private AxisAlignedBB boundingBox = ZERO_AABB;
    protected boolean onGround;
    public boolean collidedHorizontally;
    public boolean collidedVertically;
    public boolean velocityChanged;
    protected Vector3d motionMultiplier = Vector3d.ZERO;
    public boolean removed;
    public float prevDistanceWalkedModified;
    public float distanceWalkedModified;
    public float distanceWalkedOnStepModified;
    public float fallDistance;
    private float nextStepDistance = 1.0f;
    private float nextFlap = 1.0f;
    public double lastTickPosX;
    public double lastTickPosY;
    public double lastTickPosZ;
    public float stepHeight;
    public boolean noClip;
    public float entityCollisionReduction;
    protected Random rand = new Random(0L);
    public int ticksExisted;
    private int fire = -this.getFireImmuneTicks();
    protected boolean inWater;
    protected Object2DoubleMap<ITag<Fluid>> eyesFluidLevel = new Object2DoubleArrayMap<ITag<Fluid>>(2);
    protected boolean eyesInWater;
    @Nullable
    protected ITag<Fluid> field_241335_O_;
    public int hurtResistantTime;
    protected boolean firstUpdate = true;
    protected final EntityDataManager dataManager;
    protected static final DataParameter<Byte> FLAGS = EntityDataManager.createKey(Entity.class, DataSerializers.BYTE);
    private static final DataParameter<Integer> AIR = EntityDataManager.createKey(Entity.class, DataSerializers.VARINT);
    private static final DataParameter<Optional<ITextComponent>> CUSTOM_NAME = EntityDataManager.createKey(Entity.class, DataSerializers.OPTIONAL_TEXT_COMPONENT);
    private static final DataParameter<Boolean> CUSTOM_NAME_VISIBLE = EntityDataManager.createKey(Entity.class, DataSerializers.BOOLEAN);
    private static final DataParameter<Boolean> SILENT = EntityDataManager.createKey(Entity.class, DataSerializers.BOOLEAN);
    private static final DataParameter<Boolean> NO_GRAVITY = EntityDataManager.createKey(Entity.class, DataSerializers.BOOLEAN);
    protected static final DataParameter<Pose> POSE = EntityDataManager.createKey(Entity.class, DataSerializers.POSE);
    public boolean addedToChunk;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    private boolean isLoaded;
    private Vector3d field_242272_av;
    public boolean ignoreFrustumCheck;
    public boolean isAirBorne;
    private int field_242273_aw;
    protected boolean inPortal;
    protected int portalCounter;
    protected BlockPos field_242271_ac;
    private boolean invulnerable;
    protected UUID entityUniqueID = MathHelper.getRandomUUID(new Random());
    protected String cachedUniqueIdString = this.entityUniqueID.toString();
    protected boolean glowing;
    private final Set<String> tags = Sets.newHashSet();
    private boolean isPositionDirty;
    private final double[] pistonDeltas = new double[]{0.0, 0.0, 0.0};
    private long pistonDeltasGameTime;
    private EntitySize size;
    private float eyeHeight;

    public Entity(EntityType<?> entityTypeIn, World worldIn) {
        this.type = entityTypeIn;
        this.world = worldIn;
        this.size = entityTypeIn.getSize();
        this.positionVec = Vector3d.ZERO;
        this.position = BlockPos.ZERO;
        this.field_242272_av = Vector3d.ZERO;
        this.setPosition(0.0, 0.0, 0.0);
        this.dataManager = new EntityDataManager(this);
        this.dataManager.register(FLAGS, (byte)0);
        this.dataManager.register(AIR, this.getMaxAir());
        this.dataManager.register(CUSTOM_NAME_VISIBLE, false);
        this.dataManager.register(CUSTOM_NAME, Optional.empty());
        this.dataManager.register(SILENT, false);
        this.dataManager.register(NO_GRAVITY, false);
        this.dataManager.register(POSE, Pose.STANDING);
        this.registerData();
        this.eyeHeight = this.getEyeHeight(Pose.STANDING, this.size);
    }

    public boolean func_242278_a(BlockPos p_242278_1_, BlockState p_242278_2_) {
        VoxelShape voxelshape = p_242278_2_.getCollisionShape(this.world, p_242278_1_, ISelectionContext.forEntity(this));
        VoxelShape voxelshape1 = voxelshape.withOffset(p_242278_1_.getX(), p_242278_1_.getY(), p_242278_1_.getZ());
        return VoxelShapes.compare(voxelshape1, VoxelShapes.create(this.getBoundingBox()), IBooleanFunction.AND);
    }

    public int getTeamColor() {
        Team team = this.getTeam();
        return team != null && team.getColor().getColor() != null ? team.getColor().getColor() : 0xFFFFFF;
    }

    public boolean isSpectator() {
        return false;
    }

    public final void detach() {
        if (this.isBeingRidden()) {
            this.removePassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void setPacketCoordinates(double x, double y, double z) {
        this.func_242277_a(new Vector3d(x, y, z));
    }

    public void func_242277_a(Vector3d p_242277_1_) {
        this.field_242272_av = p_242277_1_;
    }

    public Vector3d func_242274_V() {
        return this.field_242272_av;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int id) {
        this.entityId = id;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String tag) {
        return this.tags.size() >= 1024 ? false : this.tags.add(tag);
    }

    public boolean removeTag(String tag) {
        return this.tags.remove(tag);
    }

    public void onKillCommand() {
        this.remove();
    }

    protected abstract void registerData();

    public EntityDataManager getDataManager() {
        return this.dataManager;
    }

    public boolean equals(Object p_equals_1_) {
        if (p_equals_1_ instanceof Entity) {
            return ((Entity)p_equals_1_).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    protected void preparePlayerToSpawn() {
        if (this.world != null) {
            for (double d0 = this.getPosY(); d0 > 0.0 && d0 < 256.0; d0 += 1.0) {
                this.setPosition(this.getPosX(), d0, this.getPosZ());
                if (this.world.hasNoCollisions(this)) break;
            }
            this.setMotion(Vector3d.ZERO);
            this.rotationPitch = 0.0f;
        }
    }

    public void remove() {
        this.removed = true;
    }

    public void setPose(Pose poseIn) {
        this.dataManager.set(POSE, poseIn);
    }

    public Pose getPose() {
        return this.dataManager.get(POSE);
    }

    public boolean isEntityInRange(Entity entity, double distance) {
        double d0 = entity.positionVec.x - this.positionVec.x;
        double d1 = entity.positionVec.y - this.positionVec.y;
        double d2 = entity.positionVec.z - this.positionVec.z;
        return d0 * d0 + d1 * d1 + d2 * d2 < distance * distance;
    }

    protected void setRotation(float yaw, float pitch) {
        this.rotationYaw = yaw % 360.0f;
        this.rotationPitch = pitch % 360.0f;
    }

    public void setPosition(double x, double y, double z) {
        this.setRawPosition(x, y, z);
        this.setBoundingBox(this.size.func_242285_a(x, y, z));
    }

    protected void recenterBoundingBox() {
        this.setPosition(this.positionVec.x, this.positionVec.y, this.positionVec.z);
    }

    public void rotateTowards(double yaw, double pitch) {
        double d0 = pitch * 0.15;
        double d1 = yaw * 0.15;
        this.rotationPitch = (float)((double)this.rotationPitch + d0);
        this.rotationYaw = (float)((double)this.rotationYaw + d1);
        this.rotationPitch = MathHelper.clamp(this.rotationPitch, -90.0f, 90.0f);
        this.prevRotationPitch = (float)((double)this.prevRotationPitch + d0);
        this.prevRotationYaw = (float)((double)this.prevRotationYaw + d1);
        this.prevRotationPitch = MathHelper.clamp(this.prevRotationPitch, -90.0f, 90.0f);
        if (this.ridingEntity != null) {
            this.ridingEntity.applyOrientationToEntity(this);
        }
    }

    public void tick() {
        if (!this.world.isRemote) {
            this.setFlag(6, this.isGlowing());
        }
        this.baseTick();
    }

    public void baseTick() {
        this.world.getProfiler().startSection("entityBaseTick");
        if (this.isPassenger() && this.getRidingEntity().removed) {
            this.stopRiding();
        }
        if (this.rideCooldown > 0) {
            --this.rideCooldown;
        }
        this.prevDistanceWalkedModified = this.distanceWalkedModified;
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        this.updatePortal();
        if (this.func_230269_aK_()) {
            this.func_233569_aL_();
        }
        this.func_233566_aG_();
        this.updateEyesInWater();
        this.updateSwimming();
        if (this.world.isRemote) {
            this.extinguish();
        } else if (this.fire > 0) {
            if (this.isImmuneToFire()) {
                this.forceFireTicks(this.fire - 4);
                if (this.fire < 0) {
                    this.extinguish();
                }
            } else {
                if (this.fire % 20 == 0 && !this.isInLava()) {
                    this.attackEntityFrom(DamageSource.ON_FIRE, 1.0f);
                }
                this.forceFireTicks(this.fire - 1);
            }
        }
        if (this.isInLava()) {
            this.setOnFireFromLava();
            this.fallDistance *= 0.5f;
        }
        if (this.getPosY() < -64.0) {
            this.outOfWorld();
        }
        if (!this.world.isRemote) {
            this.setFlag(0, this.fire > 0);
        }
        this.firstUpdate = false;
        this.world.getProfiler().endSection();
    }

    public void func_242279_ag() {
        this.field_242273_aw = this.getPortalCooldown();
    }

    public boolean func_242280_ah() {
        return this.field_242273_aw > 0;
    }

    protected void decrementTimeUntilPortal() {
        if (this.func_242280_ah()) {
            --this.field_242273_aw;
        }
    }

    public int getMaxInPortalTime() {
        return 0;
    }

    protected void setOnFireFromLava() {
        if (!this.isImmuneToFire()) {
            this.setFire(15);
            this.attackEntityFrom(DamageSource.LAVA, 4.0f);
        }
    }

    public void setFire(int seconds) {
        int i = seconds * 20;
        if (this instanceof LivingEntity) {
            i = ProtectionEnchantment.getFireTimeForEntity((LivingEntity)this, i);
        }
        if (this.fire < i) {
            this.forceFireTicks(i);
        }
    }

    public void forceFireTicks(int ticks) {
        this.fire = ticks;
    }

    public int getFireTimer() {
        return this.fire;
    }

    public void extinguish() {
        this.forceFireTicks(0);
    }

    protected void outOfWorld() {
        this.remove();
    }

    public boolean isOffsetPositionInLiquid(double x, double y, double z) {
        return this.isLiquidPresentInAABB(this.getBoundingBox().offset(x, y, z));
    }

    private boolean isLiquidPresentInAABB(AxisAlignedBB bb) {
        return this.world.hasNoCollisions(this, bb) && !this.world.containsAnyLiquid(bb);
    }

    public void setOnGround(boolean grounded) {
        this.onGround = grounded;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void move(MoverType typeIn, Vector3d pos) {
        if (this.noClip) {
            this.setBoundingBox(this.getBoundingBox().offset(pos));
            this.resetPositionToBB();
        } else {
            Vector3d vector3d;
            if (typeIn == MoverType.PISTON && (pos = this.handlePistonMovement(pos)).equals(Vector3d.ZERO)) {
                return;
            }
            this.world.getProfiler().startSection("move");
            if (this.motionMultiplier.lengthSquared() > 1.0E-7) {
                pos = pos.mul(this.motionMultiplier);
                this.motionMultiplier = Vector3d.ZERO;
                this.setMotion(Vector3d.ZERO);
            }
            if ((vector3d = this.getAllowedMovement(pos = this.maybeBackOffFromEdge(pos, typeIn))).lengthSquared() > 1.0E-7) {
                this.setBoundingBox(this.getBoundingBox().offset(vector3d));
                this.resetPositionToBB();
            }
            this.world.getProfiler().endSection();
            this.world.getProfiler().startSection("rest");
            this.collidedHorizontally = !MathHelper.epsilonEquals(pos.x, vector3d.x) || !MathHelper.epsilonEquals(pos.z, vector3d.z);
            this.collidedVertically = pos.y != vector3d.y;
            this.onGround = this.collidedVertically && pos.y < 0.0;
            BlockPos blockpos = this.getOnPosition();
            BlockState blockstate = this.world.getBlockState(blockpos);
            this.updateFallState(vector3d.y, this.onGround, blockstate, blockpos);
            Vector3d vector3d1 = this.getMotion();
            if (pos.x != vector3d.x) {
                this.setMotion(0.0, vector3d1.y, vector3d1.z);
            }
            if (pos.z != vector3d.z) {
                this.setMotion(vector3d1.x, vector3d1.y, 0.0);
            }
            Block block = blockstate.getBlock();
            if (pos.y != vector3d.y) {
                block.onLanded(this.world, this);
            }
            if (this.onGround && !this.isSteppingCarefully()) {
                block.onEntityWalk(this.world, blockpos, this);
            }
            if (this.canTriggerWalking() && !this.isPassenger()) {
                double d0 = vector3d.x;
                double d1 = vector3d.y;
                double d2 = vector3d.z;
                if (!block.isIn(BlockTags.CLIMBABLE)) {
                    d1 = 0.0;
                }
                this.distanceWalkedModified = (float)((double)this.distanceWalkedModified + (double)MathHelper.sqrt(Entity.horizontalMag(vector3d)) * 0.6);
                this.distanceWalkedOnStepModified = (float)((double)this.distanceWalkedOnStepModified + (double)MathHelper.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 0.6);
                if (this.distanceWalkedOnStepModified > this.nextStepDistance && !blockstate.isAir()) {
                    this.nextStepDistance = this.determineNextStepDistance();
                    if (this.isInWater()) {
                        Entity entity = this.isBeingRidden() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
                        float f = entity == this ? 0.35f : 0.4f;
                        Vector3d vector3d2 = entity.getMotion();
                        float f1 = MathHelper.sqrt(vector3d2.x * vector3d2.x * (double)0.2f + vector3d2.y * vector3d2.y + vector3d2.z * vector3d2.z * (double)0.2f) * f;
                        if (f1 > 1.0f) {
                            f1 = 1.0f;
                        }
                        this.playSwimSound(f1);
                    } else {
                        this.playStepSound(blockpos, blockstate);
                    }
                } else if (this.distanceWalkedOnStepModified > this.nextFlap && this.makeFlySound() && blockstate.isAir()) {
                    this.nextFlap = this.playFlySound(this.distanceWalkedOnStepModified);
                }
            }
            try {
                this.doBlockCollisions();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity being checked for collision");
                this.fillCrashReport(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            float f2 = this.getSpeedFactor();
            this.setMotion(this.getMotion().mul(f2, 1.0, f2));
            if (this.world.getStatesInArea(this.getBoundingBox().shrink(0.001)).noneMatch(p_233572_0_ -> p_233572_0_.isIn(BlockTags.FIRE) || p_233572_0_.isIn(Blocks.LAVA)) && this.fire <= 0) {
                this.forceFireTicks(-this.getFireImmuneTicks());
            }
            if (this.isInWaterRainOrBubbleColumn() && this.isBurning()) {
                this.playSound(SoundEvents.ENTITY_GENERIC_EXTINGUISH_FIRE, 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                this.forceFireTicks(-this.getFireImmuneTicks());
            }
            this.world.getProfiler().endSection();
        }
    }

    protected BlockPos getOnPosition() {
        BlockPos blockpos1;
        BlockState blockstate;
        Block block;
        int k;
        int j;
        int i = MathHelper.floor(this.positionVec.x);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.floor(this.positionVec.y - (double)0.2f), k = MathHelper.floor(this.positionVec.z));
        if (this.world.getBlockState(blockpos).isAir() && ((block = (blockstate = this.world.getBlockState(blockpos1 = blockpos.down())).getBlock()).isIn(BlockTags.FENCES) || block.isIn(BlockTags.WALLS) || block instanceof FenceGateBlock)) {
            return blockpos1;
        }
        return blockpos;
    }

    protected float getJumpFactor() {
        float f = this.world.getBlockState(this.getPosition()).getBlock().getJumpFactor();
        float f1 = this.world.getBlockState(this.getPositionUnderneath()).getBlock().getJumpFactor();
        return (double)f == 1.0 ? f1 : f;
    }

    protected float getSpeedFactor() {
        Block block = this.world.getBlockState(this.getPosition()).getBlock();
        float f = block.getSpeedFactor();
        if (block != Blocks.WATER && block != Blocks.BUBBLE_COLUMN) {
            return (double)f == 1.0 ? this.world.getBlockState(this.getPositionUnderneath()).getBlock().getSpeedFactor() : f;
        }
        return f;
    }

    protected BlockPos getPositionUnderneath() {
        return new BlockPos(this.positionVec.x, this.getBoundingBox().minY - 0.5000001, this.positionVec.z);
    }

    protected Vector3d maybeBackOffFromEdge(Vector3d vec, MoverType mover) {
        return vec;
    }

    protected Vector3d handlePistonMovement(Vector3d pos) {
        if (pos.lengthSquared() <= 1.0E-7) {
            return pos;
        }
        long i = this.world.getGameTime();
        if (i != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = i;
        }
        if (pos.x != 0.0) {
            double d2 = this.calculatePistonDeltas(Direction.Axis.X, pos.x);
            return Math.abs(d2) <= (double)1.0E-5f ? Vector3d.ZERO : new Vector3d(d2, 0.0, 0.0);
        }
        if (pos.y != 0.0) {
            double d1 = this.calculatePistonDeltas(Direction.Axis.Y, pos.y);
            return Math.abs(d1) <= (double)1.0E-5f ? Vector3d.ZERO : new Vector3d(0.0, d1, 0.0);
        }
        if (pos.z != 0.0) {
            double d0 = this.calculatePistonDeltas(Direction.Axis.Z, pos.z);
            return Math.abs(d0) <= (double)1.0E-5f ? Vector3d.ZERO : new Vector3d(0.0, 0.0, d0);
        }
        return Vector3d.ZERO;
    }

    private double calculatePistonDeltas(Direction.Axis axis, double distance) {
        int i = axis.ordinal();
        double d0 = MathHelper.clamp(distance + this.pistonDeltas[i], -0.51, 0.51);
        distance = d0 - this.pistonDeltas[i];
        this.pistonDeltas[i] = d0;
        return distance;
    }

    private Vector3d getAllowedMovement(Vector3d vec) {
        boolean flag3;
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        ISelectionContext iselectioncontext = ISelectionContext.forEntity(this);
        VoxelShape voxelshape = this.world.getWorldBorder().getShape();
        Stream<Object> stream = VoxelShapes.compare(voxelshape, VoxelShapes.create(axisalignedbb.shrink(1.0E-7)), IBooleanFunction.AND) ? Stream.empty() : Stream.of(voxelshape);
        Stream<VoxelShape> stream1 = this.world.func_230318_c_(this, axisalignedbb.expand(vec), p_233561_0_ -> true);
        ReuseableStream<VoxelShape> reuseablestream = new ReuseableStream<VoxelShape>(Stream.concat(stream1, stream));
        Vector3d vector3d = vec.lengthSquared() == 0.0 ? vec : Entity.collideBoundingBoxHeuristically(this, vec, axisalignedbb, this.world, iselectioncontext, reuseablestream);
        boolean flag = vec.x != vector3d.x;
        boolean flag1 = vec.y != vector3d.y;
        boolean flag2 = vec.z != vector3d.z;
        boolean bl = flag3 = this.onGround || flag1 && vec.y < 0.0;
        if (this.stepHeight > 0.0f && flag3 && (flag || flag2)) {
            Vector3d vector3d3;
            Vector3d vector3d1 = Entity.collideBoundingBoxHeuristically(this, new Vector3d(vec.x, this.stepHeight, vec.z), axisalignedbb, this.world, iselectioncontext, reuseablestream);
            Vector3d vector3d2 = Entity.collideBoundingBoxHeuristically(this, new Vector3d(0.0, this.stepHeight, 0.0), axisalignedbb.expand(vec.x, 0.0, vec.z), this.world, iselectioncontext, reuseablestream);
            if (vector3d2.y < (double)this.stepHeight && Entity.horizontalMag(vector3d3 = Entity.collideBoundingBoxHeuristically(this, new Vector3d(vec.x, 0.0, vec.z), axisalignedbb.offset(vector3d2), this.world, iselectioncontext, reuseablestream).add(vector3d2)) > Entity.horizontalMag(vector3d1)) {
                vector3d1 = vector3d3;
            }
            if (Entity.horizontalMag(vector3d1) > Entity.horizontalMag(vector3d)) {
                return vector3d1.add(Entity.collideBoundingBoxHeuristically(this, new Vector3d(0.0, -vector3d1.y + vec.y, 0.0), axisalignedbb.offset(vector3d1), this.world, iselectioncontext, reuseablestream));
            }
        }
        return vector3d;
    }

    public static double horizontalMag(Vector3d vec) {
        return vec.x * vec.x + vec.z * vec.z;
    }

    public static Vector3d collideBoundingBoxHeuristically(@Nullable Entity entity, Vector3d vec, AxisAlignedBB collisionBox, World world, ISelectionContext context, ReuseableStream<VoxelShape> potentialHits) {
        boolean flag2;
        boolean flag = vec.x == 0.0;
        boolean flag1 = vec.y == 0.0;
        boolean bl = flag2 = vec.z == 0.0;
        if (!(flag && flag1 || flag && flag2 || flag1 && flag2)) {
            ReuseableStream<VoxelShape> reuseablestream = new ReuseableStream<VoxelShape>(Stream.concat(potentialHits.createStream(), world.getCollisionShapes(entity, collisionBox.expand(vec))));
            return Entity.collideBoundingBox(vec, collisionBox, reuseablestream);
        }
        return Entity.getAllowedMovement(vec, collisionBox, world, context, potentialHits);
    }

    public static Vector3d collideBoundingBox(Vector3d vec, AxisAlignedBB collisionBox, ReuseableStream<VoxelShape> potentialHits) {
        boolean flag;
        double d0 = vec.x;
        double d1 = vec.y;
        double d2 = vec.z;
        if (d1 != 0.0 && (d1 = VoxelShapes.getAllowedOffset(Direction.Axis.Y, collisionBox, potentialHits.createStream(), d1)) != 0.0) {
            collisionBox = collisionBox.offset(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.getAllowedOffset(Direction.Axis.Z, collisionBox, potentialHits.createStream(), d2)) != 0.0) {
            collisionBox = collisionBox.offset(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.getAllowedOffset(Direction.Axis.X, collisionBox, potentialHits.createStream(), d0);
            if (!flag && d0 != 0.0) {
                collisionBox = collisionBox.offset(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.getAllowedOffset(Direction.Axis.Z, collisionBox, potentialHits.createStream(), d2);
        }
        return new Vector3d(d0, d1, d2);
    }

    public static Vector3d getAllowedMovement(Vector3d vec, AxisAlignedBB collisionBox, IWorldReader worldIn, ISelectionContext selectionContext, ReuseableStream<VoxelShape> potentialHits) {
        boolean flag;
        double d0 = vec.x;
        double d1 = vec.y;
        double d2 = vec.z;
        if (d1 != 0.0 && (d1 = VoxelShapes.getAllowedOffset(Direction.Axis.Y, collisionBox, worldIn, d1, selectionContext, potentialHits.createStream())) != 0.0) {
            collisionBox = collisionBox.offset(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.getAllowedOffset(Direction.Axis.Z, collisionBox, worldIn, d2, selectionContext, potentialHits.createStream())) != 0.0) {
            collisionBox = collisionBox.offset(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.getAllowedOffset(Direction.Axis.X, collisionBox, worldIn, d0, selectionContext, potentialHits.createStream());
            if (!flag && d0 != 0.0) {
                collisionBox = collisionBox.offset(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.getAllowedOffset(Direction.Axis.Z, collisionBox, worldIn, d2, selectionContext, potentialHits.createStream());
        }
        return new Vector3d(d0, d1, d2);
    }

    protected float determineNextStepDistance() {
        return (int)this.distanceWalkedOnStepModified + 1;
    }

    public void resetPositionToBB() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        this.setRawPosition((axisalignedbb.minX + axisalignedbb.maxX) / 2.0, axisalignedbb.minY, (axisalignedbb.minZ + axisalignedbb.maxZ) / 2.0);
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.ENTITY_GENERIC_SWIM;
    }

    protected SoundEvent getSplashSound() {
        return SoundEvents.ENTITY_GENERIC_SPLASH;
    }

    protected SoundEvent getHighspeedSplashSound() {
        return SoundEvents.ENTITY_GENERIC_SPLASH;
    }

    protected void doBlockCollisions() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        BlockPos blockpos = new BlockPos(axisalignedbb.minX + 0.001, axisalignedbb.minY + 0.001, axisalignedbb.minZ + 0.001);
        BlockPos blockpos1 = new BlockPos(axisalignedbb.maxX - 0.001, axisalignedbb.maxY - 0.001, axisalignedbb.maxZ - 0.001);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        if (this.world.isAreaLoaded(blockpos, blockpos1)) {
            for (int i = blockpos.getX(); i <= blockpos1.getX(); ++i) {
                for (int j = blockpos.getY(); j <= blockpos1.getY(); ++j) {
                    for (int k = blockpos.getZ(); k <= blockpos1.getZ(); ++k) {
                        blockpos$mutable.setPos(i, j, k);
                        BlockState blockstate = this.world.getBlockState(blockpos$mutable);
                        try {
                            blockstate.onEntityCollision(this.world, blockpos$mutable, this);
                            this.onInsideBlock(blockstate);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being collided with");
                            CrashReportCategory.addBlockInfo(crashreportcategory, blockpos$mutable, blockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void onInsideBlock(BlockState state) {
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        if (!blockIn.getMaterial().isLiquid()) {
            BlockState blockstate = this.world.getBlockState(pos.up());
            SoundType soundtype = blockstate.isIn(Blocks.SNOW) ? blockstate.getSoundType() : blockIn.getSoundType();
            this.playSound(soundtype.getStepSound(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
        }
    }

    protected void playSwimSound(float volume) {
        this.playSound(this.getSwimSound(), volume, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
    }

    protected float playFlySound(float volume) {
        return 0.0f;
    }

    protected boolean makeFlySound() {
        return false;
    }

    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        if (!this.isSilent()) {
            this.world.playSound(null, this.getPosX(), this.getPosY(), this.getPosZ(), soundIn, this.getSoundCategory(), volume, pitch);
        }
    }

    public boolean isSilent() {
        return this.dataManager.get(SILENT);
    }

    public void setSilent(boolean isSilent) {
        this.dataManager.set(SILENT, isSilent);
    }

    public boolean hasNoGravity() {
        return this.dataManager.get(NO_GRAVITY);
    }

    public void setNoGravity(boolean noGravity) {
        this.dataManager.set(NO_GRAVITY, noGravity);
    }

    protected boolean canTriggerWalking() {
        return true;
    }

    protected void updateFallState(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (onGroundIn) {
            if (this.fallDistance > 0.0f) {
                state.getBlock().onFallenUpon(this.world, pos, this, this.fallDistance);
            }
            this.fallDistance = 0.0f;
        } else if (y < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - y);
        }
    }

    public boolean isImmuneToFire() {
        return this.getType().isImmuneToFire();
    }

    public boolean onLivingFall(float distance, float damageMultiplier) {
        if (this.isBeingRidden()) {
            for (Entity entity : this.getPassengers()) {
                entity.onLivingFall(distance, damageMultiplier);
            }
        }
        return false;
    }

    public boolean isInWater() {
        return this.inWater;
    }

    private boolean isInRain() {
        BlockPos blockpos = this.getPosition();
        return this.world.isRainingAt(blockpos) || this.world.isRainingAt(new BlockPos((double)blockpos.getX(), this.getBoundingBox().maxY, (double)blockpos.getZ()));
    }

    private boolean isInBubbleColumn() {
        return this.world.getBlockState(this.getPosition()).isIn(Blocks.BUBBLE_COLUMN);
    }

    public boolean isWet() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInWaterRainOrBubbleColumn() {
        return this.isInWater() || this.isInRain() || this.isInBubbleColumn();
    }

    public boolean isInWaterOrBubbleColumn() {
        return this.isInWater() || this.isInBubbleColumn();
    }

    public boolean canSwim() {
        return this.eyesInWater && this.isInWater();
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.canSwim() && !this.isPassenger());
        }
    }

    protected boolean func_233566_aG_() {
        this.eyesFluidLevel.clear();
        this.func_233567_aH_();
        double d0 = this.world.getDimensionType().isUltrawarm() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.handleFluidAcceleration(FluidTags.LAVA, d0);
        return this.isInWater() || flag;
    }

    void func_233567_aH_() {
        if (this.getRidingEntity() instanceof BoatEntity) {
            this.inWater = false;
        } else if (this.handleFluidAcceleration(FluidTags.WATER, 0.014)) {
            if (!this.inWater && !this.firstUpdate) {
                this.doWaterSplashEffect();
            }
            this.fallDistance = 0.0f;
            this.inWater = true;
            this.extinguish();
        } else {
            this.inWater = false;
        }
    }

    private void updateEyesInWater() {
        BoatEntity boatentity;
        this.eyesInWater = this.areEyesInFluid(FluidTags.WATER);
        this.field_241335_O_ = null;
        double d0 = this.getPosYEye() - 0.1111111119389534;
        Entity entity = this.getRidingEntity();
        if (entity instanceof BoatEntity && !(boatentity = (BoatEntity)entity).canSwim() && boatentity.getBoundingBox().maxY >= d0 && boatentity.getBoundingBox().minY <= d0) {
            return;
        }
        BlockPos blockpos = new BlockPos(this.getPosX(), d0, this.getPosZ());
        FluidState fluidstate = this.world.getFluidState(blockpos);
        for (ITag iTag : FluidTags.getAllTags()) {
            if (!fluidstate.isTagged(iTag)) continue;
            double d1 = (float)blockpos.getY() + fluidstate.getActualHeight(this.world, blockpos);
            if (d1 > d0) {
                this.field_241335_O_ = iTag;
            }
            return;
        }
    }

    protected void doWaterSplashEffect() {
        Entity entity = this.isBeingRidden() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
        float f = entity == this ? 0.2f : 0.9f;
        Vector3d vector3d = entity.getMotion();
        float f1 = MathHelper.sqrt(vector3d.x * vector3d.x * (double)0.2f + vector3d.y * vector3d.y + vector3d.z * vector3d.z * (double)0.2f) * f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        if ((double)f1 < 0.25) {
            this.playSound(this.getSplashSound(), f1, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getHighspeedSplashSound(), f1, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
        }
        float f2 = MathHelper.floor(this.getPosY());
        int i = 0;
        while ((float)i < 1.0f + this.size.width * 20.0f) {
            double d0 = (this.rand.nextDouble() * 2.0 - 1.0) * (double)this.size.width;
            double d1 = (this.rand.nextDouble() * 2.0 - 1.0) * (double)this.size.width;
            this.world.addParticle(ParticleTypes.BUBBLE, this.getPosX() + d0, f2 + 1.0f, this.getPosZ() + d1, vector3d.x, vector3d.y - this.rand.nextDouble() * (double)0.2f, vector3d.z);
            ++i;
        }
        int j = 0;
        while ((float)j < 1.0f + this.size.width * 20.0f) {
            double d2 = (this.rand.nextDouble() * 2.0 - 1.0) * (double)this.size.width;
            double d3 = (this.rand.nextDouble() * 2.0 - 1.0) * (double)this.size.width;
            this.world.addParticle(ParticleTypes.SPLASH, this.getPosX() + d2, f2 + 1.0f, this.getPosZ() + d3, vector3d.x, vector3d.y, vector3d.z);
            ++j;
        }
    }

    protected BlockState getStateBelow() {
        return this.world.getBlockState(this.getOnPosition());
    }

    public boolean func_230269_aK_() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void func_233569_aL_() {
        int k;
        int j;
        int i = MathHelper.floor(this.getPosX());
        BlockPos blockpos = new BlockPos(i, j = MathHelper.floor(this.getPosY() - (double)0.2f), k = MathHelper.floor(this.getPosZ()));
        BlockState blockstate = this.world.getBlockState(blockpos);
        if (blockstate.getRenderType() != BlockRenderType.INVISIBLE) {
            Vector3d vector3d = this.getMotion();
            this.world.addParticle(new BlockParticleData(ParticleTypes.BLOCK, blockstate), this.getPosX() + (this.rand.nextDouble() - 0.5) * (double)this.size.width, this.getPosY() + 0.1, this.getPosZ() + (this.rand.nextDouble() - 0.5) * (double)this.size.width, vector3d.x * -4.0, 1.5, vector3d.z * -4.0);
        }
    }

    public boolean areEyesInFluid(ITag<Fluid> tagIn) {
        return this.field_241335_O_ == tagIn;
    }

    public boolean isInLava() {
        return !this.firstUpdate && this.eyesFluidLevel.getDouble(FluidTags.LAVA) > 0.0;
    }

    public void moveRelative(float p_213309_1_, Vector3d relative) {
        Vector3d vector3d = Entity.getAbsoluteMotion(relative, p_213309_1_, this.rotationYaw);
        this.setMotion(this.getMotion().add(vector3d));
    }

    private static Vector3d getAbsoluteMotion(Vector3d relative, float p_213299_1_, float facing) {
        double d0 = relative.lengthSquared();
        if (d0 < 1.0E-7) {
            return Vector3d.ZERO;
        }
        Vector3d vector3d = (d0 > 1.0 ? relative.normalize() : relative).scale(p_213299_1_);
        float f = MathHelper.sin(facing * ((float)Math.PI / 180));
        float f1 = MathHelper.cos(facing * ((float)Math.PI / 180));
        return new Vector3d(vector3d.x * (double)f1 - vector3d.z * (double)f, vector3d.y, vector3d.z * (double)f1 + vector3d.x * (double)f);
    }

    public float getBrightness() {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(this.getPosX(), 0.0, this.getPosZ());
        if (this.world.isBlockLoaded(blockpos$mutable)) {
            blockpos$mutable.setY(MathHelper.floor(this.getPosYEye()));
            return this.world.getBrightness(blockpos$mutable);
        }
        return 0.0f;
    }

    public void setWorld(World worldIn) {
        this.world = worldIn;
    }

    public void setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        this.func_242281_f(x, y, z);
        this.rotationYaw = yaw % 360.0f;
        this.rotationPitch = MathHelper.clamp(pitch, -90.0f, 90.0f) % 360.0f;
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    public void func_242281_f(double p_242281_1_, double p_242281_3_, double p_242281_5_) {
        double d0 = MathHelper.clamp(p_242281_1_, -3.0E7, 3.0E7);
        double d1 = MathHelper.clamp(p_242281_5_, -3.0E7, 3.0E7);
        this.prevPosX = d0;
        this.prevPosY = p_242281_3_;
        this.prevPosZ = d1;
        this.setPosition(d0, p_242281_3_, d1);
    }

    public void moveForced(Vector3d vec) {
        this.moveForced(vec.x, vec.y, vec.z);
    }

    public void moveForced(double x, double y, double z) {
        this.setLocationAndAngles(x, y, z, this.rotationYaw, this.rotationPitch);
    }

    public void moveToBlockPosAndAngles(BlockPos pos, float rotationYawIn, float rotationPitchIn) {
        this.setLocationAndAngles((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, rotationYawIn, rotationPitchIn);
    }

    public void setLocationAndAngles(double x, double y, double z, float yaw, float pitch) {
        this.forceSetPosition(x, y, z);
        this.rotationYaw = yaw;
        this.rotationPitch = pitch;
        this.recenterBoundingBox();
    }

    public void forceSetPosition(double x, double y, double z) {
        this.setRawPosition(x, y, z);
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.lastTickPosX = x;
        this.lastTickPosY = y;
        this.lastTickPosZ = z;
    }

    public float getDistance(Entity entityIn) {
        float f = (float)(this.getPosX() - entityIn.getPosX());
        float f1 = (float)(this.getPosY() - entityIn.getPosY());
        float f2 = (float)(this.getPosZ() - entityIn.getPosZ());
        return MathHelper.sqrt(f * f + f1 * f1 + f2 * f2);
    }

    public double getDistanceSq(double x, double y, double z) {
        double d0 = this.getPosX() - x;
        double d1 = this.getPosY() - y;
        double d2 = this.getPosZ() - z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double getDistanceSq(Entity entityIn) {
        return this.getDistanceSq(entityIn.getPositionVec());
    }

    public double getDistanceSq(Vector3d vec) {
        double d0 = this.getPosX() - vec.x;
        double d1 = this.getPosY() - vec.y;
        double d2 = this.getPosZ() - vec.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void onCollideWithPlayer(PlayerEntity entityIn) {
    }

    public void applyEntityCollision(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.isRidingSameEntity(entityIn) && !entityIn.noClip && !this.noClip && (d2 = MathHelper.absMax(d0 = entityIn.getPosX() - this.getPosX(), d1 = entityIn.getPosZ() - this.getPosZ())) >= (double)0.01f) {
            d2 = MathHelper.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.entityCollisionReduction);
            d1 *= (double)(1.0f - this.entityCollisionReduction);
            if (!this.isBeingRidden()) {
                this.addVelocity(-d0, 0.0, -d1);
            }
            if (!entityIn.isBeingRidden()) {
                entityIn.addVelocity(d0, 0.0, d1);
            }
        }
    }

    public void addVelocity(double x, double y, double z) {
        this.setMotion(this.getMotion().add(x, y, z));
        this.isAirBorne = true;
    }

    protected void markVelocityChanged() {
        this.velocityChanged = true;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markVelocityChanged();
        return false;
    }

    public final Vector3d getLook(float partialTicks) {
        return this.getVectorForRotation(this.getPitch(partialTicks), this.getYaw(partialTicks));
    }

    public float getPitch(float partialTicks) {
        return partialTicks == 1.0f ? this.rotationPitch : MathHelper.lerp(partialTicks, this.prevRotationPitch, this.rotationPitch);
    }

    public float getYaw(float partialTicks) {
        return partialTicks == 1.0f ? this.rotationYaw : MathHelper.lerp(partialTicks, this.prevRotationYaw, this.rotationYaw);
    }

    protected final Vector3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.cos(f1);
        float f3 = MathHelper.sin(f1);
        float f4 = MathHelper.cos(f);
        float f5 = MathHelper.sin(f);
        return new Vector3d(f3 * f4, -f5, f2 * f4);
    }

    public final Vector3d getUpVector(float partialTicks) {
        return this.calculateUpVector(this.getPitch(partialTicks), this.getYaw(partialTicks));
    }

    protected final Vector3d calculateUpVector(float pitch, float yaw) {
        return this.getVectorForRotation(pitch - 90.0f, yaw);
    }

    public final Vector3d getEyePosition(float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vector3d(this.getPosX(), this.getPosYEye(), this.getPosZ());
        }
        double d0 = MathHelper.lerp((double)partialTicks, this.prevPosX, this.getPosX());
        double d1 = MathHelper.lerp((double)partialTicks, this.prevPosY, this.getPosY()) + (double)this.getEyeHeight();
        double d2 = MathHelper.lerp((double)partialTicks, this.prevPosZ, this.getPosZ());
        return new Vector3d(d0, d1, d2);
    }

    public Vector3d func_241842_k(float p_241842_1_) {
        return this.getEyePosition(p_241842_1_);
    }

    public final Vector3d func_242282_l(float p_242282_1_) {
        double d0 = MathHelper.lerp((double)p_242282_1_, this.prevPosX, this.getPosX());
        double d1 = MathHelper.lerp((double)p_242282_1_, this.prevPosY, this.getPosY());
        double d2 = MathHelper.lerp((double)p_242282_1_, this.prevPosZ, this.getPosZ());
        return new Vector3d(d0, d1, d2);
    }

    public RayTraceResult pick(double rayTraceDistance, float partialTicks, boolean p_213324_4_) {
        Vector3d vector3d = this.getEyePosition(partialTicks);
        Vector3d vector3d1 = this.getLook(partialTicks);
        Vector3d vector3d2 = vector3d.add(vector3d1.x * rayTraceDistance, vector3d1.y * rayTraceDistance, vector3d1.z * rayTraceDistance);
        return this.world.rayTraceBlocks(new RayTraceContext(vector3d, vector3d2, RayTraceContext.BlockMode.OUTLINE, p_213324_4_ ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, this));
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public void awardKillScore(Entity killed, int scoreValue, DamageSource damageSource) {
        if (killed instanceof ServerPlayerEntity) {
            CriteriaTriggers.ENTITY_KILLED_PLAYER.trigger((ServerPlayerEntity)killed, this, damageSource);
        }
    }

    public boolean isInRangeToRender3d(double x, double y, double z) {
        double d0 = this.getPosX() - x;
        double d1 = this.getPosY() - y;
        double d2 = this.getPosZ() - z;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return this.isInRangeToRenderDist(d3);
    }

    public boolean isInRangeToRenderDist(double distance) {
        double d0 = this.getBoundingBox().getAverageEdgeLength();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * renderDistanceWeight) * d0;
    }

    public boolean writeUnlessRemoved(CompoundNBT compound) {
        String s = this.getEntityString();
        if (!this.removed && s != null) {
            compound.putString("id", s);
            this.writeWithoutTypeId(compound);
            return true;
        }
        return false;
    }

    public boolean writeUnlessPassenger(CompoundNBT compound) {
        return this.isPassenger() ? false : this.writeUnlessRemoved(compound);
    }

    public CompoundNBT writeWithoutTypeId(CompoundNBT compound) {
        try {
            if (this.ridingEntity != null) {
                compound.put("Pos", this.newDoubleNBTList(this.ridingEntity.getPosX(), this.getPosY(), this.ridingEntity.getPosZ()));
            } else {
                compound.put("Pos", this.newDoubleNBTList(this.getPosX(), this.getPosY(), this.getPosZ()));
            }
            Vector3d vector3d = this.getMotion();
            compound.put("Motion", this.newDoubleNBTList(vector3d.x, vector3d.y, vector3d.z));
            compound.put("Rotation", this.newFloatNBTList(this.rotationYaw, this.rotationPitch));
            compound.putFloat("FallDistance", this.fallDistance);
            compound.putShort("Fire", (short)this.fire);
            compound.putShort("Air", (short)this.getAir());
            compound.putBoolean("OnGround", this.onGround);
            compound.putBoolean("Invulnerable", this.invulnerable);
            compound.putInt("PortalCooldown", this.field_242273_aw);
            compound.putUniqueId("UUID", this.getUniqueID());
            ITextComponent itextcomponent = this.getCustomName();
            if (itextcomponent != null) {
                compound.putString("CustomName", ITextComponent.Serializer.toJson(itextcomponent));
            }
            if (this.isCustomNameVisible()) {
                compound.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                compound.putBoolean("Silent", this.isSilent());
            }
            if (this.hasNoGravity()) {
                compound.putBoolean("NoGravity", this.hasNoGravity());
            }
            if (this.glowing) {
                compound.putBoolean("Glowing", this.glowing);
            }
            if (!this.tags.isEmpty()) {
                ListNBT listnbt = new ListNBT();
                for (String s : this.tags) {
                    listnbt.add(StringNBT.valueOf(s));
                }
                compound.put("Tags", listnbt);
            }
            this.writeAdditional(compound);
            if (this.isBeingRidden()) {
                ListNBT listnbt1 = new ListNBT();
                for (Entity entity : this.getPassengers()) {
                    CompoundNBT compoundnbt;
                    if (!entity.writeUnlessRemoved(compoundnbt = new CompoundNBT())) continue;
                    listnbt1.add(compoundnbt);
                }
                if (!listnbt1.isEmpty()) {
                    compound.put("Passengers", listnbt1);
                }
            }
            return compound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Saving entity NBT");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity being saved");
            this.fillCrashReport(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    public void read(CompoundNBT compound) {
        block11: {
            try {
                ListNBT listnbt = compound.getList("Pos", 6);
                ListNBT listnbt1 = compound.getList("Motion", 6);
                ListNBT listnbt2 = compound.getList("Rotation", 5);
                double d0 = listnbt1.getDouble(0);
                double d1 = listnbt1.getDouble(1);
                double d2 = listnbt1.getDouble(2);
                this.setMotion(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
                this.forceSetPosition(listnbt.getDouble(0), listnbt.getDouble(1), listnbt.getDouble(2));
                this.rotationYaw = listnbt2.getFloat(0);
                this.rotationPitch = listnbt2.getFloat(1);
                this.prevRotationYaw = this.rotationYaw;
                this.prevRotationPitch = this.rotationPitch;
                this.setRotationYawHead(this.rotationYaw);
                this.setRenderYawOffset(this.rotationYaw);
                this.fallDistance = compound.getFloat("FallDistance");
                this.fire = compound.getShort("Fire");
                this.setAir(compound.getShort("Air"));
                this.onGround = compound.getBoolean("OnGround");
                this.invulnerable = compound.getBoolean("Invulnerable");
                this.field_242273_aw = compound.getInt("PortalCooldown");
                if (compound.hasUniqueId("UUID")) {
                    this.entityUniqueID = compound.getUniqueId("UUID");
                    this.cachedUniqueIdString = this.entityUniqueID.toString();
                }
                if (Double.isFinite(this.getPosX()) && Double.isFinite(this.getPosY()) && Double.isFinite(this.getPosZ())) {
                    if (Double.isFinite(this.rotationYaw) && Double.isFinite(this.rotationPitch)) {
                        this.recenterBoundingBox();
                        this.setRotation(this.rotationYaw, this.rotationPitch);
                        if (compound.contains("CustomName", 8)) {
                            String s = compound.getString("CustomName");
                            try {
                                this.setCustomName(ITextComponent.Serializer.getComponentFromJson(s));
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                            }
                        }
                        this.setCustomNameVisible(compound.getBoolean("CustomNameVisible"));
                        this.setSilent(compound.getBoolean("Silent"));
                        this.setNoGravity(compound.getBoolean("NoGravity"));
                        this.setGlowing(compound.getBoolean("Glowing"));
                        if (compound.contains("Tags", 9)) {
                            this.tags.clear();
                            ListNBT listnbt3 = compound.getList("Tags", 8);
                            int i = Math.min(listnbt3.size(), 1024);
                            for (int j = 0; j < i; ++j) {
                                this.tags.add(listnbt3.getString(j));
                            }
                        }
                        this.readAdditional(compound);
                        if (this.shouldSetPosAfterLoading()) {
                            this.recenterBoundingBox();
                        }
                        break block11;
                    }
                    throw new IllegalStateException("Entity has invalid rotation");
                }
                throw new IllegalStateException("Entity has invalid position");
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Loading entity NBT");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity being loaded");
                this.fillCrashReport(crashreportcategory);
                throw new ReportedException(crashreport);
            }
        }
    }

    protected boolean shouldSetPosAfterLoading() {
        return true;
    }

    @Nullable
    protected final String getEntityString() {
        EntityType<?> entitytype = this.getType();
        ResourceLocation resourcelocation = EntityType.getKey(entitytype);
        return entitytype.isSerializable() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    protected abstract void readAdditional(CompoundNBT var1);

    protected abstract void writeAdditional(CompoundNBT var1);

    protected ListNBT newDoubleNBTList(double ... numbers) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : numbers) {
            listnbt.add(DoubleNBT.valueOf(d0));
        }
        return listnbt;
    }

    protected ListNBT newFloatNBTList(float ... numbers) {
        ListNBT listnbt = new ListNBT();
        for (float f : numbers) {
            listnbt.add(FloatNBT.valueOf(f));
        }
        return listnbt;
    }

    @Nullable
    public ItemEntity entityDropItem(IItemProvider itemIn) {
        return this.entityDropItem(itemIn, 0);
    }

    @Nullable
    public ItemEntity entityDropItem(IItemProvider itemIn, int offset) {
        return this.entityDropItem(new ItemStack(itemIn), (float)offset);
    }

    @Nullable
    public ItemEntity entityDropItem(ItemStack stack) {
        return this.entityDropItem(stack, 0.0f);
    }

    @Nullable
    public ItemEntity entityDropItem(ItemStack stack, float offsetY) {
        if (stack.isEmpty()) {
            return null;
        }
        if (this.world.isRemote) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.world, this.getPosX(), this.getPosY() + (double)offsetY, this.getPosZ(), stack);
        itementity.setDefaultPickupDelay();
        this.world.addEntity(itementity);
        return itementity;
    }

    public boolean isAlive() {
        return !this.removed;
    }

    public boolean isEntityInsideOpaqueBlock() {
        if (this.noClip) {
            return false;
        }
        float f = 0.1f;
        float f1 = this.size.width * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.withSizeAtOrigin(f1, 0.1f, f1).offset(this.getPosX(), this.getPosYEye(), this.getPosZ());
        return this.world.func_241457_a_(this, axisalignedbb, (p_241338_1_, p_241338_2_) -> p_241338_1_.isSuffocating(this.world, (BlockPos)p_241338_2_)).findAny().isPresent();
    }

    public ActionResultType processInitialInteract(PlayerEntity player, Hand hand) {
        return ActionResultType.PASS;
    }

    public boolean canCollide(Entity entity) {
        return entity.func_241845_aY() && !this.isRidingSameEntity(entity);
    }

    public boolean func_241845_aY() {
        return false;
    }

    public void updateRidden() {
        this.setMotion(Vector3d.ZERO);
        this.tick();
        if (this.isPassenger()) {
            this.getRidingEntity().updatePassenger(this);
        }
    }

    public void updatePassenger(Entity passenger) {
        this.positionRider(passenger, Entity::setPosition);
    }

    private void positionRider(Entity entity, IMoveCallback callback) {
        if (this.isPassenger(entity)) {
            double d0 = this.getPosY() + this.getMountedYOffset() + entity.getYOffset();
            callback.accept(entity, this.getPosX(), d0, this.getPosZ());
        }
    }

    public void applyOrientationToEntity(Entity entityToUpdate) {
    }

    public double getYOffset() {
        return 0.0;
    }

    public double getMountedYOffset() {
        return (double)this.size.height * 0.75;
    }

    public boolean startRiding(Entity entityIn) {
        return this.startRiding(entityIn, false);
    }

    public boolean isLiving() {
        return this instanceof LivingEntity;
    }

    public boolean startRiding(Entity entityIn, boolean force) {
        Entity entity = entityIn;
        while (entity.ridingEntity != null) {
            if (entity.ridingEntity == this) {
                return false;
            }
            entity = entity.ridingEntity;
        }
        if (force || this.canBeRidden(entityIn) && entityIn.canFitPassenger(this)) {
            if (this.isPassenger()) {
                this.stopRiding();
            }
            this.setPose(Pose.STANDING);
            this.ridingEntity = entityIn;
            this.ridingEntity.addPassenger(this);
            return true;
        }
        return false;
    }

    protected boolean canBeRidden(Entity entityIn) {
        return !this.isSneaking() && this.rideCooldown <= 0;
    }

    protected boolean isPoseClear(Pose pose) {
        return this.world.hasNoCollisions(this, this.getBoundingBox(pose).shrink(1.0E-7));
    }

    public void removePassengers() {
        for (int i = this.passengers.size() - 1; i >= 0; --i) {
            this.passengers.get(i).stopRiding();
        }
    }

    public void dismount() {
        if (this.ridingEntity != null) {
            Entity entity = this.ridingEntity;
            this.ridingEntity = null;
            entity.removePassenger(this);
        }
    }

    public void stopRiding() {
        this.dismount();
    }

    protected void addPassenger(Entity passenger) {
        if (passenger.getRidingEntity() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (!this.world.isRemote && passenger instanceof PlayerEntity && !(this.getControllingPassenger() instanceof PlayerEntity)) {
            this.passengers.add(0, passenger);
        } else {
            this.passengers.add(passenger);
        }
    }

    protected void removePassenger(Entity passenger) {
        if (passenger.getRidingEntity() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.passengers.remove(passenger);
        passenger.rideCooldown = 60;
    }

    protected boolean canFitPassenger(Entity passenger) {
        return this.getPassengers().size() < 1;
    }

    public void setPositionAndRotationDirect(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.setPosition(x, y, z);
        this.setRotation(yaw, pitch);
    }

    public void setHeadRotation(float yaw, int pitch) {
        this.setRotationYawHead(yaw);
    }

    public float getCollisionBorderSize() {
        return 0.0f;
    }

    public Vector3d getLookVec() {
        return this.getVectorForRotation(this.rotationPitch, this.rotationYaw);
    }

    public Vector2f getPitchYaw() {
        return new Vector2f(this.rotationPitch, this.rotationYaw);
    }

    public Vector3d getForward() {
        return Vector3d.fromPitchYaw(this.getPitchYaw());
    }

    public void setPortal(BlockPos pos) {
        if (this.func_242280_ah()) {
            this.func_242279_ag();
        } else {
            if (!this.world.isRemote && !pos.equals(this.field_242271_ac)) {
                this.field_242271_ac = pos.toImmutable();
            }
            this.inPortal = true;
        }
    }

    protected void updatePortal() {
        if (this.world instanceof ServerWorld) {
            int i = this.getMaxInPortalTime();
            ServerWorld serverworld = (ServerWorld)this.world;
            if (this.inPortal) {
                RegistryKey<World> registrykey;
                MinecraftServer minecraftserver = serverworld.getServer();
                ServerWorld serverworld1 = minecraftserver.getWorld(registrykey = this.world.getDimensionKey() == World.THE_NETHER ? World.OVERWORLD : World.THE_NETHER);
                if (serverworld1 != null && minecraftserver.getAllowNether() && !this.isPassenger() && this.portalCounter++ >= i) {
                    this.world.getProfiler().startSection("portal");
                    this.portalCounter = i;
                    this.func_242279_ag();
                    this.changeDimension(serverworld1);
                    this.world.getProfiler().endSection();
                }
                this.inPortal = false;
            } else {
                if (this.portalCounter > 0) {
                    this.portalCounter -= 4;
                }
                if (this.portalCounter < 0) {
                    this.portalCounter = 0;
                }
            }
            this.decrementTimeUntilPortal();
        }
    }

    public int getPortalCooldown() {
        return 300;
    }

    public void setVelocity(double x, double y, double z) {
        this.setMotion(x, y, z);
    }

    public void handleStatusUpdate(byte id) {
        switch (id) {
            case 53: {
                HoneyBlock.entitySlideParticles(this);
            }
        }
    }

    public void performHurtAnimation() {
    }

    public Iterable<ItemStack> getHeldEquipment() {
        return EMPTY_EQUIPMENT;
    }

    public Iterable<ItemStack> getArmorInventoryList() {
        return EMPTY_EQUIPMENT;
    }

    public Iterable<ItemStack> getEquipmentAndArmor() {
        return Iterables.concat(this.getHeldEquipment(), this.getArmorInventoryList());
    }

    public void setItemStackToSlot(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public boolean isBurning() {
        boolean flag = this.world != null && this.world.isRemote;
        return !this.isImmuneToFire() && (this.fire > 0 || flag && this.getFlag(0));
    }

    public boolean isPassenger() {
        return this.getRidingEntity() != null;
    }

    public boolean isBeingRidden() {
        return !this.getPassengers().isEmpty();
    }

    public boolean canBeRiddenInWater() {
        return true;
    }

    public void setSneaking(boolean keyDownIn) {
        this.setFlag(1, keyDownIn);
    }

    public boolean isSneaking() {
        return this.getFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isSneaking();
    }

    public boolean isSuppressingBounce() {
        return this.isSneaking();
    }

    public boolean isDiscrete() {
        return this.isSneaking();
    }

    public boolean isDescending() {
        return this.isSneaking();
    }

    public boolean isCrouching() {
        return this.getPose() == Pose.CROUCHING;
    }

    public boolean isSprinting() {
        return this.getFlag(3);
    }

    public void setSprinting(boolean sprinting) {
        this.setFlag(3, sprinting);
    }

    public boolean isSwimming() {
        return this.getFlag(4);
    }

    public boolean isActualySwimming() {
        return this.getPose() == Pose.SWIMMING;
    }

    public boolean isVisuallySwimming() {
        return this.isActualySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean swimming) {
        this.setFlag(4, swimming);
    }

    public boolean isGlowing() {
        return this.glowing || this.world.isRemote && this.getFlag(6);
    }

    public void setGlowing(boolean glowingIn) {
        this.glowing = glowingIn;
        if (!this.world.isRemote) {
            this.setFlag(6, this.glowing);
        }
    }

    public boolean isInvisible() {
        return this.getFlag(5);
    }

    public boolean isInvisibleToPlayer(PlayerEntity player) {
        if (player.isSpectator()) {
            return false;
        }
        Team team = this.getTeam();
        return team != null && player != null && player.getTeam() == team && team.getSeeFriendlyInvisiblesEnabled() ? false : this.isInvisible();
    }

    @Nullable
    public Team getTeam() {
        return this.world.getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public boolean isOnSameTeam(Entity entityIn) {
        return this.isOnScoreboardTeam(entityIn.getTeam());
    }

    public boolean isOnScoreboardTeam(Team teamIn) {
        return this.getTeam() != null ? this.getTeam().isSameTeam(teamIn) : false;
    }

    public void setInvisible(boolean invisible) {
        this.setFlag(5, invisible);
    }

    protected boolean getFlag(int flag) {
        return (this.dataManager.get(FLAGS) & 1 << flag) != 0;
    }

    protected void setFlag(int flag, boolean set) {
        byte b0 = this.dataManager.get(FLAGS);
        if (set) {
            this.dataManager.set(FLAGS, (byte)(b0 | 1 << flag));
        } else {
            this.dataManager.set(FLAGS, (byte)(b0 & ~(1 << flag)));
        }
    }

    public int getMaxAir() {
        return 300;
    }

    public int getAir() {
        return this.dataManager.get(AIR);
    }

    public void setAir(int air) {
        this.dataManager.set(AIR, air);
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        this.forceFireTicks(this.fire + 1);
        if (this.fire == 0) {
            this.setFire(8);
        }
        this.attackEntityFrom(DamageSource.LIGHTNING_BOLT, 5.0f);
    }

    public void onEnterBubbleColumnWithAirAbove(boolean downwards) {
        Vector3d vector3d = this.getMotion();
        double d0 = downwards ? Math.max(-0.9, vector3d.y - 0.03) : Math.min(1.8, vector3d.y + 0.1);
        this.setMotion(vector3d.x, d0, vector3d.z);
    }

    public void onEnterBubbleColumn(boolean downwards) {
        Vector3d vector3d = this.getMotion();
        double d0 = downwards ? Math.max(-0.3, vector3d.y - 0.03) : Math.min(0.7, vector3d.y + 0.06);
        this.setMotion(vector3d.x, d0, vector3d.z);
        this.fallDistance = 0.0f;
    }

    public void func_241847_a(ServerWorld p_241847_1_, LivingEntity p_241847_2_) {
    }

    protected void pushOutOfBlocks(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        Vector3d vector3d = new Vector3d(x - (double)blockpos.getX(), y - (double)blockpos.getY(), z - (double)blockpos.getZ());
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.setAndMove(blockpos, direction1);
            if (this.world.getBlockState(blockpos$mutable).hasOpaqueCollisionShape(this.world, blockpos$mutable)) continue;
            double d1 = vector3d.getCoordinate(direction1.getAxis());
            double d = d2 = direction1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.rand.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.getAxisDirection().getOffset();
        Vector3d vector3d1 = this.getMotion().scale(0.75);
        if (direction.getAxis() == Direction.Axis.X) {
            this.setMotion(f1 * f, vector3d1.y, vector3d1.z);
        } else if (direction.getAxis() == Direction.Axis.Y) {
            this.setMotion(vector3d1.x, f1 * f, vector3d1.z);
        } else if (direction.getAxis() == Direction.Axis.Z) {
            this.setMotion(vector3d1.x, vector3d1.y, f1 * f);
        }
    }

    public void setMotionMultiplier(BlockState state, Vector3d motionMultiplierIn) {
        this.fallDistance = 0.0f;
        this.motionMultiplier = motionMultiplierIn;
    }

    private static ITextComponent func_233573_b_(ITextComponent p_233573_0_) {
        IFormattableTextComponent iformattabletextcomponent = p_233573_0_.copyRaw().setStyle(p_233573_0_.getStyle().setClickEvent(null));
        for (ITextComponent itextcomponent : p_233573_0_.getSiblings()) {
            iformattabletextcomponent.append(Entity.func_233573_b_(itextcomponent));
        }
        return iformattabletextcomponent;
    }

    @Override
    public ITextComponent getName() {
        ITextComponent itextcomponent = this.getCustomName();
        return itextcomponent != null ? Entity.func_233573_b_(itextcomponent) : this.getProfessionName();
    }

    protected ITextComponent getProfessionName() {
        return this.type.getName();
    }

    public boolean isEntityEqual(Entity entityIn) {
        return this == entityIn;
    }

    public float getRotationYawHead() {
        return 0.0f;
    }

    public void setRotationYawHead(float rotation) {
    }

    public void setRenderYawOffset(float offset) {
    }

    public boolean canBeAttackedWithItem() {
        return true;
    }

    public boolean hitByEntity(Entity entityIn) {
        return false;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getName().getString(), this.entityId, this.world == null ? "~NULL~" : this.world.toString(), this.getPosX(), this.getPosY(), this.getPosZ());
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.invulnerable && source != DamageSource.OUT_OF_WORLD && !source.isCreativePlayer();
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean isInvulnerable) {
        this.invulnerable = isInvulnerable;
    }

    public void copyLocationAndAnglesFrom(Entity entityIn) {
        this.setLocationAndAngles(entityIn.getPosX(), entityIn.getPosY(), entityIn.getPosZ(), entityIn.rotationYaw, entityIn.rotationPitch);
    }

    public void copyDataFromOld(Entity entityIn) {
        CompoundNBT compoundnbt = entityIn.writeWithoutTypeId(new CompoundNBT());
        compoundnbt.remove("Dimension");
        this.read(compoundnbt);
        this.field_242273_aw = entityIn.field_242273_aw;
        this.field_242271_ac = entityIn.field_242271_ac;
    }

    @Nullable
    public Entity changeDimension(ServerWorld server) {
        if (this.world instanceof ServerWorld && !this.removed) {
            this.world.getProfiler().startSection("changeDimension");
            this.detach();
            this.world.getProfiler().startSection("reposition");
            PortalInfo portalinfo = this.func_241829_a(server);
            if (portalinfo == null) {
                return null;
            }
            this.world.getProfiler().endStartSection("reloading");
            Object entity = this.getType().create(server);
            if (entity != null) {
                ((Entity)entity).copyDataFromOld(this);
                ((Entity)entity).setLocationAndAngles(portalinfo.pos.x, portalinfo.pos.y, portalinfo.pos.z, portalinfo.rotationYaw, ((Entity)entity).rotationPitch);
                ((Entity)entity).setMotion(portalinfo.motion);
                server.addFromAnotherDimension((Entity)entity);
                if (server.getDimensionKey() == World.THE_END) {
                    ServerWorld.func_241121_a_(server);
                }
            }
            this.setDead();
            this.world.getProfiler().endSection();
            ((ServerWorld)this.world).resetUpdateEntityTick();
            server.resetUpdateEntityTick();
            this.world.getProfiler().endSection();
            return entity;
        }
        return null;
    }

    protected void setDead() {
        this.removed = true;
    }

    @Nullable
    protected PortalInfo func_241829_a(ServerWorld p_241829_1_) {
        boolean flag1;
        boolean flag = this.world.getDimensionKey() == World.THE_END && p_241829_1_.getDimensionKey() == World.OVERWORLD;
        boolean bl = flag1 = p_241829_1_.getDimensionKey() == World.THE_END;
        if (!flag && !flag1) {
            boolean flag2;
            boolean bl2 = flag2 = p_241829_1_.getDimensionKey() == World.THE_NETHER;
            if (this.world.getDimensionKey() != World.THE_NETHER && !flag2) {
                return null;
            }
            WorldBorder worldborder = p_241829_1_.getWorldBorder();
            double d0 = Math.max(-2.9999872E7, worldborder.minX() + 16.0);
            double d1 = Math.max(-2.9999872E7, worldborder.minZ() + 16.0);
            double d2 = Math.min(2.9999872E7, worldborder.maxX() - 16.0);
            double d3 = Math.min(2.9999872E7, worldborder.maxZ() - 16.0);
            double d4 = DimensionType.getCoordinateDifference(this.world.getDimensionType(), p_241829_1_.getDimensionType());
            BlockPos blockpos1 = new BlockPos(MathHelper.clamp(this.getPosX() * d4, d0, d2), this.getPosY(), MathHelper.clamp(this.getPosZ() * d4, d1, d3));
            return this.func_241830_a(p_241829_1_, blockpos1, flag2).map(p_242275_2_ -> {
                Vector3d vector3d;
                Direction.Axis direction$axis;
                BlockState blockstate = this.world.getBlockState(this.field_242271_ac);
                if (blockstate.hasProperty(BlockStateProperties.HORIZONTAL_AXIS)) {
                    direction$axis = blockstate.get(BlockStateProperties.HORIZONTAL_AXIS);
                    TeleportationRepositioner.Result teleportationrepositioner$result = TeleportationRepositioner.findLargestRectangle(this.field_242271_ac, direction$axis, 21, Direction.Axis.Y, 21, p_242276_2_ -> this.world.getBlockState((BlockPos)p_242276_2_) == blockstate);
                    vector3d = this.func_241839_a(direction$axis, teleportationrepositioner$result);
                } else {
                    direction$axis = Direction.Axis.X;
                    vector3d = new Vector3d(0.5, 0.0, 0.0);
                }
                return PortalSize.func_242963_a(p_241829_1_, p_242275_2_, direction$axis, vector3d, this.getSize(this.getPose()), this.getMotion(), this.rotationYaw, this.rotationPitch);
            }).orElse(null);
        }
        BlockPos blockpos = flag1 ? ServerWorld.field_241108_a_ : p_241829_1_.getHeight(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, p_241829_1_.getSpawnPoint());
        return new PortalInfo(new Vector3d((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5), this.getMotion(), this.rotationYaw, this.rotationPitch);
    }

    protected Vector3d func_241839_a(Direction.Axis axis, TeleportationRepositioner.Result result) {
        return PortalSize.func_242973_a(result, axis, this.getPositionVec(), this.getSize(this.getPose()));
    }

    protected Optional<TeleportationRepositioner.Result> func_241830_a(ServerWorld p_241830_1_, BlockPos p_241830_2_, boolean p_241830_3_) {
        return p_241830_1_.getDefaultTeleporter().getExistingPortal(p_241830_2_, p_241830_3_);
    }

    public boolean isNonBoss() {
        return true;
    }

    public float getExplosionResistance(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, FluidState fluidState, float explosionPower) {
        return explosionPower;
    }

    public boolean canExplosionDestroyBlock(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, float explosionPower) {
        return true;
    }

    public int getMaxFallHeight() {
        return 3;
    }

    public boolean doesEntityNotTriggerPressurePlate() {
        return false;
    }

    public void fillCrashReport(CrashReportCategory category) {
        category.addDetail("Entity Type", () -> EntityType.getKey(this.getType()) + " (" + this.getClass().getCanonicalName() + ")");
        category.addDetail("Entity ID", this.entityId);
        category.addDetail("Entity Name", () -> this.getName().getString());
        category.addDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getPosX(), this.getPosY(), this.getPosZ()));
        category.addDetail("Entity's Block location", CrashReportCategory.getCoordinateInfo(MathHelper.floor(this.getPosX()), MathHelper.floor(this.getPosY()), MathHelper.floor(this.getPosZ())));
        Vector3d vector3d = this.getMotion();
        category.addDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vector3d.x, vector3d.y, vector3d.z));
        category.addDetail("Entity's Passengers", () -> this.getPassengers().toString());
        category.addDetail("Entity's Vehicle", () -> this.getRidingEntity().toString());
    }

    public boolean canRenderOnFire() {
        return this.isBurning() && !this.isSpectator();
    }

    public void setUniqueId(UUID uniqueIdIn) {
        this.entityUniqueID = uniqueIdIn;
        this.cachedUniqueIdString = this.entityUniqueID.toString();
    }

    public UUID getUniqueID() {
        return this.entityUniqueID;
    }

    public String getCachedUniqueIdString() {
        return this.cachedUniqueIdString;
    }

    public String getScoreboardName() {
        return this.cachedUniqueIdString;
    }

    public boolean isPushedByWater() {
        return true;
    }

    public static double getRenderDistanceWeight() {
        return renderDistanceWeight;
    }

    public static void setRenderDistanceWeight(double renderDistWeight) {
        renderDistanceWeight = renderDistWeight;
    }

    @Override
    public ITextComponent getDisplayName() {
        return ScorePlayerTeam.func_237500_a_(this.getTeam(), this.getName()).modifyStyle(p_211516_1_ -> p_211516_1_.setHoverEvent(this.getHoverEvent()).setInsertion(this.getCachedUniqueIdString()));
    }

    public void setCustomName(@Nullable ITextComponent name) {
        this.dataManager.set(CUSTOM_NAME, Optional.ofNullable(name));
    }

    @Override
    @Nullable
    public ITextComponent getCustomName() {
        return this.dataManager.get(CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.dataManager.get(CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean alwaysRenderNameTag) {
        this.dataManager.set(CUSTOM_NAME_VISIBLE, alwaysRenderNameTag);
    }

    public boolean isCustomNameVisible() {
        return this.dataManager.get(CUSTOM_NAME_VISIBLE);
    }

    public final void teleportKeepLoaded(double x, double y, double z) {
        if (this.world instanceof ServerWorld) {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(x, y, z));
            ((ServerWorld)this.world).getChunkProvider().registerTicket(TicketType.POST_TELEPORT, chunkpos, 0, this.getEntityId());
            this.world.getChunk(chunkpos.x, chunkpos.z);
            this.setPositionAndUpdate(x, y, z);
        }
    }

    public void setPositionAndUpdate(double x, double y, double z) {
        if (this.world instanceof ServerWorld) {
            ServerWorld serverworld = (ServerWorld)this.world;
            this.setLocationAndAngles(x, y, z, this.rotationYaw, this.rotationPitch);
            this.getSelfAndPassengers().forEach(p_233565_1_ -> {
                serverworld.chunkCheck((Entity)p_233565_1_);
                p_233565_1_.isPositionDirty = true;
                for (Entity entity : p_233565_1_.passengers) {
                    p_233565_1_.positionRider(entity, Entity::moveForced);
                }
            });
        }
    }

    public boolean getAlwaysRenderNameTagForRender() {
        return this.isCustomNameVisible();
    }

    public void notifyDataManagerChange(DataParameter<?> key) {
        if (POSE.equals(key)) {
            this.recalculateSize();
        }
    }

    public void recalculateSize() {
        EntitySize entitysize1;
        EntitySize entitysize = this.size;
        Pose pose = this.getPose();
        this.size = entitysize1 = this.getSize(pose);
        this.eyeHeight = this.getEyeHeight(pose, entitysize1);
        if (entitysize1.width < entitysize.width) {
            double d0 = (double)entitysize1.width / 2.0;
            this.setBoundingBox(new AxisAlignedBB(this.getPosX() - d0, this.getPosY(), this.getPosZ() - d0, this.getPosX() + d0, this.getPosY() + (double)entitysize1.height, this.getPosZ() + d0));
        } else {
            AxisAlignedBB axisalignedbb = this.getBoundingBox();
            this.setBoundingBox(new AxisAlignedBB(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.minX + (double)entitysize1.width, axisalignedbb.minY + (double)entitysize1.height, axisalignedbb.minZ + (double)entitysize1.width));
            if (entitysize1.width > entitysize.width && !this.firstUpdate && !this.world.isRemote) {
                float f = entitysize.width - entitysize1.width;
                this.move(MoverType.SELF, new Vector3d(f, 0.0, f));
            }
        }
    }

    public Direction getHorizontalFacing() {
        return Direction.fromAngle(this.rotationYaw);
    }

    public Direction getAdjustedHorizontalFacing() {
        return this.getHorizontalFacing();
    }

    protected HoverEvent getHoverEvent() {
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, new HoverEvent.EntityHover(this.getType(), this.getUniqueID(), this.getName()));
    }

    public boolean isSpectatedByPlayer(ServerPlayerEntity player) {
        return true;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox();
    }

    protected AxisAlignedBB getBoundingBox(Pose pose) {
        EntitySize entitysize = this.getSize(pose);
        float f = entitysize.width / 2.0f;
        Vector3d vector3d = new Vector3d(this.getPosX() - (double)f, this.getPosY(), this.getPosZ() - (double)f);
        Vector3d vector3d1 = new Vector3d(this.getPosX() + (double)f, this.getPosY() + (double)entitysize.height, this.getPosZ() + (double)f);
        return new AxisAlignedBB(vector3d, vector3d1);
    }

    public void setBoundingBox(AxisAlignedBB bb) {
        this.boundingBox = bb;
    }

    protected float getEyeHeight(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.height * 0.85f;
    }

    public float getEyeHeight(Pose pose) {
        return this.getEyeHeight(pose, this.getSize(pose));
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, this.getEyeHeight(), this.getWidth() * 0.4f);
    }

    public boolean replaceItemInInventory(int inventorySlot, ItemStack itemStackIn) {
        return false;
    }

    @Override
    public void sendMessage(ITextComponent component, UUID senderUUID) {
    }

    public World getEntityWorld() {
        return this.world;
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.world.getServer();
    }

    public ActionResultType applyPlayerInteraction(PlayerEntity player, Vector3d vec, Hand hand) {
        return ActionResultType.PASS;
    }

    public boolean isImmuneToExplosions() {
        return false;
    }

    public void applyEnchantments(LivingEntity entityLivingBaseIn, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            EnchantmentHelper.applyThornEnchantments((LivingEntity)entityIn, entityLivingBaseIn);
        }
        EnchantmentHelper.applyArthropodEnchantments(entityLivingBaseIn, entityIn);
    }

    public void addTrackingPlayer(ServerPlayerEntity player) {
    }

    public void removeTrackingPlayer(ServerPlayerEntity player) {
    }

    public float getRotatedYaw(Rotation transformRotation) {
        float f = MathHelper.wrapDegrees(this.rotationYaw);
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float getMirroredYaw(Mirror transformMirror) {
        float f = MathHelper.wrapDegrees(this.rotationYaw);
        switch (transformMirror) {
            case LEFT_RIGHT: {
                return -f;
            }
            case FRONT_BACK: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public boolean ignoreItemEntityData() {
        return false;
    }

    public boolean func_233577_ch_() {
        boolean flag = this.isPositionDirty;
        this.isPositionDirty = false;
        return flag;
    }

    public boolean func_233578_ci_() {
        boolean flag = this.isLoaded;
        this.isLoaded = false;
        return flag;
    }

    @Nullable
    public Entity getControllingPassenger() {
        return null;
    }

    public List<Entity> getPassengers() {
        return this.passengers.isEmpty() ? Collections.emptyList() : Lists.newArrayList(this.passengers);
    }

    public boolean isPassenger(Entity entityIn) {
        for (Entity entity : this.getPassengers()) {
            if (!entity.equals(entityIn)) continue;
            return true;
        }
        return false;
    }

    public boolean isPassenger(Class<? extends Entity> entityClazz) {
        for (Entity entity : this.getPassengers()) {
            if (!entityClazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    public Collection<Entity> getRecursivePassengers() {
        HashSet<Entity> set = Sets.newHashSet();
        for (Entity entity : this.getPassengers()) {
            set.add(entity);
            entity.getRecursivePassengers(false, set);
        }
        return set;
    }

    public Stream<Entity> getSelfAndPassengers() {
        return Stream.concat(Stream.of(this), this.passengers.stream().flatMap(Entity::getSelfAndPassengers));
    }

    public boolean isOnePlayerRiding() {
        HashSet<Entity> set = Sets.newHashSet();
        this.getRecursivePassengers(true, set);
        return set.size() == 1;
    }

    private void getRecursivePassengers(boolean playersOnly, Set<Entity> p_200604_2_) {
        for (Entity entity : this.getPassengers()) {
            if (!playersOnly || ServerPlayerEntity.class.isAssignableFrom(entity.getClass())) {
                p_200604_2_.add(entity);
            }
            entity.getRecursivePassengers(playersOnly, p_200604_2_);
        }
    }

    public Entity getLowestRidingEntity() {
        Entity entity = this;
        while (entity.isPassenger()) {
            entity = entity.getRidingEntity();
        }
        return entity;
    }

    public boolean isRidingSameEntity(Entity entityIn) {
        return this.getLowestRidingEntity() == entityIn.getLowestRidingEntity();
    }

    public boolean isRidingOrBeingRiddenBy(Entity entityIn) {
        for (Entity entity : this.getPassengers()) {
            if (entity.equals(entityIn)) {
                return true;
            }
            if (!entity.isRidingOrBeingRiddenBy(entityIn)) continue;
            return true;
        }
        return false;
    }

    public boolean canPassengerSteer() {
        Entity entity = this.getControllingPassenger();
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).isUser();
        }
        return !this.world.isRemote;
    }

    protected static Vector3d func_233559_a_(double p_233559_0_, double p_233559_2_, float p_233559_4_) {
        double d0 = (p_233559_0_ + p_233559_2_ + (double)1.0E-5f) / 2.0;
        float f = -MathHelper.sin(p_233559_4_ * ((float)Math.PI / 180));
        float f1 = MathHelper.cos(p_233559_4_ * ((float)Math.PI / 180));
        float f2 = Math.max(Math.abs(f), Math.abs(f1));
        return new Vector3d((double)f * d0 / (double)f2, 0.0, (double)f1 * d0 / (double)f2);
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        return new Vector3d(this.getPosX(), this.getBoundingBox().maxY, this.getPosZ());
    }

    @Nullable
    public Entity getRidingEntity() {
        return this.ridingEntity;
    }

    public PushReaction getPushReaction() {
        return PushReaction.NORMAL;
    }

    public SoundCategory getSoundCategory() {
        return SoundCategory.NEUTRAL;
    }

    protected int getFireImmuneTicks() {
        return 1;
    }

    public CommandSource getCommandSource() {
        return new CommandSource(this, this.getPositionVec(), this.getPitchYaw(), this.world instanceof ServerWorld ? (ServerWorld)this.world : null, this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.world.getServer(), this);
    }

    protected int getPermissionLevel() {
        return 0;
    }

    public boolean hasPermissionLevel(int level) {
        return this.getPermissionLevel() >= level;
    }

    @Override
    public boolean shouldReceiveFeedback() {
        return this.world.getGameRules().getBoolean(GameRules.SEND_COMMAND_FEEDBACK);
    }

    @Override
    public boolean shouldReceiveErrors() {
        return true;
    }

    @Override
    public boolean allowLogging() {
        return true;
    }

    public void lookAt(EntityAnchorArgument.Type anchor, Vector3d target) {
        Vector3d vector3d = anchor.apply(this);
        double d0 = target.x - vector3d.x;
        double d1 = target.y - vector3d.y;
        double d2 = target.z - vector3d.z;
        double d3 = MathHelper.sqrt(d0 * d0 + d2 * d2);
        this.rotationPitch = MathHelper.wrapDegrees((float)(-(MathHelper.atan2(d1, d3) * 57.2957763671875)));
        this.rotationYaw = MathHelper.wrapDegrees((float)(MathHelper.atan2(d2, d0) * 57.2957763671875) - 90.0f);
        this.setRotationYawHead(this.rotationYaw);
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
    }

    public boolean handleFluidAcceleration(ITag<Fluid> fluidTag, double p_210500_2_) {
        int j1;
        AxisAlignedBB axisalignedbb = this.getBoundingBox().shrink(0.001);
        int i = MathHelper.floor(axisalignedbb.minX);
        int j = MathHelper.ceil(axisalignedbb.maxX);
        int k = MathHelper.floor(axisalignedbb.minY);
        int l = MathHelper.ceil(axisalignedbb.maxY);
        int i1 = MathHelper.floor(axisalignedbb.minZ);
        if (!this.world.isAreaLoaded(i, k, i1, j, l, j1 = MathHelper.ceil(axisalignedbb.maxZ))) {
            return false;
        }
        double d0 = 0.0;
        boolean flag = this.isPushedByWater();
        boolean flag1 = false;
        Vector3d vector3d = Vector3d.ZERO;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = k; i2 < l; ++i2) {
                for (int j2 = i1; j2 < j1; ++j2) {
                    double d1;
                    blockpos$mutable.setPos(l1, i2, j2);
                    FluidState fluidstate = this.world.getFluidState(blockpos$mutable);
                    if (!fluidstate.isTagged(fluidTag) || !((d1 = (double)((float)i2 + fluidstate.getActualHeight(this.world, blockpos$mutable))) >= axisalignedbb.minY)) continue;
                    flag1 = true;
                    d0 = Math.max(d1 - axisalignedbb.minY, d0);
                    if (!flag) continue;
                    Vector3d vector3d1 = fluidstate.getFlow(this.world, blockpos$mutable);
                    if (d0 < 0.4) {
                        vector3d1 = vector3d1.scale(d0);
                    }
                    vector3d = vector3d.add(vector3d1);
                    ++k1;
                }
            }
        }
        if (vector3d.length() > 0.0) {
            if (k1 > 0) {
                vector3d = vector3d.scale(1.0 / (double)k1);
            }
            if (!(this instanceof PlayerEntity)) {
                vector3d = vector3d.normalize();
            }
            Vector3d vector3d2 = this.getMotion();
            vector3d = vector3d.scale(p_210500_2_ * 1.0);
            double d2 = 0.003;
            if (Math.abs(vector3d2.x) < 0.003 && Math.abs(vector3d2.z) < 0.003 && vector3d.length() < 0.0045000000000000005) {
                vector3d = vector3d.normalize().scale(0.0045000000000000005);
            }
            this.setMotion(this.getMotion().add(vector3d));
        }
        this.eyesFluidLevel.put(fluidTag, d0);
        return flag1;
    }

    public double func_233571_b_(ITag<Fluid> p_233571_1_) {
        return this.eyesFluidLevel.getDouble(p_233571_1_);
    }

    public double func_233579_cu_() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getWidth() {
        return this.size.width;
    }

    public final float getHeight() {
        return this.size.height;
    }

    public abstract IPacket<?> createSpawnPacket();

    public EntitySize getSize(Pose poseIn) {
        return this.type.getSize();
    }

    public Vector3d getPositionVec() {
        return this.positionVec;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public Vector3d getMotion() {
        return this.motion;
    }

    public void setMotion(Vector3d motionIn) {
        this.motion = motionIn;
    }

    public void setMotion(double x, double y, double z) {
        this.setMotion(new Vector3d(x, y, z));
    }

    public final double getPosX() {
        return this.positionVec.x;
    }

    public double getPosXWidth(double p_226275_1_) {
        return this.positionVec.x + (double)this.getWidth() * p_226275_1_;
    }

    public double getPosXRandom(double p_226282_1_) {
        return this.getPosXWidth((2.0 * this.rand.nextDouble() - 1.0) * p_226282_1_);
    }

    public final double getPosY() {
        return this.positionVec.y;
    }

    public double getPosYHeight(double p_226283_1_) {
        return this.positionVec.y + (double)this.getHeight() * p_226283_1_;
    }

    public double getPosYRandom() {
        return this.getPosYHeight(this.rand.nextDouble());
    }

    public double getPosYEye() {
        return this.positionVec.y + (double)this.eyeHeight;
    }

    public final double getPosZ() {
        return this.positionVec.z;
    }

    public double getPosZWidth(double p_226285_1_) {
        return this.positionVec.z + (double)this.getWidth() * p_226285_1_;
    }

    public double getPosZRandom(double p_226287_1_) {
        return this.getPosZWidth((2.0 * this.rand.nextDouble() - 1.0) * p_226287_1_);
    }

    public void setRawPosition(double x, double y, double z) {
        if (this.positionVec.x != x || this.positionVec.y != y || this.positionVec.z != z) {
            this.positionVec = new Vector3d(x, y, z);
            int i = MathHelper.floor(x);
            int j = MathHelper.floor(y);
            int k = MathHelper.floor(z);
            if (i != this.position.getX() || j != this.position.getY() || k != this.position.getZ()) {
                this.position = new BlockPos(i, j, k);
            }
            this.isLoaded = true;
        }
    }

    public void checkDespawn() {
    }

    public Vector3d getLeashPosition(float partialTicks) {
        return this.func_242282_l(partialTicks).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void setRandomSeed(long seed) {
        this.rand.setSeed(seed);
    }

    @FunctionalInterface
    public static interface IMoveCallback {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

