/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.dispenser;

import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class BeehiveDispenseBehavior
extends OptionalDispenseBehavior {
    @Override
    protected ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
        ServerWorld world = source.getWorld();
        if (!world.isRemote()) {
            BlockPos blockpos = source.getBlockPos().offset(source.getBlockState().get(DispenserBlock.FACING));
            this.setSuccessful(BeehiveDispenseBehavior.shearComb(world, blockpos) || BeehiveDispenseBehavior.shear(world, blockpos));
            if (this.isSuccessful() && stack.attemptDamageItem(1, world.getRandom(), null)) {
                stack.setCount(0);
            }
        }
        return stack;
    }

    private static boolean shearComb(ServerWorld world, BlockPos pos) {
        int i;
        BlockState blockstate = world.getBlockState(pos);
        if (blockstate.isIn(BlockTags.BEEHIVES) && (i = blockstate.get(BeehiveBlock.HONEY_LEVEL).intValue()) >= 5) {
            world.playSound(null, pos, SoundEvents.BLOCK_BEEHIVE_SHEAR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.dropHoneyComb(world, pos);
            ((BeehiveBlock)blockstate.getBlock()).takeHoney(world, blockstate, pos, null, BeehiveTileEntity.State.BEE_RELEASED);
            return true;
        }
        return false;
    }

    private static boolean shear(ServerWorld world, BlockPos pos) {
        for (LivingEntity livingEntity : world.getEntitiesWithinAABB(LivingEntity.class, new AxisAlignedBB(pos), EntityPredicates.NOT_SPECTATING)) {
            IShearable ishearable;
            if (!(livingEntity instanceof IShearable) || !(ishearable = (IShearable)((Object)livingEntity)).isShearable()) continue;
            ishearable.shear(SoundCategory.BLOCKS);
            return true;
        }
        return false;
    }
}

