/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.Util;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SNBTToNBTConverter
implements IDataProvider {
    @Nullable
    private static final Path EMPTY = null;
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator generator;
    private final List<ITransformer> transformers = Lists.newArrayList();

    public SNBTToNBTConverter(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public SNBTToNBTConverter addTransformer(ITransformer transformer) {
        this.transformers.add(transformer);
        return this;
    }

    private CompoundNBT snbtToNBT(String fileName, CompoundNBT nbt) {
        CompoundNBT compoundnbt = nbt;
        for (ITransformer snbttonbtconverter$itransformer : this.transformers) {
            compoundnbt = snbttonbtconverter$itransformer.func_225371_a(fileName, compoundnbt);
        }
        return compoundnbt;
    }

    @Override
    public void act(DirectoryCache cache) throws IOException {
        Path path = this.generator.getOutputFolder();
        ArrayList list = Lists.newArrayList();
        for (Path path1 : this.generator.getInputFolders()) {
            Files.walk(path1, new FileVisitOption[0]).filter(snbtPath -> snbtPath.toString().endsWith(".snbt")).forEach(filePath -> list.add(CompletableFuture.supplyAsync(() -> this.convertSNBTToNBT((Path)filePath, this.getFileName(path1, (Path)filePath)), Util.getServerExecutor())));
        }
        Util.gather(list).join().stream().filter(Objects::nonNull).forEach(result -> this.writeStructureSNBT(cache, (TaskResult)result, path));
    }

    @Override
    public String getName() {
        return "SNBT -> NBT";
    }

    private String getFileName(Path inputFolder, Path fileIn) {
        String s = inputFolder.relativize(fileIn).toString().replaceAll("\\\\", "/");
        return s.substring(0, s.length() - ".snbt".length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private TaskResult convertSNBTToNBT(Path filePath, String fileName) {
        try (BufferedReader bufferedreader = Files.newBufferedReader(filePath);){
            String s = IOUtils.toString(bufferedreader);
            CompoundNBT compoundnbt = this.snbtToNBT(fileName, JsonToNBT.getTagFromJson(s));
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            CompressedStreamTools.writeCompressed(compoundnbt, bytearrayoutputstream);
            byte[] abyte = bytearrayoutputstream.toByteArray();
            String s1 = HASH_FUNCTION.hashBytes(abyte).toString();
            String s2 = EMPTY != null ? compoundnbt.toFormattedComponent("    ", 0).getString() + "\n" : null;
            TaskResult taskResult = new TaskResult(fileName, abyte, s2, s1);
            return taskResult;
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            LOGGER.error("Couldn't convert {} from SNBT to NBT at {} as it's invalid SNBT", (Object)fileName, (Object)filePath, (Object)commandsyntaxexception);
            return null;
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't convert {} from SNBT to NBT at {}", (Object)fileName, (Object)filePath, (Object)ioexception);
        }
        return null;
    }

    private void writeStructureSNBT(DirectoryCache directory, TaskResult taskResult, Path pathIn) {
        if (taskResult.field_240515_c_ != null) {
            Path path = EMPTY.resolve(taskResult.fileName + ".snbt");
            try {
                FileUtils.write(path.toFile(), (CharSequence)taskResult.field_240515_c_, StandardCharsets.UTF_8);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't write structure SNBT {} at {}", (Object)taskResult.fileName, (Object)path, (Object)ioexception);
            }
        }
        Path path1 = pathIn.resolve(taskResult.fileName + ".nbt");
        try {
            if (!Objects.equals(directory.getPreviousHash(path1), taskResult.bytesHash) || !Files.exists(path1, new LinkOption[0])) {
                Files.createDirectories(path1.getParent(), new FileAttribute[0]);
                try (OutputStream outputstream = Files.newOutputStream(path1, new OpenOption[0]);){
                    outputstream.write(taskResult.nbtBytes);
                }
            }
            directory.recordHash(path1, taskResult.bytesHash);
        }
        catch (IOException ioexception1) {
            LOGGER.error("Couldn't write structure {} at {}", (Object)taskResult.fileName, (Object)path1, (Object)ioexception1);
        }
    }

    static class TaskResult {
        private final String fileName;
        private final byte[] nbtBytes;
        @Nullable
        private final String field_240515_c_;
        private final String bytesHash;

        public TaskResult(String fileName, byte[] p_i232551_2_, @Nullable String p_i232551_3_, String bytesHash) {
            this.fileName = fileName;
            this.nbtBytes = p_i232551_2_;
            this.field_240515_c_ = p_i232551_3_;
            this.bytesHash = bytesHash;
        }
    }

    @FunctionalInterface
    public static interface ITransformer {
        public CompoundNBT func_225371_a(String var1, CompoundNBT var2);
    }
}

