/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.player.SpawnLocationHelper;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public class TeleportBiomeCommand {
    public static final DynamicCommandExceptionType invalidBiomeException = new DynamicCommandExceptionType(p_241052_0_ -> new TranslationTextComponent("commands.locatebiome.invalid", p_241052_0_));
    private static final DynamicCommandExceptionType biomeNotFoundException = new DynamicCommandExceptionType(p_241050_0_ -> new TranslationTextComponent("commands.locatebiome.notFound", p_241050_0_));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("teleportbiome").requires(p_241048_0_ -> p_241048_0_.hasPermissionLevel(2))).then(Commands.argument("targets", EntityArgument.players()).then((ArgumentBuilder<CommandSource, ?>)Commands.argument("biome", ResourceLocationArgument.resourceLocation()).then((ArgumentBuilder<CommandSource, ?>)Commands.argument("location", Vec3Argument.vec3()).executes(context -> TeleportBiomeCommand.teleportToBiome((CommandSource)context.getSource(), context.getArgument("biome", ResourceLocation.class), EntityArgument.getPlayers(context, "targets"), ((CommandSource)context.getSource()).getWorld(), Vec3Argument.getLocation(context, "location")))))));
    }

    private static int teleportToBiome(CommandSource source, ResourceLocation resourceLocation, Collection<ServerPlayerEntity> targets, ServerWorld worldIn, ILocationArgument position) throws CommandSyntaxException {
        Biome biome = (Biome)source.getServer().func_244267_aX().getRegistry(Registry.BIOME_KEY).getOptional(resourceLocation).orElseThrow(() -> invalidBiomeException.create(resourceLocation));
        int radius = 6400;
        int increment = 8;
        boolean findClosest = false;
        BlockPos sourcePos = position.getBlockPos(source);
        BlockPos targetPos = worldIn.getChunkProvider().getChunkGenerator().getBiomeProvider().findBiomePosition(sourcePos.getX(), sourcePos.getY(), sourcePos.getZ(), 6400, 8, biome_ -> biome_ == biome, worldIn.rand, false);
        if (targetPos == null) {
            throw biomeNotFoundException.create(resourceLocation.toString());
        }
        return TeleportBiomeCommand.safeTeleportToPos(source, targets, worldIn, targetPos);
    }

    private static int safeTeleportToPos(CommandSource source, Collection<ServerPlayerEntity> targets, ServerWorld worldIn, BlockPos targetPos) {
        for (ServerPlayerEntity entity : targets) {
            ChunkPos chunkpos = new ChunkPos(targetPos);
            worldIn.getChunkProvider().registerTicket(TicketType.POST_TELEPORT, chunkpos, 1, entity.getEntityId());
            entity.stopRiding();
            if (entity.isSleeping()) {
                entity.stopSleepInBed(true, true);
            }
            BlockPos spawnPos = TeleportBiomeCommand.findSafePosition(worldIn, chunkpos);
            double x = (double)spawnPos.getX() + 0.5;
            double y = (double)spawnPos.getY() + 1.0;
            double z = (double)spawnPos.getZ() + 0.5;
            float yaw = 0.0f;
            float pitch = 0.0f;
            if (worldIn == entity.world) {
                entity.connection.setPlayerLocation(x, y, z, yaw, pitch);
            } else {
                entity.teleport(worldIn, x, y, z, yaw, pitch);
            }
            entity.setRotationYawHead(yaw);
            while (!worldIn.hasNoCollisions(entity) && entity.getPosY() < 256.0) {
                entity.setPosition(entity.getPosX(), entity.getPosY() + 1.0, entity.getPosZ());
            }
            if (entity instanceof LivingEntity && entity.isElytraFlying()) continue;
            entity.setMotion(entity.getMotion().mul(1.0, 0.0, 1.0));
            entity.setOnGround(true);
        }
        return targets.size();
    }

    private static BlockPos findSafePosition(ServerWorld worldIn, ChunkPos chunkPos) {
        boolean flag = false;
        BiomeProvider biomeprovider = worldIn.getChunkProvider().getChunkGenerator().getBiomeProvider();
        for (Block block : BlockTags.VALID_SPAWN.getAllElements()) {
            if (!biomeprovider.getSurfaceBlocks().contains(block.getDefaultState())) continue;
            flag = true;
            break;
        }
        int i1 = 0;
        int j1 = 0;
        int i = 0;
        int j = -1;
        for (int l = 0; l < 1024; ++l) {
            BlockPos blockpos1;
            if (i1 > -16 && i1 <= 16 && j1 > -16 && j1 <= 16 && (blockpos1 = SpawnLocationHelper.func_241094_a_(worldIn, new ChunkPos(chunkPos.x + i1, chunkPos.z + j1), flag)) != null) {
                return blockpos1;
            }
            if (i1 == j1 || i1 < 0 && i1 == -j1 || i1 > 0 && i1 == 1 - j1) {
                int k1 = i;
                i = -j;
                j = k1;
            }
            i1 += i;
            j1 += j;
        }
        return null;
    }
}

