/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class JSONException
extends IOException {
    private final List<Entry> entries = Lists.newArrayList();
    private final String message;

    public JSONException(String messageIn) {
        this.entries.add(new Entry());
        this.message = messageIn;
    }

    public JSONException(String messageIn, Throwable cause) {
        super(cause);
        this.entries.add(new Entry());
        this.message = messageIn;
    }

    public void prependJsonKey(String key) {
        this.entries.get(0).addJsonKey(key);
    }

    public void setFilenameAndFlush(String filenameIn) {
        this.entries.get(0).filename = filenameIn;
        this.entries.add(0, new Entry());
    }

    @Override
    public String getMessage() {
        return "Invalid " + this.entries.get(this.entries.size() - 1) + ": " + this.message;
    }

    public static JSONException forException(Exception exception) {
        if (exception instanceof JSONException) {
            return (JSONException)exception;
        }
        String s = exception.getMessage();
        if (exception instanceof FileNotFoundException) {
            s = "File not found";
        }
        return new JSONException(s, exception);
    }

    public static class Entry {
        @Nullable
        private String filename;
        private final List<String> jsonKeys = Lists.newArrayList();

        private Entry() {
        }

        private void addJsonKey(String key) {
            this.jsonKeys.add(0, key);
        }

        public String getJsonKeys() {
            return StringUtils.join(this.jsonKeys, "->");
        }

        public String toString() {
            if (this.filename != null) {
                return this.jsonKeys.isEmpty() ? this.filename : this.filename + " " + this.getJsonKeys();
            }
            return this.jsonKeys.isEmpty() ? "(Unknown file)" : "(Unknown file) " + this.getJsonKeys();
        }
    }
}

